//	MC68K code MULS



case	0x01c0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MULS D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(short)D[RN1];
	TS2=(short)D[RN2];
	TL3=(short)TS1*(short)TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL3;
	PC+=2;	return;



case	0x01d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MULS (A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=m68_read2(A[RN1]);
	TS2=(short)D[RN2];
	TL3=(short)TS1*(short)TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL3;
	PC+=2;	return;




case	0x01d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MULS (A%d)+,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=m68_read2(A[RN1]);
	TS2=(short)D[RN2];
	TL3=(short)TS1*(short)TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL3;
	A[RN1]+=2;
	PC+=2;	return;



case	0x01e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MULS -(A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=2;
	TS1=m68_read2(A[RN1]);
	TS2=(short)D[RN2];
	TL3=(short)TS1*(short)TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL3;
	PC+=2;	return;



case	0x01e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MULS $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	TS1=m68_read2(A[RN1]+(short)num2(1));
	TS2=(short)D[RN2];
	TL3=(short)TS1*(short)TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL3;
	PC+=4;	return;



case	0x01f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MULS $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TS1=m68_read2(A[RN1]+(char)num1(1)+(short)D[RN3]);
	else	TS1=m68_read2(A[RN1]+(char)num1(1)+       D[RN3]);
	TS2=(short)D[RN2];
	TL3=(short)TS1*(short)TS2;

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL3==0)				SR|=CCR_ZON;
	if((TL3&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL3;
	PC+=4;	return;



case	0x01f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MULS $%04X,D%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
			TS1=m68_read2((short)num2(1));
			TS2=(short)D[RN2];
			TL3=(short)TS1*(short)TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL3;
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MULS $%08X,D%d\n",
	num4(1),RN1,RN2);	CO;	}
#endif
			TS1=m68_read2(num4(1));
			TS2=(short)D[RN2];
			TL3=(short)TS1*(short)TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL3;
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MULS $%04X(PC),D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TS1=m68_read2(PC+(short)num2(1));
			TS2=(short)D[RN2];
			TL3=(short)TS1*(short)TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL3;
			PC+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MULS $%02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO;	}
#endif
			if((num2(1)&0x0800)==0)
					TS1=m68_read2(PC+(char)num1(1)+(short)D[RN3]);
			else	TS1=m68_read2(PC+(char)num1(1)+       D[RN3]);
			TS2=(short)D[RN2];
			TL3=(short)TS1*(short)TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL3;
			PC+=4;	return;



		case	4:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MULS #$%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TS1=num2(1);
			TS2=(short)D[RN2];
			TL3=(short)TS1*(short)TS2;

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL3==0)				SR|=CCR_ZON;
			if((TL3&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL3;
			PC+=4;	return;

		default:
			i_gic();	return;
	}





