//	MC68K	MOVE to SR



case	0x06c0:
	if(!(SR&0x2000)){								//User state
		BD0;	sprintf(buf,"MOVE D%d,SR <User State! TRAP!>\n",RN1);
		CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE D%d,SR\n",RN1);	CO;	}
#endif
	TSR=SR;	SR=(unsigned short)D[RN1];
	if((TSR^SR)&0x2000)								//Change state
		if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
			else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
	PC+=2;	return;



case	0x06d0:
	if(!(SR&0x2000)){								//User state
		BD0;	sprintf(buf,"MOVE (A%d),SR <User State! TRAP!>\n",RN1);
		CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE (A%d),SR\n",RN1);	CO;	}
#endif
	TSR=SR;	SR=m68_read2(A[RN1]);
	if((TSR^SR)&0x2000)								//Change state
		if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
			else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
	PC+=2;	return;



case	0x06d8:
	if(!(SR&0x2000)){								//User state
		BD0;	sprintf(buf,"MOVE (A%d)+,SR <User State! TRAP!>\n",RN1);
		CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE (A%d)+,SR\n",RN1);	CO;	}
#endif
	TSR=SR;	SR=m68_read2(A[RN1]);	A[RN1]+=2;
	if((TSR^SR)&0x2000)								//Change state
		if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
			else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
	PC+=2;	return;



case	0x06e0:
	if(!(SR&0x2000)){								//User state
		BD0;	sprintf(buf,"MOVE -(A%d),SR <User State! TRAP!>\n",RN1);
		CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE -(A%d),SR\n",RN1);	CO;	}
#endif
	TSR=SR;	A[RN1]-=2;	SR=m68_read2(A[RN1]);
	if((TSR^SR)&0x2000)								//Change state
		if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
			else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
	PC+=2;	return;



case	0x06e8:
	if(!(SR&0x2000)){								//User state
		BD1;
		sprintf(buf,"MOVE $%04X(A%d),SR <User State! TRAP!>\n",num2(1),RN1);
		CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE $%04X(A%d),SR\n",
	num2(1),RN1);	CO;	}
#endif
	TSR=SR;	SR=m68_read2(A[RN1]+(short)num2(1));
	if((TSR^SR)&0x2000)								//Change state
		if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
			else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
	PC+=4;	return;



case	0x06f0:
	RN2=(num2(1)>>12)&15;	//index

	if(!(SR&0x2000)){								//User state
		BD1;	sprintf(buf,"MOVE $%02X(A%d,X%d),SR <User State! TRAP!>\n",
					num1(1),RN1,RN2);	CO;		goto	_TRAP;				}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE $%02X(A%d,X%d),SR\n",
	num1(1),RN1,RN2);	CO;	}
#endif
	TSR=SR;

	if((num2(2)&0x0800)==0)
			SR=m68_read2(A[RN1]+(char)num1(1)+(short)D[RN2]);
	else	SR=m68_read2(A[RN1]+(char)num1(1)+       D[RN2]);

	if((TSR^SR)&0x2000)								//Change state
		if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
			else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
	PC+=4;	return;



case	0x06f8:
	switch(RN1){
		case	0:
			if(!(SR&0x2000)){								//User state
				BD1;
				sprintf(buf,"MOVE $%04X,SR <User State! TRAP!>\n",num2(1));
				CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE $%04X,SR\n",
	num2(1));	CO;	}
#endif
			TSR=SR;	SR=m68_read2((short)num2(1));
			if((TSR^SR)&0x2000)								//Change state
				if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
					else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
			PC+=4;	return;



		case	1:
			if(!(SR&0x2000)){								//User state
				BD2;
				sprintf(buf,"MOVE $%08X,SR <User State! TRAP!>\n",num4(1));
				CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE $%08X,SR\n",
	num4(1));	CO;	}
#endif
			TSR=SR;	SR=m68_read2(num4(1));
			if((TSR^SR)&0x2000)								//Change state
				if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
					else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
			PC+=6;	return;



		case	2:
			if(!(SR&0x2000)){								//User state
				BD1;
				sprintf(buf,"MOVE $%04X(PC),SR <User State! TRAP!>\n",num2(1));
				CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE $%04X(PC),SR\n",
	num2(1));	CO;	}
#endif
			TSR=SR;	SR=m68_read2(PC+(short)num2(1));
			if((TSR^SR)&0x2000)								//Change state
				if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
					else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
			PC+=4;	return;



		case	3:
			RN2=(num2(1)>>12)&15;	//index

			if(!(SR&0x2000)){								//User state
				BD1;
				sprintf(buf,"MOVE $%02X(PC,X%d),SR <User State! TRAP!>\n",
				num1(1),RN2);	CO;		goto	_TRAP;						}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE $%02X(PC,X%d),SR\n",
	num1(1),RN2);	CO;	}
#endif
			TSR=SR;

			if((num2(2)&0x0800)==0)
					SR=m68_read2(PC+(char)num1(1)+(short)D[RN2]);
			else	SR=m68_read2(PC+(char)num1(1)+       D[RN2]);

			if((TSR^SR)&0x2000)								//Change state
				if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
					else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
			PC+=4;	return;



		case	4:
			if(!(SR&0x2000)){								//User state
				BD1;
				sprintf(buf,"MOVE #$%04X,SR <User State! TRAP!>\n",num2(1));
				CO;		goto	_TRAP;										}
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE #$%04X,SR\n",
	num2(1));	CO;	}
#endif
			TSR=SR;	SR=num2(1);
			if((TSR^SR)&0x2000)								//Change state
				if(SR&0x2000){	USP=A[7];	A[7]=SSP;	}	//User to Super
					else	{	SSP=A[7];	A[7]=USP;	}	//Super to User
			PC+=4;	return;



		default:
			i_gic();	return;
	}
