//	MC68K code ADDQ



case	0x0000:		//byte size , data regster direct
case	0x0200:
case	0x0400:
case	0x0600:
case	0x0800:
case	0x0a00:
case	0x0c00:
case	0x0e00:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.B #$%1X,D%d\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0010:		//byte size , mem addr
case	0x0210:
case	0x0410:
case	0x0610:
case	0x0810:
case	0x0a10:
case	0x0c10:
case	0x0e10:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.B #$%1X,(A%d)\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0018:		//byte size , mem addr ,postinc
case	0x0218:
case	0x0418:
case	0x0618:
case	0x0818:
case	0x0a18:
case	0x0c18:
case	0x0e18:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.B #$%1X,(A%d)+\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0020:		//byte size , mem addr ,pridec
case	0x0220:
case	0x0420:
case	0x0620:
case	0x0820:
case	0x0a20:
case	0x0c20:
case	0x0e20:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.B #$%1X,-(A%d)\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0028:		//byte size , mem addr with disp
case	0x0228:
case	0x0428:
case	0x0628:
case	0x0828:
case	0x0a28:
case	0x0c28:
case	0x0e28:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD1;	sprintf(buf,"ADDQ.B #$%1X,$%04X(A%d)\n",TC3,dnm2(1),RN1);	CO;
	TUC+=4;	return;



case	0x0030:		//byte size , mem addr with index
case	0x0230:
case	0x0430:
case	0x0630:
case	0x0830:
case	0x0a30:
case	0x0c30:
case	0x0e30:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	RN2=(dnm2(2)>>12)&15;	//index
	DD1;	sprintf(buf,"ADDQ.B #$%1X,$%02X(A%d,X%d)\n",
		TC3,dnm1(1),RN1,RN2);	CO;	TUC+=4;	return;



case	0x0038:				//byte size , abs
case	0x0238:
case	0x0438:
case	0x0638:
case	0x0838:
case	0x0a38:
case	0x0c38:
case	0x0e38:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	switch(code&DC_02){
		case	0x0000:		//word size
			DD1;	sprintf(buf,"ADDQ.B #$%1X,$%04X\n",TC3,dnm2(1));	CO;
			TUC+=4;	return;

		case	0x0001:		//long size
			DD2;	sprintf(buf,"ADDQ.B #$%1X,$%08X\n",TC3,dnm4(1));	CO;
			TUC+=6;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



case	0x0040:		//word size , data regster direct
case	0x0240:
case	0x0440:
case	0x0640:
case	0x0840:
case	0x0a40:
case	0x0c40:
case	0x0e40:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.W #$%1X,D%d\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0048:		//word size , addr regster direct
case	0x0248:
case	0x0448:
case	0x0648:
case	0x0848:
case	0x0a48:
case	0x0c48:
case	0x0e48:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.W #$%1X,A%d\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0050:		//mem addr
case	0x0250:
case	0x0450:
case	0x0650:
case	0x0850:
case	0x0a50:
case	0x0c50:
case	0x0e50:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.W #$%1X,(A%d)\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0058:		//mem addr ,postinc
case	0x0258:
case	0x0458:
case	0x0658:
case	0x0858:
case	0x0a58:
case	0x0c58:
case	0x0e58:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.W #$%1X,(A%d)+\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0060:		//mem addr ,pridec
case	0x0260:
case	0x0460:
case	0x0660:
case	0x0860:
case	0x0a60:
case	0x0c60:
case	0x0e60:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.W #$%1X,-(A%d)\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0068:		//mem addr with disp
case	0x0268:
case	0x0468:
case	0x0668:
case	0x0868:
case	0x0a68:
case	0x0c68:
case	0x0e68:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD1;	sprintf(buf,"ADDQ.W #$%1X,$%04X(A%d)\n",TC3,dnm2(1),RN1);	CO;
	TUC+=4;	return;



case	0x0070:		//byte size , mem addr with index
case	0x0270:
case	0x0470:
case	0x0670:
case	0x0870:
case	0x0a70:
case	0x0c70:
case	0x0e70:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	RN2=(dnm2(2)>>12)&15;	//index
	DD1;	sprintf(buf,"ADDQ.W #$%1X,$%02X(A%d,X%d)\n",
		TC3,dnm1(1),RN1,RN2);	CO;	TUC+=4;	return;



case	0x0078:				//abs
case	0x0278:
case	0x0478:
case	0x0678:
case	0x0878:
case	0x0a78:
case	0x0c78:
case	0x0e78:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	switch(code&DC_02){
		case	0x0000:		//word size
			DD1;	sprintf(buf,"ADDQ.W #$%1X,$%04X\n",TC3,dnm2(1));	CO;
			TUC+=4;	return;

		case	0x0001:		//long size
			DD2;	sprintf(buf,"ADDQ.W #$%1X,$%08X\n",TC3,dnm4(2));	CO;
			TUC+=6;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



case	0x0080:		//long size , data regster direct
case	0x0280:
case	0x0480:
case	0x0680:
case	0x0880:
case	0x0a80:
case	0x0c80:
case	0x0e80:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.L #$%1X,D%d\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0088:		//long size , addr regster direct
case	0x0288:
case	0x0488:
case	0x0688:
case	0x0888:
case	0x0a88:
case	0x0c88:
case	0x0e88:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.L #$%1X,A%d\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0090:		//mem addr
case	0x0290:
case	0x0490:
case	0x0690:
case	0x0890:
case	0x0a90:
case	0x0c90:
case	0x0e90:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.L #$%1X,(A%d)\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x0098:		//mem addr ,postinc
case	0x0298:
case	0x0498:
case	0x0698:
case	0x0898:
case	0x0a98:
case	0x0c98:
case	0x0e98:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.L #$%1X,(A%d)+\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x00a0:		//mem addr ,pridec
case	0x02a0:
case	0x04a0:
case	0x06a0:
case	0x08a0:
case	0x0aa0:
case	0x0ca0:
case	0x0ea0:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD0;	sprintf(buf,"ADDQ.L #$%1X,-(A%d)\n",TC3,RN1);	CO;	TUC+=2;	return;



case	0x00a8:		//mem addr with disp
case	0x02a8:
case	0x04a8:
case	0x06a8:
case	0x08a8:
case	0x0aa8:
case	0x0ca8:
case	0x0ea8:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	DD1;	sprintf(buf,"ADDQ.L #$%1X,$%04X(A%d)\n",TC3,dnm2(1),RN1);	CO;
	TUC+=4;	return;



case	0x00b0:		//byte size , mem addr with index
case	0x02b0:
case	0x04b0:
case	0x06b0:
case	0x08b0:
case	0x0ab0:
case	0x0cb0:
case	0x0eb0:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	RN2=(dnm2(3)>>12)&15;	//index
	DD1;	sprintf(buf,"ADDQ.L #$%1X,$%02X(A%d,X%d)\n",
		TC3,dnm1(1),RN1,RN2);	CO;	TUC+=4;	return;



case	0x00b8:				//abs
case	0x02b8:
case	0x04b8:
case	0x06b8:
case	0x08b8:
case	0x0ab8:
case	0x0cb8:
case	0x0eb8:
	TC3=(code>>9)&DC_02;			//imm data
	if(TC3==0)	TC3=8;				//0 -> 8
	switch(code&DC_02){
		case	0x0000:		//word size
			DD1;	sprintf(buf,"ADDQ.L #$%1X,$%04X\n",TC3,dnm2(1));	CO;
			TUC+=4;	return;

		case	0x0001:		//long size
			DD1;	sprintf(buf,"ADDQ.L #$%1X,$%08X\n",TC3,dnm4(1));	CO;
			TUC+=6;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}
