#ifdef		WIN32
#include	<windows.h>
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/memory.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/console.h"

#ifdef		SATURN
#include	<wnaspi32.h>
#include	<scsidefs.h>
#include	"../include.h/sh.h"
#include	"../include.h/smpc.h"
#include	"../include.h/scu.h"
#include	"../include.h/vdp1.h"
#include	"../include.h/vdp2.h"
#include	"../include.h/monitor.h"
#include	"../include.h/cartport.h"
#include	"../include.h/scsp.h"
#include	"../include.h/bram.h"
#include	"../include.h/cddrv.h"
#include	"../include.h/aspi.h"
#include	"../include.h/unknown.h"

extern		SH			sh2a;
extern		SH			sh2b;
extern		SMPC		smpc;
extern		SCU			scu;
extern		VDP1		vdp1;
extern		VDP2		vdp2;
extern		MONITOR		mon;
extern		CARTPORT	cart;
extern		SCSP		scsp;
extern		BRAM		bram;
extern		CD			cd;
extern		ASPI		aspi;
extern		UNKNOWN		unknown;
#endif

#ifdef		AX68K
#include	"../include.h/video.h"
#include	"../include.h/crtc.h"
#include	"../include.h/mfp.h"
#include	"../include.h/sprbg.h"
#include	"../include.h/fdc.h"
#include	"../include.h/dmac.h"
#include	"../include.h/sysport.h"

extern		VIDEO		video;
extern		CRTC		crtc;
extern		MFP			mfp;
extern		SPRBG		sprbg;
extern		FDC			fdc;
extern		SYSPORT		sysp;
extern		HD63450		dmac;
#endif

extern		MC68K		m68k;
extern		MEMORY		mem;




#ifdef	SATURN
unsigned char	MEMORY::read1(char cn,unsigned long addr)
#endif
#ifdef	AX68K
unsigned char	MEMORY::read1(unsigned long addr)
#endif
{
//	ATS=(unsigned short)(addr>>16);
//	if(MAT[ATS]!=0)	return(*(MAT[ATS]+(addr&0xffff)));



	__asm	{
		mov		eax,dword ptr [addr]
		mov		ebx,dword ptr [this]	;MAT[]
		mov		edx,eax					;LbVp
		xor		ax,ax					;eax=????0000
		shr		eax,14					;x4Ȃ
		cmp		dword ptr [ebx+eax],0
		je		next

		mov		ebx,dword ptr [ebx+eax]	;MAT[high(addr)]
		and		edx,0ffffh				;low(addr)
		mov		al,byte ptr [ebx+edx]	;(USHORT)(MAT[high(addr)]+low(addr))
		jmp		ret_asm
	}
next:

#ifdef		SATURN
#include	"..\memory.cpp\mem_sr1.cpp"
#endif

#ifdef		AX68K
#include	"..\memory.cpp\mem_xr1.cpp"
#endif

#ifdef	_DEBUG
	sprintf(buf,"\t<DEVICE>\tR1\t%08X\n",addr);	CO;
#endif

	return(0xff);
ret_asm:	NULL;
}



//read2l 2byteACgOAE`FbNȂ
#ifdef	SATURN
unsigned short	MEMORY::read2ba(char cn,unsigned long addr)
#endif
#ifdef	AX68K
unsigned short	MEMORY::read2ba(unsigned long addr)
#endif
{
//	if(MAT[(unsigned short)(addr>>16)]!=0){
//		AMI=MAT[(unsigned short)(addr>>16)]+(addr&0xffff);
//		ATS=0;	ATS|=*(AMI )<<8;	ATS|=*(AMI+1);	return(ATS);}



	__asm	{
		mov		eax,dword ptr [addr]
		mov		ebx,dword ptr [this]	;MAT[]
		mov		edx,eax					;LbVp
		xor		ax,ax					;eax=????0000
		shr		eax,14					;x4Ȃ
		cmp		dword ptr [ebx+eax],0
		je		next

		mov		ebx,dword ptr [ebx+eax]	;MAT[high(addr)]
		and		edx,0ffffh				;low(addr)
		mov		ax,word ptr [ebx+edx]	;(USHORT)(MAT[high(addr)]+low(addr))
		xchg	ah,al					;GfBA̕ϊ
		jmp		ret_asm
	}
next:

#ifdef		SATURN
#include	"..\memory.cpp\mem_sr2.cpp"
#endif

#ifdef		AX68K
#include	"..\memory.cpp\mem_xr2.cpp"
#endif

#ifdef	_DEBUG
	sprintf(buf,"\t<DEVICE>\tR2\t%08X\n",addr);	CO;
#endif

	return(0xffff);
ret_asm:	NULL;
}



//read4l 4byteACgOAE`FbNȂ
#ifdef	SATURN
unsigned long	MEMORY::read4ba(char cn,unsigned long addr)
#endif
#ifdef	AX68K
unsigned long	MEMORY::read4ba(unsigned long addr)
#endif
{
//	ATS=(unsigned short)(addr>>16);
//	if(MAT[ATS]!=0){
//		AMI=MAT[ATS]+(addr&0xffff);
//		ATL=0;
//		ATL|=*(AMI  )<<24;	ATL|=*(AMI+1)<<16;
//		ATL|=*(AMI+2)<<8;	ATL|=*(AMI+3);
//		return(ATL);}



	__asm	{
		mov		eax,dword ptr [addr]
		mov		ebx,dword ptr [this]	;MAT[]
		mov		edx,eax					;LbVp
		xor		ax,ax					;eax=????0000
		shr		eax,14					;x4Ȃ
		cmp		dword ptr [ebx+eax],0
		je		next

		mov		ebx,dword ptr [ebx+eax]	;MAT[high(addr)]
		and		edx,0ffffh				;low(addr)
		mov		eax,dword ptr [ebx+edx]	;(ULONG)(MAT[high(addr)]+low(addr))
		bswap	eax						;GfBA̕ϊ
		jmp		ret_asm
	}
next:

#ifdef		SATURN
#include	"..\memory.cpp\mem_sr4.cpp"
#endif
#ifdef		AX68K
#include	"..\memory.cpp\mem_xr4.cpp"
#endif

#ifdef	_DEBUG
	sprintf(buf,"\t<DEVICE>\tR4\t%08X\n",addr);	CO;
#endif

	return(0xffffffff);
ret_asm:	NULL;
}



#ifdef	SATURN
void	MEMORY::write1(char cn,unsigned long addr,unsigned char data)
#endif
#ifdef	AX68K
void	MEMORY::write1(unsigned long addr,unsigned char data)
#endif
{
/*	ATS=(unsigned short)(addr>>16);

#ifdef	SATURN
if((ATS<0x4000)&&((ATS&0x07ff)<0x0009))	return;		//ROM check
#endif

	if(MAT[ATS]!=0){	*(MAT[ATS]+(addr&0xffff))=data;	return;	}	*/



	__asm	{
		mov		ebx,dword ptr [addr]
		mov		eax,ebx				;ʗpLbV
		shr		ebx,16

#ifdef		SATURN
#include	"..\memory.cpp\mem_src.asm"
#endif

#ifdef		AX68K
#include	"..\memory.cpp\mem_xrc.asm"
#endif

		mov		ebx,dword ptr [this]	;MAT[]
		mov		edx,eax					;LbVp
		xor		ax,ax					;eax=????0000
		shr		eax,14					;x4Ȃ
		cmp		dword ptr [ebx+eax],0
		je		next

		mov		ebx,dword ptr [ebx+eax]	;MAT[high(addr)]
		and		edx,0ffffh				;low(addr)
		mov		al,byte ptr [data]
		mov		byte ptr [ebx+edx],al
		jmp		ret_asm
	}
next:

#ifdef		SATURN
#include	"..\memory.cpp\mem_sw1.cpp"
#endif

#ifdef		AX68K
#include	"..\memory.cpp\mem_xw1.cpp"
#endif

#ifdef	_DEBUG
	sprintf(buf,"\t<DEVICE>\tW1\t%08X\t%02X\n",addr,data);	CO;
#endif

ret_asm:	NULL;
}



//write2b 2byteACgOAE`FbNȂ
#ifdef	SATURN
void	MEMORY::write2ba(char cn,unsigned long addr,unsigned short data)
#endif
#ifdef	AX68K
void	MEMORY::write2ba(unsigned long addr,unsigned short data)
#endif
{
/*	ATS=(unsigned short)(addr>>16);

#ifdef	SATURN
if((ATS<0x4000)&&((ATS&0x07ff)<0x0009))	return;		//ROM check
#endif

	if(MAT[ATS]!=0){
		AMI=MAT[ATS]+(addr&0xffff);
		*(AMI  )=(unsigned char)(data>>8);
		*(AMI+1)=(unsigned char)data;	return;	}	*/



	__asm	{
		mov		ebx,dword ptr [addr]
		mov		eax,ebx				;ʗpLbV
		shr		ebx,16

#ifdef		SATURN
#include	"..\memory.cpp\mem_src.asm"
#endif

#ifdef		AX68K
#include	"..\memory.cpp\mem_xrc.asm"
#endif

		mov		ebx,dword ptr [this]	;MAT[]
		mov		edx,eax					;LbVp
		xor		ax,ax					;eax=????0000
		shr		eax,14					;x4Ȃ
		cmp		dword ptr [ebx+eax],0
		je		next

		mov		ebx,dword ptr [ebx+eax]	;MAT[high(addr)]
		and		edx,0ffffh				;low(addr)
		mov		ax,word ptr [data]
		xchg	ah,al					;GfBA̕ϊ
		mov		word ptr [ebx+edx],ax
		jmp		ret_asm
	}
next:

#ifdef		SATURN
#include	"..\memory.cpp\mem_sw2.cpp"
#endif

#ifdef		AX68K
#include	"..\memory.cpp\mem_xw2.cpp"
#endif

#ifdef	_DEBUG
	sprintf(buf,"\t<DEVICE>\tW2\t%08X\t%04X\n",addr,data);	CO;
#endif

ret_asm:	NULL;
}



//write4b 4byteACgOAE`FbNȂ
#ifdef	SATURN
void	MEMORY::write4ba(char cn,unsigned long addr,unsigned long data)
#endif
#ifdef	AX68K
void	MEMORY::write4ba(unsigned long addr,unsigned long data)
#endif
{
/*	ATS=(unsigned short)(addr>>16);

#ifdef	SATURN
if((ATS<0x4000)&&((ATS&0x07ff)<0x0009))	return;		//ROM check
#endif

	if(MAT[ATS]!=0){
		AMI=MAT[ATS]+(addr&0xffff);
		*(AMI  )=(unsigned char)(data>>24);
		*(AMI+1)=(unsigned char)(data>>16);
		*(AMI+2)=(unsigned char)(data>>8);
		*(AMI+3)=(unsigned char)data;	return;	}				*/



	__asm	{
		mov		ebx,dword ptr [addr]
		mov		eax,ebx				;ʗpLbV
		shr		ebx,16

#ifdef		SATURN
#include	"..\memory.cpp\mem_src.asm"
#endif

#ifdef		AX68K
#include	"..\memory.cpp\mem_xrc.asm"
#endif

		mov		ebx,dword ptr [this]	;MAT[]
		mov		edx,eax					;LbVp
		xor		ax,ax					;eax=????0000
		shr		eax,14					;x4Ȃ
		cmp		dword ptr [ebx+eax],0
		je		next

		mov		ebx,dword ptr [ebx+eax]	;MAT[high(addr)]
		and		edx,0ffffh				;low(addr)
		mov		eax,dword ptr [data]
		bswap	eax						;GfBA̕ϊ
		mov		dword ptr [ebx+edx],eax
		jmp		ret_asm
	}
next:

#ifdef		SATURN
#include	"..\memory.cpp\mem_sw4.cpp"
#endif
#ifdef		AX68K
#include	"..\memory.cpp\mem_xw4.cpp"
#endif

#ifdef	_DEBUG
	sprintf(buf,"\t<DEVICE>\tW4\t%08X\t%08X\n",addr,data);	CO;
#endif

ret_asm:	NULL;
}
