#ifdef		WIN32
#include	<windows.h>
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/memory.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/console.h"
#include	"../include.h/sram.h"

extern	MEMORY	mem;
extern	char	szInifilePath[MAX_PATH];



void	SRAM::init(void)
//		SRAM::SRAM(void)
{
	unsigned char	tmp;

	tmp=GetPrivateProfileInt("system","sram_64k",0,szInifilePath);
	if(tmp==1)	VSR|=0x0001;
}



void	SRAM::save(void)
{
	HANDLE			hBRAMFILE;
	unsigned long	dwByte;
	char			path[MAX_PATH];

	GetPrivateProfileString("memory","00ed",NULL,path,sizeof(path),
		szInifilePath);
	hBRAMFILE=CreateFile(path,GENERIC_WRITE,0,0,CREATE_ALWAYS,
		FILE_ATTRIBUTE_NORMAL,0);
	if(hBRAMFILE==(void *)-1){
		WritePrivateProfileString("memory","00ed","sram.ram",szInifilePath);
		return;	}
	if((VSR&0x0001)==0){
			sprintf(buf,"SRAM Saving [16KB] %s ...\n",path);	CO;
			WriteFile(hBRAMFILE,mem.x68k_sram_addr(),0x4000,&dwByte,NULL);	}
	else{	sprintf(buf,"SRAM Saving [64KB] %s ...\n",path);	CO;
			WriteFile(hBRAMFILE,mem.x68k_sram_addr(),0x10000,&dwByte,NULL);	}
	CloseHandle(hBRAMFILE);
}



