//	DMAC HD63450
//	Ver 0.01
//	coded by EG6+

// dual-address mode only.

// Be68k <-> AX68k
#include	"../include.h/directiv.h"

#ifdef		BE68K
#include	<Application.h>
#include	<string.h>
#include	"../include/directiv.h"
#include	"../include/mc68k.h"
#include	"../include/memory.h"
#include	"../include/dmac.h"
#include	"../include/console.h"
#else
#include	<Windows.h>
#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/memory.h"
#include	"../include.h/dmac.h"
#include	"../include.h/console.h"
#endif

extern	MC68K	m68k;
extern	MEMORY	mem;


unsigned char	HD63450::read(unsigned short Addr)
{
#ifdef	_DEBUG
if(m68k.VSR&0x0080){	
	sprintf(buf,"\tDMAC\tR1\t%02X > %02X\n",Addr,DMA_Reg[Addr & 0xff]);	CO;	}
#endif
	return DMA_Reg[Addr & 0xff];
}

unsigned short	HD63450::read2(unsigned short Addr)
{
#ifdef	_DEBUG
if(m68k.VSR&0x0080){	
	sprintf(buf,"\tDMAC\tR2\t%02X > %04X\n",Addr,*((unsigned short *)(DMA_Reg+Addr)));	CO;	}
#endif
	return *((unsigned short *)(DMA_Reg+Addr));
}

unsigned long	HD63450::read4(unsigned short Addr)
{
#ifdef	_DEBUG
if(m68k.VSR&0x0080){	
	sprintf(buf,"\tDMAC\tR4\t%02X > %08X\n",Addr,*((unsigned long *)(DMA_Reg+Addr)));	CO;	}
#endif
	return *((unsigned long *)(DMA_Reg+Addr));
}

void	HD63450::write2(unsigned short Addr,unsigned short Data)
{
#ifdef	_DEBUG
if(m68k.VSR&0x0080){	
	sprintf(buf,"\tDMAC\tW2\t%02X < %04X\n",Addr,Data);	CO;	}
#endif
	*((unsigned short *)(DMA_Reg+Addr))=Data;
}

void	HD63450::write4(unsigned short Addr,unsigned long Data)
{
#ifdef	_DEBUG
if(m68k.VSR&0x0080){	
	sprintf(buf,"\tDMAC\tW4\t%02X < %08X\n",Addr,Data);	CO;	}
#endif
	*((unsigned *)(DMA_Reg+Addr))=Data;
}

void	HD63450::write(unsigned short Addr,unsigned char Data)
{
#ifdef	_DEBUG
if(m68k.VSR&0x0080){	
	sprintf(buf,"\tDMAC\tW1\t%02X < %02X\n",Addr,Data);	CO;	}
#endif
	DMA_Reg[Addr & 0xff]=Data;
	
	// check start operation regs.
	if(DMA_Reg[DMA_CH0+DMA_CCR] & 0x80) {	// FDD
#ifdef	_DEBUG
	sprintf(buf,"\tDMAC\tChannel #0 Active.\n");	CO;
#endif
		DMA_Reg[DMA_CH0+DMA_CSR] |= BIT3;	// channel active '1'
		switch((0x08+0x04)>> 2) {
			case 0:	// no chain
				DataCopy(DMA_CH0);
				break;
			case 2:	// array chain
				ArrayChainCopy(DMA_CH0);
				break;
			case 3:	// link array chain
				LinkArrayChainCopy(DMA_CH0);
				break;
			default:// undefine(error)
				DMA_Reg[DMA_CH0+DMA_CER] = 1;		// error code(cfg err)
				DMA_Reg[DMA_CH0+DMA_CSR] |= BIT4;	// error '1'
				DMA_Reg[DMA_CH0+DMA_CSR] &= (BIT7+BIT6+BIT5+BIT4+BIT2+BIT1+BIT0);
				return;
		}
#ifdef	_DEBUG
	sprintf(buf,"\tDMAC\tOperation #0 completed.\n");	CO;
#endif
		DMA_Reg[DMA_CH0+DMA_CER] = 0;					// no error.
		DMA_Reg[DMA_CH0+DMA_CSR] = (BIT7+BIT6+BIT5);	// operation completed.
	}

	
	if(DMA_Reg[DMA_CH1+DMA_CCR] & BIT7) {	// SASI/SCSI
#ifdef	_DEBUG
	sprintf(buf,"\tDMAC\tChannel #1 Active.\n");	CO;
#endif
		DMA_Reg[DMA_CH1+DMA_CSR] |= BIT3;
		switch((0x08+0x04)>> 2) {
			case 0:	// no chain
				DataCopy(DMA_CH1);
				break;
			case 2:	// array chain
				ArrayChainCopy(DMA_CH1);
				break;
			case 3:	// link array chain
				LinkArrayChainCopy(DMA_CH1);
				break;
			default:// undefine(error)
				DMA_Reg[DMA_CH1+DMA_CER] = 1;		// error code(cfg err)
				DMA_Reg[DMA_CH1+DMA_CSR] |= BIT4;	// error '1'
				DMA_Reg[DMA_CH1+DMA_CSR] &= (BIT7+BIT6+BIT5+BIT4+BIT2+BIT1+BIT0);
				return;
		}
#ifdef	_DEBUG
	sprintf(buf,"\tDMAC\tOperation #1 completed.\n");	CO;
#endif
		DMA_Reg[DMA_CH1+DMA_CER] = 0;					// no error.
		DMA_Reg[DMA_CH1+DMA_CSR] = (BIT7+BIT6+BIT5);	// operation completed.
	}

	
	if(DMA_Reg[DMA_CH2+DMA_CCR] & BIT7) {	// IOCS
#ifdef	_DEBUG
	sprintf(buf,"\tDMAC\tChannel #2 Active.\n");	CO;
#endif
		DMA_Reg[DMA_CH2+DMA_CSR] |= BIT3;
		switch((0x08+0x04)>> 2) {
			case 0:	// no chain
				DataCopy(DMA_CH2);
				break;
			case 2:	// array chain
				ArrayChainCopy(DMA_CH2);
				break;
			case 3:	// link array chain
				LinkArrayChainCopy(DMA_CH2);
				break;
			default:// undefine(error)
				DMA_Reg[DMA_CH2+DMA_CER] = 1;		// error code(cfg err)
				DMA_Reg[DMA_CH2+DMA_CSR] |= BIT4;	// error '1'
				DMA_Reg[DMA_CH2+DMA_CSR] &= (BIT7+BIT6+BIT5+BIT4+BIT2+BIT1+BIT0);
				return;
		}
#ifdef	_DEBUG
	sprintf(buf,"\tDMAC\tOperation #2 completed.\n");	CO;
#endif
		DMA_Reg[DMA_CH2+DMA_CER] = 0;					// no error.
		DMA_Reg[DMA_CH2+DMA_CSR] = (BIT7+BIT6+BIT5);	// operation completed.
	}

	
	if(DMA_Reg[DMA_CH3+DMA_CCR] & BIT7) {	// ADPCM
#ifdef	_DEBUG
	sprintf(buf,"\tDMAC\tChannel #3 Active.\n");	CO;
#endif
		DMA_Reg[DMA_CH3+DMA_CSR] |= BIT3;
		switch((0x08+0x04)>> 2) {
			case 0:	// no chain
				DataCopy(DMA_CH3);
				break;
			case 2:	// array chain
				ArrayChainCopy(DMA_CH3);
				break;
			case 3:	// link array chain
				LinkArrayChainCopy(DMA_CH3);
				break;
			default:// undefine(error)
				DMA_Reg[DMA_CH3+DMA_CER] = 1;		// error code(cfg err)
				DMA_Reg[DMA_CH3+DMA_CSR] |= BIT4;	// error '1'
				DMA_Reg[DMA_CH3+DMA_CSR] &= (BIT7+BIT6+BIT5+BIT4+BIT2+BIT1+BIT0);
				return;
		}
#ifdef	_DEBUG
	sprintf(buf,"\tDMAC\tOperation #3 completed.\n");	CO;
#endif
		DMA_Reg[DMA_CH3+DMA_CER] = 0;					// no error.
		DMA_Reg[DMA_CH3+DMA_CSR] = (BIT7+BIT6+BIT5);	// operation completed.
	}
}

void	HD63450::ArrayChainCopy(DMA_Channel Channel)
{
	unsigned		*AddrMAR,*AddrDAR;
	unsigned short	*AddrBAR,*AddrBTC;
	unsigned		vBAR,vBTC,vMTC,vMAR,vDAR;
	int				CountMAC,CountDAC;
	
	
	AddrBAR=(unsigned short *)(DMA_Reg+Channel+DMA_BAR);	// base addr
	AddrBTC=(unsigned short *)(DMA_Reg+Channel+DMA_BTC);	// blocks
	vBAR=*AddrBAR;
	vBTC=*AddrBTC;
	CountMAC=(DMA_Reg[Channel+DMA_SCR] & (BIT3+BIT2))>> 2;
	CountDAC=DMA_Reg[Channel+DMA_SCR] & (BIT1+BIT0);
	
	if(DMA_Reg[Channel+DMA_OCR] & BIT7) {
		// device -> memory
		for(;vBTC>0;vBTC--) {
			AddrDAR=(unsigned *)(DMA_Reg+Channel+DMA_DAR);
			vDAR=*AddrDAR;
			vMAR=m68_read4(vBAR);
			vMTC=m68_read2(vBAR+4);
			if((CountMAC)||(CountDAC)) {	// check mem-addr count
				// count copy
				switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
					case 0:	// 8bit
					case 3:	// 8bit no-pack
						for(;vMTC>0;vMTC--) {
							m68_write1(vMAR,m68_read1(vDAR));
							vMAR++;
							vDAR++;
							if(CountMAC & 1) *AddrMAR++;
							if(CountDAC & 1) *AddrDAR++;
							if(CountMAC & 2) *AddrMAR--;
							if(CountDAC & 2) *AddrDAR--;
						}
						break;
					case 1:	// 16bit
						for(;vMTC>0;vMTC--) {
							m68_write2(vMAR,m68_read2(vDAR));
							vMAR+=2;
							vDAR+=2;
							if(CountMAC & 1) *AddrMAR+=2;
							if(CountDAC & 1) *AddrDAR+=2;
							if(CountMAC & 2) *AddrMAR-=2;
							if(CountDAC & 2) *AddrDAR-=2;
						}
						break;
					case 2:	// 32bit
						for(;vMTC>0;vMTC--) {
							m68_write4(vMAR,m68_read4(vDAR));
							vMAR+=4;
							vDAR+=4;
							if(CountMAC & 1) *AddrMAR+=4;
							if(CountDAC & 1) *AddrDAR+=4;
							if(CountMAC & 2) *AddrMAR-=4;
							if(CountDAC & 2) *AddrDAR-=4;
						}
						break;
				}
			}else{
				// no count copy
				switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
					case 0:	// 8bit
					case 3:	// 8bit no-pack
						for(;vMTC>0;vMTC--) {
							m68_write1(vMAR,m68_read1(vDAR));
							vMAR++;
							vDAR++;
						}
						break;
					case 1:	// 16bit
						for(;vMTC>0;vMTC--) {
							m68_write2(vMAR,m68_read2(vDAR));
							vMAR+=2;
							vDAR+=2;
						}
						break;
					case 2:	// 32bit
						for(;vMTC>0;vMTC--) {
							m68_write4(vMAR,m68_read4(vDAR));
							vMAR+=4;
							vDAR+=4;
						}
						break;
				}
			}
			vBAR+=6;
			*AddrBTC--;
		}
	}else{
		// memory -> device
		for(;vBTC>0;vBTC--) {
			AddrMAR=(unsigned *)(DMA_Reg+Channel+DMA_MAR);
			vMAR=*AddrMAR;
			vDAR=m68_read4(vBAR);
			vMTC=m68_read2(vBAR+4);
			// memory -> device
			if((CountMAC)||(CountDAC)) {
				switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
					case 0:	// 8bit
					case 3:	// 8bit no-pack
						for(;vMTC>0;vMTC--) {
							m68_write1(vDAR,m68_read1(vMAR));
							vMAR++;
							vDAR++;
							if(CountMAC & 1) *AddrMAR++;
							if(CountDAC & 1) *AddrDAR++;
							if(CountMAC & 2) *AddrMAR--;
							if(CountDAC & 2) *AddrDAR--;
						}
						break;
					case 1:	// 16bit
						for(;vMTC>0;vMTC--) {
							m68_write2(vDAR,m68_read2(vMAR));
							vMAR+=2;
							vDAR+=2;
							if(CountMAC & 1) *AddrMAR+=2;
							if(CountDAC & 1) *AddrDAR+=2;
							if(CountMAC & 2) *AddrMAR-=2;
							if(CountDAC & 2) *AddrDAR-=2;
						}
						break;
					case 2:	// 32bit
						for(;vMTC>0;vMTC--) {
							m68_write4(vDAR,m68_read4(vMAR));
							vMAR+=4;
							vDAR+=4;
							if(CountMAC & 1) *AddrMAR+=4;
							if(CountDAC & 1) *AddrDAR+=4;
							if(CountMAC & 2) *AddrMAR-=4;
							if(CountDAC & 2) *AddrDAR-=4;
						}
						break;
				}
			}else{
				// no count copy
				switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
					case 0:	// 8bit
					case 3:	// 8bit no-pack
						for(;vMTC>0;vMTC--) {
							m68_write1(vDAR,m68_read1(vMAR));
							vMAR++;
							vDAR++;
						}
						break;
					case 1:	// 16bit
						for(;vMTC>0;vMTC--) {
							m68_write2(vDAR,m68_read2(vMAR));
							vMAR+=2;
							vDAR+=2;
						}
						break;
					case 2:	// 32bit
						for(;vMTC>0;vMTC--) {
							m68_write4(vDAR,m68_read4(vMAR));
							vMAR+=4;
							vDAR+=4;
						}
						break;
				}
			}
			vBAR+=6;
			*AddrBTC--;
		}
	}
	
}

void	HD63450::LinkArrayChainCopy(DMA_Channel Channel)
{
	unsigned		*AddrMAR,*AddrDAR;
	unsigned short	*AddrBAR,*AddrBTC;
	unsigned		vBAR,vBTC,vMTC,vMAR,vDAR;
	int				CountMAC,CountDAC;
	
	
	AddrBAR=(unsigned short *)(DMA_Reg+Channel+DMA_BAR);		// base addr
	AddrBTC=(unsigned short *)(DMA_Reg+Channel+DMA_BTC);// blocks
	vBAR=*AddrBAR;
	vBTC=*AddrBTC;
	CountMAC=(DMA_Reg[Channel+DMA_SCR] & (BIT3+BIT2))>> 2;
	CountDAC=DMA_Reg[Channel+DMA_SCR] & (BIT1+BIT0);
	
	if(DMA_Reg[Channel+DMA_OCR] & BIT7) {
		// device -> memory
		while(vBAR!=0) {
			AddrDAR=(unsigned *)(DMA_Reg+Channel+DMA_DAR);
			vDAR=*AddrDAR;
			vMAR=m68_read4(vBAR);
			vMTC=m68_read2(vBAR+4);
			if((CountMAC)||(CountDAC)) {	// check mem-addr count
				// count copy
				switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
					case 0:	// 8bit
					case 3:	// 8bit no-pack
						for(;vMTC>0;vMTC--) {
							m68_write1(vMAR,m68_read1(vDAR));
							vMAR++;
							vDAR++;
							if(CountMAC & 1) *AddrMAR++;
							if(CountDAC & 1) *AddrDAR++;
							if(CountMAC & 2) *AddrMAR--;
							if(CountDAC & 2) *AddrDAR--;
						}
						break;
					case 1:	// 16bit
						for(;vMTC>0;vMTC--) {
							m68_write2(vMAR,m68_read2(vDAR));
							vMAR+=2;
							vDAR+=2;
							if(CountMAC & 1) *AddrMAR+=2;
							if(CountDAC & 1) *AddrDAR+=2;
							if(CountMAC & 2) *AddrMAR-=2;
							if(CountDAC & 2) *AddrDAR-=2;
						}
						break;
					case 2:	// 32bit
						for(;vMTC>0;vMTC--) {
							m68_write4(vMAR,m68_read4(vDAR));
							vMAR+=4;
							vDAR+=4;
							if(CountMAC & 1) *AddrMAR+=4;
							if(CountDAC & 1) *AddrDAR+=4;
							if(CountMAC & 2) *AddrMAR-=4;
							if(CountDAC & 2) *AddrDAR-=4;
						}
						break;
				}
			}else{
				// no count copy
				switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
					case 0:	// 8bit
					case 3:	// 8bit no-pack
						for(;vMTC>0;vMTC--) {
							m68_write1(vMAR,m68_read1(vDAR));
							vMAR++;
							vDAR++;
						}
						break;
					case 1:	// 16bit
						for(;vMTC>0;vMTC--) {
							m68_write2(vMAR,m68_read2(vDAR));
							vMAR+=2;
							vDAR+=2;
						}
						break;
					case 2:	// 32bit
						for(;vMTC>0;vMTC--) {
							m68_write4(vMAR,m68_read4(vDAR));
							vMAR+=4;
							vDAR+=4;
						}
						break;
				}
			}
			vBAR=m68_read4(vBAR+6);
		}
	}else{
		// memory -> device
		while(vBAR!=0) {
			AddrMAR=(unsigned *)(DMA_Reg+Channel+DMA_MAR);
			vMAR=*AddrMAR;
			vDAR=m68_read4(vBAR);
			vMTC=m68_read2(vBAR+4);
			// memory -> device
			if((CountMAC)||(CountDAC)) {
				switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
					case 0:	// 8bit
					case 3:	// 8bit no-pack
						for(;vMTC>0;vMTC--) {
							m68_write1(vDAR,m68_read1(vMAR));
							vMAR++;
							vDAR++;
							if(CountMAC & 1) *AddrMAR++;
							if(CountDAC & 1) *AddrDAR++;
							if(CountMAC & 2) *AddrMAR--;
							if(CountDAC & 2) *AddrDAR--;
						}
						break;
					case 1:	// 16bit
						for(;vMTC>0;vMTC--) {
							m68_write2(vDAR,m68_read2(vMAR));
							vMAR+=2;
							vDAR+=2;
							if(CountMAC & 1) *AddrMAR+=2;
							if(CountDAC & 1) *AddrDAR+=2;
							if(CountMAC & 2) *AddrMAR-=2;
							if(CountDAC & 2) *AddrDAR-=2;
						}
						break;
					case 2:	// 32bit
						for(;vMTC>0;vMTC--) {
							m68_write4(vDAR,m68_read4(vMAR));
							vMAR+=4;
							vDAR+=4;
							if(CountMAC & 1) *AddrMAR+=4;
							if(CountDAC & 1) *AddrDAR+=4;
							if(CountMAC & 2) *AddrMAR-=4;
							if(CountDAC & 2) *AddrDAR-=4;
						}
						break;
				}
			}else{
				// no count copy
				switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
					case 0:	// 8bit
					case 3:	// 8bit no-pack
						for(;vMTC>0;vMTC--) {
							m68_write1(vDAR,m68_read1(vMAR));
							vMAR++;
							vDAR++;
						}
						break;
					case 1:	// 16bit
						for(;vMTC>0;vMTC--) {
							m68_write2(vDAR,m68_read2(vMAR));
							vMAR+=2;
							vDAR+=2;
						}
						break;
					case 2:	// 32bit
						for(;vMTC>0;vMTC--) {
							m68_write4(vDAR,m68_read4(vMAR));
							vMAR+=4;
							vDAR+=4;
						}
						break;
				}
			}
			vBAR=m68_read4(vBAR+6);
		}
	}
	
}

void	HD63450::DataCopy(DMA_Channel Channel)
{
	unsigned		*AddrMAR,*AddrDAR;
	unsigned short	*AddrMTC;
	unsigned		vMAR,vDAR,vMTC;
	int				CountMAC,CountDAC;
	
	AddrMAR=(unsigned *)(DMA_Reg+Channel+DMA_MAR);		// memory addr
	AddrDAR=(unsigned *)(DMA_Reg+Channel+DMA_DAR);		// device addr
	AddrMTC=(unsigned short *)(DMA_Reg+Channel+DMA_MTC);// MTC addr
	vMAR=*AddrMAR;
	vDAR=*AddrDAR;
	vMTC=*AddrMTC;
	CountMAC=(DMA_Reg[Channel+DMA_SCR] & (BIT3+BIT2))>> 2;
	CountDAC=DMA_Reg[Channel+DMA_SCR] & (BIT1+BIT0);
	
	// data copy
	if(DMA_Reg[Channel+DMA_OCR] & BIT7) {
		// device -> memory
		if((CountMAC)||(CountDAC)) {	// check mem-addr count
			// count copy
			switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
				case 0:	// 8bit
				case 3:	// 8bit no-pack
					for(;vMTC>0;vMTC--) {
						m68_write1(vMAR,m68_read1(vDAR));
						vMAR++;
						vDAR++;
						if(CountMAC & 1) *AddrMAR++;
						if(CountDAC & 1) *AddrDAR++;
						if(CountMAC & 2) *AddrMAR--;
						if(CountDAC & 2) *AddrDAR--;
						*AddrMTC--;
					}
					break;
				case 1:	// 16bit
					for(;vMTC>0;vMTC--) {
						m68_write2(vMAR,m68_read2(vDAR));
						vMAR+=2;
						vDAR+=2;
						if(CountMAC & 1) *AddrMAR+=2;
						if(CountDAC & 1) *AddrDAR+=2;
						if(CountMAC & 2) *AddrMAR-=2;
						if(CountDAC & 2) *AddrDAR-=2;
						*AddrMTC--;
					}
					break;
				case 2:	// 32bit
					for(;vMTC>0;vMTC--) {
						m68_write4(vMAR,m68_read4(vDAR));
						vMAR+=4;
						vDAR+=4;
						if(CountMAC & 1) *AddrMAR+=4;
						if(CountDAC & 1) *AddrDAR+=4;
						if(CountMAC & 2) *AddrMAR-=4;
						if(CountDAC & 2) *AddrDAR-=4;
						*AddrMTC--;
					}
					break;
			}
		}else{
			// no count copy
			switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
				case 0:	// 8bit
				case 3:	// 8bit no-pack
					for(;vMTC>0;vMTC--) {
						m68_write1(vMAR,m68_read1(vDAR));
						vMAR++;
						vDAR++;
						*AddrMTC--;
					}
					break;
				case 1:	// 16bit
					for(;vMTC>0;vMTC--) {
						m68_write2(vMAR,m68_read2(vDAR));
						vMAR+=2;
						vDAR+=2;
						*AddrMTC--;
					}
					break;
				case 2:	// 32bit
					for(;vMTC>0;vMTC--) {
						m68_write4(vMAR,m68_read4(vDAR));
						vMAR+=4;
						vDAR+=4;
						*AddrMTC--;
					}
					break;
			}
		}
	}else{
		// memory -> device
		if((CountMAC)||(CountDAC)) {
			switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
				case 0:	// 8bit
				case 3:	// 8bit no-pack
					for(;vMTC>0;vMTC--) {
						m68_write1(vDAR,m68_read1(vMAR));
						vMAR++;
						vDAR++;
						if(CountMAC & 1) *AddrMAR++;
						if(CountDAC & 1) *AddrDAR++;
						if(CountMAC & 2) *AddrMAR--;
						if(CountDAC & 2) *AddrDAR--;
						*AddrMTC--;
					}
					break;
				case 1:	// 16bit
					for(;vMTC>0;vMTC--) {
						m68_write2(vDAR,m68_read2(vMAR));
						vMAR+=2;
						vDAR+=2;
						if(CountMAC & 1) *AddrMAR+=2;
						if(CountDAC & 1) *AddrDAR+=2;
						if(CountMAC & 2) *AddrMAR-=2;
						if(CountDAC & 2) *AddrDAR-=2;
						*AddrMTC--;
					}
					break;
				case 2:	// 32bit
					for(;vMTC>0;vMTC--) {
						m68_write4(vDAR,m68_read4(vMAR));
						vMAR+=4;
						vDAR+=4;
						if(CountMAC & 1) *AddrMAR+=4;
						if(CountDAC & 1) *AddrDAR+=4;
						if(CountMAC & 2) *AddrMAR-=4;
						if(CountDAC & 2) *AddrDAR-=4;
						*AddrMTC--;
					}
					break;
			}
		}else{
			// no count copy
			switch((DMA_Reg[Channel+DMA_OCR] & (BIT5+BIT4))>> 4) {
				case 0:	// 8bit
				case 3:	// 8bit no-pack
					for(;vMTC>0;vMTC--) {
						m68_write1(vDAR,m68_read1(vMAR));
						vMAR++;
						vDAR++;
						*AddrMTC--;
					}
					break;
				case 1:	// 16bit
					for(;vMTC>0;vMTC--) {
						m68_write2(vDAR,m68_read2(vMAR));
						vMAR+=2;
						vDAR+=2;
						*AddrMTC--;
					}
					break;
				case 2:	// 32bit
					for(;vMTC>0;vMTC--) {
						m68_write4(vDAR,m68_read4(vMAR));
						vMAR+=4;
						vDAR+=4;
						*AddrMTC--;
					}
					break;
			}
		}
	}
}

void	HD63450::init(void)
{
	for(int idx=0;idx<(0x40*4);idx++) {
		DMA_Reg[idx]=0;
	}
}
