#ifdef		WIN32
#include	<windows.h>
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/console.h"
#include	"../include.h/fdc.h"

extern	MC68K	m68k;



unsigned char	FDC::read(unsigned short addr)
{
	switch(addr){
		case	0x0001:
#ifdef	_DEBUG
if(m68k.VSR&0x0080){
	sprintf(buf,"\tFDC\tR1\t01 > 80\n");	CO;	}
#endif
			return(0x80);			break;

		case	0x0005:
#ifdef	_DEBUG
if(m68k.VSR&0x0080){
	sprintf(buf,"\tFDC\tR1\t05 > 00\n");	CO;	}
#endif
			return(0x00);			break;



		case	0x0000:
		case	0x0002:
		case	0x0004:
		case	0x0006:
		case	0x0008:
		case	0x000a:
		case	0x000c:
		case	0x000e:
#ifdef	_DEBUG
if(m68k.VSR&0x0080){
	sprintf(buf,"\tFDC\tR1\t%02X > FF\n",addr);	CO;	}
#endif
			return(0xff);			break;



		default:
#ifdef	_DEBUG
if(m68k.VSR&0x0080){
	sprintf(buf,"\tFDC\tR1\t%02X > %02X\n",addr,reg[addr>>1]);	CO;	}
#endif
			return(reg[addr>>1]);	break;
	}

}
