class	MC68K{
public:
	unsigned long	D[8];
	unsigned long	A[8];
	unsigned long	USP,SSP;
	unsigned long	PC;
	unsigned short	SR;

	unsigned short	VSR;				//VirtualStatusRegister
		//VSR=0x8000	Renterant Check
		//VSR=0x4000	processer active flug
		//VSR=0x0200	enable bleak point
		//VSR=0x0100	auto display register
		//VSR=0x0080	display memory error & device access
		//VSR=0x0040	display code enable about jump
		//VSR=0x0020	display code enable
		//VSR=0x0010	Enable Interrupt

	unsigned long	ISR1;				//InterruptStatusRegister
#ifdef	AX68K
	unsigned short	ISR4,ISR5,ISR6;		//X68K system depend
#endif
	unsigned long	ICR;				//InterruptCountRegister
	unsigned long	IDS;				//InterruptDelayStep
	unsigned long	TTC;				//Temp Trace Counter
	unsigned long	TUC;				//Temp disassem Counter
	unsigned long	TSR;				//Temp SR
	unsigned long	BPL[BPL_MAX];		//Break Point List



//					MC68K(unsigned char);
	void			init(void);
	void			main_loop(void);
	void			decode(unsigned short);
	void			disasm(unsigned short);
	unsigned char	interrupt(void);
	void			stat(void);
//ꊄ荞
	void			i_rst(void);		//ReSeT
	void			i_be(void);			//Bus Error
	void			i_ae(void);			//Address Error
	void			i_gic(void);		//General Invalid Code
	void			i_dvz(void);		//DiVid Zero
	void			i_chk(void);		//CHK
	void			i_trv(void);		//TRapV
};



//	<<< Macros >>>

//Read wrapper
#ifdef	AX68K
#define	m68_read1(addr)			(mem.read1	 (addr))
#define	m68_read2(addr)			(mem.read2ba (addr))
#define	m68_read4(addr)			(mem.read4ba (addr))
#define	m68_write1(addr,data)	(mem.write1	 (addr,data))
#define	m68_write2(addr,data)	(mem.write2ba(addr,data))
#define	m68_write4(addr,data)	(mem.write4ba(addr,data))
#endif

#ifdef	SATURN
#define	m68_read1(addr)			(mem.read1	 (3,(addr&0x001fffff)+0x05a00000))
#define	m68_read2(addr)			(mem.read2ba (3,(addr&0x001fffff)+0x05a00000))
#define	m68_read4(addr)			(mem.read4ba (3,(addr&0x001fffff)+0x05a00000))
#define	m68_write1(addr,data)	(mem.write1	 (3,(addr&0x001fffff)+0x05a00000,data))
#define	m68_write2(addr,data)	(mem.write2ba(3,(addr&0x001fffff)+0x05a00000,data))
#define	m68_write4(addr,data)	(mem.write4ba(3,(addr&0x001fffff)+0x05a00000,data))
#endif



//	<<< decode >>>

//get operand
#define	num1(addr)	(m68_read1(PC+addr*2+1))
#define	num2(addr)	(m68_read2(PC+addr*2))
#define	num4(addr)	(m68_read4(PC+addr*2))

//display binary code
#define	BD0	sprintf(buf,"%04X                     ",num2(0));CO
#define	BD1	sprintf(buf,"%04X %04X                ",num2(0),num2(1));CO
#define	BD2	sprintf(buf,"%04X %04X %04X           ",num2(0),num2(1),num2(2));CO
#define	BD3	sprintf(buf,"%04X %04X %04X %04X      ",num2(0),num2(1),num2(2),num2(3));CO
#define	BD4	sprintf(buf,"%04X %04X %04X %04X %04X ",num2(0),num2(1),num2(2),num2(3),num2(4));CO



//	<<< disassemble >>>

//get operand
#ifdef	SATURN
#define	dnm1(addr)	(mem.read1(3,TUC+addr*2+1))
#define	dnm2(addr)	(mem.read2ba(3,TUC+addr*2))
#define	dnm4(addr)	(mem.read4ba(3,TUC+addr*2))
#endif
#ifdef	AX68K
#define	dnm1(addr)	(mem.read1(TUC+addr*2+1))
#define	dnm2(addr)	(mem.read2ba(TUC+addr*2))
#define	dnm4(addr)	(mem.read4ba(TUC+addr*2))
#endif

//display binary code
#define	DD0	sprintf(buf,"%04X                     ",dnm2(0));CO
#define	DD1	sprintf(buf,"%04X %04X                ",dnm2(0),dnm2(1));CO
#define	DD2	sprintf(buf,"%04X %04X %04X           ",dnm2(0),dnm2(1),dnm2(2));CO
#define	DD3	sprintf(buf,"%04X %04X %04X %04X      ",dnm2(0),dnm2(1),dnm2(2),dnm2(3));CO
#define	DD4	sprintf(buf,"%04X %04X %04X %04X %04X ",dnm2(0),dnm2(1),dnm2(2),dnm2(3),dnm2(4));CO



//opecode bit field
#define	DC_02	0x0007
#define	DC_03	0x000f
#define	DC_07	0x00ff
#define	DC_33	0x0008
#define	DC_34	0x0018
#define	DC_35	0x0038
#define	DC_37	0x00f8
#define	DC_38	0x01f8
#define	DC_3b	0x0ff8
#define	DC_55	0x0020
#define	DC_66	0x0040
#define	DC_67	0x00c0
#define	DC_68	0x01c0
#define	DC_88	0x0080
#define	DC_8b	0x0f00
#define	DC_9b	0x0e00

//status bit
#define	CCR_CON		(unsigned short)0x0001
#define	CCR_VON		(unsigned short)0x0002
#define	CCR_ZON		(unsigned short)0x0004
#define	CCR_NON		(unsigned short)0x0008
#define	CCR_XON		(unsigned short)0x0010

#define	CCR_COFF	(unsigned short)0xfffe
#define	CCR_VOFF	(unsigned short)0xfffd
#define	CCR_ZOFF	(unsigned short)0xfffb
#define	CCR_NOFF	(unsigned short)0xfff7
#define	CCR_XOFF	(unsigned short)0xffef

//condition code
#define	CC_T	0x0
#define	CC_F	0x1
#define	CC_HI	0x2
#define	CC_LS	0x3
#define	CC_CC	0x4
#define	CC_CS	0x5
#define	CC_NE	0x6
#define	CC_EQ	0x7
#define	CC_VC	0x8
#define	CC_VS	0x9
#define	CC_PL	0xA
#define	CC_MI	0xB
#define	CC_GE	0xC
#define	CC_LT	0xD
#define	CC_GT	0xE
#define	CC_LE	0xF
