//	MC68K Interrupt trap section
#ifdef		WIN32
#include	<windows.h>
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/memory.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/console.h"
#include	"../include.h/monitor.h"

#ifdef		BE68K
extern	DispView *MonView;
#endif

extern	MEMORY	mem;
extern	MONITOR	mon;



unsigned char	MC68K::interrupt(void)
{
//	unsigned long	TR1;				//Temp Register
	unsigned char	TC1,TC2;			//Temp Char



	if(ICR!=0){	ICR--;	return(0);	}	//荞݌̈ԋ֎~
	if((VSR&0x0010)==0)	return(0);		//荞݋֎~ij^ɂwj

	if(ISR1!=0){
		if((ISR1&0x00000001)!=0){		//NMI	OIɈԍŏɏ
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){
		sprintf(buf,"Non Maskable Interrupt\n");	CO;	}
#endif
			A[7]-=8;	SR|=0x0700;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x0000002c);
			ISR1&=0xfffffffe;	ICR=IDS;	return(-1);		}
	}



	TC1=(SR>>8)&7;	TC2=0xff;						//interrupt level,ID
#ifdef	AX68K
												//X68K system depend
	if((ISR4!=0)&&(TC1<6)){						//MFP interrupt level6 ID 4x
		if(ISR4&0x0001){	TC1=6;	TC2=0x40;	}	//RTC alarm/1Hz
		if(ISR4&0x0002){	TC1=6;	TC2=0x41;	}	//Ext Pow off
		if(ISR4&0x0004){	TC1=6;	TC2=0x42;	}	//Fnt pow off
		if(ISR4&0x0008){	TC1=6;	TC2=0x43;	}	//FM
		if(ISR4&0x0010){	TC1=6;	TC2=0x44;	}	//Timer-d
		if(ISR4&0x0020){	TC1=6;	TC2=0x45;	}	//Timer-c
		if(ISR4&0x0040){	TC1=6;	TC2=0x46;	}	//V-Disp
		if(ISR4&0x0080){	TC1=6;	TC2=0x47;	}	//RTC clock
		if(ISR4&0x0100){	TC1=6;	TC2=0x48;	}	//Timer-b
		if(ISR4&0x0200){	TC1=6;	TC2=0x49;	}	//key data output error
		if(ISR4&0x0400){	TC1=6;	TC2=0x4a;	}	//key data empty
		if(ISR4&0x0800){	TC1=6;	TC2=0x4b;	}	//key data input error
		if(ISR4&0x1000){	TC1=6;	TC2=0x4c;	}	//key data exist
		if(ISR4&0x2000){	TC1=6;	TC2=0x4d;	}	//Timer-a
		if(ISR4&0x4000){	TC1=6;	TC2=0x4e;	}	//CRTC irq
		if(ISR4&0x8000){	TC1=6;	TC2=0x4f;	}	//H-Sync
	}



	if((ISR5!=0)&&(TC1<5)){						//SCC interrupt level6 ID 4x
		if(ISR5&0x0001){	TC1=5;	TC2=0x50;	}	//send buffer empty B
		if(ISR5&0x0002){	TC1=5;	TC2=0x51;	}
		if(ISR5&0x0004){	TC1=5;	TC2=0x52;	}	//changed status
		if(ISR5&0x0008){	TC1=5;	TC2=0x53;	}
		if(ISR5&0x0010){	TC1=5;	TC2=0x54;	}	//valid data
		if(ISR5&0x0020){	TC1=5;	TC2=0x55;	}
		if(ISR5&0x0040){	TC1=5;	TC2=0x56;	}	//Sp Rx condition
		if(ISR5&0x0080){	TC1=5;	TC2=0x57;	}
		if(ISR5&0x0100){	TC1=5;	TC2=0x58;	}	//send buffer empty A
		if(ISR5&0x0200){	TC1=5;	TC2=0x59;	}
		if(ISR5&0x0400){	TC1=5;	TC2=0x5a;	}
		if(ISR5&0x0800){	TC1=5;	TC2=0x5b;	}
		if(ISR5&0x1000){	TC1=5;	TC2=0x5c;	}
		if(ISR5&0x2000){	TC1=5;	TC2=0x5d;	}
		if(ISR5&0x4000){	TC1=5;	TC2=0x5e;	}
		if(ISR5&0x8000){	TC1=5;	TC2=0x5f;	}
	}



	if((ISR6!=0)&&(TC1<3)){						//DMAC
		if(ISR6&0x0010){	TC1=3;	TC2=0x64;	}
		if(ISR6&0x0020){	TC1=3;	TC2=0x65;	}
		if(ISR6&0x0040){	TC1=3;	TC2=0x66;	}
		if(ISR6&0x0080){	TC1=3;	TC2=0x67;	}
		if(ISR6&0x0100){	TC1=3;	TC2=0x68;	}
		if(ISR6&0x0200){	TC1=3;	TC2=0x69;	}
		if(ISR6&0x0400){	TC1=3;	TC2=0x6a;	}
		if(ISR6&0x0800){	TC1=3;	TC2=0x6b;	}
	}

	if((ISR6!=0)&&(TC1<1)){						//I/O
		if(ISR6&0x0001){	TC1=1;	TC2=0x60;	}
		if(ISR6&0x0002){	TC1=1;	TC2=0x61;	}
		if(ISR6&0x0004){	TC1=1;	TC2=0x62;	}
		if(ISR6&0x0008){	TC1=1;	TC2=0x63;	}
		if(ISR6&0x1000){	TC1=1;	TC2=0x6c;	}	//SPC internal scsi
	}





	switch(TC2){
		case	0x40:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP RTC alarm/1Hz\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x40<<2);
			ISR4&=0xfffe;	ICR=IDS;	return(-1);



		case	0x41:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP Ext.Pow off\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x41<<2);
			ISR4&=0xfffd;	ICR=IDS;	return(-1);



		case	0x42:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP FRT.Pow off\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x42<<2);
			ISR4&=0xfffb;	ICR=IDS;	return(-1);



		case	0x43:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP FM SGEN\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x43<<2);
			ISR4&=0xfff7;	ICR=IDS;	return(-1);



		case	0x44:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP Timer-D\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x44<<2);
			ISR4&=0xffef;	ICR=IDS;	return(-1);



		case	0x45:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP Timer-C\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x45<<2);
			ISR4&=0xffdf;	ICR=IDS;	return(-1);



		case	0x46:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP V-Disp\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x46<<2);
			ISR4&=0xffbf;	ICR=IDS;	return(-1);



		case	0x47:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP RTC clock\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x47<<2);
			ISR4&=0xff7f;	ICR=IDS;	return(-1);



		case	0x48:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP Timer-B\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x48<<2);
			ISR4&=0xfeff;	ICR=IDS;	return(-1);



		case	0x49:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP KeyData Output Error\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x49<<2);
			ISR4&=0xfdff;	ICR=IDS;	return(-1);



		case	0x4a:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP KeyData Empty\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x4a<<2);
			ISR4&=0xfbff;	ICR=IDS;	return(-1);



		case	0x4b:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP KeyData Input Error\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x4b<<2);
			ISR4&=0xf7ff;	ICR=IDS;	return(-1);



		case	0x4c:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP KeyData Exist\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x4c<<2);
			ISR4&=0xefff;	ICR=IDS;	return(-1);



		case	0x4d:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP Timer-A\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x4d<<2);
			ISR4&=0xdfff;	ICR=IDS;	return(-1);



		case	0x4e:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP CRTC IRQ\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x4e<<2);
			ISR4&=0xbfff;	ICR=IDS;	return(-1);



		case	0x4f:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"MFP H-Sync\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0600;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x4f<<2);
			ISR4&=0x7fff;	ICR=IDS;	return(-1);










		case	0x50:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC B Send Buffer Empty\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x50<<2);
			ISR5&=0xfffe;	ICR=IDS;	return(-1);



		case	0x51:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC B Send Buffer Empty\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x51<<2);
			ISR5&=0xfffd;	ICR=IDS;	return(-1);



		case	0x52:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC B Ext/Status changed\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x52<<2);
			ISR5&=0xfffb;	ICR=IDS;	return(-1);



		case	0x53:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC B Ext/Status changed\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x53<<2);
			ISR5&=0xfff7;	ICR=IDS;	return(-1);



		case	0x54:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC B Receive Valid char.\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x54<<2);
			ISR5&=0xffef;	ICR=IDS;	return(-1);



		case	0x55:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC B Receive Valid char.\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x55<<2);
			ISR5&=0xffdf;	ICR=IDS;	return(-1);



		case	0x56:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC B Sp.Rx Condition\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x56<<2);
			ISR5&=0xffbf;	ICR=IDS;	return(-1);



		case	0x57:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC B Sp.Rx Condition\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x57<<2);
			ISR5&=0xff7f;	ICR=IDS;	return(-1);



		case	0x58:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC A Send Buffer Empty\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x58<<2);
			ISR5&=0xfeff;	ICR=IDS;	return(-1);



		case	0x59:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC A Send Buffer Empty\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x59<<2);
			ISR5&=0xfdff;	ICR=IDS;	return(-1);



		case	0x5a:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC A Ext/Status changed\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x5a<<2);
			ISR5&=0xfbff;	ICR=IDS;	return(-1);



		case	0x5b:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC A Ext/Status changed\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x5b<<2);
			ISR5&=0xf7ff;	ICR=IDS;	return(-1);



		case	0x5c:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC A Receive Valid char.\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x5c<<2);
			ISR5&=0xefff;	ICR=IDS;	return(-1);



		case	0x5d:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC A Receive Valid char.\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x5d<<2);
			ISR5&=0xdfff;	ICR=IDS;	return(-1);



		case	0x5e:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC A Sp.Rx Condition\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x5e<<2);
			ISR5&=0xbfff;	ICR=IDS;	return(-1);



		case	0x5f:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SCC A Sp.Rx Condition\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0500;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x5f<<2);
			ISR5&=0x7fff;	ICR=IDS;	return(-1);










		case	0x60:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"FDC Status interrupt\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0100;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x60<<2);
			ISR6&=0xfffe;	ICR=IDS;	return(-1);



		case	0x61:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"FDC Insert/Eject\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0100;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x61<<2);
			ISR6&=0xfffd;	ICR=IDS;	return(-1);



		case	0x62:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"HDC Status interrupt\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0100;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x62<<2);
			ISR6&=0xfffb;	ICR=IDS;	return(-1);



		case	0x63:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"PRN Ready interrupt\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0100;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x63<<2);
			ISR6&=0xfff7;	ICR=IDS;	return(-1);



		case	0x64:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"DMAC 0-FDD Xfer End\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0300;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x64<<2);
			ISR6&=0xffef;	ICR=IDS;	return(-1);



		case	0x65:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"DMAC 0-FDD Xfer Error\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0300;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x65<<2);
			ISR6&=0xffdf;	ICR=IDS;	return(-1);



		case	0x66:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"DMAC 1-SxSI Xfer End\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0300;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x66<<2);
			ISR6&=0xffbf;	ICR=IDS;	return(-1);



		case	0x67:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"DMAC 1-SxSI Xfer Error\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0300;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x67<<2);
			ISR6&=0xff7f;	ICR=IDS;	return(-1);



		case	0x68:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"DMAC 2-IOCS Xfer End\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0300;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x68<<2);
			ISR6&=0xfeff;	ICR=IDS;	return(-1);



		case	0x69:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"DMAC 2-IOCS Xfer Error\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0300;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x69<<2);
			ISR6&=0xfdff;	ICR=IDS;	return(-1);



		case	0x6a:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"DMAC 3-ADPCM Xfer End\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0300;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x6a<<2);
			ISR6&=0xfbff;	ICR=IDS;	return(-1);



		case	0x6b:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"DMAC 3-ADPCM Xfer Error\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0300;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x6b<<2);
			ISR6&=0xf7ff;	ICR=IDS;	return(-1);



		case	0x6c:
#ifdef	_DEBUG
	if((VSR&0x0080)!=0){	sprintf(buf,"SPC Int.SCSI interrupt\n");	CO;	}
#endif
			A[7]-=8;	SR=(SR&0xf0ff)|0x0100;
			m68_write4(A[7]  ,PC);
			m68_write4(A[7]+4,SR);
			PC=m68_read4(0x6c<<2);
			ISR6&=0xfeff;	ICR=IDS;	return(-1);





	}








#endif
	return(0);
}
