#ifdef		WIN32
#include	<windows.h>
#endif

#ifdef		BE68K
#include	<Application.h>
#include	<unistd.h>
#include	"../include/be68k.h"
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/memory.h"
#include	"../include.h/console.h"

extern	MEMORY	mem;



void	MC68K::main_loop(void)
{
#ifdef	_DEBUG
	unsigned long	BPI;
#endif

loop:
	if((VSR&0x4000)==0){	snooze(100);	goto loop;	}

	for(;TTC!=0;TTC--){
#ifdef	_DEBUG
		if((VSR&0x0200)!=0){
			for(BPI=0;BPI!=BPL_MAX;BPI++){
				if(BPL[BPI]==PC){
					TTC=0;	VSR&=0xbfff;
					sprintf(buf,"M68K>Break=%08lX\n",PC);	CO;
					goto loop;
				}
			}
		}
#endif
#ifdef	AX68K
		decode(m68_read2(PC&0x00ffffff));
#else
		decode(m68_read2(PC));
#endif
#ifdef	_DEBUG
		if((VSR&0x0100)!=0)	stat();
#endif
	}
	VSR&=0xbfff;
	goto loop;
}
