//	MC68K code BCHG



case	0x0140:
case	0x0340:
case	0x0540:
case	0x0740:
case	0x0940:
case	0x0b40:
case	0x0d40:
case	0x0f40:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"BCHG D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=1<<(D[RN2]&0x1F);
	if((D[RN1]&TL1)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	D[RN1]^=TL1;
	PC+=2;	return;



case	0x0150:
case	0x0350:
case	0x0550:
case	0x0750:
case	0x0950:
case	0x0b50:
case	0x0d50:
case	0x0f50:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"BCHG D%d,(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	TR1=A[RN1];
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	PC+=2;	return;



case	0x0158:
case	0x0358:
case	0x0558:
case	0x0758:
case	0x0958:
case	0x0b58:
case	0x0d58:
case	0x0f58:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"BCHG D%d,(A%d)+\n",
	RN2,RN1);	CO;	}
#endif
	TR1=A[RN1];
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	A[RN1]++;
	PC+=2;	return;



case	0x0160:
case	0x0360:
case	0x0560:
case	0x0760:
case	0x0960:
case	0x0b60:
case	0x0d60:
case	0x0f60:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"BCHG D%d,-(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	A[RN1]--;
	TR1=A[RN1];
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	PC+=2;	return;



case	0x0168:
case	0x0368:
case	0x0568:
case	0x0768:
case	0x0968:
case	0x0b68:
case	0x0d68:
case	0x0f68:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCHG D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	PC+=4;	return;



case	0x0170:
case	0x0370:
case	0x0570:
case	0x0770:
case	0x0970:
case	0x0b70:
case	0x0d70:
case	0x0f70:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCHG D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
				TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	PC+=4;	return;



case	0x0178:
case	0x0378:
case	0x0578:
case	0x0778:
case	0x0978:
case	0x0b78:
case	0x0d78:
case	0x0f78:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCHG D%d,$%04X\n",
	RN2,num2(1));	CO;	}
#endif
			TR1=(short)num2(1);
			TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^TC2);
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCHG D%d,$%08X\n",
	RN2,num4(1));	CO;	}
#endif
			TR1=num4(1);
			TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^TC2);
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCHG D%d,$%04X(PC)\n",
	RN2,num2(1));	CO;	}
#endif
			TR1=PC+(short)num2(1);
			TC2=1<<(D[RN2]&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^TC2);
			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x0840:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCHG #$%1X,D%d\n",
	num1(1),RN1);	CO;	}
#endif
	TL1=1<<(num1(1)&0x1F);
	if((D[RN1]&TL1)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	D[RN1]^=TL1;
	PC+=4;	return;



case	0x0850:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCHG #$%1X,(A%d)\n",
	num1(1),RN1);	CO;	}
#endif
	TR1=A[RN1];
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	PC+=4;	return;



case	0x0858:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCHG #$%1X,(A%d)+\n",
	num1(1),RN1);	CO;	}
#endif
	TR1=A[RN1];
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	A[RN1]++;
	PC+=4;	return;



case	0x0860:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"BCHG #$%1X,-(A%d)\n",
	num1(1),RN1);	CO;	}
#endif
	A[RN1]--;
	TR1=A[RN1];
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	PC+=4;	return;



case	0x0868:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCHG #$%1X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(2);
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	PC+=6;	return;



case	0x0870:
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCHG #$%1X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO;	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=A[RN1]+(char)num1(2)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(2)+       D[RN3];	//32bitgp
	TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
	if((TC1&TC2)==0)	SR|=CCR_ZON;
		else			SR&=CCR_ZOFF;
	m68_write1(TR1,TC1^TC2);
	PC+=6;	return;



case	0x0878:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCHG #$%1X,$%04X\n",
	num1(1),num2(2));	CO;	}
#endif
			TR1=(short)num2(2);
			TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^TC2);
			PC+=6;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"BCHG #$%1X,$%08X\n",
	num1(1),num4(2));	CO;	}
#endif
			TR1=num4(2);
			TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^TC2);
			PC+=8;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"BCHG #$%1X,$%04X(PC)\n",
	num1(1),num2(2));	CO;	}
#endif
			TR1=PC+(short)num2(2);
			TC2=1<<(num1(1)&0x7);	TC1=m68_read1(TR1);
			if((TC1&TC2)==0)	SR|=CCR_ZON;
				else			SR&=CCR_ZOFF;
			m68_write1(TR1,TC1^TC2);
			PC+=6;	return;



		default:
			i_gic();	return;
	}
