//	MC68K code DIVS



case	0x01c0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"DIVS D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
//	if((D[RN1]&0xffff)==0)	zero divide
	TL1=(long)D[RN2]/(short)D[RN1];
	TS1=(short)(long)D[RN2]%(short)D[RN1];

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1>=0x10000)		SR|=CCR_VON;
	else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
		if(TL1==0)			SR|=CCR_ZON;
		if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

	PC+=2;	return;



case	0x01d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"DIVS (A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
//	if((D[RN1]&0xffff)==0)	zero divide
	TS2=m68_read2(A[RN1]);
	TL1=(long)D[RN2]/(short)TS2;
	TS1=(short)(long)D[RN2]%(short)TS2;

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1>=0x10000)		SR|=CCR_VON;
	else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
		if(TL1==0)			SR|=CCR_ZON;
		if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

	PC+=2;	return;



case	0x01d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"DIVS (A%d)+,D%d\n",
	RN1,RN2);	CO;	}
#endif
//	if((D[RN1]&0xffff)==0)	zero divide
	TS2=m68_read2(A[RN1]);
	TL1=(long)D[RN2]/(short)TS2;
	TS1=(short)(long)D[RN2]%(short)TS2;

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1>=0x10000)		SR|=CCR_VON;
	else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
		if(TL1==0)			SR|=CCR_ZON;
		if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

	A[RN1]+=2;
	PC+=2;	return;



case	0x01e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"DIVS -(A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
//	if((D[RN1]&0xffff)==0)	zero divide
	A[RN1]-=2;
	TS2=m68_read2(A[RN1]);
	TL1=(long)D[RN2]/(short)TS2;
	TS1=(short)(long)D[RN2]%(short)TS2;

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1>=0x10000)		SR|=CCR_VON;
	else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
		if(TL1==0)			SR|=CCR_ZON;
		if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

	PC+=2;	return;



case	0x01e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"DIVS $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
//	if((D[RN1]&0xffff)==0)	zero divide
	TS2=m68_read2(A[RN1]+(short)num2(1));
	TL1=(long)D[RN2]/(short)TS2;
	TS1=(short)(long)D[RN2]%(short)TS2;

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1>=0x10000)		SR|=CCR_VON;
	else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
		if(TL1==0)			SR|=CCR_ZON;
		if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

	PC+=4;	return;



case	0x01f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"DIVS $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,RN3,RN2);	CO;	}
#endif
//	if((D[RN1]&0xffff)==0)	zero divide
	if((num2(1)&0x0800)==0)
			TS2=m68_read2(A[RN1]+(char)num1(1)+(short)D[RN3]);	//16bitg
	else	TS2=m68_read2(A[RN1]+(char)num1(1)+       D[RN3]);	//32bitgp
	TL1=(long)D[RN2]/(short)TS2;
	TS1=(short)(long)D[RN2]%(short)TS2;

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1>=0x10000)		SR|=CCR_VON;
	else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
		if(TL1==0)			SR|=CCR_ZON;
		if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

	PC+=4;	return;



case	0x01f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"DIVS $%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TS2=m68_read2((short)num2(1));
			TL1=(long)D[RN2]/(short)TS2;
			TS1=(short)(long)D[RN2]%(short)TS2;

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1>=0x10000)		SR|=CCR_VON;
			else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
				if(TL1==0)			SR|=CCR_ZON;
				if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"DIVS $%08X,D%d\n",
	num4(1),RN2);	CO;	}
#endif
			TS2=m68_read2(num4(1));
			TL1=(long)D[RN2]/(short)TS2;
			TS1=(short)(long)D[RN2]%(short)TS2;

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1>=0x10000)		SR|=CCR_VON;
			else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
				if(TL1==0)			SR|=CCR_ZON;
				if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"DIVS $%04X(PC),D%d\n",
	num2(1),RN2);	CO;	}
#endif
//			if((D[RN1]&0xffff)==0)	zero divide
			TS2=m68_read2(PC+(short)num2(1));
			TL1=(long)D[RN2]/(short)TS2;
			TS1=(short)(long)D[RN2]%(short)TS2;

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1>=0x10000)		SR|=CCR_VON;
			else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
				if(TL1==0)			SR|=CCR_ZON;
				if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

			PC+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"DIVS $%02X(PC,X%d),D%d\n",
	num1(1),RN3,RN2);	CO;	}
#endif
//			if((D[RN1]&0xffff)==0)	zero divide
			if((num2(1)&0x0800)==0)
					TS2=m68_read2(PC+(char)num1(1)+(short)D[RN3]);	//16bitg
			else	TS2=m68_read2(PC+(char)num1(1)+       D[RN3]);	//32bitgp
			TL1=(long)D[RN2]/(short)TS2;
			TS1=(short)(long)D[RN2]%(short)TS2;

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1>=0x10000)		SR|=CCR_VON;
			else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
				if(TL1==0)			SR|=CCR_ZON;
				if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

			PC+=4;	return;



		case	4:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"DIVS #$%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
//			if((D[RN1]&0xffff)==0)	zero divide
			TL1=(long)D[RN2]/(unsigned short)num2(1);
			TS1=(short)(long)D[RN2]%(unsigned short)num2(1);

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1>=0x10000)		SR|=CCR_VON;
			else{					D[RN2]=(TS1<<16)|(unsigned short)TL1;
				if(TL1==0)			SR|=CCR_ZON;
				if((TL1&0x8000)!=0)	SR|=CCR_NON;	}

			PC+=4;	return;



		default:
			i_gic();	return;
	}
