//	MC68K code EOR






case	0x0100:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.B D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TC1=(unsigned char)D[RN2]^(unsigned char)D[RN1];

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	D[RN1]=(D[RN1]&0xffffff00)|TC1;
	PC+=2;	return;



case	0x0110:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.B D%d,(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	TC1=(unsigned char)D[RN2]^m68_read1(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(A[RN1],TC1);
	PC+=2;	return;



case	0x0118:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.B D%d,(A%d)+\n",
	RN2,RN1);	CO;	}
#endif
	TC1=(unsigned char)D[RN2]^m68_read1(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(A[RN1],TC1);
	A[RN1]++;
	PC+=2;	return;



case	0x0120:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.B D%d,-(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	A[RN1]--;
	TC1=(unsigned char)D[RN2]^m68_read1(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(A[RN1],TC1);
	PC+=2;	return;



case	0x0128:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.B D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TC1=(unsigned char)D[RN2]^m68_read1(TR1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(TR1,TC1);
	PC+=4;	return;



case	0x0130:
	RN3=(num2(1)>>12)&15;
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.B D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TC1=(unsigned char)D[RN2]^m68_read1(TR1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(TR1,TC1);
	PC+=4;	return;



case	0x0138:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.B D%d,$%04X\n",
	RN2,num2(1));	CO;	}
#endif
			TC1=(unsigned char)D[RN2]^m68_read1((short)num2(1));

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			m68_write1((short)num2(1),TC1);
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EOR.B D%d,$%08X\n",
	RN2,num4(1));	CO;	}
#endif
			TC1=(unsigned char)D[RN2]^m68_read1(num4(1));

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			m68_write1(num4(1),TC1);
			PC+=6;	return;



		default:
			i_gic();	return;
	}





case	0x0140:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.W D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TS1=(unsigned short)D[RN2]^(unsigned short)D[RN1];

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	D[RN1]=(D[RN1]&0xffff0000)|TS1;
	PC+=2;	return;



case	0x0150:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.W D%d,(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	TS1=(unsigned short)D[RN2]^m68_read2(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(A[RN1],TS1);
	PC+=2;	return;



case	0x0158:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.W D%d,(A%d)+\n",
	RN2,RN1);	CO;	}
#endif
	TS1=(unsigned short)D[RN2]^m68_read2(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(A[RN1],TS1);
	A[RN1]+=2;
	PC+=2;	return;



case	0x0160:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.W D%d,-(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	A[RN1]-=2;
	TS1=(unsigned short)D[RN2]^m68_read2(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(A[RN1],TS1);
	PC+=2;	return;



case	0x0168:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.W D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TS1=(unsigned short)D[RN2]^m68_read2(TR1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(TR1,TS1);
	PC+=4;	return;



case	0x0170:
	RN3=(num2(1)>>12)&15;
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.W D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TS1=(unsigned short)D[RN2]^m68_read2(TR1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(TR1,TS1);
	PC+=4;	return;



case	0x0178:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.W D%d,$%04X\n",
	RN2,num2(1));	CO;	}
#endif
			TS1=(unsigned short)D[RN2]^m68_read2((short)num2(1));

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			m68_write2((short)num2(1),TS1);
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EOR.W D%d,$%08X\n",
	RN2,num4(1));	CO;	}
#endif
			TS1=(unsigned short)D[RN2]^m68_read2(num4(1));

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			m68_write2(num4(1),TS1);
			PC+=6;	return;



		default:
			i_gic();	return;
	}





case	0x0180:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.L D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN2]^D[RN1];

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	D[RN1]=TL1;
	PC+=2;	return;



case	0x0190:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.L D%d,(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN2]^m68_read4(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(A[RN1],TL1);
	PC+=2;	return;



case	0x0198:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.L D%d,(A%d)+\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN2]^m68_read4(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(A[RN1],TL1);
	A[RN1]+=4;
	PC+=2;	return;



case	0x01a0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"EOR.L D%d,-(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	A[RN1]-=4;
	TL1=D[RN2]^m68_read4(A[RN1]);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(A[RN1],TL1);
	PC+=2;	return;



case	0x01a8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.L D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TL1=D[RN2]^m68_read4(TR1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(TR1,TL1);
	PC+=4;	return;



case	0x01b0:
	RN3=(num2(1)>>12)&15;
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.L D%d,$%02X(A%d,X%d)\n",
	RN2,num1(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TL1=D[RN2]^m68_read4(TR1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(TR1,TL1);
	PC+=4;	return;



case	0x01b8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"EOR.L D%d,$%04X\n",
	RN2,num2(1));	CO;	}
#endif
			TL1=D[RN2]^m68_read4((short)num2(1));

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			m68_write4((short)num2(1),TL1);
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"EOR.L D%d,$%08X\n",
	RN2,num4(1));	CO;	}
#endif
			TL1=D[RN2]^m68_read4(num4(1));

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			m68_write4(num4(1),TL1);
			PC+=6;	return;



		default:
			i_gic();	return;
	}





