//	MC68K	0x1xxx	Opecode
//			MOVE.W


RN1=code		&DC_02;			//source
RN2=(code>>9)	&DC_02;			//distination

switch(code&DC_38){



	case	0x0000:				//	S=Dn	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
		TS1=(unsigned short)D[RN1];
		D[RN2]=(D[RN2]&0xffff0000)|TS1;

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0008:				//	S=An	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W A%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
		TS1=(unsigned short)A[RN1];
		D[RN2]=(D[RN2]&0xffff0000)|TS1;

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0010:				//	S=(An)	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W (A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		D[RN2]=(D[RN2]&0xffff0000)|TS1;

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0018:				//	S=(An)+	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W (A%d)+,D%d\n",
	RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		D[RN2]=(D[RN2]&0xffff0000)|TS1;

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN1]+=2;
		PC+=2;	return;



	case	0x0020:				//	S=-(An)	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W -(A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
		A[RN1]-=2;
		TS1=m68_read2(A[RN1]);
		D[RN2]=(D[RN2]&0xffff0000)|TS1;

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0028:				//	S=d16(An)	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]+(short)num2(1));
		D[RN2]=(D[RN2]&0xffff0000)|TS1;

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0030:				//	S=d8(An,Xn)	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%02X(A%d,X%d),D%d\n",
	num1(1),RN1,(num2(1)>>12),RN2);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TS1=m68_read2(A[RN1]+(short)D[num2(1)>>12]+(char)num1(1));
			else	TS1=m68_read2(A[RN1]+		D[num2(1)>>12]+(char)num1(1));
		D[RN2]=(D[RN2]&0xffff0000)|TS1;

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0038:
		switch(RN1){
			case	0:			//	S=Abs.W	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=m68_read2((short)num2(1));
				D[RN2]=(D[RN2]&0xffff0000)|TS1;

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	1:			//	S=Abs.L	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%08X,D%d\n",
	num4(1),RN2);	CO;	}
#endif
				TS1=m68_read2(num4(1));
				D[RN2]=(D[RN2]&0xffff0000)|TS1;

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	2:			//	S=d16(PC)	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X(PC),D%d\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=m68_read2(PC+(short)num2(1));
				D[RN2]=(D[RN2]&0xffff0000)|TS1;

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	3:			//	S=d8(PC,Xn)	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%02X(PC,X%d),D%d\n",
	num1(1),num2(1)>>12,RN2);	CO;	}
#endif
				if((num2(1)&0x0800)==0)
						TS1=m68_read2(PC+(short)D[num2(1)>>12]+(char)num1(1));
				else	TS1=m68_read2(PC+		D[num2(1)>>12]+(char)num1(1));
				D[RN2]=(D[RN2]&0xffff0000)|TS1;

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	4:			//	S=#imm	D=Dn
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W #$%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=num2(1);
				D[RN2]=(D[RN2]&0xffff0000)|TS1;

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			default:
				i_gic();	return;
		}





	case	0x0040:				//	S=Dn	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVEA.W D%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
		TS1=(unsigned short)D[RN1];
		A[RN2]=(short)TS1;
		PC+=2;	return;



	case	0x0048:				//	S=An	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVEA.W A%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
		TS1=(unsigned short)A[RN1];
		A[RN2]=(short)TS1;
		PC+=2;	return;



	case	0x0050:				//	S=(An)	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVEA.W (A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		A[RN2]=(short)TS1;
		PC+=2;	return;



	case	0x0058:				//	S=(An)+	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVEA.W (A%d)+,A%d\n",
	RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		A[RN2]=(short)TS1;
		A[RN1]+=2;
		PC+=2;	return;



	case	0x0060:				//	S=-(An)	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVEA.W -(A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
		A[RN1]-=2;
		TS1=m68_read2(A[RN1]);
		A[RN2]=(short)TS1;
		PC+=2;	return;



	case	0x0068:				//	S=d16(An)	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVEA.W $%04X(A%d),A%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]+(short)num2(1));
		A[RN2]=(short)TS1;
		PC+=4;	return;



	case	0x0070:				//	S=d8(An,Xn)	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVEA.W $%02X(A%d,X%d),A%d\n",
	num1(1),RN1,(num2(1)>>12),RN2);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TS1=m68_read2(A[RN1]+(short)D[num2(1)>>12]+(char)num1(1));
			else	TS1=m68_read2(A[RN1]+		D[num2(1)>>12]+(char)num1(1));
		A[RN2]=(short)TS1;
		PC+=4;	return;



	case	0x0078:
		switch(RN1){
			case	0:			//	S=Abs.W	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVEA.W $%04X,A%d\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=m68_read2((short)num2(1));
				A[RN2]=(short)TS1;
				PC+=4;	return;
			case	1:			//	S=Abs.L	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVEA.W $%08X,A%d\n",
	num4(1),RN2);	CO;	}
#endif
				TS1=m68_read2(num4(1));
				A[RN2]=(short)TS1;
				PC+=6;	return;
			case	2:			//	S=d16(PC)	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVEA.W $%04X(PC),A%d\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=m68_read2(PC+(short)num2(1));
				A[RN2]=(short)TS1;
				PC+=4;	return;
			case	3:			//	S=d8(PC,Xn)	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVEA.W $%02X(PC,X%d),A%d\n",
	num1(1),num2(1)>>12,RN2);	CO;	}
#endif
				if((num2(1)&0x0800)==0)
						TS1=m68_read2(PC+(short)D[num2(1)>>12]+(char)num1(1));
				else	TS1=m68_read2(PC+		D[num2(1)>>12]+(char)num1(1));
				A[RN2]=(short)TS1;
				PC+=4;	return;
			case	4:			//	S=#imm	D=An
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVEA.W #$%04X,A%d\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=num2(1);
				A[RN2]=(short)TS1;
				PC+=4;	return;
			default:
				i_gic();	return;
		}





	case	0x0080:				//	S=Dn	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W D%d,(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		TS1=(unsigned short)D[RN1];
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0088:				//	S=An	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W A%d,(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		TS1=(unsigned short)A[RN1];
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0090:				//	S=(An)	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W (A%d),(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0098:				//	S=(An)+	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W (A%d)+,(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN1]+=2;
		PC+=2;	return;



	case	0x00a0:				//	S=-(An)	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W -(A%d),(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		A[RN1]-=2;
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x00a8:				//	S=d16(An)	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X(A%d),(A%d)\n",
	num2(1),RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]+(short)num2(1));
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x00b0:				//	S=d8(An,Xn)	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%02X(A%d,X%d),(A%d)\n",
	num1(1),RN1,(num2(1)>>12),RN2);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TS1=m68_read2(A[RN1]+(short)D[num2(1)>>12]+(char)num1(1));
			else	TS1=m68_read2(A[RN1]+		D[num2(1)>>12]+(char)num1(1));
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x00b8:
		switch(RN1){
			case	0:			//	S=Abs.W	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X,(A%d)\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=m68_read2((short)num2(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	1:			//	S=Abs.L	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%08X,(A%d)\n",
	num4(1),RN2);	CO;	}
#endif
				TS1=m68_read2(num4(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	2:			//	S=d16(PC)	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X(PC),(A%d)\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=m68_read2(PC+(short)num2(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	3:			//	S=d8(PC,Xn)	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%02X(PC,X%d),(A%d)\n",
	num1(1),num2(1)>>12,RN2);	CO;	}
#endif
				if((num2(1)&0x0800)==0)
						TS1=m68_read2(PC+(short)D[num2(1)>>12]+(char)num1(1));
				else	TS1=m68_read2(PC+		D[num2(1)>>12]+(char)num1(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	4:			//	S=#imm	D=(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W #$%04X,(A%d)\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=num2(1);
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			default:
				i_gic();	return;
		}





	case	0x00c0:				//	S=Dn	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W D%d,(A%d)+\n",
	RN1,RN2);	CO;	}
#endif
		TS1=(unsigned short)D[RN1];
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN2]+=2;
		PC+=2;	return;



	case	0x00c8:				//	S=An	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W A%d,(A%d)+\n",
	RN1,RN2);	CO;	}
#endif
		TS1=(unsigned short)A[RN1];
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN2]+=2;
		PC+=2;	return;



	case	0x00d0:				//	S=(An)	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W (A%d),(A%d)+\n",
	RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN2]+=2;
		PC+=2;	return;



	case	0x00d8:				//	S=(An)+	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W (A%d)+,(A%d)+\n",
	RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN1]+=2;
		A[RN2]+=2;
		PC+=2;	return;



	case	0x00e0:				//	S=-(An)	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W -(A%d),(A%d)+\n",
	RN1,RN2);	CO;	}
#endif
		A[RN1]-=2;
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN2]+=2;
		PC+=2;	return;



	case	0x00e8:				//	S=d16(An)	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X(A%d),(A%d)+\n",
	num2(1),RN1,RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]+(short)num2(1));
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN2]+=2;
		PC+=4;	return;



	case	0x00f0:				//	S=d8(An,Xn)	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%02X(A%d,X%d),(A%d)+\n",
	num1(1),RN1,(num2(1)>>12),RN2);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TS1=m68_read2(A[RN1]+(short)D[num2(1)>>12]+(char)num1(1));
			else	TS1=m68_read2(A[RN1]+		D[num2(1)>>12]+(char)num1(1));
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN2]+=2;
		PC+=4;	return;



	case	0x00f8:
		switch(RN1){
			case	0:			//	S=Abs.W	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X,(A%d)+\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=m68_read2((short)num2(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				A[RN2]+=2;
				PC+=4;	return;
			case	1:		//	S=Abs.L	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%08X,(A%d)+\n",
	num4(1),RN2);	CO;	}
#endif
				TS1=m68_read2(num4(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				A[RN2]+=2;
				PC+=6;	return;
			case	2:			//	S=d16(PC)	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X(PC),(A%d)+\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=m68_read2(PC+(short)num2(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				A[RN2]+=2;
				PC+=4;	return;
			case	3:			//	S=d8(PC,Xn)	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%02X(PC,X%d),(A%d)+\n",
	num1(1),num2(1)>>12,RN2);	CO;	}
#endif
				if((num2(1)&0x0800)==0)
						TS1=m68_read2(PC+(short)D[num2(1)>>12]+(char)num1(1));
				else	TS1=m68_read2(PC+		D[num2(1)>>12]+(char)num1(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				A[RN2]+=2;
				PC+=4;	return;
			case	4:			//	S=#imm	D=(An)+
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W #$%04X,(A%d)+\n",
	num2(1),RN2);	CO;	}
#endif
				TS1=num2(1);
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				A[RN2]+=2;
				PC+=4;	return;
			default:
				i_gic();	return;
		}





	case	0x0100:				//	S=Dn	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W D%d,-(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		A[RN2]-=2;
		TS1=(unsigned short)D[RN1];
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0108:				//	S=An	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W A%d,-(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		A[RN2]-=2;
		TS1=(unsigned short)A[RN1];
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0110:				//	S=(An)	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W (A%d),-(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		A[RN2]-=2;
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0118:				//	S=(An)+	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W (A%d)+,-(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		A[RN2]-=2;
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN1]+=2;
		PC+=2;	return;



	case	0x0120:				//	S=-(An)	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"MOVE.W -(A%d),-(A%d)\n",
	RN1,RN2);	CO;	}
#endif
		A[RN1]-=2;
		A[RN2]-=2;
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=2;	return;



	case	0x0128:				//	S=d16(An)	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X(A%d),-(A%d)\n",
	num2(1),RN1,RN2);	CO;	}
#endif
		A[RN2]-=2;
		TS1=m68_read2(A[RN1]+(short)num2(1));
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0130:				//	S=d8(An,Xn)	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%02X(A%d,X%d),-(A%d)\n",
	num1(1),RN1,(num2(1)>>12),RN2);	CO;	}
#endif
		A[RN2]-=2;
		if((num2(1)&0x0800)==0)
					TS1=m68_read2(A[RN1]+(short)D[num2(1)>>12]+(char)num1(1));
			else	TS1=m68_read2(A[RN1]+		D[num2(1)>>12]+(char)num1(1));
		m68_write2(A[RN2],TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0138:
		switch(RN1){
			case	0:		//	S=Abs.W	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X,-(A%d)\n",
	num2(1),RN2);	CO;	}
#endif
				A[RN2]-=2;
				TS1=m68_read2((short)num2(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	1:		//	S=Abs.L	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%08X,-(A%d)\n",
	num4(1),RN2);	CO;	}
#endif
				A[RN2]-=2;
				TS1=m68_read2(num4(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	2:			//	S=d16(PC)	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%04X(PC),-(A%d)\n",
	num2(1),RN2);	CO;	}
#endif
				A[RN2]-=2;
				TS1=m68_read2(PC+(short)num2(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	3:			//	S=d8(PC,Xn)	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W $%02X(PC,X%d),-(A%d)\n",
	num1(1),num2(1)>>12,RN2);	CO;	}
#endif
				A[RN2]-=2;
				if((num2(1)&0x0800)==0)
						TS1=m68_read2(PC+(short)D[num2(1)>>12]+(char)num1(1));
				else	TS1=m68_read2(PC+		D[num2(1)>>12]+(char)num1(1));
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	4:			//	S=#imm	D=-(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W #$%04X,-(A%d)\n",
	num2(1),RN2);	CO;	}
#endif
				A[RN2]-=2;
				TS1=num2(1);
				m68_write2(A[RN2],TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			default:
				i_gic();	return;
		}





	case	0x0140:				//	S=Dn	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W D%d,$%04X(A%d)\n",
	RN1,num2(1),RN2);	CO;	}
#endif
		TS1=(unsigned short)D[RN1];
		m68_write2(A[RN2]+(short)num2(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0148:				//	S=An	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W A%d,$%04X(A%d)\n",
	RN1,num2(1),RN2);	CO;	}
#endif
		TS1=(unsigned short)A[RN1];
		m68_write2(A[RN2]+(short)num2(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0150:				//	S=(An)	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W (A%d),$%04X(A%d)\n",
	RN1,num2(1),RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2]+(short)num2(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0158:				//	S=(An)+	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W (A%d)+,$%04X(A%d)\n",
	RN1,num2(1),RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2]+(short)num2(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN1]+=2;
		PC+=4;	return;



	case	0x0160:				//	S=-(An)	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W -(A%d),$%04X(A%d)\n",
	RN1,num2(1),RN2);	CO;	}
#endif
		A[RN1]-=2;
		TS1=m68_read2(A[RN1]);
		m68_write2(A[RN2]+(short)num2(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0168:				//	S=d16(An)	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%04X(A%d),$%04X(A%d)\n",
	num2(1),RN1,num2(2),RN2);	CO;	}
#endif
		TS1=m68_read2(A[RN1]+(short)num2(1));
		m68_write2(A[RN2]+(short)num2(2),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=6;	return;



	case	0x0170:				//	S=d8(An,Xn)	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%02X(A%d,X%d),$%04X(A%d)\n",
	num1(1),RN1,(num2(1)>>12),num2(2),RN2);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TS1=m68_read2(A[RN1]+(short)D[num2(1)>>12]+(char)num1(1));
			else	TS1=m68_read2(A[RN1]+		D[num2(1)>>12]+(char)num1(1));
		m68_write2(A[RN2]+(short)num2(2),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=6;	return;



	case	0x0178:
		switch(RN1){
			case	0:			//	S=Abs.W	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%04X,$%04X(A%d)\n",
	num2(1),num2(2),RN2);	CO;	}
#endif
				TS1=m68_read2((short)num2(1));
				m68_write2(A[RN2]+(short)num2(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	1:			//	S=Abs.L	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"MOVE.W $%08X,$%04X(A%d)\n",
	num4(1),num2(3),RN2);	CO;	}
#endif
				TS1=m68_read2(num4(1));
				m68_write2(A[RN2]+(short)num2(3),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=8;	return;
			case	2:			//	S=d16(PC)	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%04X(PC),$%04X(A%d)\n",
	num2(1),num2(2),RN2);	CO;	}
#endif
				TS1=m68_read2(PC+(short)num2(1));
				m68_write2(A[RN2]+(short)num2(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	3:			//	S=d8(PC,Xn)	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%02X(PC,X%d),$%04X(A%d)\n",
	num1(1),num2(1)>>12,num2(2),RN2);	CO;	}
#endif
				if((num2(1)&0x0800)==0)
						TS1=m68_read2(PC+(short)D[num2(1)>>12]+(char)num1(1));
				else	TS1=m68_read2(PC+		D[num2(1)>>12]+(char)num1(1));
				m68_write2(A[RN2]+(short)num2(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	4:			//	S=#imm	D=d16(An)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W #$%04X,$%04X(A%d)\n",
	num2(1),num2(2),RN2);	CO;	}
#endif
				TS1=num2(1);
				m68_write2(A[RN2]+(short)num2(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			default:
				i_gic();	return;
		}





	case	0x0180:				//	S=Dn	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W D%d,$%02X(A%d,X%d)\n",
	RN1,num1(1),RN2,num2(1)>>12);	CO;	}
#endif
		TS1=(unsigned short)D[RN1];
		if((num2(1)&0x0800)==0)
				m68_write2(A[RN2]+(short)D[num2(1)>>12]+(char)num1(1),TS1);
		else	m68_write2(A[RN2]+       D[num2(1)>>12]+(char)num1(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0188:				//	S=An	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W A%d,$%02X(A%d,X%d)\n",
	RN1,num1(1),RN2,num2(1)>>12);	CO;	}
#endif
		TS1=(unsigned short)A[RN1];
		if((num2(1)&0x0800)==0)
				m68_write2(A[RN2]+(short)D[num2(1)>>12]+(char)num1(1),TS1);
		else	m68_write2(A[RN2]+       D[num2(1)>>12]+(char)num1(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0190:				//	S=(An)	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W (A%d),$%02X(A%d,X%d)\n",
	RN1,num1(1),RN2,num2(1)>>12);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		if((num2(1)&0x0800)==0)
				m68_write2(A[RN2]+(short)D[num2(1)>>12]+(char)num1(1),TS1);
		else	m68_write2(A[RN2]+       D[num2(1)>>12]+(char)num1(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x0198:				//	S=(An)+	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W (A%d)+,$%02X(A%d,X%d)\n",
	RN1,num1(1),RN2,num2(1)>>12);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		if((num2(1)&0x0800)==0)
				m68_write2(A[RN2]+(short)D[num2(1)>>12]+(char)num1(1),TS1);
		else	m68_write2(A[RN2]+       D[num2(1)>>12]+(char)num1(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		A[RN1]+=2;
		PC+=4;	return;



	case	0x01a0:				//	S=-(An)	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W -(A%d),$%02X(A%d,X%d)\n",
	RN1,num1(1),RN2,num2(1)>>12);	CO;	}
#endif
		A[RN1]-=2;
		TS1=m68_read2(A[RN1]);
		if((num2(1)&0x0800)==0)
				m68_write2(A[RN2]+(short)D[num2(1)>>12]+(char)num1(1),TS1);
		else	m68_write2(A[RN2]+       D[num2(1)>>12]+(char)num1(1),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=4;	return;



	case	0x01a8:				//	S=d16(An)	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%04X(A%d),$%02X(A%d,X%d)\n",
	num2(1),RN1,num1(2),RN2,num2(2)>>12);	CO;	}
#endif
		TS1=m68_read2(A[RN1]+(short)num2(1));
		if((num2(2)&0x0800)==0)
				m68_write2(A[RN2]+(short)D[num2(2)>>12]+(char)num1(2),TS1);
		else	m68_write2(A[RN2]+       D[num2(2)>>12]+(char)num1(2),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=6;	return;



	case	0x01b0:				//	S=d8(An,Xn)	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%02X(A%d,X%d),$%02X(A%d,X%d)\n",
	num1(1),RN1,(num2(1)>>12),num1(2),RN2,num2(2)>>12);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TS1=m68_read2(A[RN1]+(short)D[num2(1)>>12]+(char)num1(1));
			else	TS1=m68_read2(A[RN1]+		D[num2(1)>>12]+(char)num1(1));
		if((num2(2)&0x0800)==0)
				m68_write2(A[RN2]+(short)D[num2(2)>>12]+(char)num1(2),TS1);
		else	m68_write2(A[RN2]+       D[num2(2)>>12]+(char)num1(2),TS1);

		SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
		if(TS1==0)					SR|=CCR_ZON;
		if((TS1&0x8000)!=0)			SR|=CCR_NON;

		PC+=6;	return;



	case	0x01b8:
		switch(RN1){
			case	0:			//	S=Abs.w	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%04X,$%02X(A%d,X%d)\n",
	num2(1),num1(2),RN2,num2(2)>>12);	CO;	}
#endif
				TS1=m68_read2((short)num2(1));
				if((num2(2)&0x0800)==0)
							m68_write2(A[RN2]+
								(short)D[num2(2)>>12]+(char)num1(2),TS1);
					else	m68_write2(A[RN2]+
								       D[num2(2)>>12]+(char)num1(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	1:			//	S=Abs.L	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"MOVE.W $%08X,$%02X(A%d,X%d)\n",
	num4(1),num1(3),RN2,num2(3)>>12);	CO;	}
#endif
				TS1=m68_read2(num4(1));
				if((num2(3)&0x0800)==0)
							m68_write2(A[RN2]+
								(short)D[num2(3)>>12]+(char)num1(3),TS1);
					else	m68_write2(A[RN2]+
								       D[num2(3)>>12]+(char)num1(3),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=8;	return;
			case	2:			//	S=d16(PC)	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%04X(PC),$%02X(A%d,X%d)\n",
	num2(1),num1(2),RN2,num2(2)>>12);	CO;	}
#endif
				TS1=m68_read2(PC+(short)num2(1));
				if((num2(2)&0x0800)==0)
							m68_write2(A[RN2]+
								(short)D[num2(2)>>12]+(char)num1(2),TS1);
					else	m68_write2(A[RN2]+
								       D[num2(2)>>12]+(char)num1(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	3:			//	S=d8(PC,Xn)	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%02X(PC,X%d),$%02X(A%d,X%d)\n",
	num1(1),num2(1)>>12,num1(2),RN2,num2(2)>>12);	CO;	}
#endif
				if((num2(1)&0x0800)==0)
						TS1=m68_read2(PC+(short)D[num2(1)>>12]+(char)num1(1));
				else	TS1=m68_read2(PC+		D[num2(1)>>12]+(char)num1(1));
				if((num2(2)&0x0800)==0)
							m68_write2(A[RN2]+
								(short)D[num2(2)>>12]+(char)num1(2),TS1);
					else	m68_write2(A[RN2]+
								       D[num2(2)>>12]+(char)num1(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	4:			//	S=#imm	D=d8(An,Xn)
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W #$%04X,$%02X(A%d,X%d)\n",
	num2(1),num1(2),RN2,num2(2)>>12);	CO;	}
#endif
				TS1=num2(1);
				if((num2(2)&0x0800)==0)
							m68_write2(A[RN2]+
								(short)D[num2(2)>>12]+(char)num1(2),TS1);
					else	m68_write2(A[RN2]+
								       D[num2(2)>>12]+(char)num1(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			default:
				i_gic();	return;
		}





	case	0x01c0:
		switch(RN2){
			case	0:			//	S=Dn	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W D%d,$%04X\n",
	RN1,num2(1));	CO;	}
#endif
				TS1=(unsigned short)D[RN1];
				m68_write2((short)num2(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	1:			//	S=Dn	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W D%d,$%08X\n",
	RN1,num4(1));	CO;	}
#endif
				TS1=(unsigned short)D[RN1];
				m68_write2(num4(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			default:
				i_gic();	return;
		}



	case	0x01c8:
		switch(RN2){
			case	0:			//	S=An	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W A%d,$%04X\n",
	RN1,num2(1));	CO;	}
#endif
				TS1=(unsigned short)A[RN1];
				m68_write2((short)num2(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	1:			//	S=An	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W A%d,$%08X\n",
	RN1,num4(1));	CO;	}
#endif
				TS1=(unsigned short)A[RN1];
				m68_write2(num4(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			default:
				i_gic();	return;
		}



	case	0x01d0:
		switch(RN2){
			case	0:			//	S=(An)	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W (A%d),$%04X\n",
	RN1,num2(1));	CO;	}
#endif
				TS1=m68_read2(A[RN1]);
				m68_write2((short)num2(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	1:			//	S=(An)	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W (A%d),$%08X\n",
	RN1,num4(1));	CO;	}
#endif
				TS1=m68_read2(A[RN1]);
				m68_write2(num4(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			default:
				i_gic();	return;
		}



	case	0x01d8:	
		switch(RN2){
			case	0:		//	S=(An)+	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W (A%d)+,$%04X\n",
	RN1,num2(1));	CO;	}
#endif
				TS1=m68_read2(A[RN1]);
				m68_write2((short)num2(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				A[RN1]+=2;
				PC+=4;	return;
			case	1:		//	S=(An)+	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W (A%d)+,$%08X\n",
	RN1,num4(1));	CO;	}
#endif
				TS1=m68_read2(A[RN1]);
				m68_write2(num4(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				A[RN1]+=2;
				PC+=6;	return;
			default:
				i_gic();	return;
		}



	case	0x01e0:
		switch(RN2){
			case	0:			//	S=-(An)	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"MOVE.W -(A%d),$%04X\n",
	RN1,num2(1));	CO;	}
#endif
				A[RN1]-=2;
				TS1=m68_read2(A[RN1]);
				m68_write2((short)num2(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=4;	return;
			case	1:			//	S=-(An)	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W -(A%d),$%08X\n",
	RN1,num4(1));	CO;	}
#endif
				A[RN1]-=2;
				TS1=m68_read2(A[RN1]);
				m68_write2(num4(1),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			default:
				i_gic();	return;
		}



	case	0x01e8:
		switch(RN2){
			case	0:			//	S=d16(An)	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%04X(A%d),$%04X\n",
	num2(1),RN1,num2(2));	CO;	}
#endif
				TS1=m68_read2(A[RN1]+(short)num2(1));
				m68_write2((short)num2(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	1:			//	S=d16(An)	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;
	sprintf(buf,"MOVE.W $%04X(A%d),$%08X\n",
	num2(1),RN1,num4(2));	CO;	}
#endif
				TS1=m68_read2(A[RN1]+(short)num2(1));
				m68_write2(num4(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=8;	return;
			default:
				i_gic();	return;
		}



	case	0x01f0:
		switch(RN2){
			case	0:			//	S=d8(An,Xn)	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%02X(A%d,X%d),$%04X\n",
	num1(1),RN1,(num2(1)>>12),num2(2));	CO;	}
#endif
				if((num2(1)&0x0800)==0)
							TS1=m68_read2(A[RN1]+
									(short)D[num2(1)>>12]+(char)num1(1));
					else	TS1=m68_read2(A[RN1]+
									       D[num2(1)>>12]+(char)num1(1));
				m68_write2((short)num2(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=6;	return;
			case	1:			//	S=d8(An,Xn)	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;
	sprintf(buf,"MOVE.W $%02X(A%d,X%d),$%04X\n",
	num1(1),RN1,(num2(1)>>12),num4(2));	CO;	}
#endif
				if((num2(1)&0x0800)==0)
							TS1=m68_read2(A[RN1]+
									(short)D[num2(1)>>12]+(char)num1(1));
					else	TS1=m68_read2(A[RN1]+
									       D[num2(1)>>12]+(char)num1(1));
				m68_write2(num4(2),TS1);

				SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
				if(TS1==0)					SR|=CCR_ZON;
				if((TS1&0x8000)!=0)			SR|=CCR_NON;

				PC+=8;	return;
			default:
				i_gic();	return;
		}



	case	0x01f8:
		switch(RN2){
			case	0:
				switch(RN1){
					case	0:		//	S=Abs.w	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W $%04X,$%04X\n",
	num2(1),num2(2));	CO;	}
#endif
						TS1=m68_read2((short)num2(1));
						m68_write2((short)num2(2),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=6;	return;
					case	1:		//	S=Abs.L	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"MOVE.W $%08X,$%04X\n",
	num4(1),num2(3));	CO;	}
#endif
						TS1=m68_read2(num4(1));
						m68_write2((short)num2(3),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=8;	return;
					case	2:		//	S=d16(PC)	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%04X(PC),$%04X\n",
	num2(1),num2(2));	CO;	}
#endif
						TS1=m68_read2(PC+(short)num2(1));
						m68_write2((short)num2(2),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=6;	return;
					case	3:			//	S=d8(PC,Xn)	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;
	sprintf(buf,"MOVE.W $%02X(PC,X%d),$%04X\n",
	num1(1),num2(1)>>12,num2(2));	CO;	}
#endif
						if((num2(1)&0x0800)==0)
								TS1=m68_read2(PC+(short)D[num2(1)>>12]+
										(char)num1(1));
						else	TS1=m68_read2(PC+       D[num2(1)>>12]+
										(char)num1(1));
						m68_write2((short)num2(2),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=6;	return;
					case	4:			//	S=#imm	D=Abs.W
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"MOVE.W #$%04X,$%04X\n",
	num2(1),num2(2));	CO;	}
#endif
						TS1=num2(1);
						m68_write2((short)num2(2),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=6;	return;
					default:
						i_gic();	return;
				}



			case	1:
				switch(RN1){
					case	0:		//	S=Abs.w	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"MOVE.W $%04X,$%08X\n",
	num2(1),num4(2));	CO;	}
#endif
						TS1=m68_read2((short)num2(1));
						m68_write2(num4(2),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=8;	return;
					case	1:		//	S=Abs.L	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD4;	sprintf(buf,"MOVE.W $%08X,$%08X\n",
	num4(1),num4(3));	CO;	}
#endif
						TS1=m68_read2(num4(1));
						m68_write2(num4(3),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=10;	return;
					case	2:		//	S=d16(PC)	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;
	sprintf(buf,"MOVE.W $%04X(PC),$%08X\n",
	num2(1),num4(2));	CO;	}
#endif
						TS1=m68_read2(PC+(short)num2(1));
						m68_write2(num4(2),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=8;	return;
					case	3:			//	S=d8(PC,Xn)	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;
	sprintf(buf,"MOVE.W $%02X(PC,X%d),$%08X\n",
	num1(1),num2(1)>>12,num4(2));	CO;	}
#endif
						if((num2(1)&0x0800)==0)
								TS1=m68_read2(PC+(short)D[num2(1)>>12]+
										(char)num1(1));
						else	TS1=m68_read2(PC+       D[num2(1)>>12]+
										(char)num1(1));
						m68_write2(num4(2),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=8;	return;
					case	4:			//	S=#imm	D=Abs.L
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"MOVE.W #$%04X,$%08X\n",
	num2(1),num4(2));	CO;	}
#endif
						TS1=num2(1);
						m68_write2(num4(2),TS1);

						SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
						if(TS1==0)					SR|=CCR_ZON;
						if((TS1&0x8000)!=0)			SR|=CCR_NON;

						PC+=8;	return;
					default:
						i_gic();	return;
				}
			default:
				i_gic();	return;
		}
}
