//	MC68K code OR



case	0x0000:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.B D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TC1=(unsigned char)(D[RN1]|D[RN2]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffffff00)|TC1;
	PC+=2;	return;



case	0x0010:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.B (A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	TC1=(unsigned char)D[RN2]|m68_read1(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffffff00)|TC1;
	PC+=2;	return;



case	0x0018:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.B (A%d)+,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TC1=(unsigned char)D[RN2]|m68_read1(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	A[RN1]++;
	D[RN2]=(D[RN2]&0xffffff00)|TC1;
	PC+=2;	return;



case	0x0020:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.B -(A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]--;
	TC1=(unsigned char)D[RN2]|m68_read1(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffffff00)|TC1;
	PC+=2;	return;



case	0x0028:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	TC1=(unsigned char)D[RN2]|m68_read1(A[RN1]+(short)num2(1));

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffffff00)|TC1;
	PC+=4;	return;



case	0x0030:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B $%02X(A%d,X%d),D%d\n",
	num2(1),RN1,RN3,RN2);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TC1=(unsigned char)D[RN2]|m68_read1(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffffff00)|TC1;
	PC+=4;	return;




case	0x0038:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B $%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TC1=(unsigned char)D[RN2]|m68_read1((short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffffff00)|TC1;
			PC+=4;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"OR.B $%08X,D%d\n",
	num4(1),RN2);	CO;	}
#endif
			TC1=(unsigned char)D[RN2]|m68_read1((long)num4(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffffff00)|TC1;
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B $%04X(PC),D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TC1=(unsigned char)D[RN2]|m68_read1(PC+(short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffffff00)|TC1;
			PC+=2;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B $%02X(PC,X%d),D%d\n",
	num2(1),RN1,RN3,RN2);	CO;	}
#endif
			if((num2(1)&0x0800)==0)
					TR1=PC+(char)num1(1)+(short)D[RN3];	//16bitg
			else	TR1=PC+(char)num1(1)+       D[RN3];	//32bitgp
			TC1=(unsigned char)D[RN2]|m68_read1(TR1);

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffffff00)|TC1;
			PC+=4;	return;



		case	4:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B #%02X,D%d\n",
	num1(1),RN2);	CO;	}
#endif
			TC1=(unsigned char)D[RN2]|num1(1);

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffffff00)|TC1;
			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x0040:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.W D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)(D[RN1]|D[RN2]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffff0000)|TS1;
	PC+=2;	return;



case	0x0050:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.W (A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)D[RN2]|m68_read2(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffff0000)|TS1;
	PC+=2;	return;



case	0x0058:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.W (A%d)+,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)D[RN2]|m68_read2(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	A[RN1]+=2;
	D[RN2]=(D[RN2]&0xffff0000)|TS1;
	PC+=2;	return;



case	0x0060:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.W -(A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=2;
	TS1=(unsigned short)D[RN2]|m68_read2(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffff0000)|TS1;
	PC+=2;	return;



case	0x0068:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	TS1=(unsigned short)D[RN2]|m68_read2(A[RN1]+(short)num2(1));

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffff0000)|TS1;
	PC+=4;	return;



case	0x0070:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W $%02X(A%d,X%d),D%d\n",
	num2(1),RN1,RN3,RN2);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TS1=(unsigned short)D[RN2]|m68_read2(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	D[RN2]=(D[RN2]&0xffff0000)|TS1;
	PC+=4;	return;




case	0x0078:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W $%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TS1=(unsigned short)D[RN2]|m68_read2((short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffff0000)|TS1;
			PC+=4;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"OR.W $%08X,D%d\n",
	num4(1),RN2);	CO;	}
#endif
			TS1=(unsigned short)D[RN2]|m68_read2((long)num4(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffff0000)|TS1;
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W $%04X(PC),D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TS1=(unsigned short)D[RN2]|m68_read2(PC+(short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffff0000)|TS1;
			PC+=2;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W $%02X(PC,X%d),D%d\n",
	num2(1),RN1,RN3,RN2);	CO;	}
#endif
			if((num2(1)&0x0800)==0)
					TR1=PC+(char)num1(1)+(short)D[RN3];	//16bitg
			else	TR1=PC+(char)num1(1)+       D[RN3];	//32bitgp
			TS1=(unsigned short)D[RN2]|m68_read2(TR1);

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffff0000)|TS1;
			PC+=4;	return;



		case	4:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W #%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TS1=(unsigned short)D[RN2]|num2(1);

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			D[RN2]=(D[RN2]&0xffff0000)|TS1;
			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x0080:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.L D%d,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TL1=D[RN1]|D[RN2];

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL1;
	PC+=2;	return;



case	0x0090:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.L (A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	TL1=D[RN2]|m68_read4(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL1;
	PC+=2;	return;



case	0x0098:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.L (A%d)+,D%d\n",
	RN1,RN2);	CO;	}
#endif
	TL1=D[RN2]|m68_read4(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	A[RN1]+=4;
	D[RN2]=TL1;
	PC+=2;	return;



case	0x00a0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.L -(A%d),D%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=4;
	TL1=D[RN2]|m68_read4(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL1;
	PC+=2;	return;



case	0x00a8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L $%04X(A%d),D%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	TL1=D[RN2]|m68_read4(A[RN1]+(short)num2(1));

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL1;
	PC+=4;	return;



case	0x00b0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L $%02X(A%d,X%d),D%d\n",
	num2(1),RN1,RN3,RN2);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TL1=D[RN2]|m68_read4(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	D[RN2]=TL1;
	PC+=4;	return;




case	0x00b8:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L $%04X,D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TL1=D[RN2]|m68_read4((short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL1;
			PC+=4;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"OR.L $%08X,D%d\n",
	num4(1),RN2);	CO;	}
#endif
			TL1=D[RN2]|m68_read4((long)num4(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL1;
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L $%04X(PC),D%d\n",
	num2(1),RN2);	CO;	}
#endif
			TL1=D[RN2]|m68_read4(PC+(short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL1;
			PC+=2;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L $%02X(PC,X%d),D%d\n",
	num2(1),RN1,RN3,RN2);	CO;	}
#endif
			if((num2(1)&0x0800)==0)
					TR1=PC+(char)num1(1)+(short)D[RN3];	//16bitg
			else	TR1=PC+(char)num1(1)+       D[RN3];	//32bitgp
			TL1=D[RN2]|m68_read4(TR1);

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL1;
			PC+=4;	return;



		case	4:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L #%08X,D%d\n",
	num4(1),RN2);	CO;	}
#endif
			TL1=D[RN2]|num4(1);

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			D[RN2]=TL1;
			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x0110:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.B D%d,(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	TC1=(unsigned char)D[RN2]|m68_read1(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(A[RN1],TC1);
	PC+=2;	return;



case	0x0118:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.B D%d,(A%d)+\n",
	RN2,RN1);	CO;	}
#endif
	TC1=(unsigned char)D[RN2]|m68_read1(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(A[RN1],TC1);
	A[RN1]++;
	PC+=2;	return;



case	0x0120:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.B D%d,-(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	A[RN1]--;
	TC1=(unsigned char)D[RN2]|m68_read1(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(A[RN1],TC1);
	PC+=2;	return;



case	0x0128:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TC1=(unsigned char)D[RN2]|m68_read1(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(TR1,TC1);
	PC+=2;	return;



case	0x0130:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B D%d,$%02X(A%d,X%d)\n",
	RN2,num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TC1=(unsigned char)D[RN2]|m68_read1(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TC1==0)			SR|=CCR_ZON;
	if((TC1&0x80)!=0)	SR|=CCR_NON;

	m68_write1(TR1,TC1);
	PC+=2;	return;



case	0x0138:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.B D%d,$%04X\n",
	RN2,num2(1));	CO;	}
#endif
			TC1=(unsigned char)D[RN2]|m68_read1((short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			m68_write1((short)num2(1),TC1);
			PC+=4;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"OR.B D%d,$%08X\n",
	RN2,num4(1));	CO;	}
#endif
			TC1=(unsigned char)D[RN2]|m68_read1((long)num4(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TC1==0)			SR|=CCR_ZON;
			if((TC1&0x80)!=0)	SR|=CCR_NON;

			m68_write1((short)num4(1),TC1);
			PC+=6;	return;



		default:
			i_gic();	return;
	}





case	0x0150:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.W D%d,(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	TS1=(unsigned short)D[RN2]|m68_read2(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(A[RN1],TS1);
	PC+=2;	return;



case	0x0158:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.W D%d,(A%d)+\n",
	RN2,RN1);	CO;	}
#endif
	TS1=(unsigned short)D[RN2]|m68_read2(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(A[RN1],TS1);
	A[RN1]+=4;
	PC+=2;	return;



case	0x0160:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.W D%d,-(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	A[RN1]-=4;
	TS1=(unsigned short)D[RN2]|m68_read2(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(A[RN1],TS1);
	PC+=2;	return;



case	0x0168:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TS1=(unsigned short)D[RN2]|m68_read2(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(TR1,TS1);
	PC+=2;	return;



case	0x0170:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W D%d,$%02X(A%d,X%d)\n",
	RN2,num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TS1=(unsigned short)D[RN2]|m68_read2(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TS1==0)			SR|=CCR_ZON;
	if((TS1&0x8000)!=0)	SR|=CCR_NON;

	m68_write2(TR1,TS1);
	PC+=2;	return;



case	0x0178:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.W D%d,$%04X\n",
	RN2,num2(1));	CO;	}
#endif
			TS1=(unsigned short)D[RN2]|m68_read2((short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			m68_write2((short)num2(1),TS1);
			PC+=4;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"OR.W D%d,$%08X\n",
	RN2,num4(1));	CO;	}
#endif
			TS1=(unsigned short)D[RN2]|m68_read2((long)num4(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TS1==0)			SR|=CCR_ZON;
			if((TS1&0x8000)!=0)	SR|=CCR_NON;

			m68_write2((short)num4(1),TS1);
			PC+=6;	return;



		default:
			i_gic();	return;
	}





case	0x0190:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.L D%d,(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN2]|m68_read4(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(A[RN1],TL1);
	PC+=2;	return;



case	0x0198:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.L D%d,(A%d)+\n",
	RN2,RN1);	CO;	}
#endif
	TL1=(unsigned short)D[RN2]|m68_read4(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(A[RN1],TL1);
	A[RN1]+=4;
	PC+=2;	return;



case	0x01a0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"OR.L D%d,-(A%d)\n",
	RN2,RN1);	CO;	}
#endif
	A[RN1]-=4;
	TL1=(unsigned short)D[RN2]|m68_read4(A[RN1]);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(A[RN1],TL1);
	PC+=2;	return;



case	0x01a8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L D%d,$%04X(A%d)\n",
	RN2,num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TL1=(unsigned short)D[RN2]|m68_read4(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(TR1,TL1);
	PC+=2;	return;



case	0x01b0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L D%d,$%02X(A%d,X%d)\n",
	RN2,num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];	//16bitg
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];	//32bitgp
	TL1=(unsigned short)D[RN2]|m68_read4(TR1);

	SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
	if(TL1==0)				SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)	SR|=CCR_NON;

	m68_write4(TR1,TL1);
	PC+=2;	return;



case	0x01b8:				//byte size , abs
	switch(RN1){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"OR.L D%d,$%04X\n",
	RN2,num2(1));	CO;	}
#endif
			TL1=(unsigned short)D[RN2]|m68_read4((short)num2(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			m68_write4((short)num2(1),TL1);
			PC+=4;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"OR.L D%d,$%08X\n",
	RN2,num4(1));	CO;	}
#endif
			TL1=(unsigned short)D[RN2]|m68_read4((long)num4(1));

			SR&=CCR_NOFF&CCR_ZOFF&CCR_VOFF&CCR_COFF;
			if(TL1==0)				SR|=CCR_ZON;
			if((TL1&0x80000000)!=0)	SR|=CCR_NON;

			m68_write4((short)num4(1),TL1);
			PC+=6;	return;



		default:
			i_gic();	return;
	}





