//	MC68K code ROXL



case	0x0110:
case	0x0310:
case	0x0510:
case	0x0710:
case	0x0910:
case	0x0b10:
case	0x0d10:
case	0x0f10:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.B #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	for(TC1=0;TC1!=RN2;TC1++){
		switch((TL1&0x80)|(SR&CCR_XON)){
			case	0x00:	TL1<<=1;		SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x10:	TL1=(TL1<<1)|1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x80:	TL1<<=1;		SR|=CCR_XON |CCR_CON;	break;
			case	0x90:	TL1=(TL1<<1)|1;	SR|=CCR_XON |CCR_CON;	break;
		}
	}
	if((unsigned char)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x80)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffffff00)|(TL1&0xff);
	PC+=2;	return;



case	0x0150:
case	0x0350:
case	0x0550:
case	0x0750:
case	0x0950:
case	0x0b50:
case	0x0d50:
case	0x0f50:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.W #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	for(TC1=0;TC1!=RN2;TC1++){
		switch((TL1&0x8000)|(SR&CCR_XON)){
			case	0x0000:	TL1<<=1;		SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TL1=(TL1<<1)|1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:	TL1<<=1;		SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TL1=(TL1<<1)|1;	SR|=CCR_XON |CCR_CON;	break;
		}
	}
	if((unsigned short)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x8000)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffff0000)|(TL1&0xffff);
	PC+=2;	return;



case	0x0190:
case	0x0390:
case	0x0590:
case	0x0790:
case	0x0990:
case	0x0b90:
case	0x0d90:
case	0x0f90:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.L #$%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	if(RN2==0)	RN2=8;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	for(TC1=0;TC1!=RN2;TC1++){
		switch((TL1&0x80000000)|(SR&CCR_XON)){
			case	0x00000000:	TL1<<=1;		SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x00000010:	TL1=(TL1<<1)|1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x80000000:	TL1<<=1;		SR|=CCR_XON |CCR_CON;	break;
			case	0x80000010:	TL1=(TL1<<1)|1;	SR|=CCR_XON |CCR_CON;	break;
		}
	}
	if(TL1==0)					SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)		SR|=CCR_NON;
	D[RN1]=TL1;
	PC+=2;	return;





case	0x0130:
case	0x0330:
case	0x0530:
case	0x0730:
case	0x0930:
case	0x0b30:
case	0x0d30:
case	0x0f30:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.B D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		switch((TL1&0x80)|(SR&CCR_XON)){
			case	0x00:	TL1<<=1;		SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x10:	TL1=(TL1<<1)|1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x80:	TL1<<=1;		SR|=CCR_XON |CCR_CON;	break;
			case	0x90:	TL1=(TL1<<1)|1;	SR|=CCR_XON |CCR_CON;	break;
		}
	}
	if((unsigned char)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x80)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffffff00)|(TL1&0xff);
	PC+=2;	return;



case	0x0170:
case	0x0370:
case	0x0570:
case	0x0770:
case	0x0970:
case	0x0b70:
case	0x0d70:
case	0x0f70:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.W D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		switch((TL1&0x8000)|(SR&CCR_XON)){
			case	0x0000:	TL1<<=1;		SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TL1=(TL1<<1)|1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:	TL1<<=1;		SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TL1=(TL1<<1)|1;	SR|=CCR_XON |CCR_CON;	break;
		}
	}
	if((unsigned short)TL1==0)	SR|=CCR_ZON;
	if((TL1&0x8000)!=0)			SR|=CCR_NON;
	D[RN1]=(D[RN1]&0xffff0000)|(TL1&0xffff);
	PC+=2;	return;



case	0x01b0:
case	0x03b0:
case	0x05b0:
case	0x07b0:
case	0x09b0:
case	0x0bb0:
case	0x0db0:
case	0x0fb0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.L D%d,D%d\n",
	RN2,RN1);	CO;	}
#endif
	TL1=D[RN1];
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	TC2=(char)(D[RN2]&0x3f);
	for(TC1=0;TC1!=TC2;TC1++){
		switch((TL1&0x80000000)|(SR&CCR_XON)){
			case	0x00000000:	TL1<<=1;		SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x00000010:	TL1=(TL1<<1)|1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x80000000:	TL1<<=1;		SR|=CCR_XON |CCR_CON;	break;
			case	0x80000010:	TL1=(TL1<<1)|1;	SR|=CCR_XON |CCR_CON;	break;
		}
	}
	if(TL1==0)					SR|=CCR_ZON;
	if((TL1&0x80000000)!=0)		SR|=CCR_NON;
	D[RN1]=TL1;
	PC+=2;	return;





case	0x05d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.W (A%d)\n",
	RN1);	CO;	}
#endif
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&0x8000)|(SR&CCR_XON)){
			case	0x0000:			SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TS2|=1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:			SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TS2|=1;	SR|=CCR_XON |CCR_CON;	break;	}
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=2;	return;



case	0x05d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.W (A%d)+\n",
	RN1);	CO;	}
#endif
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&0x8000)|(SR&CCR_XON)){
			case	0x0000:			SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TS2|=1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:			SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TS2|=1;	SR|=CCR_XON |CCR_CON;	break;	}
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	A[RN1]+=2;
	PC+=2;	return;



case	0x05e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"ROXL.W -(A%d)\n",
	RN1);	CO;	}
#endif
	A[RN1]-=2;
	TR1=A[RN1];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&0x8000)|(SR&CCR_XON)){
			case	0x0000:			SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TS2|=1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:			SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TS2|=1;	SR|=CCR_XON |CCR_CON;	break;	}
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=2;	return;



case	0x05e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ROXL.W $%04X(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	TR1=A[RN1]+(short)num2(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&0x8000)|(SR&CCR_XON)){
			case	0x0000:			SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TS2|=1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:			SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TS2|=1;	SR|=CCR_XON |CCR_CON;	break;	}
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



case	0x05f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ROXL.W $%02X(A%d,X%d)\n",
	num2(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			TR1=A[RN1]+(char)num1(1)+(short)D[RN3];
	else	TR1=A[RN1]+(char)num1(1)+       D[RN3];
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&0x8000)|(SR&CCR_XON)){
			case	0x0000:			SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TS2|=1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:			SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TS2|=1;	SR|=CCR_XON |CCR_CON;	break;	}
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



case	0x05f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"ROXL.W $%04X\n",
	num2(1));	CO;	}
#endif
	TR1=(short)num2(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&0x8000)|(SR&CCR_XON)){
			case	0x0000:			SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TS2|=1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:			SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TS2|=1;	SR|=CCR_XON |CCR_CON;	break;	}
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"ROXL.W $%08X\n",
	num4(1));	CO;	}
#endif
	TR1=(short)num4(1);
	TS1=m68_read2(TR1);
	TS2=TS1<<1;
	SR&=CCR_VOFF&CCR_ZOFF&CCR_NOFF;
	switch((TS1&0x8000)|(SR&CCR_XON)){
			case	0x0000:			SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x0010:	TS2|=1;	SR&=CCR_XOFF&CCR_COFF;	break;
			case	0x8000:			SR|=CCR_XON |CCR_CON;	break;
			case	0x8010:	TS2|=1;	SR|=CCR_XON |CCR_CON;	break;	}
	if((unsigned short)TS2==0)	SR|=CCR_ZON;
	if((TS2&0x8000)!=0)			SR|=CCR_NON;
	m68_write2(TR1,TS2);
	PC+=6;	return;



		default:
			i_gic();	return;
	}



