//	MC68K code SUB



case	0x00c0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.W D%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN2]-=(short)D[RN1];
	PC+=2;	return;



case	0x00c8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.W A%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN2]-=(short)A[RN1];
	PC+=2;	return;



case	0x00d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.W (A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN2]-=(short)m68_read2(A[RN1]);
	PC+=2;	return;



case	0x00d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.W (A%d)+,A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN2]-=(short)m68_read2(A[RN1]);
	A[RN1]+=2;
	PC+=2;	return;



case	0x00e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.W -(A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=2;
	A[RN2]-=(short)m68_read2(A[RN1]);
	PC+=2;	return;



case	0x00e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.W $%04X(A%d),A%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	A[RN2]-=(short)m68_read2(A[RN1]+(short)num2(1));
	PC+=4;	return;



case	0x00f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.W $%02X(A%d,X%d),A%d\n",
	num1(1),RN1,RN3,RN2);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			A[RN2]-=(short)m68_read2(A[RN1]+(char)num1(1)+(short)D[RN3]);
	else	A[RN2]-=(short)m68_read2(A[RN1]+(char)num1(1)+      D[RN3]);
	PC+=4;	return;



case	0x00f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.W $%04X,A%d\n",
	num2(1),RN2);	CO;	}
#endif
			A[RN2]-=(short)m68_read2((short)num2(1));
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBA.W $%08X,A%d\n",
	num4(1),RN2);	CO;	}
#endif
			A[RN2]-=(short)m68_read2(num4(1));
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.W $%04X(PC),A%d\n",
	num2(1),RN2);	CO;	}
#endif
			A[RN2]-=(short)m68_read2(PC+(short)num2(1));
			PC+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.W $%02X(PC,X%d),A%d\n",
	num1(1),RN3,RN2);	CO;	}
#endif
			if((num2(1)&0x0800)==0)
					A[RN2]-=(short)m68_read2(PC+(char)num1(1)+(short)D[RN3]);
			else	A[RN2]-=(short)m68_read2(PC+(char)num1(1)+       D[RN3]);
			PC+=4;	return;



		case	4:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.W #$%04X,A%d\n",
	num2(1),RN3,RN2);	CO;	}
#endif
			A[RN2]-=(short)m68_read2((short)num2(1));
			PC+=4;	return;



		default:
			i_gic();	return;
	}





case	0x01c0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.L D%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN2]-=D[RN1];
	PC+=2;	return;



case	0x01c8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.L A%d,A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN2]-=A[RN1];
	PC+=2;	return;



case	0x01d0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.L (A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN2]-=m68_read4(A[RN1]);
	PC+=2;	return;



case	0x01d8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.L (A%d)+,A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN2]-=m68_read4(A[RN1]);
	A[RN1]+=2;
	PC+=2;	return;



case	0x01e0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBA.L -(A%d),A%d\n",
	RN1,RN2);	CO;	}
#endif
	A[RN1]-=2;
	A[RN2]-=m68_read4(A[RN1]);
	PC+=2;	return;



case	0x01e8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.L $%04X(A%d),A%d\n",
	num2(1),RN1,RN2);	CO;	}
#endif
	A[RN2]-=m68_read4(A[RN1]+(short)num2(1));
	PC+=4;	return;



case	0x01f0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.L $%02X(A%d,X%d),A%d\n",
	num1(1),RN1,RN3,RN2);	CO;	}
#endif
	if((num2(1)&0x0800)==0)
			A[RN2]-=m68_read4(A[RN1]+(char)num1(1)+(short)D[RN3]);
	else	A[RN2]-=m68_read4(A[RN1]+(char)num1(1)+       D[RN3]);
	PC+=4;	return;



case	0x01f8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.L $%04X,A%d\n",
	num2(1),RN2);	CO;	}
#endif
			A[RN2]-=m68_read4((short)num2(1));
			PC+=4;	return;



		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBA.L $%08X,A%d\n",
	num4(1),RN2);	CO;	}
#endif
			A[RN2]-=m68_read4(num4(1));
			PC+=6;	return;



		case	2:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.L $%04X(PC),A%d\n",
	num2(1),RN2);	CO;	}
#endif
			A[RN2]-=m68_read4(PC+(short)num2(1));
			PC+=4;	return;



		case	3:
			RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBA.L $%02X(PC,X%d),A%d\n",
	num1(1),RN3,RN2);	CO;	}
#endif
			if((num2(1)&0x0800)==0)
					A[RN2]-=m68_read4(PC+(char)num1(1)+(short)D[RN3]);
			else	A[RN2]-=m68_read4(PC+(char)num1(1)+       D[RN3]);
			PC+=4;	return;



		case	4:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBA.L #$%08X,A%d\n",
	num4(1),RN2);	CO;	}
#endif
			A[RN2]-=num4(1);
			PC+=6;	return;



		default:
			i_gic();	return;
	}



