//	MC68K code SUBI



case	0x0400:		//byte size , data regster direct
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBI.B #$%02X,D%d\n",
	num1(1),RN1);	CO;	}
#endif
	TC1=(unsigned char)D[RN1];
	TC2=TC1-num1(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC2==0)					SR|=CCR_ZON;
	if((TC2&0x80)!=0)			SR|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	SR|=CCR_VON;
	if(TC2>TC1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	D[RN1]=(D[RN1]&0xffffff00)|TC2;
	PC+=4;	return;



case	0x0410:		//byte size , mem addr
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBI.B #$%02X,(A%d)\n",
	num1(1),RN1);	CO;	}
#endif
	TC1=m68_read1(A[RN1]);
	TC2=TC1-num1(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC2==0)					SR|=CCR_ZON;
	if((TC2&0x80)!=0)			SR|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	SR|=CCR_VON;
	if(TC2>TC1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	m68_write1(A[RN1],TC2);
	PC+=4;	return;



case	0x0418:		//byte size , mem addr ,postinc
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBI.B #$%02X,(A%d)+\n",
	num1(1),RN1);	CO;	}
#endif
	TC1=m68_read1(A[RN1]);
	TC2=TC1-num1(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC2==0)					SR|=CCR_ZON;
	if((TC2&0x80)!=0)			SR|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	SR|=CCR_VON;
	if(TC2>TC1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	m68_write1(A[RN1],TC2);
	A[RN1]++;
	PC+=4;	return;



case	0x0420:		//byte size , mem addr ,pridec
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBI.B #$%02X,-(A%d)\n",
	num1(1),RN1);	CO;	}
#endif
	A[RN1]--;
	TC1=m68_read1(A[RN1]);
	TC2=TC1-num1(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC2==0)					SR|=CCR_ZON;
	if((TC2&0x80)!=0)			SR|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	SR|=CCR_VON;
	if(TC2>TC1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	m68_write1(A[RN1],TC2);
	PC+=4;	return;



case	0x0428:		//byte size , mem addr with disp
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.B #$%02X,$%04X(A%d)\n",
	num1(1),num2(2),RN1);	CO;	}
#endif
	TC1=m68_read1(A[RN1]+(short)num2(2));
	TC2=TC1-num1(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC2==0)					SR|=CCR_ZON;
	if((TC2&0x80)!=0)			SR|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	SR|=CCR_VON;
	if(TC2>TC1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	m68_write1(A[RN1]+(short)num2(2),TC2);
	PC+=6;	return;



case	0x0430:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.B #$%02X,$%02X(A%d,X%d)\n",
	num1(1),num1(2),RN1,RN3);	CO;	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=A[RN1]+(char)num1(2)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(2)+       D[RN3];	//32bitgp
	TC1=m68_read1(TR1);
	TC2=TC1-num1(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TC2==0)					SR|=CCR_ZON;
	if((TC2&0x80)!=0)			SR|=CCR_NON;
		else
	if(((TC1^num1(1))&0x80)!=0)	SR|=CCR_VON;
	if(TC2>TC1){				SR|=CCR_CON;
								SR|=CCR_XON;	}

	m68_write1(TR1,TC2);
	PC+=6;	return;



case	0x0438:				//byte size , abs
	switch(code&DC_02){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.B #$%02X,$%04X\n",
	num1(1),num2(2));	CO;	}
#endif
			TR1=(short)num2(2);
			TC1=m68_read1(TR1);
			TC2=TC1-num1(1);

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TC2==0)					SR|=CCR_ZON;
			if((TC2&0x80)!=0)			SR|=CCR_NON;
				else
			if(((TC1^num1(1))&0x80)!=0)	SR|=CCR_VON;
			if(TC2>TC1){				SR|=CCR_CON;
										SR|=CCR_XON;	}

			m68_write1(TR1,TC2);
			PC+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"SUBI.B #$%02X,$%08X\n",
	num1(1),num4(2));	CO;	}
#endif
			TR1=num4(2);
			TC1=m68_read1(TR1);
			TC2=TC1-num1(1);

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TC2==0)					SR|=CCR_ZON;
			if((TC2&0x80)!=0)			SR|=CCR_NON;
				else
			if(((TC1^num1(1))&0x80)!=0)	SR|=CCR_VON;
			if(TC2>TC1){				SR|=CCR_CON;
										SR|=CCR_XON;	}

			m68_write1(TR1,TC2);
			PC+=8;	return;



		default:
			i_gic();	return;
	}





case	0x0440:		//word size , data regster direct
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBI.W #$%04X,D%d\n",
	num2(1),RN1);	CO;	}
#endif
	TS1=(unsigned short)D[RN1];
	TS2=TS1-num2(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS2==0)						SR|=CCR_ZON;
	if((TS2&0x8000)!=0)				SR|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	SR|=CCR_VON;
	if(TS2>TS1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	D[RN1]=(D[RN1]&0xffff0000)|TS2;
	PC+=4;	return;



case	0x0450:		//mem addr
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBI.W #$%04X,(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	TS1=m68_read2(A[RN1]);
	TS2=TS1-num2(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS2==0)						SR|=CCR_ZON;
	if((TS2&0x8000)!=0)				SR|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	SR|=CCR_VON;
	if(TS2>TS1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	m68_write2(A[RN1],TS2);
	PC+=4;	return;



case	0x0458:		//mem addr ,postinc
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBI.W #$%04X,(A%d)+\n",
	num2(1),RN1);	CO;	}
#endif
	TS1=m68_read2(A[RN1]);
	TS2=TS1-num2(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS2==0)						SR|=CCR_ZON;
	if((TS2&0x8000)!=0)				SR|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	SR|=CCR_VON;
	if(TS2>TS1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	m68_write2(A[RN1],TS2);
	A[RN1]+=2;
	PC+=4;	return;



case	0x0460:		//mem addr ,pridec
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBI.W #$%04X,-(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	A[RN1]-=2;
	TS1=m68_read2(A[RN1]);
	TS2=TS1-num2(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS2==0)						SR|=CCR_ZON;
	if((TS2&0x8000)!=0)				SR|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	SR|=CCR_VON;
	if(TS2>TS1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	m68_write2(A[RN1],TS2);
	PC+=4;	return;



case	0x0468:		//mem addr with disp
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.W #$%04X,$%04X(A%d)\n",
	num2(1),num2(2),RN1);	CO;	}
#endif
	TS1=m68_read2(A[RN1]+(short)num2(2));
	TS2=TS1-num2(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS2==0)						SR|=CCR_ZON;
	if((TS2&0x8000)!=0)				SR|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	SR|=CCR_VON;
	if(TS2>TS1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	m68_write2(A[RN1]+(short)num2(2),TS2);
	PC+=6;	return;



case	0x0470:		//byte size , mem addr with index
	RN3=(num2(2)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.W #$%04X,$%02X(A%d,X%d)\n",
	num2(1),num1(2),RN1,RN3);	CO;	}
#endif
	if((num2(2)&0x0800)==0)
				TR1=A[RN1]+(char)num1(2)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(2)+       D[RN3];	//32bitgp
	TS1=m68_read2(TR1);
	TS2=TS1-num2(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TS2==0)						SR|=CCR_ZON;
	if((TS2&0x8000)!=0)				SR|=CCR_NON;
		else
	if(((TS1^num2(1))&0x8000)!=0)	SR|=CCR_VON;
	if(TS2>TS1){					SR|=CCR_CON;
									SR|=CCR_XON;	}

	m68_write2(TR1,TS2);
	PC+=6;	return;



case	0x0478:				//abs
	switch(code&DC_02){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.W #$%04X,$%04X\n",
	num2(1),num2(2));	CO;	}
#endif
			TR1=(short)num2(2);
			TS1=m68_read2(TR1);
			TS2=TS1-num2(1);

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS2==0)						SR|=CCR_ZON;
			if((TS2&0x8000)!=0)				SR|=CCR_NON;
				else
			if(((TS1^num2(1))&0x8000)!=0)	SR|=CCR_VON;
			if(TS2>TS1){					SR|=CCR_CON;
											SR|=CCR_XON;	}

			m68_write2(TR1,TS2);
			PC+=6;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"SUBI.W #$%04X,$%08X\n",
	num2(1),num4(2));	CO;	}
#endif
			TR1=num4(2);
			TS1=m68_read2(TR1);
			TS2=TS1-num2(1);

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TS2==0)						SR|=CCR_ZON;
			if((TS2&0x8000)!=0)				SR|=CCR_NON;
				else
			if(((TS1^num2(1))&0x8000)!=0)	SR|=CCR_VON;
			if(TS2>TS1){					SR|=CCR_CON;
											SR|=CCR_XON;	}

			m68_write2(TR1,TS2);
			PC+=8;	return;



		default:
			i_gic();	return;
	}





case	0x0480:		//long size , data regster direct
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.L #$%08X,D%d\n",
	num4(1),RN1);	CO;	}
#endif
	TL1=D[RN1];
	D[RN1]=TL1-num4(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(D[RN1]==0)							SR|=CCR_ZON;
	if((D[RN1]&0x80000000)!=0)				SR|=CCR_NON;
		else
	if(((D[RN1]^num4(1))&0x80000000)!=0)	SR|=CCR_VON;
	if(D[RN1]>TL1){							SR|=CCR_CON;
											SR|=CCR_XON;	}

	PC+=6;	return;



case	0x0490:		//mem addr
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.L #$%08X,(A%d)\n",
	num4(1),RN1);	CO;	}
#endif
	TL1=m68_read4(A[RN1]);
	TL2=TL1-num4(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL2==0)							SR|=CCR_ZON;
	if((TL2&0x80000000)!=0)				SR|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	SR|=CCR_VON;
	if(TL2>TL1){						SR|=CCR_CON;
										SR|=CCR_XON;	}

	m68_write4(A[RN1],TL2);
	PC+=6;	return;



case	0x0498:		//mem addr ,postinc
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.L #$%08X,(A%d)+\n",
	num4(1),RN1);	CO;	}
#endif
	TL1=m68_read4(A[RN1]);
	TL2=TL1-num4(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL2==0)							SR|=CCR_ZON;
	if((TL2&0x80000000)!=0)				SR|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	SR|=CCR_VON;
	if(TL2>TL1){						SR|=CCR_CON;
										SR|=CCR_XON;	}

	m68_write4(A[RN1],TL2);
	A[RN1]+=4;
	PC+=6;	return;



case	0x04a0:		//mem addr ,pridec
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBI.L #$%08X,-(A%d)\n",
	num4(1),RN1);	CO;	}
#endif
	A[RN1]-=4;
	TL1=m68_read4(A[RN1]);
	TL2=TL1-num4(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL2==0)							SR|=CCR_ZON;
	if((TL2&0x80000000)!=0)				SR|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	SR|=CCR_VON;
	if(TL2>TL1){						SR|=CCR_CON;
										SR|=CCR_XON;	}

	m68_write4(A[RN1],TL2);
	PC+=6;	return;



case	0x04a8:		//mem addr with disp
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"SUBI.L #$%08X,$%04X(A%d)\n",
	num4(1),num2(3),RN1);	CO;	}
#endif
	TL1=m68_read4(A[RN1]+(short)num2(3));
	TL2=TL1-num4(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL2==0)							SR|=CCR_ZON;
	if((TL2&0x80000000)!=0)				SR|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	SR|=CCR_VON;
	if(TL2>TL1){						SR|=CCR_CON;
										SR|=CCR_XON;	}

	m68_write4(A[RN1],TL2);
	PC+=8;	return;



case	0x04b0:		//byte size , mem addr with index
	RN3=(num2(3)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"SUBI.L #$%08X,$%02X(A%d,X%d)\n",
	num4(1),num1(3),RN1,RN3);	CO;	}
#endif
	if((num2(3)&0x0800)==0)
				TR1=A[RN1]+(char)num1(3)+(short)D[RN3];	//16bitg
		else	TR1=A[RN1]+(char)num1(3)+       D[RN3];	//32bitgp

	TL1=m68_read4(TR1);
	TL2=TL1-num4(1);

	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
	if(TL2==0)							SR|=CCR_ZON;
	if((TL2&0x80000000)!=0)				SR|=CCR_NON;
		else
	if(((TL1^num4(1))&0x80000000)!=0)	SR|=CCR_VON;
	if(TL2>TL1){						SR|=CCR_CON;
										SR|=CCR_XON;	}

	m68_write4(TR1,TL2);
	PC+=8;	return;



case	0x04b8:				//abs
	switch(code&DC_02){
		case	0:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD3;	sprintf(buf,"SUBI.L #$%08X,$%04X\n",
	num4(1),num2(3));	CO;	}
#endif
			TR1=(short)num2(3);
			TL1=m68_read4(TR1);
			TL2=TL1-num4(1);

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL2==0)							SR|=CCR_ZON;
			if((TL2&0x80000000)!=0)				SR|=CCR_NON;
				else
			if(((TL1^num4(1))&0x80000000)!=0)	SR|=CCR_VON;
			if(TL2>TL1){						SR|=CCR_CON;
												SR|=CCR_XON;	}

			m68_write4(TR1,TL2);
			PC+=8;	return;



		case	1:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD4;	sprintf(buf,"SUBI.L #$%08X,$%08X\n",
	num4(1),num4(3));	CO;	}
#endif
			TR1=num4(3);
			TL1=m68_read4(TR1);
			TL2=TL1-num4(1);

			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
			if(TL2==0)							SR|=CCR_ZON;
			if((TL2&0x80000000)!=0)				SR|=CCR_NON;
				else
			if(((TL1^num4(1))&0x80000000)!=0)	SR|=CCR_VON;
			if(TL2>TL1){						SR|=CCR_CON;
												SR|=CCR_XON;	}

			m68_write4(TR1,TL2);
			PC+=10;	return;



		default:
			i_gic();	return;
	}
