//	MC68K code SUBQ



	case	0x0100:		//byte size , data regster direct
	case	0x0300:
	case	0x0500:
	case	0x0700:
	case	0x0900:
	case	0x0b00:
	case	0x0d00:
	case	0x0f00:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.B #$%1X,D%d\n",
	TC3,RN1);	CO;	}
#endif
		TC1=(unsigned char)D[RN1];
		TC2=TC1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TC2==0)				SR|=CCR_ZON;
		if((TC2&0x80)!=0)		SR|=CCR_NON;
			else
		if(((TC1^TC3)&0x80)!=0)	SR|=CCR_VON;
		if(TC2>TC1){			SR|=CCR_CON;
								SR|=CCR_XON;	}

		D[RN1]=(D[RN1]&0xffffff00)|TC2;
		PC+=2;	return;



	case	0x0110:		//byte size , mem addr
	case	0x0310:
	case	0x0510:
	case	0x0710:
	case	0x0910:
	case	0x0b10:
	case	0x0d10:
	case	0x0f10:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.B #$%1X,(A%d)\n",
	TC3,RN1);	CO;	}
#endif
		TC1=m68_read1(A[RN1]);
		TC2=TC1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TC2==0)				SR|=CCR_ZON;
		if((TC2&0x80)!=0)		SR|=CCR_NON;
			else
		if(((TC1^TC3)&0x80)!=0)	SR|=CCR_VON;
		if(TC2>TC1){			SR|=CCR_CON;
								SR|=CCR_XON;	}

		m68_write1(A[RN1],TC2);
		PC+=2;	return;



	case	0x0118:		//byte size , mem addr ,postinc
	case	0x0318:
	case	0x0518:
	case	0x0718:
	case	0x0918:
	case	0x0b18:
	case	0x0d18:
	case	0x0f18:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.B #$%1X,(A%d)+\n",
	TC3,RN1);	CO;	}
#endif
		TC1=m68_read1(A[RN1]);
		TC2=TC1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TC2==0)				SR|=CCR_ZON;
		if((TC2&0x80)!=0)		SR|=CCR_NON;
			else
		if(((TC1^TC3)&0x80)!=0)	SR|=CCR_VON;
		if(TC2>TC1){			SR|=CCR_CON;
								SR|=CCR_XON;	}

		m68_write1(A[RN1],TC2);
		A[RN1]++;
		PC+=2;	return;



	case	0x0120:		//byte size , mem addr ,pridec
	case	0x0320:
	case	0x0520:
	case	0x0720:
	case	0x0920:
	case	0x0b20:
	case	0x0d20:
	case	0x0f20:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.B #$%1X,-(A%d)\n",
	TC3,RN1);	CO;	}
#endif
		A[RN1]--;
		TC1=m68_read1(A[RN1]);
		TC2=TC1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TC2==0)				SR|=CCR_ZON;
		if((TC2&0x80)!=0)		SR|=CCR_NON;
			else
		if(((TC1^TC3)&0x80)!=0)	SR|=CCR_VON;
		if(TC2>TC1){			SR|=CCR_CON;
								SR|=CCR_XON;	}

		m68_write1(A[RN1],TC2);
		PC+=2;	return;



	case	0x0128:		//byte size , mem addr with disp
	case	0x0328:
	case	0x0528:
	case	0x0728:
	case	0x0928:
	case	0x0b28:
	case	0x0d28:
	case	0x0f28:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.B #$%1X,$%04X(A%d)\n",
	TC3,num2(1),RN1);	CO;	}
#endif
		TC1=m68_read1(A[RN1]+(short)num2(1));
		TC2=TC1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TC2==0)				SR|=CCR_ZON;
		if((TC2&0x80)!=0)		SR|=CCR_NON;
			else
		if(((TC1^TC3)&0x80)!=0)	SR|=CCR_VON;
		if(TC2>TC1){			SR|=CCR_CON;
								SR|=CCR_XON;	}

		m68_write1(A[RN1]+(short)num2(1),TC2);
		PC+=4;	return;



	case	0x0130:		//byte size , mem addr with index
	case	0x0330:
	case	0x0530:
	case	0x0730:
	case	0x0930:
	case	0x0b30:
	case	0x0d30:
	case	0x0f30:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		RN2=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.B #$%1X,$%02X(A%d,X%d)\n",
	TC3,num1(1),RN1,RN2);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TR1=A[RN1]+(char)num1(1)+(short)D[RN2];	//16bitg
			else	TR1=A[RN1]+(char)num1(1)+D[RN2];		//32bitgp

				TC1=m68_read1(TR1);
				TC2=TC1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TC2==0)				SR|=CCR_ZON;
				if((TC2&0x80)!=0)		SR|=CCR_NON;
					else
				if(((TC1^TC3)&0x80)!=0)	SR|=CCR_VON;
				if(TC2>TC1){			SR|=CCR_CON;
										SR|=CCR_XON;	}

				m68_write1(TR1,TC2);
				PC+=4;	return;



	case	0x0138:				//byte size , abs
	case	0x0338:
	case	0x0538:
	case	0x0738:
	case	0x0938:
	case	0x0b38:
	case	0x0d38:
	case	0x0f38:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		switch(code&DC_02){
			case	0x0000:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.B #$%1X,$%04X\n",
	TC3,num2(1));	CO;	}
#endif
				TR1=(short)num2(1);
				TC1=m68_read1(TR1);
				TC2=TC1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TC2==0)				SR|=CCR_ZON;
				if((TC2&0x80)!=0)		SR|=CCR_NON;
					else
				if(((TC1^TC3)&0x80)!=0)	SR|=CCR_VON;
				if(TC2>TC1){			SR|=CCR_CON;
										SR|=CCR_XON;	}

				m68_write1(TR1,TC2);
				PC+=4;	return;



			case	0x0001:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBQ.B #$%1X,$%08X\n",
	TC3,num4(1));	CO;	}
#endif
				TR1=num4(1);
				TC1=m68_read1(TR1);
				TC2=TC1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TC2==0)				SR|=CCR_ZON;
				if((TC2&0x80)!=0)		SR|=CCR_NON;
					else
				if(((TC1^TC3)&0x80)!=0)	SR|=CCR_VON;
				if(TC2>TC1){			SR|=CCR_CON;
										SR|=CCR_XON;	}

				m68_write1(TR1,TC2);
				PC+=6;	return;



			default:
				i_gic();	return;
		}





	case	0x0140:		//word size , data regster direct
	case	0x0340:
	case	0x0540:
	case	0x0740:
	case	0x0940:
	case	0x0b40:
	case	0x0d40:
	case	0x0f40:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.W #$%1X,D%d\n",
	TC3,RN1);	CO;	}
#endif
		TS1=(unsigned short)D[RN1];
		TS2=TS1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TS2==0)					SR|=CCR_ZON;
		if((TS2&0x8000)!=0)			SR|=CCR_NON;
			else
		if(((TS1^TC3)&0x8000)!=0)	SR|=CCR_VON;
		if(TS2>TS1){				SR|=CCR_CON;
									SR|=CCR_XON;	}

		D[RN1]=(D[RN1]&0xffff0000)|TS2;
		PC+=2;	return;



	case	0x0150:		//mem addr
	case	0x0350:
	case	0x0550:
	case	0x0750:
	case	0x0950:
	case	0x0b50:
	case	0x0d50:
	case	0x0f50:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.W #$%1X,(A%d)\n",
	TC3,RN1);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		TS2=TS1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TS2==0)					SR|=CCR_ZON;
		if((TS2&0x8000)!=0)			SR|=CCR_NON;
			else
		if(((TS1^TC3)&0x8000)!=0)	SR|=CCR_VON;
		if(TS2>TS1){				SR|=CCR_CON;
									SR|=CCR_XON;	}

		m68_write2(A[RN1],TS2);
		PC+=2;	return;



	case	0x0158:		//mem addr ,postinc
	case	0x0358:
	case	0x0558:
	case	0x0758:
	case	0x0958:
	case	0x0b58:
	case	0x0d58:
	case	0x0f58:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.W #$%1X,(A%d)+\n",
	TC3,RN1);	CO;	}
#endif
		TS1=m68_read2(A[RN1]);
		TS2=TS1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TS2==0)					SR|=CCR_ZON;
		if((TS2&0x8000)!=0)			SR|=CCR_NON;
			else
		if(((TS1^TC3)&0x8000)!=0)	SR|=CCR_VON;
		if(TS2>TS1){				SR|=CCR_CON;
									SR|=CCR_XON;	}

		m68_write2(A[RN1],TS2);
		A[RN1]+=2;
		PC+=2;	return;



	case	0x0160:		//mem addr ,pridec
	case	0x0360:
	case	0x0560:
	case	0x0760:
	case	0x0960:
	case	0x0b60:
	case	0x0d60:
	case	0x0f60:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.W #$%1X,-(A%d)\n",
	TC3,RN1);	CO;	}
#endif
		A[RN1]-=2;
		TS1=m68_read2(A[RN1]);
		TS2=TS1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TS2==0)					SR|=CCR_ZON;
		if((TS2&0x8000)!=0)			SR|=CCR_NON;
			else
		if(((TS1^TC3)&0x8000)!=0)	SR|=CCR_VON;
		if(TS2>TS1){				SR|=CCR_CON;
									SR|=CCR_XON;	}

		m68_write2(A[RN1],TS2);
		PC+=2;	return;



	case	0x0168:		//mem addr with disp
	case	0x0368:
	case	0x0568:
	case	0x0768:
	case	0x0968:
	case	0x0b68:
	case	0x0d68:
	case	0x0f68:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.W #$%1X,$%04X(A%d)\n",
	TC3,num2(1),RN1);	CO;	}
#endif
		TS1=m68_read2(A[RN1]+(short)num2(1));
		TS2=TS1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TS2==0)					SR|=CCR_ZON;
		if((TS2&0x8000)!=0)			SR|=CCR_NON;
			else
		if(((TS1^TC3)&0x8000)!=0)	SR|=CCR_VON;
		if(TS2>TS1){				SR|=CCR_CON;
									SR|=CCR_XON;	}

		m68_write2(A[RN1]+(short)num2(1),TS2);
		PC+=4;	return;



	case	0x0170:		//byte size , mem addr with index
	case	0x0370:
	case	0x0570:
	case	0x0770:
	case	0x0970:
	case	0x0b70:
	case	0x0d70:
	case	0x0f70:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		RN2=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.W #$%1X,$%02X(A%d,X%d)\n",
	TC3,num1(1),RN1,RN2);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TR1=A[RN1]+(char)num1(1)+(short)D[RN2];	//16bitg
			else	TR1=A[RN1]+(char)num1(1)+D[RN2];		//32bitgp

				TS1=m68_read2(TR1);
				TS2=TS1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TS2==0)					SR|=CCR_ZON;
				if((TS2&0x8000)!=0)			SR|=CCR_NON;
					else
				if(((TS1^TC3)&0x8000)!=0)	SR|=CCR_VON;
				if(TS2>TS1){				SR|=CCR_CON;
											SR|=CCR_XON;	}

				m68_write2(TR1,TS2);
				PC+=4;	return;



	case	0x0178:				//abs
	case	0x0378:
	case	0x0578:
	case	0x0778:
	case	0x0978:
	case	0x0b78:
	case	0x0d78:
	case	0x0f78:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		switch(code&DC_02){
			case	0x0000:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.W #$%1X,$%04X\n",
	TC3,num2(1));	CO;	}
#endif
				TR1=(short)num2(1);
				TS1=m68_read2(TR1);
				TS2=TS1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TS2==0)					SR|=CCR_ZON;
				if((TS2&0x8000)!=0)			SR|=CCR_NON;
					else
				if(((TS1^TC3)&0x8000)!=0)	SR|=CCR_VON;
				if(TS2>TS1){				SR|=CCR_CON;
											SR|=CCR_XON;	}

				m68_write2(TR1,TS2);
				PC+=4;	return;



			case	0x0001:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBQ.W #$%1X,$%08X\n",
	TC3,num4(1));	CO;	}
#endif
				TR1=num4(1);
				TS1=m68_read2(TR1);
				TS2=TS1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TS2==0)					SR|=CCR_ZON;
				if((TS2&0x8000)!=0)			SR|=CCR_NON;
					else
				if(((TS1^TC3)&0x8000)!=0)	SR|=CCR_VON;
				if(TS2>TS1){				SR|=CCR_CON;
											SR|=CCR_XON;	}

				m68_write2(TR1,TS2);
				PC+=6;	return;



			default:
				i_gic();	return;
		}





	case	0x0180:		//long size , data regster direct
	case	0x0380:
	case	0x0580:
	case	0x0780:
	case	0x0980:
	case	0x0b80:
	case	0x0d80:
	case	0x0f80:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.L #$%1X,D%d\n",
	TC3,RN1);	CO;	}
#endif
		TL1=D[RN1];
		D[RN1]=TL1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(D[RN1]==0)						SR|=CCR_ZON;
		if((D[RN1]&0x80000000)!=0)			SR|=CCR_NON;
			else
		if(((D[RN1]^TC3)&0x80000000)!=0)	SR|=CCR_VON;
		if(D[RN1]>TL1){						SR|=CCR_CON;
											SR|=CCR_XON;	}

		PC+=2;	return;



	case	0x0190:		//mem addr
	case	0x0390:
	case	0x0590:
	case	0x0790:
	case	0x0990:
	case	0x0b90:
	case	0x0d90:
	case	0x0f90:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.L #$%1X,(A%d)\n",
	TC3,RN1);	CO;	}
#endif
		TL1=m68_read4(A[RN1]);
		TL2=TL1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TL2==0)						SR|=CCR_ZON;
		if((TL2&0x80000000)!=0)			SR|=CCR_NON;
			else
		if(((TL1^TC3)&0x80000000)!=0)	SR|=CCR_VON;
		if(TL2>TL1){					SR|=CCR_CON;
										SR|=CCR_XON;	}

		m68_write4(A[RN1],TL2);
		PC+=2;	return;



	case	0x0198:		//mem addr ,postinc
	case	0x0398:
	case	0x0598:
	case	0x0798:
	case	0x0998:
	case	0x0b98:
	case	0x0d98:
	case	0x0f98:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.L #$%1X,(A%d)+\n",
	TC3,RN1);	CO;	}
#endif
		TL1=m68_read4(A[RN1]);
		TL2=TL1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TL2==0)						SR|=CCR_ZON;
		if((TL2&0x80000000)!=0)			SR|=CCR_NON;
			else
		if(((TL1^TC3)&0x80000000)!=0)	SR|=CCR_VON;
		if(TL2>TL1){					SR|=CCR_CON;
										SR|=CCR_XON;	}

		m68_write4(A[RN1],TL2);
		A[RN1]+=4;
		PC+=2;	return;



	case	0x01a0:		//mem addr ,pridec
	case	0x03a0:
	case	0x05a0:
	case	0x07a0:
	case	0x09a0:
	case	0x0ba0:
	case	0x0da0:
	case	0x0fa0:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"SUBQ.L #$%1X,-(A%d)\n",
	TC3,RN1);	CO;	}
#endif
		A[RN1]-=4;
		TL1=m68_read4(A[RN1]);
		TL2=TL1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TL2==0)						SR|=CCR_ZON;
		if((TL2&0x80000000)!=0)			SR|=CCR_NON;
			else
		if(((TL1^TC3)&0x80000000)!=0)	SR|=CCR_VON;
		if(TL2>TL1){					SR|=CCR_CON;
										SR|=CCR_XON;	}

		m68_write4(A[RN1],TL2);
		PC+=2;	return;



	case	0x01a8:		//mem addr with disp
	case	0x03a8:
	case	0x05a8:
	case	0x07a8:
	case	0x09a8:
	case	0x0ba8:
	case	0x0da8:
	case	0x0fa8:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.L #$%1X,$%04X(A%d)\n",
	TC3,num2(1),RN1);	CO;	}
#endif
		TL1=m68_read4(A[RN1]+(short)num2(1));
		TL2=TL1-TC3;

		SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
		if(TL2==0)						SR|=CCR_ZON;
		if((TL2&0x80000000)!=0)			SR|=CCR_NON;
			else
		if(((TL1^TC3)&0x80000000)!=0)	SR|=CCR_VON;
		if(TL2>TL1){					SR|=CCR_CON;
										SR|=CCR_XON;	}

		m68_write4(A[RN1],TL2);
		PC+=4;	return;



	case	0x01b0:		//byte size , mem addr with index
	case	0x03b0:
	case	0x05b0:
	case	0x07b0:
	case	0x09b0:
	case	0x0bb0:
	case	0x0db0:
	case	0x0fb0:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		RN2=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.L #$%1X,$%02X(A%d,X%d)\n",
	TC3,num1(1),RN1,RN2);	CO;	}
#endif
		if((num2(1)&0x0800)==0)
					TR1=A[RN1]+(char)num1(1)+(short)D[RN2];	//16bitg
			else	TR1=A[RN1]+(char)num1(1)+D[RN2];		//32bitgp

				TL1=m68_read4(TR1);
				TL2=TL1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TL2==0)						SR|=CCR_ZON;
				if((TL2&0x80000000)!=0)			SR|=CCR_NON;
					else
				if(((TL1^TC3)&0x80000000)!=0)	SR|=CCR_VON;
				if(TL2>TL1){					SR|=CCR_CON;
												SR|=CCR_XON;	}

				m68_write4(TR1,TL2);
				PC+=4;	return;



	case	0x01b8:				//abs
	case	0x03b8:
	case	0x05b8:
	case	0x07b8:
	case	0x09b8:
	case	0x0bb8:
	case	0x0db8:
	case	0x0fb8:
		TC3=(code>>9)&DC_02;			//imm data
		if(TC3==0)	TC3=8;				//0 -> 8
		switch(code&DC_02){
			case	0x0000:		//word size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"SUBQ.L #$%1X,$%04X\n",
	TC3,num2(1));	CO;	}
#endif
				TR1=(short)num2(1);
				TL1=m68_read4(TR1);
				TL2=TL1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TL2==0)						SR|=CCR_ZON;
				if((TL2&0x80000000)!=0)			SR|=CCR_NON;
					else
				if(((TL1^TC3)&0x80000000)!=0)	SR|=CCR_VON;
				if(TL2>TL1){					SR|=CCR_CON;
												SR|=CCR_XON;	}

				m68_write4(TR1,TL2);
				PC+=4;	return;



			case	0x0001:		//long size
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"SUBQ.L #$%1X,$%08X\n",
	TC3,num4(1));	CO;	}
#endif
				TR1=num4(1);
				TL1=m68_read4(TR1);
				TL2=TL1-TC3;

				SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF&CCR_XOFF;
				if(TL2==0)						SR|=CCR_ZON;
				if((TL2&0x80000000)!=0)			SR|=CCR_NON;
					else
				if(((TL1^TC3)&0x80000000)!=0)	SR|=CCR_VON;
				if(TL2>TL1){					SR|=CCR_CON;
												SR|=CCR_XON;	}

				m68_write4(TR1,TL2);
				PC+=6;	return;


			default:
				i_gic();	return;
		}
