//	MC68K code TAS



case	0x0ac0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"TAS D%d\n",
	RN1);	CO;	}
#endif
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if((unsigned char)D[RN1]==0)		SR|=CCR_ZON;
	if(((unsigned char)D[RN1]&0x80)!=0)	SR|=CCR_NON;
	D[RN1]|=0x80;
	PC+=2;	return;



case	0x0ad0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"TAS (A%d)\n",
	RN1);	CO;	}
#endif
	TC2=m68_read1(A[RN1]);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)			SR|=CCR_ZON;
	if((TC2&0x80)!=0)	SR|=CCR_NON;
	m68_write1(A[RN1],TC2|0x80);
	PC+=2;	return;



case	0x0ad8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"TAS (A%d)+\n",
	RN1);	CO;	}
#endif
	TC2=m68_read1(A[RN1]);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)			SR|=CCR_ZON;
	if((TC2&0x80)!=0)	SR|=CCR_NON;
	m68_write1(A[RN1],TC2|0x80);
	A[RN1]++;
	PC+=2;	return;



case	0x0ae0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD0;	sprintf(buf,"TAS -(A%d)\n",
	RN1);	CO;	}
#endif
	A[RN1]--;
	TC2=m68_read1(A[RN1]);
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)			SR|=CCR_ZON;
	if((TC2&0x80)!=0)	SR|=CCR_NON;
	m68_write1(A[RN1],TC2|0x80);
	PC+=2;	return;



case	0x0ae8:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"TAS $%04X(A%d)\n",
	num2(1),RN1);	CO;	}
#endif
	TC2=m68_read1(A[RN1]+(short)num2(1));
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)			SR|=CCR_ZON;
	if((TC2&0x80)!=0)	SR|=CCR_NON;
	m68_write1(A[RN1]+(short)num2(1),TC2|0x80);
	PC+=4;	return;



case	0x0af0:
	RN3=(num2(1)>>12)&15;	//index
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"TAS $%02X(A%d,X%d)\n",
	num1(1),RN1,RN3);	CO;	}
#endif
	if((num2(1)&0x0800)==0){
				TC2=m68_read1(A[RN1]+(char)num1(1)+(short)D[RN2]);	//16bit
				m68_write1(   A[RN1]+(char)num1(1)+(short)D[RN2],TC2|0x80);	}
		else{	TC2=m68_read1(A[RN1]+(char)num1(1)+       D[RN2]);	//32bit
				m68_write1(   A[RN1]+(char)num1(1)+       D[RN2],TC2|0x80);	}
	SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
	if(TC2==0)			SR|=CCR_ZON;
	if((TC2&0x80)!=0)	SR|=CCR_NON;
	PC+=4;	return;



case	0x0af8:
	switch(RN1){
		case	0:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD1;	sprintf(buf,"TAS $%04X\n",
	num2(1));	CO;	}
#endif
			TC2=m68_read1(num2(1));
			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC2==0)			SR|=CCR_ZON;
			if((TC2&0x80)!=0)	SR|=CCR_NON;
			m68_write1(num2(1),TC2|0x80);
			PC+=4;	return;
		case	1:
#ifdef	_DEBUG
if((VSR&0x0020)!=0){	BD2;	sprintf(buf,"TAS $%08X\n",
	num4(1));	CO;	}
#endif
			TC2=m68_read1(num4(1));
			SR&=CCR_VOFF&CCR_COFF&CCR_ZOFF&CCR_NOFF;
			if(TC2==0)			SR|=CCR_ZON;
			if((TC2&0x80)!=0)	SR|=CCR_NON;
			m68_write1(num4(1),TC2|0x80);
			PC+=6;	return;



			default:
				i_gic();	return;
		}



