//	MC68K code ANDI



case	0x0200:		//byte size , data regster direct
	DD1;	sprintf(buf,"ANDI.B #$%02X,D%d\n",dnm1(1),RN1);	CO;	TUC+=4;	return;

case	0x0210:		//byte size , mem addr
	DD1;	sprintf(buf,"ANDI.B #$%02X,(A%d)\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0218:		//byte size , mem addr ,postinc
	DD1;	sprintf(buf,"ANDI.B #$%02X,(A%d)+\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0220:		//byte size , mem addr ,pridec
	DD1;	sprintf(buf,"ANDI.B #$%02X,-(A%d)\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0228:		//byte size , mem addr with disp
	DD2;	sprintf(buf,"ANDI.B #$%02X,$%04X(A%d)\n",dnm1(1),dnm2(2),RN1);	CO;
	TUC+=6;	return;

case	0x0230:		//byte size , mem addr with index
	RN3=(dnm2(2)>>12)&15;	//index
	DD2;	sprintf(buf,"ANDI.B #$%02X,$%02X(A%d,X%d)\n",
		dnm1(1),dnm1(2),RN1,RN3);	CO;	TUC+=6;	return;

case	0x0238:				//byte size , abs
	switch(RN1){
		case	0:		//word size
			DD2;	sprintf(buf,"ANDI.B #$%02X,$%04X\n",dnm1(1),dnm2(2));	CO;
			TUC+=6;	return;

		case	1:		//long size
			DD3;	sprintf(buf,"ANDI.B #$%02X,$%08X\n",dnm1(1),dnm4(2));	CO;
			TUC+=8;	return;

		case	4:		//ANDI to CCR
			DD1;	sprintf(buf,"ANDI #$%02X,CCR\n",dnm1(1));	CO;
			TUC+=4;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}



case	0x0240:		//word size , data regster direct
	DD1;	sprintf(buf,"ANDI.W #$%04X,D%d\n",dnm2(1),RN1);	CO;	TUC+=4;	return;

case	0x0250:		//mem addr
	DD1;	sprintf(buf,"ANDI.W #$%04X,(A%d)\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0258:		//mem addr ,postinc
	DD1;	sprintf(buf,"ANDI.W #$%04X,(A%d)+\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0260:		//mem addr ,pridec
	DD1;	sprintf(buf,"ANDI.W #$%04X,-(A%d)\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0268:		//mem addr with disp
	DD2;	sprintf(buf,"ANDI.W #$%04X,$%04X(A%d)\n",dnm2(1),dnm2(2),RN1);	CO;
	TUC+=6;	return;

case	0x0270:		//byte size , mem addr with index
	RN3=(dnm2(2)>>12)&15;	//index
	DD2;	sprintf(buf,"ANDI.W #$%04X,$%02X(A%d,X%d)\n",
		dnm2(1),dnm1(2),RN1,RN3);	CO;	TUC+=6;	return;

case	0x0278:				//abs
	switch(RN1){
		case	0:		//word size
			DD2;	sprintf(buf,"ANDI.W #$%04X,$%04X\n",dnm2(1),dnm2(2));	CO;
			TUC+=6;	return;

		case	1:		//long size
			DD3;	sprintf(buf,"ANDI.W #$%04X,$%08X\n",dnm2(1),dnm4(2));	CO;
			TUC+=8;	return;

		case	4:		//ANDI to SR
			DD1;	sprintf(buf,"ANDI #$%04X,SR\n",dnm2(1));	CO;
			TUC+=4;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}



case	0x0280:		//long size , data regster direct
	DD2;	sprintf(buf,"ANDI.L #$%08X,D%d\n",dnm4(1),RN1);	CO;	TUC+=6;	return;

case	0x0290:		//mem addr
	DD2;	sprintf(buf,"ANDI.L #$%08X,(A%d)\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x0298:		//mem addr ,postinc
	DD2;	sprintf(buf,"ANDI.L #$%08X,(A%d)+\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x02a0:		//mem addr ,pridec
	DD2;	sprintf(buf,"ANDI.L #$%08X,-(A%d)\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x02a8:		//mem addr with disp
	DD3;	sprintf(buf,"ANDI.L #$%08X,$%04X(A%d)\n",dnm4(1),dnm2(3),RN1);	CO;
	TUC+=8;	return;

case	0x02b0:		//byte size , mem addr with index
	RN3=(dnm2(3)>>12)&15;	//index
	DD3;	sprintf(buf,"ANDI.L #$%08X,$%02X(A%d,X%d)\n",
		dnm4(1),dnm1(3),RN1,RN3);	CO;	TUC+=8;	return;

case	0x02b8:				//abs
	switch(RN1){
		case	0:		//word size
			DD3;	sprintf(buf,"ANDI.L #$%08X,$%04X\n",dnm4(1),dnm2(3));	CO;
			TUC+=8;	return;

		case	1:		//long size
			DD4;	sprintf(buf,"ANDI.L #$%08X,$%08X\n",dnm4(1),dnm4(3));	CO;
			TUC+=10;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}
