//	MC68K code CMPI



case	0x0c00:		//byte size , data regster direct
	DD1;	sprintf(buf,"CMPI.B #$%02X,D%d\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0c10:		//byte size , mem addr
	DD1;	sprintf(buf,"CMPI.B #$%02X,(A%d)\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0c18:		//byte size , mem addr ,postinc
	DD1;	sprintf(buf,"CMPI.B #$%02X,(A%d)+\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0c20:		//byte size , mem addr ,pridec
	DD1;	sprintf(buf,"CMPI.B #$%02X,-(A%d)\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0c28:		//byte size , mem addr with disp
	DD2;	sprintf(buf,"CMPI.B #$%02X,$%04X(A%d)\n",dnm1(1),dnm2(2),RN1);	CO;
	TUC+=6;	return;

case	0x0c30:		//byte size , mem addr with index
	RN3=(dnm2(2)>>12)&15;	//index
	DD2;	sprintf(buf,"CMPI.B #$%02X,$%02X(A%d,X%d)\n",
		dnm1(1),dnm1(2),RN1,RN3);	CO;	TUC+=6;	return;

case	0x0c38:				//byte size , abs
	switch(RN1){
		case	0:		//word size
			DD2;	sprintf(buf,"CMPI.B #$%02X,$%04X\n",dnm1(1),dnm2(2));	CO;
			TUC+=6;	return;

		case	1:		//long size
			DD3;	sprintf(buf,"CMPI.B #$%02X,$%08X\n",dnm1(1),dnm4(2));	CO;
			TUC+=8;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}



case	0x0c40:		//word size , data regster direct
	DD1;	sprintf(buf,"CMPI.W #$%04X,D%d\n",dnm2(1),RN1);	CO;	TUC+=4;	return;

case	0x0c50:		//mem addr
	DD1;	sprintf(buf,"CMPI.W #$%04X,(A%d)\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0c58:		//mem addr ,postinc
	DD1;	sprintf(buf,"CMPI.W #$%04X,(A%d)+\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0c60:		//mem addr ,pridec
	DD1;	sprintf(buf,"CMPI.W #$%04X,-(A%d)\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0c68:		//mem addr with disp
	DD2;	sprintf(buf,"CMPI.W #$%04X,$%04X(A%d)\n",dnm2(1),dnm2(2),RN1);	CO;
	TUC+=4;	return;

case	0x0c70:		//byte size , mem addr with index
	RN3=(dnm2(2)>>12)&15;	//index
	DD2;	sprintf(buf,"CMPI.W #$%04X,$%02X(A%d,X%d)\n",
		dnm2(1),dnm1(2),RN1,RN3);	CO;	TUC+=6;	return;

case	0x0c78:				//abs
	switch(RN1){
		case	0:		//word size
			DD2;	sprintf(buf,"CMPI.W #$%04X,$%04X\n",dnm2(1),dnm2(2));	CO;
			TUC+=6;	return;

		case	1:		//long size
			DD3;	sprintf(buf,"CMPI.W #$%04X,$%08X\n",dnm2(1),dnm4(2));	CO;
			TUC+=8;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}



case	0x0c80:		//long size , data regster direct
	DD2;	sprintf(buf,"CMPI.L #$%08X,D%d\n",dnm4(1),RN1);	CO;	TUC+=6;	return;

case	0x0c90:		//mem addr
	DD2;	sprintf(buf,"CMPI.L #$%08X,(A%d)\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x0c98:		//mem addr ,postinc
	DD2;	sprintf(buf,"CMPI.L #$%08X,(A%d)+\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x0ca0:		//mem addr ,pridec
	DD2;	sprintf(buf,"CMPI.L #$%08X,-(A%d)\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x0ca8:		//mem addr with disp
	DD3;	sprintf(buf,"CMPI.L #$%08X,$%04X(A%d)\n",dnm4(1),dnm2(3),RN1);	CO;
	TUC+=8;	return;

case	0x0cb0:		//byte size , mem addr with index
	RN3=(dnm2(3)>>12)&15;	//index
	DD3;	sprintf(buf,"CMPI.L #$%08X,$%02X(A%d,X%d)\n",
		dnm4(1),dnm1(3),RN1,RN3);	CO;
	TUC+=8;	return;

case	0x0cb8:				//abs
	switch(RN1){
		case	0:		//word size
			DD3;	sprintf(buf,"CMPI.L #$%08X,$%04X\n",dnm4(1),dnm2(3));	CO;
			TUC+=8;	return;

		case	0x0001:		//long size
			DD4;	sprintf(buf,"CMPI.L #$%08X,$%08X\n",dnm4(1),dnm4(3));	CO;
			TUC+=10;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}
