//	MC68K	0x1xxx	Opecode
//			MOVE.L


RN1=code		&DC_02;			//source
RN2=(code>>9)	&DC_02;			//distination

switch(code&DC_38){
	case	0x0000:				//	S=Dn	D=Dn
		DD0;	sprintf(buf,"MOVE.L D%d,D%d\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0008:				//	S=An	D=Dn
		DD0;	sprintf(buf,"MOVE.L A%d,D%d\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0010:				//	S=(An)	D=Dn
		DD0;	sprintf(buf,"MOVE.L (A%d),D%d\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0018:				//	S=(An)+	D=Dn
		DD0;	sprintf(buf,"MOVE.L (A%d)+,D%d\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0020:				//	S=-(An)	D=Dn
		DD0;	sprintf(buf,"MOVE.L -(A%d),D%d\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0028:				//	S=d16(An)	D=Dn
		DD1;	sprintf(buf,"MOVE.L $%04X(A%d),D%d\n",dnm2(1),RN1,RN2);	CO;
		TUC+=4;	return;

	case	0x0030:				//	S=d8(An,Xn)	D=Dn
		DD1;	sprintf(buf,"MOVE.L $%02X(A%d,X%d),D%d\n",
			dnm1(1),RN1,(dnm2(1)>>12),RN2);	CO;	TUC+=4;	return;

	case	0x0038:
		switch(RN1){
			case	0:			//	S=Abs.W	D=Dn
				DD1;	sprintf(buf,"MOVE.L $%04X,D%d\n",dnm2(1),RN2);	CO;
				TUC+=4;	return;

			case	1:			//	S=Abs.L	D=Dn
				DD2;	sprintf(buf,"MOVE.L $%08X,D%d\n",dnm4(1),RN2);	CO;
				TUC+=6;	return;

			case	2:			//	S=d16(PC)	D=Dn
				DD1;	sprintf(buf,"MOVE.L $%04X(PC),D%d\n",dnm2(1),RN2);	CO;
				TUC+=4;	return;

			case	3:			//	S=d8(PC,Xn)	D=Dn
				DD1;	sprintf(buf,"MOVE.L $%02X(PC,X%d),D%d\n",
					dnm1(1),dnm2(1)>>12,RN2);	CO;	TUC+=4;	return;

			case	4:			//	S=#imm	D=Dn
				DD2;	sprintf(buf,"MOVE.L #$%08X,D%d\n",dnm4(1),RN2);	CO;
				TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x0040:				//	S=Dn	D=An
		DD0;	sprintf(buf,"MOVEA.L D%d,A%d\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0048:				//	S=An	D=An
		DD0;	sprintf(buf,"MOVEA.L A%d,A%d\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0050:				//	S=(An)	D=An
		DD0;	sprintf(buf,"MOVEA.L (A%d),A%d\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0058:				//	S=(An)+	D=An
		DD0;	sprintf(buf,"MOVEA.L (A%d)+,A%d\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x0060:				//	S=-(An)	D=An
		DD0;	sprintf(buf,"MOVEA.L -(A%d),A%d\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x0068:				//	S=d16(An)	D=An
		DD1;	sprintf(buf,"MOVEA.L $%04X(A%d),A%d\n",dnm2(1),RN1,RN2);	CO;
		TUC+=4;	return;

	case	0x0070:				//	S=d8(An,Xn)	D=An
		DD1;	sprintf(buf,"MOVEA.L $%02X(A%d,X%d),A%d\n",
			dnm1(1),RN1,(dnm2(1)>>12),RN2);	CO;	TUC+=4;	return;

	case	0x0078:
		switch(RN1){
			case	0:			//	S=Abs.W	D=An
				DD1;	sprintf(buf,"MOVEA.L $%04X,A%d\n",dnm2(1),RN2);	CO;
				TUC+=4;	return;

			case	1:			//	S=Abs.L	D=An
				DD2;	sprintf(buf,"MOVEA.L $%08X,A%d\n",dnm4(1),RN2);	CO;
				TUC+=6;	return;

			case	2:			//	S=d16(PC)	D=An
				DD1;	sprintf(buf,"MOVEA.L $%04X(PC),A%d\n",dnm2(1),RN2);	CO;
				TUC+=4;	return;

			case	3:			//	S=d8(PC,Xn)	D=An
				DD1;	sprintf(buf,"MOVEA.L $%02X(PC,X%d),A%d\n",
					dnm1(1),dnm2(1)>>12,RN2);	CO;	TUC+=4;	return;

			case	4:			//	S=#imm	D=An
				DD2;	sprintf(buf,"MOVEA.L #$%08X,A%d\n",dnm4(1),RN2);	CO;
				TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x0080:				//	S=Dn	D=(An)
		DD0;	sprintf(buf,"MOVE.L D%d,(A%d)\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0088:				//	S=An	D=(An)
		DD0;	sprintf(buf,"MOVE.L A%d,(A%d)\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0090:				//	S=(An)	D=(An)
		DD0;	sprintf(buf,"MOVE.L (A%d),(A%d)\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x0098:				//	S=(An)+	D=(An)
		DD0;	sprintf(buf,"MOVE.L (A%d)+,(A%d)\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x00a0:				//	S=-(An)	D=(An)
		DD0;	sprintf(buf,"MOVE.L -(A%d),(A%d)\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x00a8:				//	S=d16(An)	D=(An)
		DD1;	sprintf(buf,"MOVE.L $%04X(A%d),(A%d)\n",dnm2(1),RN1,RN2);	CO;
		TUC+=4;	return;

	case	0x00b0:				//	S=d8(An,Xn)	D=(An)
		DD1;	sprintf(buf,"MOVE.L $%02X(A%d,X%d),(A%d)\n",
			dnm1(1),RN1,(dnm2(1)>>12),RN2);	CO;	TUC+=4;	return;

	case	0x00b8:
		switch(RN1){
			case	0:			//	S=Abs.W	D=(An)
				DD1;	sprintf(buf,"MOVE.L $%04X,(A%d)\n",dnm2(1),RN2);	CO;
				TUC+=4;	return;

			case	1:			//	S=Abs.L	D=(An)
				DD2;	sprintf(buf,"MOVE.L $%08X,(A%d)\n",dnm4(1),RN2);	CO;
				TUC+=6;	return;

			case	2:			//	S=d16(PC)	D=(An)
				DD1;	sprintf(buf,"MOVE.L $%04X(PC),(A%d)\n",
					dnm2(1),RN2);	CO;	TUC+=4;	return;

			case	3:			//	S=d8(PC,Xn)	D=(An)
				DD1;	sprintf(buf,"MOVE.L $%02X(PC,X%d),(A%d)\n",
					dnm1(1),dnm2(1)>>12,RN2);	CO;	TUC+=4;	return;

			case	4:			//	S=#imm	D=(An)
				DD2;	sprintf(buf,"MOVE.L #$%04X,(A%d)\n",dnm4(1),RN2);	CO;
				TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x00c0:				//	S=Dn	D=(An)+
		DD0;	sprintf(buf,"MOVE.L D%d,(A%d)+\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x00c8:				//	S=An	D=(An)+
		DD0;	sprintf(buf,"MOVE.L A%d,(A%d)+\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x00d0:				//	S=(An)	D=(An)+
		DD0;	sprintf(buf,"MOVE.L (A%d),(A%d)+\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x00d8:				//	S=(An)+	D=(An)+
		DD0;	sprintf(buf,"MOVE.L (A%d)+,(A%d)+\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x00e0:				//	S=-(An)	D=(An)+
		DD0;	sprintf(buf,"MOVE.L -(A%d),(A%d)+\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x00e8:				//	S=d16(An)	D=(An)+
		DD1;	sprintf(buf,"MOVE.L $%04X(A%d),(A%d)+\n",dnm2(1),RN1,RN2);	CO;
		TUC+=4;	return;

	case	0x00f0:				//	S=d8(An,Xn)	D=(An)+
		DD1;	sprintf(buf,"MOVE.L $%02X(A%d,X%d),(A%d)+\n",
			dnm1(1),RN1,(dnm2(1)>>12),RN2);	CO;	TUC+=4;	return;

	case	0x00f8:
		switch(RN1){
			case	0:			//	S=Abs.W	D=(An)+
				DD1;	sprintf(buf,"MOVE.L $%04X,(A%d)+\n",dnm2(1),RN2);	CO;
				TUC+=4;	return;

			case	1:		//	S=Abs.L	D=(An)+
				DD2;	sprintf(buf,"MOVE.L $%08X,(A%d)+\n",dnm4(1),RN2);	CO;
				TUC+=6;	return;

			case	2:			//	S=d16(PC)	D=(An)+
				DD1;	sprintf(buf,"MOVE.L $%04X(PC),(A%d)+\n",
					dnm2(1),RN2);	CO;	TUC+=4;	return;

			case	3:			//	S=d8(PC,Xn)	D=(An)+
				DD1;	sprintf(buf,"MOVE.L $%02X(PC,X%d),(A%d)+\n",
					dnm1(1),dnm2(1)>>12,RN2);	CO;	TUC+=4;	return;

			case	4:			//	S=#imm	D=(An)+
				DD2;	sprintf(buf,"MOVE.L #$%08X,(A%d)+\n",
					dnm4(1),RN2);	CO;	TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x0100:				//	S=Dn	D=-(An)
		DD0;	sprintf(buf,"MOVE.L D%d,-(A%d)\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0108:				//	S=An	D=-(An)
		DD0;	sprintf(buf,"MOVE.L A%d,-(A%d)\n",RN1,RN2);	CO;	TUC+=2;	return;

	case	0x0110:				//	S=(An)	D=-(An)
		DD0;	sprintf(buf,"MOVE.L (A%d),-(A%d)\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x0118:				//	S=(An)+	D=-(An)
		DD0;	sprintf(buf,"MOVE.L (A%d)+,-(A%d)\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x0120:				//	S=-(An)	D=-(An)
		DD0;	sprintf(buf,"MOVE.L -(A%d),-(A%d)\n",RN1,RN2);	CO;
		TUC+=2;	return;

	case	0x0128:				//	S=d16(An)	D=-(An)
		DD1;	sprintf(buf,"MOVE.L $%04X(A%d),-(A%d)\n",dnm2(1),RN1,RN2);	CO;
		TUC+=4;	return;

	case	0x0130:				//	S=d8(An,Xn)	D=-(An)
		DD1;	sprintf(buf,"MOVE.L $%02X(A%d,X%d),-(A%d)\n",
			dnm1(1),RN1,(dnm2(1)>>12),RN2);	CO;	TUC+=4;	return;

	case	0x0138:
		switch(RN1){
			case	0:		//	S=Abs.W	D=-(An)
				DD1;	sprintf(buf,"MOVE.L $%04X,-(A%d)\n",dnm2(1),RN2);	CO;
				TUC+=4;	return;

			case	1:		//	S=Abs.L	D=-(An)
				DD2;	sprintf(buf,"MOVE.L $%08X,-(A%d)\n",dnm4(1),RN2);	CO;
				TUC+=6;	return;

			case	2:			//	S=d16(PC)	D=-(An)
				DD1;	sprintf(buf,"MOVE.L $%04X(PC),-(A%d)\n",
					dnm2(1),RN2);	CO;	TUC+=4;	return;

			case	3:			//	S=d8(PC,Xn)	D=-(An)
				DD1;	sprintf(buf,"MOVE.L $%02X(PC,X%d),-(A%d)\n",
					dnm1(1),dnm2(1)>>12,RN2);	CO;	TUC+=4;	return;

			case	4:			//	S=#imm	D=-(An)
				DD2;	sprintf(buf,"MOVE.L #$%08X,-(A%d)\n",
					dnm4(1),RN2);	CO;	TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x0140:				//	S=Dn	D=d16(An)
		DD1;	sprintf(buf,"MOVE.L D%d,$%04X(A%d)\n",RN1,dnm2(1),RN2);	CO;
		TUC+=4;	return;

	case	0x0148:				//	S=An	D=d16(An)
		DD1;	sprintf(buf,"MOVE.L A%d,$%04X(A%d)\n",RN1,dnm2(1),RN2);	CO;
		TUC+=4;	return;

	case	0x0150:				//	S=(An)	D=d16(An)
		DD1;	sprintf(buf,"MOVE.L (A%d),$%04X(A%d)\n",RN1,dnm2(1),RN2);	CO;
		TUC+=4;	return;

	case	0x0158:				//	S=(An)+	D=d16(An)
		DD1;	sprintf(buf,"MOVE.L (A%d)+,$%04X(A%d)\n",RN1,dnm2(1),RN2);	CO;
		TUC+=4;	return;

	case	0x0160:				//	S=-(An)	D=d16(An)
		DD1;	sprintf(buf,"MOVE.L -(A%d),$%04X(A%d)\n",RN1,dnm2(1),RN2);	CO;
		TUC+=4;	return;

	case	0x0168:				//	S=d16(An)	D=d16(An)
		DD2;	sprintf(buf,"MOVE.L $%04X(A%d),$%04X(A%d)\n",
			dnm2(1),RN1,dnm2(2),RN2);	CO;	TUC+=6;	return;

	case	0x0170:				//	S=d8(An,Xn)	D=d16(An)
		DD2;	sprintf(buf,"MOVE.L $%02X(A%d,X%d),$%04X(A%d)\n",
			dnm1(1),RN1,(dnm2(1)>>12),dnm2(2),RN2);	CO;	TUC+=6;	return;

	case	0x0178:
		switch(RN1){
			case	0:			//	S=Abs.W	D=d16(An)
				DD2;	sprintf(buf,"MOVE.L $%04X,$%04X(A%d)\n",
					dnm2(1),dnm2(2),RN2);	CO;	TUC+=6;	return;

			case	1:			//	S=Abs.L	D=d16(An)
				DD3;	sprintf(buf,"MOVE.L $%08X,$%04X(A%d)\n",
					dnm4(1),dnm2(3),RN2);	CO;	TUC+=8;	return;

			case	2:			//	S=d16(PC)	D=d16(An)
				DD2;	sprintf(buf,"MOVE.L $%04X(PC),$%04X(A%d)\n",
					dnm2(1),dnm2(2),RN2);	CO;	TUC+=6;	return;

			case	3:			//	S=d8(PC,Xn)	D=d16(An)
				DD2;	sprintf(buf,"MOVE.L $%02X(PC,X%d),$%04X(A%d)\n",
					dnm1(1),dnm2(1)>>12,dnm2(2),RN2);	CO;	TUC+=6;	return;

			case	4:			//	S=#imm	D=d16(An)
				DD3;	sprintf(buf,"MOVE.L #$%08X,$%04X(A%d)\n",
					dnm4(1),dnm2(3),RN2);	CO;	TUC+=8;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x0180:				//	S=Dn	D=d8(An,Xn)
		DD1;	sprintf(buf,"MOVE.L D%d,$%02X(A%d,X%d)\n",
			RN1,dnm1(1),RN2,dnm2(1)>>12);	CO;	TUC+=4;	return;

	case	0x0188:				//	S=An	D=d8(An,Xn)
		DD1;	sprintf(buf,"MOVE.L A%d,$%02X(A%d,X%d)\n",
			RN1,dnm1(1),RN2,dnm2(1)>>12);	CO;	TUC+=4;	return;

	case	0x0190:				//	S=(An)	D=d8(An,Xn)
		DD1;	sprintf(buf,"MOVE.L (A%d),$%02X(A%d,X%d)\n",
			RN1,dnm1(1),RN2,dnm2(1)>>12);	CO;	TUC+=4;	return;

	case	0x0198:				//	S=(An)+	D=d8(An,Xn)
		DD1;	sprintf(buf,"MOVE.L (A%d)+,$%02X(A%d,X%d)\n",
			RN1,dnm1(1),RN2,dnm2(1)>>12);	CO;	TUC+=4;	return;

	case	0x01a0:				//	S=-(An)	D=d8(An,Xn)
		DD1;	sprintf(buf,"MOVE.L -(A%d),$%02X(A%d,X%d)\n",
			RN1,dnm1(1),RN2,dnm2(1)>>12);	CO;	TUC+=4;	return;

	case	0x01a8:				//	S=d16(An)	D=d8(An,Xn)
		DD2;	sprintf(buf,"MOVE.L $%04X(A%d),$%02X(A%d,X%d)\n",
			dnm2(1),RN1,dnm1(2),RN2,dnm2(2)>>12);	CO;	TUC+=6;	return;

	case	0x01b0:				//	S=d8(An,Xn)	D=d8(An,Xn)
		DD2;	sprintf(buf,"MOVE.L $%02X(A%d,X%d),$%02X(A%d,X%d)\n",
			dnm1(1),RN1,(dnm2(1)>>12),dnm1(2),RN2,dnm2(2)>>12);	CO;
		TUC+=6;	return;

	case	0x01b8:
		switch(RN1){
			case	0:			//	S=Abs.w	D=d8(An,Xn)
				DD2;	sprintf(buf,"MOVE.L $%04X,$%02X(A%d,X%d)\n",
					dnm2(1),dnm1(2),RN2,dnm2(2)>>12);	CO;	TUC+=6;	return;

			case	1:			//	S=Abs.L	D=d8(An,Xn)
				DD3;	sprintf(buf,"MOVE.L $%08X,$%02X(A%d,X%d)\n",
					dnm4(1),dnm1(3),RN2,dnm2(3)>>12);	CO;	TUC+=8;	return;

			case	2:			//	S=d16(PC)	D=d8(An,Xn)
				DD2;	sprintf(buf,"MOVE.L $%04X(PC),$%02X(A%d,X%d)\n",
					dnm2(1),dnm1(2),RN2,dnm2(2)>>12);	CO;	TUC+=6;	return;

			case	3:			//	S=d8(PC,Xn)	D=d8(An,Xn)
				DD2;	sprintf(buf,"MOVE.L $%02X(PC,X%d),$%02X(A%d,X%d)\n",
					dnm1(1),dnm2(1)>>12,dnm1(2),RN2,dnm2(2)>>12);	CO;
				TUC+=6;	return;

			case	4:			//	S=#imm	D=d8(An,Xn)
				DD3;	sprintf(buf,"MOVE.L #$%08X,$%02X(A%d,X%d)\n",
					dnm4(1),dnm1(3),RN2,dnm2(3)>>12);	CO;	TUC+=8;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x01c0:
		switch(RN2){
			case	0:			//	S=Dn	D=Abs.W
				DD1;	sprintf(buf,"MOVE.L D%d,$%04X\n",RN1,dnm2(1));	CO;
				TUC+=4;	return;

			case	1:			//	S=Dn	D=Abs.L
				DD2;	sprintf(buf,"MOVE.L D%d,$%08X\n",RN1,dnm4(1));	CO;
				TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x01c8:
		switch(RN2){
			case	0:			//	S=An	D=Abs.W
				DD1;	sprintf(buf,"MOVE.L A%d,$%04X\n",RN1,dnm2(1));	CO;
				TUC+=4;	return;

			case	1:			//	S=An	D=Abs.L
				DD2;	sprintf(buf,"MOVE.L A%d,$%08X\n",RN1,dnm4(1));	CO;
				TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x01d0:
		switch(RN2){
			case	0:			//	S=(An)	D=Abs.W
				DD1;	sprintf(buf,"MOVE.L (A%d),$%04X\n",RN1,dnm2(1));	CO;
				TUC+=4;	return;

			case	1:			//	S=(An)	D=Abs.L
				DD2;	sprintf(buf,"MOVE.L (A%d),$%08X\n",RN1,dnm4(1));	CO;
				TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x01d8:	
		switch(RN2){
			case	0:		//	S=(An)+	D=Abs.W
				DD1;	sprintf(buf,"MOVE.L (A%d)+,$%04X\n",RN1,dnm2(1));	CO;
				TUC+=4;	return;

			case	1:		//	S=(An)+	D=Abs.L
				DD2;	sprintf(buf,"MOVE.L (A%d)+,$%08X\n",RN1,dnm4(1));	CO;
				TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x01e0:
		switch(RN2){
			case	0:			//	S=-(An)	D=Abs.W
				DD1;	sprintf(buf,"MOVE.L -(A%d),$%04X\n",RN1,dnm2(1));	CO;
				TUC+=4;	return;

			case	1:			//	S=-(An)	D=Abs.L
				DD2;	sprintf(buf,"MOVE.L -(A%d),$%08X\n",RN1,dnm4(1));	CO;
				TUC+=6;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x01e8:
		switch(RN2){
			case	0:			//	S=d16(An)	D=Abs.W
				DD2;	sprintf(buf,"MOVE.L $%04X(A%d),$%04X\n",
					dnm2(1),RN1,dnm2(2));	CO;	TUC+=6;	return;

			case	1:			//	S=d16(An)	D=Abs.L
				DD3;	sprintf(buf,"MOVE.L $%04X(A%d),$%08X\n",
					dnm2(1),RN1,dnm4(2));	CO;	TUC+=8;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x01f0:
		switch(RN2){
			case	0:			//	S=d8(An,Xn)	D=Abs.W
				DD2;	sprintf(buf,"MOVE.L $%02X(A%d,X%d),$%04X\n",
					dnm1(1),RN1,(dnm2(1)>>12),dnm2(2));	CO;	TUC+=6;	return;

			case	1:			//	S=d8(An,Xn)	D=Abs.L
				DD3;	sprintf(buf,"MOVE.L $%02X(A%d,X%d),$%04X\n",
					dnm1(1),RN1,(dnm2(1)>>12),dnm4(2));	CO;	TUC+=8;	return;

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}



	case	0x01f8:
		switch(RN2){
			case	0:
				switch(RN1){
					case	0:		//	S=Abs.w	D=Abs.W
						DD2;	sprintf(buf,"MOVE.L $%04X,$%04X\n",
							dnm2(1),dnm2(2));	CO;	TUC+=6;	return;

					case	1:		//	S=Abs.L	D=Abs.W
						DD3;	sprintf(buf,"MOVE.L $%08X,$%04X\n",
							dnm4(1),dnm2(3));	CO;	TUC+=8;	return;

					case	2:		//	S=d16(PC)	D=Abs.W
						DD2;	sprintf(buf,"MOVE.L $%04X(PC),$%04X\n",
							dnm2(1),dnm2(2));	CO;	TUC+=6;	return;

					case	3:			//	S=d8(PC,Xn)	D=Abs.W
						DD2;	sprintf(buf,"MOVE.L $%02X(PC,X%d),$%04X\n",
							dnm1(1),dnm2(1)>>12,dnm2(2));	CO;	TUC+=6;	return;

					case	4:			//	S=#imm	D=Abs.W
						DD3;	sprintf(buf,"MOVE.L #$%08X,$%04X\n",
							dnm4(1),dnm2(3));	CO;	TUC+=8;	return;

					default:
						DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
				}



			case	1:
				switch(RN1){
					case	0:		//	S=Abs.w	D=Abs.L
						DD3;	sprintf(buf,"MOVE.L $%04X,$%08X\n",
							dnm2(1),dnm4(2));	CO;	TUC+=8;	return;

					case	1:		//	S=Abs.L	D=Abs.L
						DD4;	sprintf(buf,"MOVE.L $%08X,$%08X\n",
							dnm4(1),dnm4(3));	CO;	TUC+=10;	return;

					case	2:		//	S=d16(PC)	D=Abs.L
						DD3;	sprintf(buf,"MOVE.L $%04X(PC),$%08X\n",
							dnm2(1),dnm4(2));	CO;	TUC+=8;	return;

					case	3:			//	S=d8(PC,Xn)	D=Abs.L
						DD3;	sprintf(buf,"MOVE.L $%02X(PC,X%d),$%08X\n",
							dnm1(1),dnm2(1)>>12,dnm4(2));	CO;	TUC+=8;	return;

					case	4:			//	S=#imm	D=Abs.L
						DD4;	sprintf(buf,"MOVE.L #$%08X,$%08X\n",
							dnm4(1),dnm4(3));	CO;	TUC+=10;	return;

					default:
						DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
				}

			default:
				DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
		}
}
