//	MC68K code SUBI



case	0x0400:		//byte size , data regster direct
	DD1;	sprintf(buf,"SUBI.B #$%02X,D%d\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0410:		//byte size , mem addr
	DD1;	sprintf(buf,"SUBI.B #$%02X,(A%d)\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0418:		//byte size , mem addr ,postinc
	DD1;	sprintf(buf,"SUBI.B #$%02X,(A%d)+\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0420:		//byte size , mem addr ,pridec
	DD1;	sprintf(buf,"SUBI.B #$%02X,-(A%d)\n",dnm1(1),RN1);	CO;
	TUC+=4;	return;

case	0x0428:		//byte size , mem addr with disp
	DD2;	sprintf(buf,"SUBI.B #$%02X,$%04X(A%d)\n",dnm1(1),dnm2(2),RN1);	CO;
	TUC+=6;	return;

case	0x0430:		//byte size , mem addr with index
	RN3=(dnm2(2)>>12)&15;	//index
	DD2;	sprintf(buf,"SUBI.B #$%02X,$%02X(A%d,X%d)\n",
		dnm1(1),dnm1(2),RN1,RN3);	CO;	TUC+=6;	return;

case	0x0438:				//byte size , abs
	switch(code&DC_02){
		case	0:		//word size
			DD2;	sprintf(buf,"SUBI.B #$%02X,$%04X\n",dnm1(1),dnm2(2));	CO;
			TUC+=6;	return;

		case	1:		//long size
			DD3;	sprintf(buf,"SUBI.B #$%02X,$%08X\n",dnm1(1),dnm4(2));	CO;
			TUC+=8;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}



case	0x0440:		//word size , data regster direct
	DD1;	sprintf(buf,"SUBI.W #$%04X,D%d\n",dnm2(1),RN1);	CO;	TUC+=4;	return;

case	0x0450:		//mem addr
	DD1;	sprintf(buf,"SUBI.W #$%04X,(A%d)\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0458:		//mem addr ,postinc
	DD1;	sprintf(buf,"SUBI.W #$%04X,(A%d)+\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0460:		//mem addr ,pridec
	DD1;	sprintf(buf,"SUBI.W #$%04X,-(A%d)\n",dnm2(1),RN1);	CO;
	TUC+=4;	return;

case	0x0468:		//mem addr with disp
	DD2;	sprintf(buf,"SUBI.W #$%04X,$%04X(A%d)\n",
		dnm2(1),dnm2(2),RN1);	CO;	TUC+=6;	return;

case	0x0470:		//byte size , mem addr with index
	RN3=(dnm2(2)>>12)&15;	//index
	DD2;	sprintf(buf,"SUBI.W #$%04X,$%02X(A%d,X%d)\n",
		dnm2(1),dnm1(2),RN1,RN3);	CO;	TUC+=6;	return;

case	0x0478:				//abs
	switch(code&DC_02){
		case	0:		//word size
			DD2;	sprintf(buf,"SUBI.W #$%04X,$%04X\n",dnm2(1),dnm2(2));	CO;
			TUC+=6;	return;

		case	1:		//long size
			DD3;	sprintf(buf,"SUBI.W #$%04X,$%08X\n",dnm2(1),dnm4(2));	CO;
			TUC+=8;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}



case	0x0480:		//long size , data regster direct
	DD2;	sprintf(buf,"SUBI.L #$%08X,D%d\n",dnm4(1),RN1);	CO;	TUC+=6;	return;

case	0x0490:		//mem addr
	DD2;	sprintf(buf,"SUBI.L #$%08X,(A%d)\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x0498:		//mem addr ,postinc
	DD2;	sprintf(buf,"SUBI.L #$%08X,(A%d)+\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x04a0:		//mem addr ,pridec
	DD2;	sprintf(buf,"SUBI.L #$%08X,-(A%d)\n",dnm4(1),RN1);	CO;
	TUC+=6;	return;

case	0x04a8:		//mem addr with disp
	DD3;	sprintf(buf,"SUBI.L #$%08X,$%04X(A%d)\n",dnm4(1),dnm2(3),RN1);	CO;
	TUC+=8;	return;

case	0x04b0:		//byte size , mem addr with index
	RN3=(dnm2(3)>>12)&15;	//index
	DD3;	sprintf(buf,"SUBI.L #$%08X,$%02X(A%d,X%d)\n",
		dnm4(1),dnm1(3),RN1,RN3);	CO;	TUC+=8;	return;

case	0x04b8:				//abs
	switch(code&DC_02){
		case	0:		//word size
			DD3;	sprintf(buf,"SUBI.L #$%08X,$%04X\n",dnm4(1),dnm2(3));	CO;
			TUC+=8;	return;

		case	1:		//long size
			DD4;	sprintf(buf,"SUBI.L #$%08X,$%08X\n",dnm4(1),dnm4(3));	CO;
			TUC+=10;	return;

		default:
			DD0;	sprintf(buf,"???\n");	CO;	TUC+=2;	return;
	}
