#ifdef		WIN32
#include	<windows.h>
#include	<winbase.h>
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/memory.h"
#include	"../include.h/monitor.h"
#include	"../include.h/jctype.h"
#include	"../include.h/console.h"

extern		MONITOR	mon;
extern		char	szInifilePath[MAX_PATH];


void			MEMORY::dump(unsigned long addr)
{
	unsigned long	x,y;
	unsigned short	mon_stat_backup;

	mon_stat_backup=mon.mon_stat[0];
	mon.mon_stat[0]&=0xff7f;

	sprintf(buf,"%08lX +0 +1 +2 +3 +4 +5 +6 +7 +8 +9 +A +B +C +D +E +F "
		"0123456789ABCDEF\n",addr);	CO;

	for(y=0;y!=16;y++){
		sprintf(buf,"%08lX ",y*16+addr);	CO;

#ifdef	SATURN
		for(x=0;x!=16;x++){	sprintf(buf,"%02X ",
			(unsigned char)read1(mon.CCN,y*16+x+addr));	CO;	}
		for(x=0;x!=16;x++){
			ATC=read1(mon.CCN,y*16+x+addr);
			if(	iscntrl(ATC)||				//skip controll code
				(iskanji1(ATC) && (x==15))||	/*EɊ*/
				(iskanji1(ATC) && !iskanji2(read1(mon.CCN,y*16+x+addr+1)))	)
//				(iskanji2(ATC) && (x==0))||	/*̗lłłȂ*/
//				(iskanji2(ATC) && !iskanji1(read1(mon.CCN,y*16+x+addr-1)))	)
				{	sprintf(buf,".");	CO;	}
			else{	sprintf(buf,"%c",read1(mon.CCN,y*16+x+addr));	CO;	}
		}
#endif

#ifdef	AX68K
		for(x=0;x!=16;x++){	sprintf(buf,"%02X ",
			(unsigned char)read1(y*16+x+addr));	CO;	}
		for(x=0;x!=16;x++){
			ATC=read1(y*16+x+addr);
			if(	iscntrl(ATC)||				//skip controll code
				(iskanji1(ATC) && (x==15))||	/*EɊ*/
				(iskanji1(ATC) && !iskanji2(read1(y*16+x+addr+1)))	)
//				(iskanji2(ATC) && (x==0))||	/*̗lłłȂ*/
//				(iskanji2(ATC) && !iskanji1(read1(y*16+x+addr-1)))	)
				{	sprintf(buf,".");	CO;	}
			else{	sprintf(buf,"%c",read1(y*16+x+addr));	CO;	}
		}
#endif

		sprintf(buf,"\n");	CO;	}
	mon.mon_stat[0]=mon_stat_backup;
}



void			MEMORY::mat_list(void)
{
	unsigned long	x;

	sprintf(buf,"memory allocated addr\n");	CO;
	for(x=0;x!=MAT_MAX+1;x++)
		if(MAT[x]!=NULL){	sprintf(buf,"%04X    ",x);	CO;	}
	sprintf(buf,"\n");	CO;
}



unsigned short	MEMORY::mnew(unsigned short addr)
{
	unsigned long	x=0;

#ifdef	SATURN
	if(addr==0xdfff)	return(1);	//CD-ROM ExRAM
	addr=shadow_oa(addr);
	if(addr==0x0018)	return(1);	//BRAM͑ŗpӂĂ̂ŏɐ
#endif

#ifdef	AX68K
	addr=shadow_oa(addr);
#endif

	MAT[addr]=new unsigned char[MB_LENGTH+1];
	if(MAT[addr]==NULL)
		return(0);				//false

	do{	*(MAT[addr]+x)=0;		//memory zero clear
		x++;}
	while(x!=MB_LENGTH+1);

	shadow_ac();
	return(1);					//true
}



void			MEMORY::mdelete(unsigned short addr)
{
	addr=shadow_oa(addr);

	if(MAT[addr]!=NULL){
		delete []MAT[addr];
		MAT[addr]=NULL;}
	else	return;

	shadow_ac();
}



unsigned long	MEMORY::moutput(
	HANDLE			hDUMP,
	unsigned long	addr,
	unsigned long	length		)
{
	unsigned long	addr_high,addr_low;
	unsigned long	ulByte;

	addr_high=addr>>16;	addr_low=addr&0xffff;
	if((addr_low+length)>0x10000)
		length=0x10000-addr_low;

	WriteFile(hDUMP,MAT[addr_high]+addr_low,length,&ulByte,NULL);
	return(ulByte);
}



#ifdef	SATURN
unsigned short	MEMORY::shadow_oa(unsigned short addr)
{
	switch(addr&0xf000){
		case	0x0000:
		case	0x1000:
		case	0x2000:
		case	0x3000:
			addr&=0x07ff;
			if(addr<0x0010){				//IPL ROM shadow
				addr&=0x0007;	return(addr);	}
			if(addr<0x0018){				//?
								return(addr);	}
			if(addr<0x0020){				//Back up ram
				addr=0x0018;	return(addr);	}
			if(addr<0x0040){				//cart port
				addr&=0x002f;	return(addr);	}
			if(addr<0x0600){				//?
								return(addr);	}
			if(addr<0x0800){				//work ram (system bus)
				addr&=0x060f;	return(addr);	}
								return(addr);
		case	0x4000:
		case	0x5000:
			addr&=0x4fff;		return(addr);
		case	0x6000:
		case	0x7000:
			addr&=0x6fff;		return(addr);
		case	0x8000:
		case	0x9000:
		case	0xc000:
		case	0xd000:
			addr&=0x8000;		return(addr);
		case	0xa000:
		case	0xe000:
			addr&=0xafff;		return(addr);
		default:
								return(addr);
	}
}



void			MEMORY::shadow_ac(void)
{
	unsigned long	x;

//0xxx
	for(x=0x0000;x!=0x0008;x++)		MAT[x+0x0008]	=MAT[x+0x0000];
									MAT[  0x0019]	=MAT[  0x0018];
	for(x=0x0000;x!=0x0010;x++)		MAT[x+0x0030]	=MAT[x+0x0020];
	for(x=0x0000;x!=0x0200;x++)		MAT[x+0x0600]	=MAT[(x&0xf)+0x0600];
//8xxx
	for(x=0x0001;x!=0x1000;x++)		MAT[x+0x8000]	=MAT[  0x8000];

//group A
	for(x=0x0000;x!=0x0800;x++){
		MAT[x+0x0800]	=MAT[x+0x0000];
		MAT[x+0x1000]	=MAT[x+0x0000];
		MAT[x+0x1800]	=MAT[x+0x0000];
		MAT[x+0x2000]	=MAT[x+0x0000];
		MAT[x+0x2800]	=MAT[x+0x0000];
		MAT[x+0x3000]	=MAT[x+0x0000];
		MAT[x+0x3800]	=MAT[x+0x0000];	}
//group B
	for(x=0x0000;x!=0x1000;x++){
		MAT[x+0x5000]	=MAT[x+0x4000];
		MAT[x+0x7000]	=MAT[x+0x6000];
		MAT[x+0x9000]	=MAT[x+0x8000];
		MAT[x+0xc000]	=MAT[x+0x8000];
		MAT[x+0xd000]	=MAT[x+0x8000];
		MAT[x+0xe000]	=MAT[x+0xa000];	}
}
#endif



#ifdef	AX68K
unsigned short	MEMORY::shadow_oa(unsigned short addr)
{
	return(addr&0x00ff);
}



void			MEMORY::shadow_ac(void)
{
	unsigned long	x,y;

	for(x=0;x!=0x100;x++)
		if(MAT[x]!=NULL)
			for(y=0x100;y!=0x10000;y+=0x100)
				MAT[y+x]=MAT[x];
}



unsigned char *	MEMORY::x68k_sram_addr(void)
{
	return(MAT[0x00ed]);
}
#endif



void				MEMORY::init(void)
//				MEMORY::MEMORY(void)
{
	HANDLE			hBINFILE;
	unsigned long	addr;
	long			size;
	unsigned long	dwByte;
	unsigned long	x,y;
	char			fname[FNAME_MAX];
	char			*mlist;

	for(addr=0;addr!=MAT_MAX+1;addr++)				//e[ȕ
		MAT[addr]=NULL;

	mlist=new char[0x4000];							//32KB
	GetPrivateProfileSection("memory",mlist,0x4000,szInifilePath);

	while(sscanf(mlist,"%04x=%s",&addr,fname)==2){
		hBINFILE=NULL;
		hBINFILE=CreateFile(fname,GENERIC_READ,0,0,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,0);
		if(hBINFILE==(void *)-1){
			sprintf(buf,".");	CO;
			if(!mnew((unsigned short)addr)){
				sprintf(buf,"out of memory ...\n");	CO;	break;	}	}
		else{
			sprintf(buf,"%04X <= %s\n",addr,fname);	CO;
			size=GetFileSize(hBINFILE,NULL);
			if((size&0xffff)!=0)	size+=0x10000;	size>>=16;	//64KB unit
			for(x=0;x!=(unsigned long)size;x++){
				if(!mnew((unsigned short)(addr+x))){
					sprintf(buf,"out of memory ...\n");	CO;
					FindClose(hBINFILE);	break;	}	//max 64KB load
				ReadFile(hBINFILE,MAT[addr+x],MB_LENGTH+1,&dwByte,NULL);
			}
			CloseHandle(hBINFILE);
		}
	mlist=mlist+strlen(mlist)+1;
	addr=0;	fname[0]=NULL;
	}
	sprintf(buf,"\n");	CO;



	mlist=new char[0x4000];							//32KB
	GetPrivateProfileSection("load",mlist,0x4000,szInifilePath);

	while(sscanf(mlist,"%08x=%s",&addr,fname)==2){
		hBINFILE=NULL;
		hBINFILE=CreateFile(fname,GENERIC_READ,0,0,OPEN_EXISTING,
			FILE_ATTRIBUTE_NORMAL,0);
		if(hBINFILE==(void *)-1){
			sprintf(buf,"faile load ... <%s>\n",fname);	CO;	}
		else{
			sprintf(buf,"%08X <= %s\n",addr,fname);	CO;
			size=GetFileSize(hBINFILE,NULL);
//			if((size&0xffff)!=0)	size+=0x10000;	size>>=16;	//64KB unit
			for(;size>=0;size-=x){
				if((addr&0x0000ffff)!=0)	y=addr&0x0000ffff;
					else					y=0x1000;
				ReadFile(hBINFILE,MAT[addr>>16]+(addr&0x0000ffff),
					y,&dwByte,NULL);
				addr+=y;	size-=y;
			}
			CloseHandle(hBINFILE);
		}
	mlist=mlist+strlen(mlist)+1;
	addr=0;	fname[0]=NULL;
	}
	sprintf(buf,"\n");	CO;



#ifdef	SATURN
#include	"..\memory.cpp\mem_sin.cpp"
#endif

#ifdef	AX68K
#include	"..\memory.cpp\mem_xin.cpp"
#endif
}

		MEMORY::~MEMORY(void)
{
	unsigned long	addr;

#ifdef	SATURN
#include	"..\memory.cpp\mem_srel.cpp"
#endif

	for(addr=0;addr!=MAT_MAX+1;addr++)
		mdelete((unsigned short)addr);
}
