#ifdef		WIN32
#include	<windows.h>
#include	<winbase.h>	
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/monitor.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/rti.h"
#include	"../include.h/memory.h"
#include	"../include.h/console.h"

extern	MEMORY	mem;
extern	MC68K	m68k;
extern	RTI		rti;
extern	HWND	hWnd_w1;



void	MONITOR::shell(void)
{
	do{
		switch(CCN){									//vvg̕\
			case	1:
				sprintf(buf,"M68K>");	CO;	break;
			case	2:
				sprintf(buf,"RTI >");	CO;	break;
			default:
				CCN=1;
				sprintf(buf,"M68K>");	CO;	break;
		}

		for(TL1=0;TL1!=0x100;TL1++)	com_line[TL1]=NULL;	//buff clear
		ReadFile(hSTDIN,com_line,255,&dwByte,NULL);		//Win32 func
		if(strlen(com_line)==0)	goto	COM_EXIT;		//no commands
		for(clpp=0;!isspace(com_line[clpp]);clpp++)		//skip first space

		switch(com_line[clpp]){
			case	'?':			//help message
#include	"mon_help.cpp"
			case	'!':			//help message
#include	"mon_stat.cpp"
			case	'w':			//write file commands
#include	"mon_writ.cpp"
			case	'c':			//change target CPU
#include	"mon_ctc.cpp"
			case	'g':			//trace 0xffffffff steps
#include	"mon_go.cpp"
			case	't':			//trace
#include	"mon_trac.cpp"
			case	'x':			//extention
#include	"mon_xcom.cpp"
			case	'u':			//disassemble
#include	"mon_dasm.cpp"
			case	'b':			//break point
#include	"mon_bpnt.cpp"



			case	'p':			//break
				switch(com_line[clpp+1]){
					case	'1':
						m68k.VSR^=0x4000;
						m68k.TTC=1;
						goto COM_EXIT;
					case	'2':
						rti.VSR^=0x4000;
						goto COM_EXIT;
				}
				goto COM_EXIT;

			case	'q':			//monitor quit
				SendMessage(hWnd_w1,WM_DESTROY,NULL,NULL);
				goto	COM_EXIT;

			case	'd':	//memory dump
				if(sscanf(&com_line[clpp+1],"%8lx",&TDC)==1)
					{	mem.dump(TDC);	MDC=TDC+0x100;	}
				else{	TDC=MDC;		MDC+=0x100;	mem.dump(TDC);}
				goto	COM_EXIT;

			case	'm':			//memory function
				switch(com_line[clpp+1]){
				case	'a':	//memory allocate
					clpp+=2;
					sscanf(&com_line[clpp],"%x",&TS1);
					if(mem.mnew(TS1)==1){
						sprintf(buf,"already memory allocate\n");	CO;	}
					goto	COM_EXIT;
				case	'f':	//memory free
					clpp+=2;
					sscanf(&com_line[clpp],"%x",&TS1);
					mem.mdelete((unsigned short)TS1);
					goto	COM_EXIT;
				case	'l':	//memory alloc list
					mem.mat_list();
					goto COM_EXIT;
				default:
					goto	COM_EXIT;
				}



			case	'e':			//enter data
				switch(com_line[clpp+1]){
				case	'c':		//char size
					clpp+=2;
					sscanf(&com_line[clpp],"%8x %2x",&TL1,&TC1);
					sprintf(buf,"%08X %02X -> %02X\n",
						TL1,mem.read1(TL1),TC1);	CO;
					mem.write1(TL1,TC1);
					goto	COM_EXIT;
				case	's':		//short size
					clpp+=2;		//TL1Ɖ̂Ȃ
					sscanf(&com_line[clpp],"%8x %4x",&TL2,&TS1);
					if((TL2&1)!=0){
						sprintf(buf,"not short alignment\n");	CO;
						goto	COM_EXIT;	}
					sprintf(buf,"%08X %04X -> %04X\n",
						TL2,mem.read2ba(TL2),TS1);	CO;
					mem.write2ba(TL2,TS1);
					goto	COM_EXIT;
				case	'l':		//long size
					clpp+=2;
					sscanf(&com_line[clpp],"%8x %8x",&TL1,&TL2);
					if((TL1&3)!=0){
						sprintf(buf,"not long alignment\n");	CO;
						goto	COM_EXIT;	}
					sprintf(buf,"%08X %08X -> %08X\n",
						TL1,mem.read4ba(TL1),TL2);	CO;
					mem.write4ba(TL1,TL2);
					goto	COM_EXIT;
				default:
					goto	COM_EXIT;
				}



			case	'r':
				for(clpp++;isspace(com_line[clpp]);clpp++)	NULL;
				TP1=(unsigned char *)&com_line[clpp];	//skip space
#include	"mon_r68k.cpp"

			default:
				goto	COM_EXIT;
		}
COM_EXIT:
//		Sleep(100);
		NULL;
	}
	while((mon_stat[0]&0x01)!=0x01);
}



void		MONITOR::init(void)
//		MONITOR::MONITOR(void)
{
	NULL;
}
