#ifdef		WIN32
#include	<windows.h>
#endif

#include	<stdio.h>
#include	"../include.h/directiv.h"
#include	"../include.h/mc68k.h"
#include	"../include.h/console.h"
#include	"../include.h/rti.h"

extern	char				szInifilePath[MAX_PATH];



void	RTI::init(void)
{
	QueryPerformanceFrequency(&real_time_1sec_count);	//Get resolution
	sprintf(buf,"   real_time_1sec_count=%016X\n",
		real_time_1sec_count);	CO;

	vr_time_rate=GetPrivateProfileInt("rti","vr_time_rate",100,szInifilePath);
	virtual_time_1sec_count.QuadPart=
		real_time_1sec_count.QuadPart*vr_time_rate/100;
	sprintf(buf,"virtual_time_1sec_count=%016X\n",
		virtual_time_1sec_count);	CO;

	real_frame_rate_count.QuadPart=real_time_1sec_count.QuadPart/
		GetPrivateProfileInt("rti","real_frame_rate",60,szInifilePath);
	virtual_frame_rate_count.QuadPart=virtual_time_1sec_count.QuadPart/
		GetPrivateProfileInt("rti","virtual_frame_rate",60,szInifilePath);

	VSR|=0x4080;
}
