#include <stdint.h>
#include <stdio.h>
#include "arc.h"
#include "debugger_swis.h"

static const struct
{
	uint32_t nr;
	char *name;
} swis[] =
{
	{0x00000, "OS_WriteC"},
	{0x00001, "OS_WriteS"},
	{0x00002, "OS_WriteO"},
	{0x00003, "OS_NewLine"},
	{0x00004, "OS_ReadC"},
	{0x00005, "OS_CLI"},
	{0x00006, "OS_Byte"},
	{0x00007, "OS_Word"},
	{0x00008, "OS_File"},
	{0x00009, "OS_Args"},
	{0x0000a, "OS_BGet"},
	{0x0000b, "OS_BPut"},
	{0x0000c, "OS_GBPB"},
	{0x0000d, "OS_Find"},
	{0x0000e, "OS_ReadLine"},
	{0x0000f, "OS_Control"},
	{0x00010, "OS_GetEnv"},
	{0x00011, "OS_Exit"},
	{0x00012, "OS_SetEnv"},
	{0x00013, "OS_IntOn"},
	{0x00014, "OS_IntOff"},
	{0x00015, "OS_Callback"},
	{0x00016, "OS_EnterOS"},
	{0x00017, "OS_BreakPt"},
	{0x00018, "OS_BreakCtrl"},
	{0x00019, "OS_UnusedSWI"},
	{0x0001a, "OS_UpdateMEMC"},
	{0x0001b, "OS_SetCallBack"},
	{0x0001c, "OS_Mouse"},
	{0x0001d, "OS_Heap"},
	{0x0001e, "OS_Module"},
	{0x0001f, "OS_Claim"},
	{0x00020, "OS_Release"},
	{0x00021, "OS_ReadUnsigned"},
	{0x00022, "OS_GenerateEvent"},
	{0x00023, "OS_ReadVarVal"},
	{0x00024, "OS_SetVarVal"},
	{0x00025, "OS_GSInit"},
	{0x00026, "OS_GSRead"},
	{0x00027, "OS_GSTrans"},
	{0x00028, "OS_BinaryToDecimal"},
	{0x00029, "OS_FSControl"},
	{0x0002a, "OS_ChangeDynamicArea"},
	{0x0002b, "OS_GenerateError"},
	{0x0002c, "OS_ReadEscapeState"},
	{0x0002d, "OS_EvaluateExpression"},
	{0x0002e, "OS_SpriteOp"},
	{0x0002f, "OS_ReadPalette"},
	{0x00030, "OS_ServiceCall"},
	{0x00031, "OS_ReadVduVariables"},
	{0x00032, "OS_ReadPoint"},
	{0x00033, "OS_UpCall"},
	{0x00034, "OS_CallAVector"},
	{0x00035, "OS_ReadModeVariable"},
	{0x00036, "OS_RemoveCursors"},
	{0x00037, "OS_RestoreCursors"},
	{0x00038, "OS_SWINumberToString"},
	{0x00039, "OS_SWINumberFromString"},
	{0x0003a, "OS_ValidateAddress"},
	{0x0003b, "OS_CallAfter"},
	{0x0003c, "OS_CallEvery"},
	{0x0003d, "OS_RemoveTickerEvent"},
	{0x0003e, "OS_InstallKeyHandler"},
	{0x0003f, "OS_CheckModeValid"},
	{0x00040, "OS_ChangeEnvironment"},
	{0x00041, "OS_ClaimScreenMemory"},
	{0x00042, "OS_ReadMonotonicTime"},
	{0x00043, "OS_SubstituteArgs"},
	{0x00044, "OS_PrettyPrint"},
	{0x00045, "OS_Plot"},
	{0x00046, "OS_WriteN"},
	{0x00047, "OS_AddToVector"},
	{0x00048, "OS_WriteEnv"},
	{0x00049, "OS_ReadArgs"},
	{0x0004a, "OS_ReadRAMFsLimits"},
	{0x0004b, "OS_ClaimDeviceVector"},
	{0x0004c, "OS_ReleaseDeviceVector"},
	{0x0004d, "OS_DelinkApplication"},
	{0x0004e, "OS_RelinkApplication"},
	{0x0004f, "OS_HeapSort"},

	{0x00050, "OS_ExitAndDie"},
	{0x00051, "OS_ReadMemMapInfo"},
	{0x00052, "OS_ReadMemMapEntries"},
	{0x00053, "OS_SetMemMapEntries"},
	{0x00054, "OS_AddCallBack"},
	{0x00055, "OS_ReadDefaultHandler"},
	{0x00056, "OS_SetECFOrigin"},
	{0x00057, "OS_SerialOp"},
	{0x00058, "OS_ReadSysInfo"},
	{0x00059, "OS_Confirm"},
	{0x0005a, "OS_ChangedBox"},
	{0x0005b, "OS_CRC"},
	{0x0005c, "OS_ReadDynamicArea"},
	{0x0005d, "OS_PrintChar"},
	{0x0005e, "OS_ChangeRedirection"},
	{0x0005f, "OS_RemoveCallBack"},
	{0x00060, "OS_FindMemMapEntries"},
	{0x00061, "OS_SetColour"},

	{0x00064, "OS_Pointer"},
	{0x00065, "OS_ScreenMode"},
	{0x00066, "OS_DynamicArea"},

	{0x00068, "OS_Memory"},
	{0x00069, "OS_ClaimProcessorVector"},
	{0x0006a, "OS_Reset"},
	{0x0006b, "OS_MMUControl"},

	{0x000c0, "OS_ConvertStandardDateAndTime"},
	{0x000c1, "OS_ConvertDateAndTime"},

	{0x000d0, "OS_ConvertHex1"},
	{0x000d1, "OS_ConvertHex2"},
	{0x000d2, "OS_ConvertHex3"},
	{0x000d3, "OS_ConvertHex4"},
	{0x000d4, "OS_ConvertHex8"},
	{0x000d5, "OS_ConvertCardinal1"},
	{0x000d6, "OS_ConvertCardinal2"},
	{0x000d7, "OS_ConvertCardinal3"},
	{0x000d8, "OS_ConvertCardinal4"},
	{0x000d9, "OS_ConvertInteger1"},
	{0x000da, "OS_ConvertInteger2"},
	{0x000db, "OS_ConvertInteger3"},
	{0x000dc, "OS_ConvertInteger4"},
	{0x000dd, "OS_ConvertBinary1"},
	{0x000de, "OS_ConvertBinary2"},
	{0x000df, "OS_ConvertBinary3"},
	{0x000e0, "OS_ConvertBinary4"},
	{0x000e1, "OS_ConvertSpacedCardinal1"},
	{0x000e2, "OS_ConvertSpacedCardinal2"},
	{0x000e3, "OS_ConvertSpacedCardinal3"},
	{0x000e4, "OS_ConvertSpacedCardinal4"},
	{0x000e5, "OS_ConvertSpacedInteger1"},
	{0x000e6, "OS_ConvertSpacedInteger2"},
	{0x000e7, "OS_ConvertSpacedInteger3"},
	{0x000e8, "OS_ConvertSpacedInteger4"},
	{0x000e9, "OS_ConvertFixedNetStation"},
	{0x000ea, "OS_ConvertNetStation"},
	{0x000eb, "OS_ConvertFixedFileSize"},
	{0x000ec, "OS_ConvertFileSize"},

	{0x00240, "IIC_Control"},

	{0x00280, "Cache_Control"},
	{0x00281, "Cache_Cacheable"},
	{0x00282, "Cache_Updateable"},
	{0x00283, "Cache_Disruptive"},
	{0x00284, "Cache_Flush"},

	{0x40000, "Econet_CreateReceive"},
	{0x40001, "Econet_ExamineReceive"},
	{0x40002, "Econet_ReadReceive"},
	{0x40003, "Econet_AbandonReceive"},
	{0x40004, "Econet_WaitForReception"},
	{0x40005, "Econet_EnumerateReceive"},
	{0x40006, "Econet_StartTransmit"},
	{0x40007, "Econet_PollTransmit"},
	{0x40008, "Econet_AbandonTransmit"},
	{0x40009, "Econet_DoTransmit"},
	{0x4000a, "Econet_ReadLocalStationAndNet"},
	{0x4000b, "Econet_ConvertStatusToString"},
	{0x4000c, "Econet_ConvertStatusToError"},
	{0x4000d, "Econet_ReadProtection"},
	{0x4000e, "Econet_SetProtection"},
	{0x4000f, "Econet_ReadStationNumber"},
	{0x40010, "Econet_PrintBanner"},
	{0x40011, "Econet_ReadTransportType"},
	{0x40012, "Econet_ReleasePort"},
	{0x40013, "Econet_AllocatePort"},
	{0x40014, "Econet_DeAllocatePort"},
	{0x40015, "Econet_ClaimPort"},
	{0x40016, "Econet_StartImmediate"},
	{0x40017, "Econet_DoImmediate"},
	{0x40018, "Econet_AbandonAndReadReceive"},
	{0x40019, "Econet_Version"},
	{0x4001a, "Econet_NetworkState"},
	{0x4001b, "Econet_PacketSize"},
	{0x4001c, "Econet_ReadTransportName"},
	{0x4001d, "Econet_InetRxDirect"},
	{0x4001e, "Econet_EnumerateMap"},
	{0x4001f, "Econet_EnumerateTransmit"},
	{0x40020, "Econet_HardwareAddresses"},
	{0x40021, "Econet_NetworkParameters"},

	{0x40040, "NetFS_ReadFSNumber"},
	{0x40041, "NetFS_SetFSNumber"},
	{0x40042, "NetFS_ReadFSName"},
	{0x40043, "NetFS_SetFSName"},
	{0x40044, "NetFS_ReadCurrentContext"},
	{0x40045, "NetFS_SetCurrentContext"},
	{0x40046, "NetFS_ReadFSTimeouts"},
	{0x40047, "NetFS_SetFSTimeouts"},
	{0x40048, "NetFS_DoFSOp"},
	{0x40049, "NetFS_EnumerateFSList"},
	{0x4004a, "NetFS_EnumerateFS"},
	{0x4004b, "NetFS_ConvertDate"},
	{0x4004c, "NetFS_DoFSOpToGivenFS"},
	{0x4004d, "NetFS_UpdateFSList"},
	{0x4004e, "NetFS_EnumerateFSContexts"},
	{0x4004f, "NetFS_ReadUserId"},
	{0x40050, "NetFS_GetObjectUID"},
	{0x40051, "NetFS_EnableCache"},

	{0x40080, "Font_CacheAddr"},
	{0x40081, "Font_FindFont"},
	{0x40082, "Font_LoseFont"},
	{0x40083, "Font_ReadDefn"},
	{0x40084, "Font_ReadInfo"},
	{0x40085, "Font_StringWidth"},
	{0x40086, "Font_Paint"},
	{0x40087, "Font_Caret"},
	{0x40088, "Font_ConverttoOS"},
	{0x40089, "Font_Converttopoints"},
	{0x4008a, "Font_SetFont"},
	{0x4008b, "Font_CurrentFont"},
	{0x4008c, "Font_FutureFont"},
	{0x4008d, "Font_FindCaret"},
	{0x4008e, "Font_CharBBox"},
	{0x4008f, "Font_ReadScaleFactor"},
	{0x40090, "Font_SetScaleFactor"},
	{0x40091, "Font_ListFonts"},
	{0x40092, "Font_SetFontColours"},
	{0x40093, "Font_SetPalette"},
	{0x40094, "Font_ReadThresholds"},
	{0x40095, "Font_SetThresholds"},
	{0x40096, "Font_FindCaretJ"},
	{0x40097, "Font_StringBBox"},
	{0x40098, "Font_ReadColourTable"},
	{0x40099, "Font_MakeBitmap"},
	{0x4009a, "Font_UnCacheFile"},
	{0x4009b, "Font_SetFontMax"},
	{0x4009c, "Font_ReadFontMax"},
	{0x4009d, "Font_ReadFontPrefix"},
	{0x4009e, "Font_SwitchOutputToBuffer"},
	{0x4009f, "Font_ReadFontMetrics"},
	{0x400a0, "Font_DecodeMenu"},
	{0x400a1, "Font_ScanString"},
	{0x400a2, "Font_SetColourTable"},
	{0x400a3, "Font_CurrentRGB"},
	{0x400a4, "Font_FutureRGB"},
	{0x400a5, "Font_ReadEncodingFilename"},
	{0x400a6, "Font_FindField"},
	{0x400a7, "Font_ApplyFields"},
	{0x400a8, "Font_LookupFont"},

	{0x400c0, "Wimp_Initialise"},
	{0x400c1, "Wimp_CreateWindow"},
	{0x400c2, "Wimp_CreateIcon"},
	{0x400c3, "Wimp_DeleteWindow"},
	{0x400c4, "Wimp_DeleteIcon"},
	{0x400c5, "Wimp_OpenWindow"},
	{0x400c6, "Wimp_CloseWindow"},
	{0x400c7, "Wimp_Poll"},
	{0x400c8, "Wimp_RedrawWindow"},
	{0x400c9, "Wimp_UpdateWindow"},
	{0x400ca, "Wimp_GetRectangle"},
	{0x400cb, "Wimp_GetWindowState"},
	{0x400cc, "Wimp_GetWindowInfo"},
	{0x400cd, "Wimp_SetIconState"},
	{0x400ce, "Wimp_GetIconState"},
	{0x400cf, "Wimp_GetPointerInfo"},
	{0x400d0, "Wimp_DragBox"},
	{0x400d1, "Wimp_ForceRedraw"},
	{0x400d2, "Wimp_SetCaretPosition"},
	{0x400d3, "Wimp_GetCaretPosition"},
	{0x400d4, "Wimp_CreateMenu"},
	{0x400d5, "Wimp_DecodeMenu"},
	{0x400d6, "Wimp_WhichIcon"},
	{0x400d7, "Wimp_SetExtent"},
	{0x400d8, "Wimp_SetPointerShape"},
	{0x400d9, "Wimp_OpenTemplate"},
	{0x400da, "Wimp_CloseTemplate"},
	{0x400db, "Wimp_LoadTemplate"},
	{0x400dc, "Wimp_ProcessKey"},
	{0x400dd, "Wimp_CloseDown"},
	{0x400de, "Wimp_StartTask"},
	{0x400df, "Wimp_ReportError"},
	{0x400e0, "Wimp_GetWindowOutline"},
	{0x400e1, "Wimp_PollIdle"},
	{0x400e2, "Wimp_PlotIcon"},
	{0x400e3, "Wimp_SetMode"},
	{0x400e4, "Wimp_SetPalette"},
	{0x400e5, "Wimp_ReadPalette"},
	{0x400e6, "Wimp_SetColour"},
	{0x400e7, "Wimp_SendMessage"},
	{0x400e8, "Wimp_CreateSubMenu"},
	{0x400e9, "Wimp_SpriteOp"},
	{0x400ea, "Wimp_BaseOfSprites"},
	{0x400eb, "Wimp_BlockCopy"},
	{0x400ec, "Wimp_SlotSize"},
	{0x400ed, "Wimp_ReadPixTrans"},
	{0x400ee, "Wimp_ClaimFreeMemory"},
	{0x400ef, "Wimp_CommandWindow"},
	{0x400f0, "Wimp_TextColour"},
	{0x400f1, "Wimp_TransferBlock"},
	{0x400f2, "Wimp_ReadSysInfo"},
	{0x400f3, "Wimp_SetFontColours"},
	{0x400f4, "Wimp_GetMenuState"},
	{0x400f5, "Wimp_RegisterFilter"},
	{0x400f6, "Wimp_AddMessages"},
	{0x400f7, "Wimp_RemoveMessages"},
	{0x400f8, "Wimp_SetColourMapping"},
	{0x400f9, "Wimp_TextOp"},
	{0x400fa, "Wimp_SetWatchdogState"},
	{0x400fb, "Wimp_Extend"},
	{0x400fc, "Wimp_ResizeIcon"},

	{0x40140, "Sound_Configure"},
	{0x40141, "Sound_Enable"},
	{0x40142, "Sound_Stereo"},
	{0x40143, "Sound_Speaker"},
	{0x40144, "Sound_Mode"},
	{0x40145, "Sound_LinearHandler"},
	{0x40146, "Sound_SampleRate"},

	{0x40180, "Sound_Volume"},
	{0x40181, "Sound_SoundLog"},
	{0x40182, "Sound_LogScale"},
	{0x40183, "Sound_InstallVoice"},
	{0x40184, "Sound_RemoveVoice"},
	{0x40185, "Sound_AttachVoice"},
	{0x40186, "Sound_ControlPacked"},
	{0x40187, "Sound_Tuning"},
	{0x40188, "Sound_Pitch"},
	{0x40189, "Sound_Control"},
	{0x4018a, "Sound_AttachNamedVoice"},
	{0x4018b, "Sound_ReadControlBlock"},
	{0x4018c, "Sound_WriteControlBlock"},

	{0x401c0, "Sound_QInit"},
	{0x401c1, "Sound_QSchedule"},
	{0x401c2, "Sound_QRemove"},
	{0x401c3, "Sound_QFree"},
	{0x401c4, "Sound_QSDispatch"},
	{0x401c5, "Sound_QTempo"},
	{0x401c6, "Sound_QBeat"},
	{0x401c7, "Sound_QInterface"},

	{0x40200, "NetPrint_ReadPSNumber"},
	{0x40201, "NetPrint_SetPSNumber"},
	{0x40202, "NetPrint_ReadPSName"},
	{0x40203, "NetPrint_SetPSName"},
	{0x40204, "NetPrint_ReadPSTimeouts"},
	{0x40205, "NetPrint_SetPSTimeouts"},
	{0x40206, "NetPrint_BindPSName"},
	{0x40207, "NetPrint_ListServers"},
	{0x40208, "NetPrint_ConvertStatusToString"},

	{0x40240, "ADFS_DiscOp"},
	{0x40241, "ADFS_HDC"},
	{0x40242, "ADFS_Drives"},
	{0x40243, "ADFS_FreeSpace"},
	{0x40244, "ADFS_Retries"},
	{0x40245, "ADFS_DescribeDisc"},
	{0x40246, "ADFS_VetFormat"},
	{0x40247, "ADFS_FlpProcessDCB"},
	{0x40248, "ADFS_ControllerType"},
	{0x40249, "ADFS_PowerControl"},
	{0x4024a, "ADFS_SetIDEController"},
	{0x4024b, "ADFS_IDEUserOp"},
	{0x4024c, "ADFS_MiscOp"},
	{0x4024d, "ADFS_SectorDispOp"},
	{0x40250, "ADFS_ECCSAndRetries"},
	{0x40251, "ADFS_LockIDE"},
	{0x40252, "ADFS_FreeSpace64"},

	{0x40280, "Podule_ReadID"},
	{0x40281, "Podule_ReadHeader"},
	{0x40282, "Podule_EnumerateChunks"},
	{0x40283, "Podule_ReadChunk"},
	{0x40284, "Podule_ReadBytes"},
	{0x40285, "Podule_WriteBytes"},
	{0x40286, "Podule_CallLoader"},
	{0x40287, "Podule_RawRead"},
	{0x40288, "Podule_RawWrite"},
	{0x40289, "Podule_HardwareAddress"},
	{0x4028a, "Podule_EnumerateChunksWithInfo"},
	{0x4028b, "Podule_HardwareAddresses"},
	{0x4028c, "Podule_ReturnNumber"},
	{0x4028d, "Podule_ReadInfo"},
	{0x4028e, "Podule_SetSpeed"},

	{0x40380, "Debugger_Disassemble"},

	{0x40480, "FPEmulator_Version"},

	{0x40540, "FileCore_DiscOp"},
	{0x40541, "FileCore_Create"},
	{0x40542, "FileCore_Drives"},
	{0x40543, "FileCore_FreeSpace"},
	{0x40544, "FileCore_FloppyStructure"},
	{0x40545, "FileCore_DescribeDisc"},
	{0x40546, "FileCore_DiscardReadSectorsCache"},
	{0x40547, "FileCore_DiscFormat"},
	{0x40548, "FileCore_LayoutStructure"},
	{0x40549, "FileCore_MiscOp"},
	{0x4054a, "FileCore_SectorOp"},
	{0x4054b, "FileCore_FreeSpace64"},

	{0x405c0, "Shell_Create"},
	{0x405c1, "Shell_Destroy"},

	{0x406c0, "Hourglass_On"},
	{0x406c1, "Hourglass_Off"},
	{0x406c2, "Hourglass_Smash"},
	{0x406c3, "Hourglass_Start"},
	{0x406c4, "Hourglass_Percentage"},
	{0x406c5, "Hourglass_LEDs"},
	{0x406c6, "Hourglass_Colours"},

	{0x40700, "Draw_ProcessPath"},
	{0x40701, "Draw_ProcessPathFP"},
	{0x40702, "Draw_Fill"},
	{0x40703, "Draw_FillFP"},
	{0x40704, "Draw_Stroke"},
	{0x40705, "Draw_StrokeFP"},
	{0x40706, "Draw_StrokePath"},
	{0x40707, "Draw_StrokePathFP"},
	{0x40708, "Draw_FlattenPath"},
	{0x40709, "Draw_FlattenPathFP"},
	{0x4070a, "Draw_TransformPath"},
	{0x4070b, "Draw_TransformPathFP"},

	{0x40740, "ColourTrans_SelectTable"},
	{0x40741, "ColourTrans_SelectGCOLTable"},
	{0x40742, "ColourTrans_ReturnGCOL"},
	{0x40743, "ColourTrans_SetGCOL"},
	{0x40744, "ColourTrans_ReturnColourNumber"},
	{0x40745, "ColourTrans_ReturnGCOLForMode"},
	{0x40746, "ColourTrans_ReturnColourNumberForMode"},
	{0x40747, "ColourTrans_ReturnOppGCOL"},
	{0x40748, "ColourTrans_SetOppGCOL"},
	{0x40749, "ColourTrans_ReturnOppColourNumber"},
	{0x4074a, "ColourTrans_ReturnOppGCOLForMode"},
	{0x4074b, "ColourTrans_ReturnOppColourNumberForMode"},
	{0x4074c, "ColourTrans_GCOLToColourNumber"},
	{0x4074d, "ColourTrans_ColourNumberToGCOL"},
	{0x4074e, "ColourTrans_ReturnFontColours"},
	{0x4074f, "ColourTrans_SetFontColours"},
	{0x40750, "ColourTrans_InvalidateCache"},
	{0x40751, "ColourTrans_SetCalibration"},
	{0x40752, "ColourTrans_ReadCalibration"},
	{0x40753, "ColourTrans_ConvertDeviceColour"},
	{0x40754, "ColourTrans_ConvertDevicePalette"},
	{0x40755, "ColourTrans_ConvertRGBToCIE"},
	{0x40756, "ColourTrans_ConvertCIEToRGB"},
	{0x40757, "ColourTrans_WriteCalibrationToFile"},
	{0x40758, "ColourTrans_ConvertRGBToHSV"},
	{0x40759, "ColourTrans_ConvertHSVToRGB"},
	{0x4075a, "ColourTrans_ConvertRGBToCMYK"},
	{0x4075b, "ColourTrans_ConvertCMYKToRGB"},
	{0x4075c, "ColourTrans_ReadPalette"},
	{0x4075d, "ColourTrans_WritePalette"},
	{0x4075e, "ColourTrans_SetColour"},
	{0x4075f, "ColourTrans_MiscOp"},
	{0x40760, "ColourTrans_WriteLoadingsToFile"},
	{0x40761, "ColourTrans_SetTextColour"},
	{0x40762, "ColourTrans_SetOppTextColour"},
	{0x40763, "ColourTrans_SelectTable"},

	{0x40780, "RamFS_DiscOp"},
	{0x40782, "RamFS_Drives"},
	{0x40783, "RamFS_FreeSpace"},
	{0x40785, "RamFS_DescribeDisc"},

	{0x40d80, "Super_Sample90"},
	{0x40d81, "Super_Sample45"},

	{0x40f80, "FilerAction_SendSelectedDirectory"},
	{0x40f81, "FilerAction_SendSelectedFile"},
	{0x40f82, "FilerAction_SendStartOperation"},

	{0x41200, "Socket_Creat"},
	{0x41201, "Socket_Bind"},
	{0x41202, "Socket_Listen"},
	{0x41203, "Socket_Accept"},
	{0x41204, "Socket_Connect"},
	{0x41205, "Socket_Recv"},
	{0x41206, "Socket_Recvfrom"},
	{0x41207, "Socket_Recvmsg"},
	{0x41208, "Socket_Send"},
	{0x41209, "Socket_Sendto"},
	{0x4120a, "Socket_Sendmsg"},
	{0x4120b, "Socket_Shutdown"},
	{0x4120c, "Socket_Setsockopt"},
	{0x4120d, "Socket_Getsockopt"},
	{0x4120e, "Socket_Getpeername"},
	{0x4120f, "Socket_Getsockname"},
	{0x41210, "Socket_Close"},
	{0x41211, "Socket_Select"},
	{0x41212, "Socket_Ioctl"},
	{0x41213, "Socket_Read"},
	{0x41214, "Socket_Write"},
	{0x41215, "Socket_Stat"},
	{0x41216, "Socket_Ready"},
	{0x41217, "Socket_Writev"},
	{0x41218, "Socket_Getsize"},
	{0x41219, "Socket_Sendtosm"},

	{0x41240, "CD_Version"},
	{0x41241, "CD_ReadData"},
	{0x41242, "CD_SeekTo"},
	{0x41243, "CD_DriveStatus"},
	{0x41244, "CD_DriveReady"},
	{0x41245, "CD_GetParameters"},
	{0x41246, "CD_SetParameters"},
	{0x41247, "CD_OpenDrawer"},
	{0x41248, "CD_EjectButton"},
	{0x41249, "CD_EnquireAddress"},
	{0x4124a, "CD_EnquireDataMode"},
	{0x4124b, "CD_PlayAudio"},
	{0x4124c, "CD_PlayTrack"},
	{0x4124d, "CD_AudioPause"},
	{0x4124e, "CD_EnquireTrack"},
	{0x4124f, "CD_ReadSubChannel"},
	{0x41250, "CD_CheckDrive"},
	{0x41251, "CD_DiscChanged"},
	{0x41252, "CD_StopDisc"},
	{0x41253, "CD_DiscUsed"},
	{0x41254, "CD_AudioStatus"},
	{0x41255, "CD_Inquiry"},
	{0x41256, "CD_DiscHasChanged"},
	{0x41257, "CD_Control"},
	{0x41258, "CD_Supported"},
	{0x41259, "CD_Prefetch"},
	{0x4125a, "CD_Reset"},
	{0x4125b, "CD_CloseDrawer"},
	{0x4125c, "CD_IsDrawerLocked"},
	{0x4125d, "CD_AudioControl"},
	{0x4125e, "CD_LastError"},
	{0x4125f, "CD_AudioLevel"},
	{0x41260, "CD_Register"},
	{0x41261, "CD_Unregister"},
	{0x41262, "CD_ByteCopy"},
	{0x41263, "CD_Identify"},
	{0x41264, "CD_ConvertToLBA"},
	{0x41265, "CD_ConvertToMSF"},
	{0x41266, "CD_ReadAudio"},
	{0x41267, "CD_ReadUserData"},
	{0x41268, "CD_SeekUserData"},
	{0x41269, "CD_GetAudioParms"},
	{0x4126a, "CD_SetAudioParms"},

	{0x41500, "MessageTrans_FileInfo"},
	{0x41501, "MessageTrans_OpenFile"},
	{0x41502, "MessageTrans_Lookup"},
	{0x41503, "MessageTrans_MakeMenus"},
	{0x41504, "MessageTrans_CloseFile"},
	{0x41505, "MessageTrans_EnumerateTokens"},
	{0x41506, "MessageTrans_ErrorLookup"},
	{0x41507, "MessageTrans_GSLookup"},
	{0x41508, "MessageTrans_CopyError"},
	{0x41509, "MessageTrans_Dictionary"},

	{0x41b00, "PDumper_Info"},
	{0x41b01, "PDumper_Claim"},
	{0x41b02, "PDumper_Free"},
	{0x41b03, "PDumper_Find"},
	{0x41b04, "PDumper_StartJob"},
	{0x41b05, "PDumper_TidyJob"},
	{0x41b06, "PDumper_SetColour"},
	{0x41b07, "PDumper_PrepareStrip"},
	{0x41b08, "PDumper_LookupError"},
	{0x41b09, "PDumper_CopyFilename"},

	{0x41b40, "ResourceFS_RegisterFiles"},
	{0x41b41, "ResourceFS_DeregisterFiles"},

	{0x41e80, "CDFS_ConvertDriveToDevice"},
	{0x41e81, "CDFS_SetBufferSize"},
	{0x41e82, "CDFS_GetBufferSize"},
	{0x41e83, "CDFS_SetNumberOfDrives"},
	{0x41e84, "CDFS_GetNumberOfDrives"},
	{0x41e85, "CDFS_GiveFileType"},
	{0x41e86, "CDFS_DescribeDisc"},
	{0x41e87, "CDFS_WhereIsFile"},
	{0x41e88, "CDFS_Truncation"},

	{0x42400, "DragASprite_Start"},
	{0x42401, "DragASprite_Stop"},

	{0x42640, "Filter_RegisterPreFilter"},
	{0x42641, "Filter_RegisterPostFilter"},
	{0x42642, "Filter_DeRegisterPreFilter"},
	{0x42643, "Filter_DeRegisterPostFilter"},

	{0x42680, "TaskManager_TaskNameFromHandle"},
	{0x42681, "TaskManager_EnumerateTasks"},
	{0x42682, "TaskManager_Shutdown"},

	{0x42700, "Squash_Compress"},
	{0x42701, "Squash_Decompress"},

	{0x42740, "DeviceFS_Register"},
	{0x42741, "DeviceFS_Deregister"},
	{0x42742, "DeviceFS_RegisterObjects"},
	{0x42743, "DeviceFS_DeregisterObjects"},
	{0x42744, "DeviceFS_CallDevice"},
	{0x42745, "DeviceFS_Threshold"},
	{0x42746, "DeviceFS_ReceivedCharacter"},
	{0x42747, "DeviceFS_TransmitCharacter"},

	{0x42940, "Buffer_Create"},
	{0x42941, "Buffer_Remove"},
	{0x42942, "Buffer_Register"},
	{0x42943, "Buffer_Deregister"},
	{0x42944, "Buffer_ModifyFlags"},
	{0x42945, "Buffer_LinkDevice"},
	{0x42946, "Buffer_UnlinkDevice"},
	{0x42947, "Buffer_GetInfo"},
	{0x42948, "Buffer_Threshold"},
	{0x42949, "Buffer_InternalInfo"},

	{0x42c80, "BASICTrans_HELP"},
	{0x42c81, "BASICTrans_Error"},
	{0x42c82, "BASICTrans_Message"},

	{0x42ec0, "Parallel_HardwareAddress"},
	{0x42ec1, "Parallel_Op"},

	{0x42fc0, "Portable_Speed"},
	{0x42fc1, "Portable_Control"},
	{0x42fc2, "Portable_ReadBMUVariable"},
	{0x42fc3, "Portable_WriteBMUVariable"},
	{0x42fc4, "Portable_CommandBMU"},

	{0x43040, "Territory_Number"},
	{0x43041, "Territory_Register"},
	{0x43042, "Territory_Deregister"},
	{0x43043, "Territory_NumberToName"},
	{0x43044, "Territory_Exists"},
	{0x43045, "Territory_AlphabetNumberToName"},
	{0x43046, "Territory_SelectAlphabet"},
	{0x43047, "Territory_SetTime"},
	{0x43048, "Territory_ReadCurrentTimeZone"},
	{0x43049, "Territory_ConvertTimeToUTCOrdinals"},
	{0x4304a, "Territory_ReadTimeZones"},
	{0x4304b, "Territory_ConvertDateAndTime"},
	{0x4304c, "Territory_ConvertStandardDateAndTime"},
	{0x4304d, "Territory_ConvertStandardDate"},
	{0x4304e, "Territory_ConvertStandardTime"},
	{0x4304f, "Territory_ConvertTimeToOrdinals"},
	{0x43050, "Territory_ConvertTimeStringToOrdinals"},
	{0x43051, "Territory_ConvertOrdinalsToTime"},
	{0x43052, "Territory_Alphabet"},
	{0x43053, "Territory_AlphabetIdentifier"},
	{0x43054, "Territory_SelectKeyboardHandler"},
	{0x43055, "Territory_WriteDirection"},
	{0x43056, "Territory_CharacterPropertyTable"},
	{0x43057, "Territory_LowerCaseTable"},
	{0x43058, "Territory_UpperCaseTable"},
	{0x43059, "Territory_ControlTable"},
	{0x4305a, "Territory_PlainTable"},
	{0x4305b, "Territory_ValueTable"},
	{0x4305c, "Territory_RepresentationTable"},
	{0x4305d, "Territory_Collate"},
	{0x4305e, "Territory_ReadSymbols"},
	{0x4305f, "Territory_ReadCalendarInformation"},
	{0x43060, "Territory_NameToNumber"},
	{0x43061, "Territory_TransformString"},
	{0x43075, "Territory_ConvertTextToString"},

	{0x43100, "ScreenBlanker_Control"},

	{0x43380, "TaskWindow_TaskInfo"},

	{0x43440, "MakePSFont_MakeFont"},

	{0x43f40, "Joystick_Read"},
	{0x43f41, "Joystick_CalibrateTopRight"},
	{0x43f42, "Joystick_CalibrateBottomLeft"},

	{0x444c0, "Free_Register"},
	{0x444c1, "Free_DeRegister"},

	{0x44780, "FSLock_Version"},
	{0x44781, "FSLock_Status"},
	{0x44782, "FSLock_ChangeStatus"},

	{0x44b00, "DOSFS_DiscFormat"},
	{0x44b01, "DOSFS_LayoutStructure"},

	{0x44ec0, "Toolbox_CreateObject"},
	{0x44ec1, "Toolbox_DeleteObject"},
	{0x44ec2, "Toolbox_CopyObject"},
	{0x44ec3, "Toolbox_ShowObject"},
	{0x44ec4, "Toolbox_HideObject"},
	{0x44ec5, "Toolbox_GetObjectInfo"},
	{0x44ec6, "Toolbox_ObjectMiscOp"},
	{0x44ec7, "Toolbox_SetClientHandle"},
	{0x44ec8, "Toolbox_GetClientHandle"},
	{0x44ec9, "Toolbox_GetObjectClass"},
	{0x44eca, "Toolbox_GetParent"},
	{0x44ecb, "Toolbox_GetAncestor"},
	{0x44ecc, "Toolbox_GetTemplateName"},
	{0x44ecd, "Toolbox_RaiseToolboxEvent"},
	{0x44ece, "Toolbox_GetSysInfo"},
	{0x44ecf, "Toolbox_Initialise"},
	{0x44ed0, "Toolbox_LoadResources"},
	{0x44efb, "Toolbox_TemplateLookup"},
	{0x44efc, "Toolbox_GetInternalHandle"},
	{0x44efd, "Toolbox_RegisterPostFilter"},
	{0x44efe, "Toolbox_RegisterPreFilter"},
	{0x44eff, "Toolbox_RegisterObjectModule"},

	{0x45540, "DrawFile_Render"},
	{0x45541, "DrawFile_BBox"},
	{0x45542, "DrawFile_DeclareFonts"},

	{0x46140, "DMA_RegisterChannel"},
	{0x46141, "DMA_DeregisterChannel"},
	{0x46142, "DMA_QueueTransfer"},
	{0x46143, "DMA_TerminateTransfer"},
	{0x46144, "DMA_SuspendTransfer"},
	{0x46145, "DMA_ResumeTransfer"},
	{0x46146, "DMA_ExamineTransfer"},

	{0x47700, "ColourPicker_RegisterModel"},
	{0x47701, "ColourPicker_DeregisterModel"},
	{0x47702, "ColourPicker_OpenDialogue"},
	{0x47703, "ColourPicker_CloseDialogue"},
	{0x47704, "ColourPicker_UpdateDialogue"},
	{0x47705, "ColourPicker_ReadDialogue"},
	{0x47706, "ColourPicker_SetColour"},
	{0x47707, "ColourPicker_HelpReply"},
	{0x47708, "ColourPicker_ModelSWI"},

	{0x47980, "RemotePrinterSupport_ReadPollwordLocation"},
	{0x47981, "RemotePrinterSupport_GetNextEvent"},
	{0x47982, "RemotePrinterSupport_ReadUniqueAddress"},
	{0x47983, "RemotePrinterSupport_Enable"},
	{0x47984, "RemotePrinterSupport_Disable"},
	{0x47985, "RemotePrinterSupport_EnableUpcalls"},
	{0x47986, "RemotePrinterSupport_DisableUpcalls"},

	{0x47a80, "Freeway_Register"},
	{0x47a81, "Freeway_Write"},
	{0x47a82, "Freeway_Read"},
	{0x47a83, "Freeway_Enumerate"},
	{0x47a84, "Freeway_Status"},

	{0x47ac0, "ShareFS_CreateShare"},
	{0x47ac1, "ShareFS_EnumerateShares"},
	{0x47ac2, "ShareFS_StopShare"},

	{0x47e40, "QTM_Load"},
	{0x47e41, "QTM_Start"},
	{0x47e42, "QTM_Stop"},
	{0x47e43, "QTM_Pause"},
	{0x47e44, "QTM_Clear"},
	{0x47e45, "QTM_Info"},
	{0x47e46, "QTM_Pos"},
	{0x47e47, "QTM_EffectControl"},
	{0x47e48, "QTM_Volume"},
	{0x47e49, "QTM_SetSampleSpeed"},
	{0x47e4a, "QTM_DMABuffer"},
	{0x47e4b, "QTM_RemoveChannel"},
	{0x47e4c, "QTM_RestoreChannel"},
	{0x47e4d, "QTM_Stereo"},
	{0x47e4e, "QTM_ReadSongLength"},
	{0x47e4f, "QTM_ReadSequenceTable"},
	{0x47e50, "QTM_VUBarControl"},
	{0x47e51, "QTM_ReadVULevels"},
	{0x47e52, "QTM_ReadSampleTable"},
	{0x47e53, "QTM_ReadSpeed"},
	{0x47e54, "QTM_PlaySample"},
	{0x47e55, "QTM_SongStatus"},
	{0x47e56, "QTM_ReadPlayingTime"},
	{0x47e57, "QTM_PlayRawSample"},
	{0x47e58, "QTM_SoundControl"},
	{0x47e59, "QTM_SWITableAddress"},
	{0x47e5a, "QTM_RegisterSample"},
	{0x47e5b, "QTM_SetSpeed"},
	{0x47e5c, "QTM_MusicVolume"},
	{0x47e5d, "QTM_SampleVolume"},
	{0x47e5e, "QTM_MusicOptions"},
	{0x47e5f, "QTM_MusicInterrupt"},
	{0x47e60, "QTM_ReadChannelData"},
	{0x47e61, "QTM_ReadNoteWord"},

	{0x487c0, "ScreenModes_ReadInfo"},

	{0x49980, "JPEG_Info"},
	{0x49981, "JPEG_FileInfo"},
	{0x49982, "JPEG_PlotScaled"},
	{0x49983, "JPEG_PlotFileScaled"},
	{0x49984, "JPEG_PlotTransformed"},
	{0x49985, "JPEG_PlotFileTransformed"},
	{0x49986, "JPEG_PDriverIntercept"},

	{0x49c40, "DragAnObject_Start"},
	{0x49c41, "DragAnObject_Stop"},

	{0x4a500, "CompressJPEG_Info"},
	{0x4a501, "CompressJPEG_FileInfo"},
	{0x4a502, "CompressJPEG_PlotScaled"},

	{0x4a580, "Mbuf_OpenSession"},
	{0x4a581, "Mbuf_CloseSession"},
	{0x4a582, "Mbuf_Memory"},
	{0x4a583, "Mbuf_Statistic"},
	{0x4a584, "Mbuf_Control"},

	{0x4a740, "ATAPI_GetDrives"},

	{0x80140, "PDriver_Info"},
	{0x80141, "PDriver_SetInfo"},
	{0x80142, "PDriver_CheckFeatures"},
	{0x80143, "PDriver_PageSize"},
	{0x80144, "PDriver_SetPageSize"},
	{0x80145, "PDriver_SelectJob"},
	{0x80146, "PDriver_CurrentJob"},
	{0x80147, "PDriver_FontSWI"},
	{0x80148, "PDriver_EndJob"},
	{0x80149, "PDriver_AbortJob"},
	{0x8014a, "PDriver_Reset"},
	{0x8014b, "PDriver_GiveRectangle"},
	{0x8014c, "PDriver_DrawPage"},
	{0x8014d, "PDriver_GetRectangle"},
	{0x8014e, "PDriver_CancelJob"},
	{0x8014f, "PDriver_ScreenDump"},
	{0x80150, "PDriver_EnumerateJobs"},
	{0x80151, "PDriver_SetPrinter"},
	{0x80152, "PDriver_CancelJobWithError"},
	{0x80153, "PDriver_SelectIllustration"},
	{0x80154, "PDriver_InsertIllustration"},
	{0x80155, "PDriver_DeclareFont"},
	{0x80156, "PDriver_DeclareDriver"},
	{0x80157, "PDriver_RemoveDriver"},
	{0x80158, "PDriver_SelectDriver"},
	{0x80159, "PDriver_EnumerateDrivers"},
	{0x8015a, "PDriver_MiscOp"},
	{0x8015b, "PDriver_MiscOpForDriver"},
	{0x8015c, "PDriver_SetDriver"},
	{0x8015d, "PDriver_JPEGSWI"},

	{0x80680, "SharedCLibrary_LibInitAPCS_A"},
	{0x80681, "SharedCLibrary_LibInitAPCS_R"},
	{0x80682, "SharedCLibrary_LibInitModule"},

	{0x82880, "Window_ClassSWI"},
	{0x82881, "Window_PostFilter"},
	{0x82882, "Window_PreFilter"},
	{0x82883, "Window_GetPointerInfo"},
	{0x82884, "Window_WimpToToolbox"},
	{0x82885, "Window_RegisterExternal"},
	{0x82886, "Window_DeregisterExternal"},
	{0x82887, "Window_SupportExternal"},

	{0x828c0, "Menu_ClassSWI"},
	{0x828c1, "Menu_PostFilter"},
	{0x828c2, "Menu_PreFilter"},
	{0x828c3, "Menu_UpdateTree"},

	{0x82900, "Iconbar_ClassSWI"},
	{0x82901, "Iconbar_PostFilter"},
	{0x82902, "Iconbar_PreFilter"},

	{0x82980, "ColourMenu_ClassSWI"},
	{0x82981, "ColourMenu_PostFilter"},
	{0x82982, "ColourMenu_PreFilter"},

	{0x829c0, "ColourDbox_ClassSWI"},
	{0x829c1, "ColourDbox_PostFilter"},
	{0x829c2, "ColourDbox_PreFilter"},

	{0x82a00, "FontDbox_ClassSWI"},
	{0x82a01, "FontDbox_PostFilter"},
	{0x82a02, "FontDbox_PreFilter"},

	{0x82a40, "FontMenu_ClassSWI"},
	{0x82a41, "FontMenu_PostFilter"},
	{0x82a42, "FontMenu_PreFilter"},

	{0x82a80, "DCS_ClassSWI"},
	{0x82a81, "DCS_PostFilter"},
	{0x82a82, "DCS_PreFilter"},

	{0x82ac0, "FileInfo_ClassSWI"},
	{0x82ac1, "FileInfo_PostFilter"},
	{0x82ac2, "FileInfo_PreFilter"},

	{0x82b00, "PrintDbox_ClassSWI"},
	{0x82b01, "PrintDbox_PostFilter"},
	{0x82b02, "PrintDbox_PreFilter"},

	{0x82b40, "ProgInfo_ClassSWI"},
	{0x82b41, "ProgInfo_PostFilter"},
	{0x82b42, "ProgInfo_PreFilter"},

	{0x82bc0, "SaveAs_ClassSWI"},
	{0x82bc1, "SaveAs_PostFilter"},
	{0x82bc2, "SaveAs_PreFilter"},

	{0x82c00, "Scale_ClassSWI"},
	{0x82c01, "Scale_PostFilter"},
	{0x82c02, "Scale_PreFilter"},

	{0x82c40, "TinySupport_Init"},
	{0x82c41, "TinySupport_Die"},
	{0x82c42, "TinySupport_Init2"},
	{0x82c43, "TinySupport_Share"},
};

static char writei_s[32];

const char *debugger_swi_lookup(uint32_t opcode)
{
	uint32_t swi_nr = opcode & 0xdffff;

	if (opcode & 0xf00000)
		return NULL; /*Not a RISC OS SWI*/

	if ((swi_nr & ~0xff) == 0x100) /*OS_WriteI*/
	{
		sprintf(writei_s, "OS_WriteI(%02x)", swi_nr & 0xff);
		return (const char *)writei_s;
	}

	for (int i = 0; i < nr_elems(swis); i++)
	{
		if (swis[i].nr == swi_nr)
			return swis[i].name;
	}

	return NULL;
}
