/****************************************************************************
 * grph.c  - graphics routines for TG simulator
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <dos.h>
#include <mem.h>

#include "defs.h"
#include "grph.h"
#include "pallette.h"
#include "video.h"

#define SPR_LEFT_MARG_BYTE 8
#define SPR_LEFT_MARG_PIX  32
#define SPR_TOP_MARG_PIX   64

/* GLOBALS */

Int16  gr_mode = 0;
UChar  planebuf[4][8][128];
UChar  sprbuf[4][64][16];
UInt32 gr_bit_table[256];

static void set_vga256(void) {
   union REGS inregs, outregs;
   UInt16 i;

   inregs.x.ax = 0x13;
   int86(0x10, &inregs, &outregs);
}

void set_text(void) {
   union REGS inregs, outregs;

   /* return to text */
   inregs.x.ax = 3;
   int86(0x10, &inregs, &outregs);
   gr_mode = 0;
   return;
}

void set_modex(void) {
   union REGS inregs, outregs;
   UInt16 i;

   inregs.x.ax = 0x13;

   int86(0x10, &inregs, &outregs);

   outport (0x03c4,0x0604);
   outport (0x03c4,0x0100);
   outportb(0x03c2,0xe3);
   outport (0x03c4,0x0300);
   outportb(0x03d4,0x11);
   outportb(0x03d5, (inportb(0x03d5) & 0x7f));
   outport (0x03d4, 0x0d06);
   outport (0x03d4, 0x3e07);
   outport (0x03d4, 0x4109);
   outport (0x03d4, 0xea10);
   outport (0x03d4, 0xac11);
   outport (0x03d4, 0xdf12);
   outport (0x03d4, 0x0014);
   outport (0x03d4, 0xe715);
   outport (0x03d4, 0x0616);
   outport (0x03d4, 0xe317);

   outport (0x03c4, 0x0f02);
   for (i = 0; i < 0x8000; i++) {
      poke(0xa000, i, 0);
   }
   gr_mode = 1;
}

void init_graphics(void) {
   for (int i=0; i < 256; i++) {
      UInt32 output = 0;
      for (int j=0; j < 8; j++) {
         output |= (i & (1<<j)) ? ((UInt32)0x08<<(4*j)):0;
      }
      gr_bit_table[i] = output;
   }
}

void set_palette(void) {
   union  REGS	inregs, outregs;
   struct SREGS segregs;
   UInt16 i;
   RGBEntry vga_rgb_palet[256];

   /* convert vga_palet to vga_rgb_palet: */
   for (i = 0; i < 256; i++) {
      if (vga_palet[i].color == -1) {
	 vga_rgb_palet[i].green  = 0;
	 vga_rgb_palet[i].red	 = 0;
	 vga_rgb_palet[i].blue	 = 0;
      } else {
	 vga_rgb_palet[i].green  = (UChar)((vga_palet[i].color & 0x1C0) >> 3);
	 vga_rgb_palet[i].red	 = (UChar)((vga_palet[i].color & 0x038));
	 vga_rgb_palet[i].blue	 = (UChar)((vga_palet[i].color & 0x007) << 3);
      }
   }

   /* set palette, all at once: */

   inregs.h.ah = 0x10;
   inregs.h.al = 0x12;
   inregs.x.bx = 0;
   inregs.x.cx = 256;
   inregs.x.dx = FP_OFF(&vga_rgb_palet);
   segregs.es  = FP_SEG(&vga_rgb_palet);

   int86x(0x10, &inregs, &outregs, &segregs);

   pal_flag = 0;  // reset flag to reduce unnecessary palette updates
}


void put_graphics(void) {
//   if (pal_flag) {
//	set_palette();
//   }
//   put_cg_bkgrnd();
//   put_sprites();
//   blit_mem();
//}
//
//void put_cg_bkgrnd(void) {

static UInt16 vga_seg = 0xA000;

   union REGS inregs, outregs;
   Int16      x,y;
   UInt16     i,j,k, plane;
   int	   *  intptr;
   VidByte *  element;
   VidByte *  char_base;
   UChar      ind_pal;
   UInt16     vid_addr;
//
   UChar      byte;
   UInt16     mask16;
   UInt16     indent;
   UInt16     x_blk_indent, y_blk_indent;
   UInt16     x_pix_indent, y_pix_indent;
   UInt16     start_scan, end_scan;
   UInt16     end_line;
   UInt16     y_base_offset, x_line_offset, y_line_offset;
   UInt16     oddadd;
   UInt16     bat_x, bat_y;
   void far * memdest;
   void far * memsrc;
   UInt16     byte_off, y_addr;
   Int16      x_pos, y_pos;
   UChar    * planeptr;
/* sprite stuff: */
   Int16      s;

/*
   UChar      plnbbuf[8][82];
   UChar      plncbuf[8][82];
   UChar      plndbuf[8][82];
*/

/* First, establish graphics modes and limitations: */

// Establish indentation margin around narrow screen
   if (vid_bat_x_vis == 32) {
      indent = 4;
   } else {
      indent = 0;
   }

/* Now, start on CG background graphics: */

   y_blk_indent = vidreg[8]/8 % vid_bat_y_virt;
   y_pix_indent = vidreg[8] & 7;

   x_blk_indent = (vidreg[7]/8) % vid_bat_x_virt;
   x_pix_indent = vidreg[7] & 7;

   if (y_pix_indent == 0) {
      end_line = 30;
   } else {
      end_line = 31;
   }

   for (y=0; y<end_line; y++) {
      y_base_offset = (y*8-y_pix_indent)*80;
      for (x=0; x < vid_bat_x_vis+1; x++) {
	 x_line_offset = x*2;

	 bat_y	= (y+y_blk_indent);
	 if (bat_y >= vid_bat_y_virt) bat_y-=vid_bat_y_virt;

	 bat_x	= (x+x_blk_indent);
	 if (bat_x >= vid_bat_x_virt) bat_x-=vid_bat_x_virt;

	 element   = pce_vidram + (unsigned)((bat_y*vid_bat_x_virt) + bat_x);
	 ind_pal   = (UChar)(element->byte_high & 0xf0);
	 vid_addr  = *((unsigned int *) element) << 4;
	 vid_addr &= 0x7fff;
	 char_base = pce_vidram + vid_addr;

	 for (i=0; i<8; i++) {
	    UInt32 dblword_out;
	    register UChar pix;

	    dblword_out = (((((gr_bit_table[char_base->byte_low] >> 1)
			     | gr_bit_table[char_base->byte_high]) >> 1)
			     | gr_bit_table[(char_base+8)->byte_low]) >> 1)
			     | gr_bit_table[(char_base+8)->byte_high];

	    pix = ((dblword_out >> 28) & 0x0F) | ind_pal;
	    planebuf[0][i][x_line_offset] = pce_vga_pal_map[pix];

	    pix = ((dblword_out >> 24) & 0x0F) | ind_pal;
	    planebuf[1][i][x_line_offset] = pce_vga_pal_map[pix];

	    pix = ((dblword_out >> 20) & 0x0F) | ind_pal;
	    planebuf[2][i][x_line_offset] = pce_vga_pal_map[pix];

	    pix = ((dblword_out >> 16) & 0x0F) | ind_pal;
	    planebuf[3][i][x_line_offset] = pce_vga_pal_map[pix];

	    pix = ((dblword_out >> 12) & 0x0F) | ind_pal;
	    planebuf[0][i][x_line_offset+1] = pce_vga_pal_map[pix];

	    pix = ((dblword_out >>  8) & 0x0F) | ind_pal;
	    planebuf[1][i][x_line_offset+1] = pce_vga_pal_map[pix];

	    pix = ((dblword_out >>  4) & 0x0F) | ind_pal;
	    planebuf[2][i][x_line_offset+1] = pce_vga_pal_map[pix];

	    pix = (dblword_out & 0x0F) | ind_pal;
	    planebuf[3][i][x_line_offset+1] = pce_vga_pal_map[pix];

	    char_base++;
	 }
      }
      for (j = 0; j < 4; j++) {
	 plane = ((j + x_pix_indent) & 3);
	 oddadd = (j + x_pix_indent) / 4;
	 outport(0x03c4, (int)((0x100 << j) + 2));
	 start_scan = 0;
	 end_scan = 8;

	 if (y == 0) start_scan = y_pix_indent;
	 if (y == end_line) end_scan = 8-y_pix_indent;

	 y_line_offset = start_scan * 80;

	 for (i = start_scan; i < end_scan; i++) {

	    if (indent != 0) {
	       memdest = MK_FP(vga_seg, y_base_offset + y_line_offset);
	       memset(memdest, 0, indent*2);
	    }

	    memsrc = (void far *) (&planebuf[plane][i][oddadd]);
	    memdest = MK_FP(vga_seg, y_base_offset + y_line_offset + indent*2);
	    _fmemcpy(memdest, memsrc, vid_bat_x_vis*2);

	    if (indent != 0) {
	       memdest = MK_FP(vga_seg, y_base_offset + y_line_offset + (vid_bat_x_vis+indent)*2);
	       memset(memdest, 0, indent*2);
	    }

	    y_line_offset += 80;
	 }
      }
   }
//}

//void put_sprites(void) {

/* Now, work on sprites: */
   UInt16     attr, patt;
   VidByte  * spr_base;
   VidByte  * spr_addr;
   UInt16     a,b,c,d,cellno;
   UInt16     x_reverse, y_reverse;
   UInt16     spr_behind; // flag - sprite in front, or behind ?

   if ((satb_val & 0x8000) == 0) {
      for (s = 63; s > -1; s--) {
	 spr_base = pce_vidram + satb_val + s*4;

	 y = ( *((int *) spr_base)   & 0x3ff);
	 if (y == 0) continue;	 // off screen
	 y -= SPR_TOP_MARG_PIX;
	 if (y > 240) continue;  // off screen
	 y_base_offset = y * 80;

	 x = ( *((int *) spr_base+1) & 0x3ff);
	 if ((x == 0) || (x > (vid_bat_x_vis*8+SPR_LEFT_MARG_PIX-1)) ) // off screen
	    continue;
	 x_line_offset = x/4;
	 x_pix_indent  = x&3;

	 attr = *((int *) spr_base+3);
	 spr_behind =( (attr & 0x80) ? 0:1 );

	 patt = (*((int *) spr_base+2) & 0x07FE) << 5;
	 patt &= 0x7FFF;

	 ind_pal = (attr & 0x0F) << 4;

	 x_reverse = attr & 0x0800;
	 y_reverse = attr & 0x8000;

	 c=1;				   // horiz cells in sprite
	 if (attr & 0x0100) c=2;

	 switch (attr & 0x3000) {	   // vert cells in sprite
	    case 0x1000:
	       d=2;
	       break;
	    case 0x3000:
	       d=4;
	       break;
	    default:
	       d=1;
	       break;
	 }


	 Int16 pln_ind, y_ind, x_ind;  // indices for sprite buffer

	 for (b = 0; b < d; b++) {     // vertical scan
	    for (a = 0; a < c; a++) {  // horizontal scan

	       cellno = b*c+a;
	       spr_addr = (pce_vidram + patt + cellno*64);

	       for (i = 0; i < 16; i++) {
		  if (y_reverse) {
		     y_ind = ((d-1)-b)*16+(15-i);
		  } else {
		     y_ind = b*16+i;
		  }

		  UInt32 dblword_out;
		  register UChar pix;

		  dblword_out = (((((gr_bit_table[spr_addr->byte_high] >> 1)
				   | gr_bit_table[(spr_addr+16)->byte_high]) >> 1)
				   | gr_bit_table[(spr_addr+32)->byte_high]) >> 1)
				   | gr_bit_table[(spr_addr+48)->byte_high];

		  if (x_reverse) {
		     pix = ((dblword_out >> 28) & 0x0F) | ind_pal;
		     sprbuf[3][y_ind][c*4-a*4-1] = pix;
		     pix = ((dblword_out >> 24) & 0x0F) | ind_pal;
		     sprbuf[2][y_ind][c*4-a*4-1] = pix;
		     pix = ((dblword_out >> 20) & 0x0F) | ind_pal;
		     sprbuf[1][y_ind][c*4-a*4-1] = pix;
		     pix = ((dblword_out >> 16) & 0x0F) | ind_pal;
		     sprbuf[0][y_ind][c*4-a*4-1] = pix;
		     pix = ((dblword_out >> 12) & 0x0F) | ind_pal;
		     sprbuf[3][y_ind][c*4-a*4-2] = pix;
		     pix = ((dblword_out >> 8) & 0x0F) | ind_pal;
		     sprbuf[2][y_ind][c*4-a*4-2] = pix;
		     pix = ((dblword_out >> 4) & 0x0F) | ind_pal;
		     sprbuf[1][y_ind][c*4-a*4-2] = pix;
		     pix = (dblword_out & 0x0F) | ind_pal;
		     sprbuf[0][y_ind][c*4-a*4-2] = pix;
		  } else {
		     pix = ((dblword_out >> 28) & 0x0F) | ind_pal;
		     sprbuf[0][y_ind][a*4] = pix;
		     pix = ((dblword_out >> 24) & 0x0F) | ind_pal;
		     sprbuf[1][y_ind][a*4] = pix;
		     pix = ((dblword_out >> 20) & 0x0F) | ind_pal;
		     sprbuf[2][y_ind][a*4] = pix;
		     pix = ((dblword_out >> 16) & 0x0F) | ind_pal;
		     sprbuf[3][y_ind][a*4] = pix;
		     pix = ((dblword_out >> 12) & 0x0F) | ind_pal;
		     sprbuf[0][y_ind][a*4+1] = pix;
		     pix = ((dblword_out >> 8) & 0x0F) | ind_pal;
		     sprbuf[1][y_ind][a*4+1] = pix;
		     pix = ((dblword_out >> 4) & 0x0F) | ind_pal;
		     sprbuf[2][y_ind][a*4+1] = pix;
		     pix = (dblword_out & 0x0F) | ind_pal;
		     sprbuf[3][y_ind][a*4+1] = pix;
		  }

		  dblword_out = (((((gr_bit_table[spr_addr->byte_low] >> 1)
				   | gr_bit_table[(spr_addr+16)->byte_low]) >> 1)
				   | gr_bit_table[(spr_addr+32)->byte_low]) >> 1)
				   | gr_bit_table[(spr_addr+48)->byte_low];

		  if (x_reverse) {
		     pix = ((dblword_out >> 28) & 0x0F) | ind_pal;
		     sprbuf[3][y_ind][c*4-a*4-3] = pix;
		     pix = ((dblword_out >> 24) & 0x0F) | ind_pal;
		     sprbuf[2][y_ind][c*4-a*4-3] = pix;
		     pix = ((dblword_out >> 20) & 0x0F) | ind_pal;
		     sprbuf[1][y_ind][c*4-a*4-3] = pix;
		     pix = ((dblword_out >> 16) & 0x0F) | ind_pal;
		     sprbuf[0][y_ind][c*4-a*4-3] = pix;
		     pix = ((dblword_out >> 12) & 0x0F) | ind_pal;
		     sprbuf[3][y_ind][c*4-a*4-4] = pix;
		     pix = ((dblword_out >> 8) & 0x0F) | ind_pal;
		     sprbuf[2][y_ind][c*4-a*4-4] = pix;
		     pix = ((dblword_out >> 4) & 0x0F) | ind_pal;
		     sprbuf[1][y_ind][c*4-a*4-4] = pix;
		     pix = (dblword_out & 0x0F) | ind_pal;
		     sprbuf[0][y_ind][c*4-a*4-4] = pix;
		  } else {
		     pix = ((dblword_out >> 28) & 0x0F) | ind_pal;
		     sprbuf[0][y_ind][a*4+2] = pix;
		     pix = ((dblword_out >> 24) & 0x0F) | ind_pal;
		     sprbuf[1][y_ind][a*4+2] = pix;
		     pix = ((dblword_out >> 20) & 0x0F) | ind_pal;
		     sprbuf[2][y_ind][a*4+2] = pix;
		     pix = ((dblword_out >> 16) & 0x0F) | ind_pal;
		     sprbuf[3][y_ind][a*4+2] = pix;
		     pix = ((dblword_out >> 12) & 0x0F) | ind_pal;
		     sprbuf[0][y_ind][a*4+3] = pix;
		     pix = ((dblword_out >> 8) & 0x0F) | ind_pal;
		     sprbuf[1][y_ind][a*4+3] = pix;
		     pix = ((dblword_out >> 4) & 0x0F) | ind_pal;
		     sprbuf[2][y_ind][a*4+3] = pix;
		     pix = (dblword_out & 0x0F) | ind_pal;
		     sprbuf[3][y_ind][a*4+3] = pix;
		  }

		  spr_addr++;
	       }
	    }
	 }
	 for (i = 0; i < 4; i++) {
	    plane  = ((i+x_pix_indent) & 3);
	    oddadd = (i+x_pix_indent) / 4;
	    outport (0x3c4, (int)((0x100 << plane) + 2));
	    for (j = 0; j < d*16; j++) {
	       y_pos = y+j;
	       if ( (y_pos < 0) || (y_pos > 240) )
		  continue;
	       y_addr = y_base_offset + (j*80);
	       for (k = 0; k < c*4; k++) {
		  byte_off = x_line_offset + k + oddadd - SPR_LEFT_MARG_BYTE;
		  x_pos = x+k*4+i - SPR_LEFT_MARG_PIX;
		  if ((x_pos < 0) || (x_pos > (vid_bat_x_vis*8-1)))
		     continue;
		  byte = sprbuf[i][j][k];
		  if ((byte & 0x0F) != 0) {
//		       if (spr_behind == 0) {
			pokeb(vga_seg, y_addr+byte_off+indent*2,
				       pce_vga_pal_map[(UInt16)(byte)+256]);
//		       } else {
//			  if (peekb(vga_seg, y_addr+byte_off+indent*2) == 0) {
//			   pokeb(vga_seg, y_addr+byte_off+indent*2,
//					  pce_vga_pal_map[(UInt16)(byte)+256]);
//			  }
//		       }
		  }
	       }
	    }
	 }
      }


/*
      outport(0x03d4, (vga_seg & 0x0F00)<<4 + 0x0c);
      vga_seg ^= 0x0800;
*/
   }
   return;
}
