/****************************************************************************
   hardware.c

   Hardware function implementation
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "defs.h"
#include "globals.h"
#include "hardware.h"

#include "interupt.h"
#include "joy.h"
#include "pallette.h"
#include "psg.h"
#include "timer.h"
#include "video.h"


int hardware_put(UInt16 addr, UChar byte)
{
   int err = 0;

   switch((UChar)(addr>>8)) {       /* MSB of address */

     case 0x00:                     /* video subsection */
        switch(addr) {
          case 0x0000:
            err = hw_put_0000(byte);
            break;
          case 0x0002:
            err = hw_put_0002(byte);
            break;
          case 0x0003:
            err = hw_put_0003(byte);
            break;
          default:
            err = 1;
        }
        break;

     case 0x04:                      /* palette subsection */
        switch(addr) {
          case 0x0400:
            hw_put_0400(byte);
            break;
          case 0x0402:
            hw_put_0402(byte);
            break;
          case 0x0403:
            hw_put_0403(byte);
            break;
          case 0x0404:
            hw_put_0404(byte);
            break;
          case 0x0405:
            hw_put_0405(byte);
            break;
          default:
            err = 1;
        }
        break;

     case 0x08:                      /* PSG section */
        switch(addr) {
          case 0x0800:
            hw_put_0800(byte);
            break;
          case 0x0801:
            hw_put_0801(byte);
            break;
          case 0x0802:
            hw_put_0802(byte);
            break;
          case 0x0803:
            hw_put_0803(byte);
            break;
          case 0x0804:
            hw_put_0804(byte);
            break;
          case 0x0805:
            hw_put_0805(byte);
            break;
          case 0x0806:
            hw_put_0806(byte);
            break;
          case 0x0807:
            hw_put_0807(byte);
            break;
          case 0x0808:
            hw_put_0808(byte);
            break;
          case 0x0809:
            hw_put_0809(byte);
            break;
          default:
            err = 1;
        }

        break;

     case 0x0C:                      /* TIMER controller */
        switch(addr) {
          case 0x0C00:
            hw_put_0C00(byte);
            break;
          case 0x0C01:
            hw_put_0C01(byte);
            break;
          default:
            err = 1;
        }
        break;

     case 0x10:                      /* joystick section */
        if (addr == 0x1000) {
           hw_put_1000(byte);
        } else {
           err = 1;
        }
        break;

     case 0x14:                      /* interrupt-controller */
        switch(addr) {
          case 0x1402:
            hw_put_1402(byte);
            break;
          case 0x1403:
            hw_put_1403(byte);
            break;
          default:
            err = 1;
        }
        break;

/* Expansion unit/CD hardware ? */

     case 0x18:                      /* unsure what section this is */
        switch(addr) {
          case 0x1800:
/*            hw_put_1800(byte); */
            err = 1;
            break;
          case 0x1801:
/*            hw_put_1801(byte); */
            err = 1;
            break;
          case 0x1802:
/*            hw_put_1802(byte); */
            err = 1;
            break;
          case 0x1803:
/*            hw_put_1803(byte); */
            err = 1;
            break;
          case 0x1804:
/*            hw_put_1804(byte); */
            err = 1;
            break;
          case 0x1807:
/*            hw_put_1807(byte); */
//            err = 1;
            break;
          case 0x180B:
/*            hw_put_180B(byte); */
            err = 1;
            break;
          case 0x180D:
/*            hw_put_180D(byte); */
            err = 1;
            break;
          case 0x180E:
/*            hw_put_180E(byte); */
            err = 1;
            break;
          case 0x180F:
/*            hw_put_180F(byte); */
            err = 1;
            break;
          default:
            err = 1;
        }
        break;

/**********************************************
     These sections not even roughed in yet :
 **********************************************

     case 0x1A:                      * arcade card section *
        arcadecard_put(addr, byte);
        break;
*/

     default:
        err = 1;
        break;
   }
   return(err);
}


UChar hardware_get(UInt16 addr)
{
   UChar byte = 0xff;

   switch((UChar)(addr>>8)) {       /* MSB of address */

     case 0x00:                     /* video subsection */
        switch(addr) {
          case 0x0000:
            byte = hw_get_0000();
            break;
          case 0x0002:
            byte = hw_get_0002();
            break;
          case 0x0003:
            byte = hw_get_0003();
            break;
        }
        break;

     case 0x04:                      /* palette subsection */
        switch(addr) {
          case 0x0400:
            byte = hw_get_0400();
            break;
          case 0x0402:
            byte = hw_get_0402();
            break;
          case 0x0403:
            byte = hw_get_0403();
            break;
          case 0x0404:
            byte = hw_get_0404();
            break;
          case 0x0405:
            byte = hw_get_0405();
            break;
        }
        break;

     case 0x08:                      /* PSG section */
        switch(addr) {
          case 0x0800:
            byte = hw_get_0800();
            break;
          case 0x0801:
            byte = hw_get_0801();
            break;
          case 0x0802:
            byte = hw_get_0802();
            break;
          case 0x0803:
            byte = hw_get_0803();
            break;
          case 0x0804:
            byte = hw_get_0804();
            break;
          case 0x0805:
            byte = hw_get_0805();
            break;
          case 0x0806:
            byte = hw_get_0806();
            break;
          case 0x0807:
            byte = hw_get_0807();
            break;
          case 0x0808:
            byte = hw_get_0808();
            break;
          case 0x0809:
            byte = hw_get_0809();
            break;
        }

        break;

     case 0x0C:                      /* TIMER controller */
        switch(addr) {
          case 0x0C00:
            byte = hw_get_0C00();
            break;
          case 0x0C01:
            byte = hw_get_0C01();
            break;
        }
        break;

     case 0x10:                      /* joystick section */
        if (addr == 0x1000) {
           byte = hw_get_1000();
        }
        break;

     case 0x14:                      /* interrupt controller */
        switch(addr) {
          case 0x1402:
            byte = hw_get_1402();
            break;
          case 0x1403:
            byte = hw_get_1403();
            break;
        }
        break;

/* Expansion unit/CD controller ? */

     case 0x18:                      /* unsure what section this is */
        switch(addr) {
          case 0x1800:
/*            byte = hw_get_1800(); */
            break;
          case 0x1801:
/*            byte = hw_get_1801(); */
            break;
          case 0x1802:
/*            byte = hw_get_1802(); */
            break;
          case 0x1803:
/*            byte = hw_get_1803(); */
            break;
          case 0x1804:
/*            byte = hw_get_1804(); */
            break;
          case 0x1807:
/*            byte = hw_get_1807(); */
            break;
          case 0x180B:
/*            byte = hw_get_180B(); */
            break;
          case 0x180D:
/*            byte = hw_get_180D(); */
            break;
          case 0x180E:
/*            byte = hw_get_180E(); */
            break;
          case 0x180F:
/*            byte = hw_get_180F(); */
            break;
        }
        break;

/**********************************************
     These sections not even roughed in yet :
 **********************************************

     case 0x1A:                      * arcade card section *
        byte = arcadecard_get(addr);
        break;
*/
   }
   return(byte);
}
