/****************************************************************************
   psg.c

   Programmable synth function implementation

 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <math.h>

#include "defs.h"
#include "globals.h"
#include "psg.h"

// This is 3.58MHz/our_sampling_frequency:
#define PSG_TICKS_PER_SAMPLE   512

PCE_Voice psg_voice[6];

UInt16	  psg_voicenum;
UInt16	  psg_mainvol_l;
UInt16	  psg_mainvol_r;
UChar	  psg_lfo_freq;
UChar	  psg_lfo_ctrl;

void  PSG_Init(void) {
   psg_voicenum  = 0;
   psg_mainvol_l = 0;
   psg_mainvol_r = 0;
   psg_lfo_freq  = 0;
   psg_lfo_ctrl  = 0;

   for (int i=0; i < 6; i++) {
      psg_voice[i].freq 		    = 0;
      psg_voice[i].cnt_int 		    = 0;
      psg_voice[i].cnt_frac 		    = 0;
      psg_voice[i].dda_out		    = 0;
      psg_voice[i].dda_ctrl		    = 0;
      psg_voice[i].wave_dda_l		    = 0;
      psg_voice[i].wave_dda_r		    = 0;
      psg_voice[i].dda_ctrl		    = 0;
      psg_voice[i].pan_l		    = 0;
      psg_voice[i].pan_r		    = 0;
      psg_voice[i].noise_ctrl		    = 0;
      psg_voice[i].wave_data_pgm_idx	    = 0;
      psg_voice[i].wave_data_play_idx	    = 0;
      psg_voice[i].wave_data_play_idx_frac  = 0;
      psg_voice[i].wave_data_play_countdown = 0;

      for (int j=0; j < 32; j++) {
	 psg_voice[i].wave_data[j]	    = (j>15) ? 8:0;
	 psg_voice[i].wave_data_l[j]	    = 0;
	 psg_voice[i].wave_data_r[j]	    = 0;
      }
   }

   int blaster_reset_flag = 0;

   int count1 = 10;
   while ((blaster_reset_flag == 0) && (count1 != 0)) {
      outportb(BLASTER+0x06, 1);
      outportb(BLASTER+0x06, 0);
      int count2 = 50;
      while ((count2 > 0) && (inportb(BLASTER+0x0E) < 128))
	 --count2;
      if ((count2 == 0) || (inportb(BLASTER+0x0A) != 0xAA)) {
	 --count1;
      } else {
	 blaster_reset_flag = 1;
	 break;
      }
      if (count1 == 0) {
	 break;
      }
   }
   if (blaster_reset_flag == 0) {
      printf("Could not reset Soundblaster card\n");
      exit(0);
   }
}

void  hw_put_0800(UChar byte) {
   psg_voicenum = (byte & 0x07);
}

void  hw_put_0801(UChar byte) {
   psg_mainvol_l = (byte >> 4);
   psg_mainvol_r = (byte & 0x0F);
}

void  hw_put_0802(UChar byte) {
   PCE_Voice * voiceptr = &(psg_voice[psg_voicenum]);

   voiceptr->freq = (voiceptr->freq & 0xFF00) + byte;

   if (voiceptr->freq == 0) {
     voiceptr->cnt_int  = 0;
     voiceptr->cnt_frac = 0;
   } else {
     voiceptr->cnt_int  = PSG_TICKS_PER_SAMPLE/voiceptr->freq;
     voiceptr->cnt_frac = PSG_TICKS_PER_SAMPLE - (voiceptr->cnt_int * voiceptr->freq);
   }
}

void  hw_put_0803(UChar byte) {
   PCE_Voice * voiceptr = &(psg_voice[psg_voicenum]);

   voiceptr->freq = (byte & 0x0F) * 256 + (voiceptr->freq & 0x00FF);

   if (voiceptr->freq == 0) {
     voiceptr->cnt_int  = 0;
     voiceptr->cnt_frac = 0;
   } else {
     voiceptr->cnt_int  = PSG_TICKS_PER_SAMPLE/voiceptr->freq;
     voiceptr->cnt_frac = PSG_TICKS_PER_SAMPLE - (voiceptr->cnt_int * voiceptr->freq);
   }
}

void  hw_put_0804(UChar byte) {
   PCE_Voice * voiceptr = &(psg_voice[psg_voicenum]);

   voiceptr->dda_ctrl = (byte & 0xDF);

   if (voiceptr->dda_ctrl & 0x40) {
      voiceptr->dda_out = (byte & 0x1F);
      UInt16 temp = voiceptr->dda_out * (voiceptr->dda_ctrl & 0x1F);
      voiceptr->wave_dda_l = (temp * voiceptr->pan_l) /2;
      voiceptr->wave_dda_r = (temp * voiceptr->pan_r) /2;

   } else {

      for (int i=0; i < 32; i++) {
        UInt16 temp = voiceptr->wave_data[i] * (voiceptr->dda_ctrl & 0x1F);
        voiceptr->wave_data_l[i] = (temp * voiceptr->pan_l) /2;
        voiceptr->wave_data_r[i] = (temp * voiceptr->pan_r) /2;
      }
   }
}

void  hw_put_0805(UChar byte) {
   PCE_Voice * voiceptr = &(psg_voice[psg_voicenum]);

   voiceptr->pan_l = (byte >> 4);
   voiceptr->pan_r = (byte & 0x0F);

   if (voiceptr->dda_ctrl & 0x40) {
      voiceptr->dda_out = (byte & 0x1F);
      UInt16 temp = voiceptr->dda_out * (voiceptr->dda_ctrl & 0x1F);
      voiceptr->wave_dda_l = (temp * voiceptr->pan_l) /2;
      voiceptr->wave_dda_r = (temp * voiceptr->pan_r) /2;

   } else {

      for (int i=0; i < 32; i++) {
        UInt16 temp = voiceptr->wave_data[i] * (voiceptr->dda_ctrl & 0x1F);
        voiceptr->wave_data_l[i] = (temp * voiceptr->pan_l) /2;
        voiceptr->wave_data_r[i] = (temp * voiceptr->pan_r) /2;
      }
   }
}

void  hw_put_0806(UChar byte) {
   PCE_Voice * voiceptr = &(psg_voice[psg_voicenum]);

   if (voiceptr->dda_ctrl & 0x40) {
      voiceptr->dda_out = (byte & 0x1F);
      UInt16 temp = voiceptr->dda_out * (voiceptr->dda_ctrl & 0x1F);
      voiceptr->wave_dda_l = (temp * voiceptr->pan_l) /2;
      voiceptr->wave_dda_r = (temp * voiceptr->pan_r) /2;

   } else {
      voiceptr->wave_data[voiceptr->wave_data_pgm_idx++] = (byte & 0x1f);
      voiceptr->wave_data_pgm_idx &= 31;

      int i = voiceptr->wave_data_pgm_idx;
      UInt16 temp = voiceptr->wave_data[i] * (voiceptr->dda_ctrl & 0x1F);
      voiceptr->wave_data_l[i] = (temp * voiceptr->pan_l) /2;
      voiceptr->wave_data_r[i] = (temp * voiceptr->pan_r) /2;
   }
}

void  hw_put_0807(UChar byte) {
   psg_voice[psg_voicenum].noise_ctrl = (byte & 0x9F);
}

void  hw_put_0808(UChar byte) {
   psg_lfo_freq = byte;
}

void  hw_put_0809(UChar byte) {
   psg_lfo_ctrl = (byte & 0x83);
}


UChar hw_get_0800(void) {
   return(psg_voicenum);
}

UChar hw_get_0801(void) {
   return((UChar) ((psg_mainvol_l << 4) + psg_mainvol_r));
}

UChar hw_get_0802(void) {
   return(psg_voice[psg_voicenum].freq & 0x00FF);
}

UChar hw_get_0803(void) {
   return(psg_voice[psg_voicenum].freq & 0xFF00);
}

UChar hw_get_0804(void) {
   return(psg_voice[psg_voicenum].dda_ctrl);
}

UChar hw_get_0805(void) {
   UChar ret = (psg_voice[psg_voicenum].pan_l << 4)
	     +	psg_voice[psg_voicenum].pan_r;

   return(ret);
}

UChar hw_get_0806(void) {
   return 0;
}

UChar hw_get_0807(void) {
   return(psg_voice[psg_voicenum].noise_ctrl);
}

UChar hw_get_0808(void) {
   return(psg_lfo_freq);
}

UChar hw_get_0809(void) {
   return(psg_lfo_ctrl);
}
