/****************************************************************************
 psg.h
 Programmable synth hardware function prototypes
 ****************************************************************************/

#ifndef PSG_H_
#define PSG_H_

#include "defs.h"

typedef struct {
   Int16  wave_data_play_idx;
   Int16  wave_data_play_idx_frac;
   Int16  wave_data_play_countdown;
   Int16  wave_data_pgm_idx;
   UInt16 wave_data_l[32];
   UInt16 wave_data_r[32];
   UChar  wave_data[32];
   UInt16 wave_dda_l;
   UInt16 wave_dda_r;
   UInt16 cnt_int;
   UInt16 cnt_frac;
   UInt16 freq;
   UChar  pan_l;
   UChar  pan_r;
   UChar  dda_out;
   UChar  dda_ctrl;
   UChar  noise_ctrl;
   UChar  filler[256-183];   // align according to power of 2
} PCE_Voice;

extern PCE_Voice psg_voice[];
extern UInt16    psg_voicenum;
extern UInt16    psg_mainvol_l;
extern UInt16    psg_mainvol_r;
extern UChar     psg_lfo_freq;
extern UChar     psg_lfo_ctrl;

extern void  PSG_Init(void);

extern void  hw_put_0800(UChar);
extern void  hw_put_0801(UChar);
extern void  hw_put_0802(UChar);
extern void  hw_put_0803(UChar);
extern void  hw_put_0804(UChar);
extern void  hw_put_0805(UChar);
extern void  hw_put_0806(UChar);
extern void  hw_put_0807(UChar);
extern void  hw_put_0808(UChar);
extern void  hw_put_0809(UChar);

extern UChar hw_get_0800(void);
extern UChar hw_get_0801(void);
extern UChar hw_get_0802(void);
extern UChar hw_get_0803(void);
extern UChar hw_get_0804(void);
extern UChar hw_get_0805(void);
extern UChar hw_get_0806(void);
extern UChar hw_get_0807(void);
extern UChar hw_get_0808(void);
extern UChar hw_get_0809(void);

#endif
