/****************************************************************************
   interupt.c

   Interrupt-controller function implementation

 ****************************************************************************/

#include "defs.h"
#include "globals.h"
#include "interupt.h"

// GLOBAL data:

UChar irq_mask     = 0x00;    // initialize to 'all enabled'
UChar irq_register = 0x00;    // initialize to zeroes

// Hardware functions:

void hw_put_1402(UChar byte) {
   irq_mask = byte;
   return;
}

void hw_put_1403(UChar byte) {
   irq_register = byte;
   return;
}

UChar hw_get_1402(void) {
   return(irq_mask);
}

UChar hw_get_1403(void) {
   return(irq_register);
}
