/****************************************************************************
   joy.c

   Joystick function implementation

   Note: 'joy_values[]' is set elsewhere (impl.c)
 ****************************************************************************/

#include "defs.h"
#include "globals.h"
#include "joy.h"
#include "impl.h"

/* This nybble contains some unknown data, plus the flag
   which determines whether the machine is a TG or PC-E */

#define JOY_SYSNYBBLE 0x00

/* These bits control what data to return to the program
   on a joystick port read */
#define JOY_RESET     0x02
#define JOY_CLOCK     0x01

UChar joy_count;
UChar joy_hilo;
UChar joy_nybble;
UChar joy_values[5];


void  hw_put_1000(UChar byte) {
   if (byte & JOY_RESET) {
/*      read_localjoys(); */
      joy_count = 0;
      joy_hilo = (byte & JOY_CLOCK);
   }

   if (byte & JOY_CLOCK) {
      if (!joy_hilo) {                            /* transition; inc counter */
         joy_count++;
         if (joy_count > 4) {
            joy_count = 0;
         }
      }
      joy_nybble = joy_values[joy_count]>>4;      /* 1st nybble */
      joy_hilo = (byte & JOY_CLOCK);
   }
   else
   {
      joy_nybble = joy_values[joy_count] & 0x0F;  /* 2nd nybble */
      joy_hilo = (byte & JOY_CLOCK);
   }
}

UChar hw_get_1000(void) {
   return(joy_nybble | JOY_SYSNYBBLE);
}
