/****************************************************************************
 exe.h
 Function protoypes for simulated execution routines
 ****************************************************************************/

#ifndef EXE_H_
#define EXE_H_

/********************************************/
/* function parameters:                     */
/* --------------------                     */
/* - address (16-bit unsigned),             */
/* - pointer to buffer @ program counter    */
/********************************************/

extern void EXE_FAR exe_instruct(void);
extern void EXE_FAR exe_go(void);

extern int EXE_NEAR adc_abs(void);
extern int EXE_NEAR adc_absx(void);
extern int EXE_NEAR adc_absy(void);
extern int EXE_NEAR adc_imm(void);
extern int EXE_NEAR adc_zp(void);
extern int EXE_NEAR adc_zpind(void);
extern int EXE_NEAR adc_zpindx(void);
extern int EXE_NEAR adc_zpindy(void);
extern int EXE_NEAR adc_zpx(void);
extern int EXE_NEAR and_abs(void);
extern int EXE_NEAR and_absx(void);
extern int EXE_NEAR and_absy(void);
extern int EXE_NEAR and_imm(void);
extern int EXE_NEAR and_zp(void);
extern int EXE_NEAR and_zpind(void);
extern int EXE_NEAR and_zpindx(void);
extern int EXE_NEAR and_zpindy(void);
extern int EXE_NEAR and_zpx(void);
extern int EXE_NEAR asl_a(void);
extern int EXE_NEAR asl_abs(void);
extern int EXE_NEAR asl_absx(void);
extern int EXE_NEAR asl_zp(void);
extern int EXE_NEAR asl_zpx(void);
extern int EXE_NEAR bbr0(void);
extern int EXE_NEAR bbr1(void);
extern int EXE_NEAR bbr2(void);
extern int EXE_NEAR bbr3(void);
extern int EXE_NEAR bbr4(void);
extern int EXE_NEAR bbr5(void);
extern int EXE_NEAR bbr6(void);
extern int EXE_NEAR bbr7(void);
extern int EXE_NEAR bbs0(void);
extern int EXE_NEAR bbs1(void);
extern int EXE_NEAR bbs2(void);
extern int EXE_NEAR bbs3(void);
extern int EXE_NEAR bbs4(void);
extern int EXE_NEAR bbs5(void);
extern int EXE_NEAR bbs6(void);
extern int EXE_NEAR bbs7(void);
extern int EXE_NEAR bcc(void);
extern int EXE_NEAR bcs(void);
extern int EXE_NEAR beq(void);
extern int EXE_NEAR bit_abs(void);
extern int EXE_NEAR bit_absx(void);
extern int EXE_NEAR bit_imm(void);
extern int EXE_NEAR bit_zp(void);
extern int EXE_NEAR bit_zpx(void);
extern int EXE_NEAR bmi(void);
extern int EXE_NEAR bne(void);
extern int EXE_NEAR bpl(void);
extern int EXE_NEAR bra(void);
extern int EXE_NEAR brk(void);
extern int EXE_NEAR bsr(void);
extern int EXE_NEAR bvc(void);
extern int EXE_NEAR bvs(void);
extern int EXE_NEAR cla(void);
extern int EXE_NEAR clc(void);
extern int EXE_NEAR cld(void);
extern int EXE_NEAR cli(void);
extern int EXE_NEAR clv(void);
extern int EXE_NEAR clx(void);
extern int EXE_NEAR cly(void);
extern int EXE_NEAR cmp_abs(void);
extern int EXE_NEAR cmp_absx(void);
extern int EXE_NEAR cmp_absy(void);
extern int EXE_NEAR cmp_imm(void);
extern int EXE_NEAR cmp_zp(void);
extern int EXE_NEAR cmp_zpind(void);
extern int EXE_NEAR cmp_zpindx(void);
extern int EXE_NEAR cmp_zpindy(void);
extern int EXE_NEAR cmp_zpx(void);
extern int EXE_NEAR cpx_abs(void);
extern int EXE_NEAR cpx_imm(void);
extern int EXE_NEAR cpx_zp(void);
extern int EXE_NEAR cpy_abs(void);
extern int EXE_NEAR cpy_imm(void);
extern int EXE_NEAR cpy_zp(void);
extern int EXE_NEAR dec_a(void);
extern int EXE_NEAR dec_abs(void);
extern int EXE_NEAR dec_absx(void);
extern int EXE_NEAR dec_zp(void);
extern int EXE_NEAR dec_zpx(void);
extern int EXE_NEAR dex(void);
extern int EXE_NEAR dey(void);
extern int EXE_NEAR eor_abs(void);
extern int EXE_NEAR eor_absx(void);
extern int EXE_NEAR eor_absy(void);
extern int EXE_NEAR eor_imm(void);
extern int EXE_NEAR eor_zp(void);
extern int EXE_NEAR eor_zpind(void);
extern int EXE_NEAR eor_zpindx(void);
extern int EXE_NEAR eor_zpindy(void);
extern int EXE_NEAR eor_zpx(void);
extern int EXE_NEAR halt(void);
extern int EXE_NEAR inc_a(void);
extern int EXE_NEAR inc_abs(void);
extern int EXE_NEAR inc_absx(void);
extern int EXE_NEAR inc_zp(void);
extern int EXE_NEAR inc_zpx(void);
extern int EXE_NEAR inx(void);
extern int EXE_NEAR iny(void);
extern int EXE_NEAR jmp(void);
extern int EXE_NEAR jmp_absind(void);
extern int EXE_NEAR jmp_absindx(void);
extern int EXE_NEAR jsr(void);
extern int EXE_NEAR lda_abs(void);
extern int EXE_NEAR lda_absx(void);
extern int EXE_NEAR lda_absy(void);
extern int EXE_NEAR lda_imm(void);
extern int EXE_NEAR lda_zp(void);
extern int EXE_NEAR lda_zpind(void);
extern int EXE_NEAR lda_zpindx(void);
extern int EXE_NEAR lda_zpindy(void);
extern int EXE_NEAR lda_zpx(void);
extern int EXE_NEAR ldx_abs(void);
extern int EXE_NEAR ldx_absy(void);
extern int EXE_NEAR ldx_imm(void);
extern int EXE_NEAR ldx_zp(void);
extern int EXE_NEAR ldx_zpy(void);
extern int EXE_NEAR ldy_abs(void);
extern int EXE_NEAR ldy_absx(void);
extern int EXE_NEAR ldy_imm(void);
extern int EXE_NEAR ldy_zp(void);
extern int EXE_NEAR ldy_zpx(void);
extern int EXE_NEAR lsr_a(void);
extern int EXE_NEAR lsr_abs(void);
extern int EXE_NEAR lsr_absx(void);
extern int EXE_NEAR lsr_zp(void);
extern int EXE_NEAR lsr_zpx(void);
extern int EXE_NEAR nop(void);
extern int EXE_NEAR ora_abs(void);
extern int EXE_NEAR ora_absx(void);
extern int EXE_NEAR ora_absy(void);
extern int EXE_NEAR ora_imm(void);
extern int EXE_NEAR ora_zp(void);
extern int EXE_NEAR ora_zpind(void);
extern int EXE_NEAR ora_zpindx(void);
extern int EXE_NEAR ora_zpindy(void);
extern int EXE_NEAR ora_zpx(void);
extern int EXE_NEAR pha(void);
extern int EXE_NEAR php(void);
extern int EXE_NEAR phx(void);
extern int EXE_NEAR phy(void);
extern int EXE_NEAR pla(void);
extern int EXE_NEAR plp(void);
extern int EXE_NEAR plx(void);
extern int EXE_NEAR ply(void);
extern int EXE_NEAR rmb0(void);
extern int EXE_NEAR rmb1(void);
extern int EXE_NEAR rmb2(void);
extern int EXE_NEAR rmb3(void);
extern int EXE_NEAR rmb4(void);
extern int EXE_NEAR rmb5(void);
extern int EXE_NEAR rmb6(void);
extern int EXE_NEAR rmb7(void);
extern int EXE_NEAR rol_a(void);
extern int EXE_NEAR rol_abs(void);
extern int EXE_NEAR rol_absx(void);
extern int EXE_NEAR rol_zp(void);
extern int EXE_NEAR rol_zpx(void);
extern int EXE_NEAR ror_a(void);
extern int EXE_NEAR ror_abs(void);
extern int EXE_NEAR ror_absx(void);
extern int EXE_NEAR ror_zp(void);
extern int EXE_NEAR ror_zpx(void);
extern int EXE_NEAR rti(void);
extern int EXE_NEAR rts(void);
extern int EXE_NEAR sax(void);
extern int EXE_NEAR say(void);
extern int EXE_NEAR sbc_abs(void);
extern int EXE_NEAR sbc_absx(void);
extern int EXE_NEAR sbc_absy(void);
extern int EXE_NEAR sbc_imm(void);
extern int EXE_NEAR sbc_zp(void);
extern int EXE_NEAR sbc_zpind(void);
extern int EXE_NEAR sbc_zpindx(void);
extern int EXE_NEAR sbc_zpindy(void);
extern int EXE_NEAR sbc_zpx(void);
extern int EXE_NEAR sec(void);
extern int EXE_NEAR sed(void);
extern int EXE_NEAR sei(void);
extern int EXE_NEAR set(void);
extern int EXE_NEAR smb0(void);
extern int EXE_NEAR smb1(void);
extern int EXE_NEAR smb2(void);
extern int EXE_NEAR smb3(void);
extern int EXE_NEAR smb4(void);
extern int EXE_NEAR smb5(void);
extern int EXE_NEAR smb6(void);
extern int EXE_NEAR smb7(void);
extern int EXE_NEAR st0(void);
extern int EXE_NEAR st1(void);
extern int EXE_NEAR st2(void);
extern int EXE_NEAR sta_abs(void);
extern int EXE_NEAR sta_absx(void);
extern int EXE_NEAR sta_absy(void);
extern int EXE_NEAR sta_zp(void);
extern int EXE_NEAR sta_zpind(void);
extern int EXE_NEAR sta_zpindx(void);
extern int EXE_NEAR sta_zpindy(void);
extern int EXE_NEAR sta_zpx(void);
extern int EXE_NEAR stx_abs(void);
extern int EXE_NEAR stx_zp(void);
extern int EXE_NEAR stx_zpy(void);
extern int EXE_NEAR sty_abs(void);
extern int EXE_NEAR sty_zp(void);
extern int EXE_NEAR sty_zpx(void);
extern int EXE_NEAR stz_abs(void);
extern int EXE_NEAR stz_absx(void);
extern int EXE_NEAR stz_zp(void);
extern int EXE_NEAR stz_zpx(void);
extern int EXE_NEAR sxy(void);
extern int EXE_NEAR tai(void);
extern int EXE_NEAR tam(void);
extern int EXE_NEAR tax(void);
extern int EXE_NEAR tay(void);
extern int EXE_NEAR tdd(void);
extern int EXE_NEAR tia(void);
extern int EXE_NEAR tii(void);
extern int EXE_NEAR tin(void);
extern int EXE_NEAR tma(void);
extern int EXE_NEAR trb_abs(void);
extern int EXE_NEAR trb_zp(void);
extern int EXE_NEAR tsb_abs(void);
extern int EXE_NEAR tsb_zp(void);
extern int EXE_NEAR tstins_abs(void);
extern int EXE_NEAR tstins_absx(void);
extern int EXE_NEAR tstins_zp(void);
extern int EXE_NEAR tstins_zpx(void);
extern int EXE_NEAR tsx(void);
extern int EXE_NEAR txa(void);
extern int EXE_NEAR txs(void);
extern int EXE_NEAR tya(void);

#endif
