/****************************************************************************
 globals.h
 ****************************************************************************/

#ifndef GLOBALS_H_
#define GLOBALS_H_

#include "defs.h"

#define BLASTER 0x220

#define FL_N 0x80
#define FL_V 0x40
#define FL_T 0x20
#define FL_B 0x10
#define FL_D 0x08
#define FL_I 0x04
#define FL_Z 0x02
#define FL_C 0x01

extern UChar * base[256];
extern UChar * zp_base;
extern UChar * sp_base;
extern UChar * mmr_base[8];

extern UInt16  reg_pc;
extern UChar   reg_a;
extern UChar   reg_x;
extern UChar   reg_y;
extern UChar   reg_p;
extern UChar   reg_s;

extern UChar   mmr[8];
extern long   cycles;
extern long   frames;

/* misc */

typedef struct mode {
  Int16 size;
  void (*func_format)(Char *, long, UChar *, Char *);
} mode_struct;

typedef struct op {
   int EXE_NEAR (*func_exe)(void);
   Int16  addr_mode;
   Char * opname;
   short int filler[4];
} operation;

extern mode_struct addr_info[];
extern operation optable[];

#endif
