/****************************************************************************
 * tgsim.c
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <fcntl.h>
#include <math.h>
#include <sys\stat.h>
#include <errno.h>
#include <conio.h>
#include <bios.h>

#include "defs.h"
#include "format.h"
#include "exe.h"
#include "dis.h"
#include "display.h"
#include "grph.h"
#include "video.h"
#include "pallette.h"
#include "psg.h"
/* #include "joy.h" */

/***********/
/* GLOBALS */
/***********/

/* PROCESSOR stuff */

UChar * base[256];
UChar * zp_base;
UChar * sp_base;
UChar * mmr_base[8];

UChar	mmr[8];


/* misc */

Char	buf[128];
UInt16	bkpt;


long cvtnum(char * string)
{
   long   value = 0;
   char * c = string;

   while (*c != '\0') {

     value *= 16;

     if ((*c >= '0') && (*c <= '9')) {
       value += (*c - '0');

     } else if ((*c >= 'A') && (*c <= 'F')) {
       value += (*c - 'A' + 10);

     } else if ((*c >= 'a') && (*c <= 'f')) {
       value += (*c - 'a' + 10);

     } else {

       return(-1);
     }

     c++;
   }

   return(value);
}


void inputnum(char * buffer, int len)
{
   char  ch;

   while (len) {
      ch = getch();
      if ((ch >= '0' && ch <= '9') ||
          (ch >= 'A' && ch <= 'F') ||
          (ch >= 'a' && ch <= 'f')) {

	 *(buffer++) = (char)ch;
	 len--;
      }
   }
   *buffer = '\0';
}


int main(int argc, char *argv[])
{
   FILE *inf;
   FILE *outf;
   char linebuf[256];
   char *  ptr;
   UInt16  addr;
   UInt16  vidaddr;
   UChar   op;
   long length;
   int	i, j;
   int	temp, break_out;
   int	memreg;
   UChar hold;
   register void (*func)(void);
   register unsigned int reg;
   long starttime, endtime;
   float duration, vmhz;
#ifndef HUCARD
   int	temp1, temp2;
   int	start, seclen, ldaddr, exeaddr;
#endif

   if (argc < 2) {
      fprintf(stderr, "Usage:  %s <infile>\n", argv[0]);
      exit(1);
   }

   /* Open input and output files. */
   if ((inf = fopen(argv[1], "rb")) == NULL) {
      fprintf(stderr, "%s: can't open %s\n", argv[0], argv[1]);
      exit(1);
   }

/* initialize PC structures */
   init_graphics();
   PSG_Init();

/* initialize video subsystem */

   Video_Init();
   Pallette_Init();

/******************************************/
/* Here, we allocate memory in a loop.	  */
/* The memory is allocated in 8K chunks   */
/* to be used as base addresses for	  */
/* segments.				  */
/*					  */
/* The index 'i' is the value which would */
/* be contained in an MMR register for an */
/* operation on this memory.		  */
/*					  */
/* The size and locations of TG memory	  */
/* allocated in this section are enough   */
/* for a 2Mbit card game		  */
/*					  */
/* Card Memory is at	$00-$0F 	  */
/* NVRAM is at		$F7 (?) 	  */
/* Scratchpad RAM is at $F8		  */
/* Hardware I/O is at	$FF		  */
/*					  */
/* All of these areas must be allocated   */
/* because access attempts at unallocated */
/* areas of memory may cause SEGV's       */
/******************************************/

   for (i = 0; i < 256; i++) {

      /* card memory (i<32 is 2MBit) */
      /* scratchpad RAM (i=0xF8)     */
      /* and hardware access (i=0xFF)*/

      if ((i < 32) || (i == 0xF7) || (i == 0xF8)) {

	 base[i] = (UChar *)malloc(0x2000);
	 if (base[i] == NULL) {
            printf("Can't malloc that much !  %d\n", i);
	    exit(1);
	 }

      } else {

	 base[i] = NULL;		  /* else leave it unallocated */
      }

      if (i == 0xF8) {			  /* scratchpad RAM */
	 zp_base = base[i];		  /* set zero page base addr  */
	 sp_base = base[i] + 0x100;	  /* set stack page base addr */
      }
   }

   for (i = 0; i < 8; i++) {             /* init mmr var's */
      mmr[i] = 0;
      mmr_base[i] = base[0];
   }

#ifdef HUCARD
/* this is a HuCard-like beginning.... */

   /* fill buffers */
   break_out = 0;

   for (i = 0; (i < 32) && (!break_out); i++) {

      ptr = base[i];

      for (j = 0; j < 0x2000; j++) {
	 if ((temp = fgetc(inf)) == EOF) {
            printf("EOF at block %d, offset %d\n", temp, i, j);
	    break;
	 }
	 *ptr = (char)temp;
	 ptr++;
      }
   }

   reg_pc = ((UChar)(*(base[0] + 0x1fff)) * 256) +
	     (UChar)(*(base[0] + 0x1ffe));

/* end HuCard beginning... */

#endif
#ifndef HUCARD

   /* This is an attempt at a quickie CDROM interface */

   mmr[0] = 0xff;      /* hardware */
   mmr[1] = 0xf8;      /* base RAM, zero page/stack */
   mmr_base[1] = base[0xf8];
   mmr[7] = 0x00;
   mmr_base[7] = base[0x00];

   for (i = 2; i < 7; i++) {             /* init mmr var's */
      mmr[i] = i;
      mmr_base[i] = base[i];
   }
   if (fseek(inf, 0x800, SEEK_SET)) {
      printf("Error seeking to CD file header\n");
      exit(1);
   }
   if (errno == EBADF || errno == EINVAL || errno == ESPIPE) {
      printf("Error seeking to CD file header\n");
      exit(1);
   }

   temp  = fgetc(inf);	/* dummy value */
   temp1 = fgetc(inf);
   temp2 = fgetc(inf);
   start = temp1 * 256 + temp2;
   temp  = fgetc(inf);
   seclen = temp;
   temp1 = fgetc(inf);
   temp2 = fgetc(inf);
   ldaddr = temp2 * 256 + temp1;
   temp1 = fgetc(inf);
   temp2 = fgetc(inf);
   exeaddr = temp2 * 256 + temp1;
   reg_pc = exeaddr;

   if (fseek(inf, (start * 0x800), SEEK_SET)) {
      printf("Error seeking to CD file info\n");
      exit(1);
   }
   if (errno == EBADF || errno == EINVAL || errno == ESPIPE) {
      printf("Error seeking to CD file info\n");
      exit(1);
   }

   seclen += 0x14; /* patch */
   *(mmr_base[0xe009>>13] + (0xe009 & 0x1fff)) = (UChar)0x0b;
   *(mmr_base[0xe00a>>13] + (0xe00a & 0x1fff)) = (UChar)0x60;

   for (addr = ldaddr; addr < (ldaddr + (0x800*seclen)); addr++) {
      if ((temp = fgetc(inf)) == EOF) {
	 break_out = 1;
         printf("EOF at offset %d\n", addr);
	 exit(1);
      }
      *(mmr_base[addr>>13] + (addr & 0x1fff)) = (UChar)temp;
   }

#endif

   clrscr();				 /* init screen */
   put_frame();


/* loop until escape key hit */

   while (1) {
      put_regs();
      put_disasm(reg_pc);
      put_cmdprompt();

      i = getch();			  /* get keyboard hit */

      switch (i) {

        case 27:                          /* if escape, break 'switch' stmt */
	   break;

        case 'A':                         /* Time video display 1000 frames */
        case 'a':
	   cycles = 0;

#ifdef HUCARD
/**/
	   set_modex();
	   set_palette();
/**/
#endif
	   starttime = biostime(0,0);
	   for (i = 0; i < 1000; i++) {
	      put_graphics();
	   }
	   endtime = biostime(0,0);
#ifdef HUCARD
/**/
	   set_text();
	   put_frame();
/**/
#endif
	   duration = (float)(endtime-starttime)/_BIOS_CLK_TCK;
	   if (duration != 0) {
              printf("\n\n\n1000 frames, Duration = %f", duration);
	   }
	   while (getch() == NULL);
	   break;

        case 'B':                         /* set breakpoint */
        case 'b':
           /* implement 'breakpoint' by inserting a non-opcode */
	   /* in the breakpoint location, and recovering later */

	   inputnum(buf, 4);
	   bkpt = cvtnum(buf);
	   hold = *(mmr_base[bkpt>>13] + (bkpt & 0x1FFF));
	   *(mmr_base[bkpt>>13] + (bkpt & 0x1FFF)) = 0x0B;
	   break;

        case 'F':                         /* Dump NVRam to File */
        case 'f':
           if ((outf = fopen("nvram.000", "wb")) == NULL) {
              fprintf(stderr, "%s: can't open %s\n", argv[0], argv[1]);
	      exit(1);
	   }
	   for (i = 0; i < 0x0800; i++) {
	      fputc((int) *(base[0xf7] + i), outf);
	   }
	   fclose(outf);
	   break;

        case 'G':                         /* 'Go' execute inst.'s */
        case 'g':
	   cycles = 0;

#ifdef HUCARD
/**/
	   set_modex();
/**/
#endif
	   starttime = biostime(0,0);
	   exe_go();
	   endtime = biostime(0,0);
#ifdef HUCARD
/**/
	   set_text();
	   put_frame();
/**/
#endif
	   if (reg_pc == bkpt) {
	      *(mmr_base[bkpt>>13] + (bkpt & 0x1FFF)) = hold;
	   }
	   duration = (float)(endtime-starttime)/_BIOS_CLK_TCK;
	   if (duration != 0) {
	      vmhz = ((((frames*262)+lines)*455+cycles)/duration)/1000000;
              printf("\n\n\n\n\n\n\nDuration = %f\nVirtual MHz = %f\n", duration, vmhz);
	   }
           printf("vidreg = %d\n", vid_reg);
           printf("vidregs[1-8]  =%.4x,%.4x,%.4x,%.4x,%.4x,%.4x,%.4x,%.4x\n",
				  vidreg[1], vidreg[2], vidreg[3], vidreg[4],
				  vidreg[5], vidreg[6], vidreg[7], vidreg[8]);
           printf("vidregs[9-16] =%.4x,%.4x,%.4x,%.4x,%.4x,%.4x,%.4x,%.4x\n",
				  vidreg[9], vidreg[10], vidreg[11], vidreg[12],
				  vidreg[13], vidreg[14], vidreg[15], vidreg[16]);
           printf("vidregs[17-20]=%.4x,%.4x,%.4x,%.4x\n", vidreg[17], vidreg[18], vidreg[19], vidreg[20]);
//           printf("vga_pal_idx = %d\n", vga_pal_idx);
           printf("pce_vga_pal_map[0-7]   = %d %d %d %d %d %d %d %d\n",
				  pce_vga_pal_map[0], pce_vga_pal_map[1],
				  pce_vga_pal_map[2], pce_vga_pal_map[3],
				  pce_vga_pal_map[4], pce_vga_pal_map[5],
				  pce_vga_pal_map[6], pce_vga_pal_map[7]);
           printf("pce_vga_pal_map[8-15]  = %d %d %d %d %d %d %d %d\n",
				  pce_vga_pal_map[8], pce_vga_pal_map[9],
				  pce_vga_pal_map[10], pce_vga_pal_map[11],
				  pce_vga_pal_map[12], pce_vga_pal_map[13],
				  pce_vga_pal_map[14], pce_vga_pal_map[15]);
           printf("pce_vga_pal_map[16-23] = %d %d %d %d %d %d %d %d\n",
				  pce_vga_pal_map[16], pce_vga_pal_map[17],
				  pce_vga_pal_map[18], pce_vga_pal_map[19],
				  pce_vga_pal_map[20], pce_vga_pal_map[21],
				  pce_vga_pal_map[22], pce_vga_pal_map[23]);
           printf("pce_vga_pal_map[24-31] = %d %d %d %d %d %d %d %d\n",
				  pce_vga_pal_map[24], pce_vga_pal_map[25],
				  pce_vga_pal_map[26], pce_vga_pal_map[27],
				  pce_vga_pal_map[28], pce_vga_pal_map[29],
				  pce_vga_pal_map[30], pce_vga_pal_map[31]);
           printf("pce_vga_pal_map[32-39] = %d %d %d %d %d %d %d %d\n",
				  pce_vga_pal_map[32], pce_vga_pal_map[33],
				  pce_vga_pal_map[34], pce_vga_pal_map[35],
				  pce_vga_pal_map[36], pce_vga_pal_map[37],
				  pce_vga_pal_map[38], pce_vga_pal_map[39]);
	   while (getch() == NULL);
	   while (getch() == NULL);
	   break;

        case 'N':                         /* Show NVRam */
        case 'n':
	   hexdump_nvram();
	   i = getch();
	   break;

        case 'P':                         /* Display Picture */
        case 'p':
	   set_modex();
	   set_palette();
	   put_graphics();
	   while (getch() == NULL);
	   set_text();
	   put_frame();
	   break;

        case 'Q':                         /* 'Q'uit */
        case 'q':
	   i = 27;
	   break;

        case 'R':                         /* Show 'SATB' Sprite descriptors */
        case 'r':
	   hexdump_SATB();
	   i = getch();
	   break;

        case 'S':                         /* skip (don't execute) instruction */
        case 's':
	   op	   = *(mmr_base[reg_pc>>13] + (reg_pc & 0x1FFF));
	   reg_pc += addr_info[optable[op].addr_mode].size;
	   break;

        case 'T':                         /* Display Stack */
        case 't':
	   hexdump_sp();
	   i = getch();
	   break;

        case 'V':                         /* display vram @ pointer */
        case 'v':
	   /* ask for vram address to display */
	   inputnum(buf, 4);
	   vidaddr = cvtnum(buf);
	   hexdump_vram(vidaddr);
	   i = getch();
	   break;

        case 'X':                         /* execute instruction */
        case 'x':
	   exe_instruct();
	   break;

        case 'Y':                         /* Dump Sound info to File */
        case 'y':
           if ((outf = fopen("sound.000", "w")) == NULL) {
              fprintf(stderr, "%s: can't open %s\n", argv[0], argv[1]);
	      exit(1);
	   }
           fprintf(outf, "psg_voice = %d\n", (int)psg_voicenum);
           fprintf(outf, "psg_mainvol: left = %d, right = %d\n",
                          (int)psg_mainvol_l, (int)psg_mainvol_r);
           fprintf(outf, "psg_lfo_freq = %.2x\n", (int)psg_lfo_freq);
           fprintf(outf, "psg_lfo_ctrl = %.2x\n", (int)psg_lfo_ctrl);
           fprintf(outf, "\n");
	   for (i = 0; i < 6; i++) {
              fprintf(outf, "psg_freq[%d]       = %.4X\n",
                             i, (int)psg_voice[i].freq);
              fprintf(outf, "psg_dda_ctrl[%d]   = %.2X\n",
                             i, psg_voice[i].dda_ctrl);
              fprintf(outf, "psg_pan[%d]   left = %d, right = %d\n",
                             i, psg_voice[i].pan_l, psg_voice[i].pan_r);
              fprintf(outf, "psg_noise_ctrl[%d] = %.2X\n",
                             i, psg_voice[i].noise_ctrl);
              fprintf(outf, "\n");
	   }
	   fclose(outf);
	   break;


        case 'Z':                         /* Display Zero-Page */
        case 'z':
	   hexdump_zp();
	   i = getch();
	   break;

	default:
	   break;
      }

      if (i == 27)                      /* break 'while' stmt */
	 break;
   }

   return(0);				/* return value to appease compiler */
}
