/****************************************************************************
 * display.c  - display routines for TG simulator
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <bios.h>
#include <dos.h>

#include "defs.h"
#include "format.h"
#include "display.h"
#include "globals.h"
#include "pallette.h"
#include "video.h"

/* GLOBALS */

Char   spaces[61] = "                                                       ";

void put_frame(void)
{
   int i;

   gotoxy(1,1);                         /* top left corner */
   putch(201);
   for (i = 2; i < 80; i++) {           /* top line */
      putch(205);
   }
   putch(187);                          /* top right corner */

   gotoxy(1,24);                        /* bottom left corner */
   putch(200);
   for (i = 2; i < 80; i++) {           /* bottom line */
      putch(205);
   }
   putch(188);                          /* bottom right corner */

   for (i = 2; i < 24; i++) {
      gotoxy(1, i);                     /* left vertical */
      putch(186);
      gotoxy(80, i);                    /* right vertical */
      putch(186);
   }

   gotoxy(1,22);                        /* command line separator */
   putch(199);
   for (i = 2; i<80; i++) {
      putch(196);
   }
   putch(182);

   gotoxy(64,1);                        /* register column separator */
   putch(209);
   for (i = 2; i < 22; i++) {
      gotoxy(64, i);
      putch(179);
   }
   gotoxy(64,22);
   putch(193);

   gotoxy(64,13);                       /* MMR separator */
   putch(195);
   for (i = 65; i < 80; i ++) {
      putch(196);
   }
   putch(182);
}

void put_cmdprompt(void)
{
   gotoxy(33,23);
   cprintf("(X=execute; S=skip)");
   gotoxy(3,23);
   cprintf("Command: ");
}

void put_regs(void)
{
   int i;
   int temp_base;
   int temp_pc;

   temp_pc = reg_pc & 0x1FFF;
   temp_base = reg_pc>>13;

   gotoxy(66,2);
   cprintf("A = %2.2X", reg_a);
   gotoxy(66,3);
   cprintf("X = %2.2X", reg_x);
   gotoxy(66,4);
   cprintf("Y = %2.2X", reg_y);

   gotoxy(66,6);
   cprintf("P = %1.1s%1.1s%1.1s%1.1s%1.1s%1.1s%1.1s%1.1s",
            ((reg_p & FL_N) ? "+" : "-"),
            ((reg_p & FL_V) ? "+" : "-"),
            ((reg_p & FL_T) ? "+" : "-"),
            ((reg_p & FL_B) ? "+" : "-"),
            ((reg_p & FL_D) ? "+" : "-"),
            ((reg_p & FL_I) ? "+" : "-"),
            ((reg_p & FL_Z) ? "+" : "-"),
            ((reg_p & FL_C) ? "+" : "-") );
   gotoxy(70,7);
   cprintf("NVTBDIZC");

   gotoxy(66,9);
   cprintf("S = %2.2X", reg_s);

   gotoxy(66,11);
   cprintf("PC= %4.4X", reg_pc);
   gotoxy(70,12);
   cprintf("MMR%1.1X:%4.4X", temp_base, temp_pc);

   for (i = 0; i < 8; i++) {
      gotoxy(66, 14+i);
      cprintf("MMR%1.1X = %2.2X", i, mmr[i]);
   }
}

void put_disasm(unsigned int addr)
{
   int   cnt;
   int   size;
   char  linebuf[80];

   unsigned char op;
   unsigned char * opbuf;
   int  memreg;


   for (cnt = 2; cnt < 22; cnt++) {
      memreg = (addr >> 13) & 0x07;
      opbuf  = base[mmr[memreg]] + (addr & 0x1FFF);
      op     = *opbuf;

   /*****************************************************/
   /* This line is the real 'meat' of the disassembler: */
   /*                                                   */
   /* It calls a 'formatting' function based on the     */
   /* addressing mode of the opcode.                    */
   /*                                                   */
   /* This formatting function returns a disassembled   */
   /* instruction based on the parameters passed.       */
   /*****************************************************/

      (*addr_info[optable[op].addr_mode].func_format)
          (linebuf, (long)addr, opbuf, optable[op].opname);

      /* fill with spaces to cover over previous stuff on screen: */
      strncat(linebuf, spaces, 60-strlen(linebuf));

      /* display the line: */
      gotoxy(3, cnt);
      cprintf("%-60s", linebuf);

      /* next instruction: */
      size = addr_info[optable[op].addr_mode].size;
      addr += size;
   }
}

void hexdump_nvram(void)
{
   int   i, j;
   char  linebuf[80];
   char  buf[32];

   strncpy(linebuf, spaces, 24);
   strcpy(linebuf, "NVRAM");
   strncat(linebuf, spaces, 60-strlen(linebuf));
   gotoxy(3, 2);
   cprintf("%-60s", linebuf);

   gotoxy(3, 3);
   cprintf("%-60s", spaces);

   for (i = 0; i < 16; i++) {
      sprintf(linebuf, "  %.2X: ", (i*0x10));
      for (j = 0; j < 16; j++) {
         if (j == 8) strcat(linebuf, " ");
         sprintf(buf, "%.2X ", *(base[0xf7] + (i*0x10)+j));
         strcat(linebuf, buf);
      }
      /* fill with spaces to cover over previous stuff on screen: */
      strncat(linebuf, spaces, 60-strlen(linebuf));

      /* display the line: */
      gotoxy(3, i+4);
      cprintf("%-60s", linebuf);
   }
   /* clear the bottom of the screen */
   for (i = 20; i < 22; i++) {
      gotoxy(3, i);
      cprintf("%-60s", spaces);
   }
}

void hexdump_SATB(void)
{
   int   i, j;
   char  linebuf[80];
   char  buf[32];

   strncpy(linebuf, spaces, 24);
   strcpy(linebuf, "SATB");
   strncat(linebuf, spaces, 60-strlen(linebuf));
   gotoxy(3, 2);
   cprintf("%-60s", linebuf);

   gotoxy(3, 3);
   cprintf("%-60s", spaces);

   for (i = 0; i < 16; i++) {
      sprintf(linebuf, "  %.2X: ", (i*0x08));
      for (j = 0; j < 8; j++) {
         if (j == 4) strcat(linebuf, " ");
         sprintf(buf, "%.4X ", *((int *)pce_vidram+satb_val+(i*0x08)+j) );
         strcat(linebuf, buf);
      }
      /* fill with spaces to cover over previous stuff on screen: */
      strncat(linebuf, spaces, 60-strlen(linebuf));

      /* display the line: */
      gotoxy(3, i+4);
      cprintf("%-60s", linebuf);
   }
   /* clear the bottom of the screen */
   for (i = 20; i < 22; i++) {
      gotoxy(3, i);
      cprintf("%-60s", spaces);
   }
}

void hexdump_vram(UInt16 addr)
{
   int   i, j;
   char  linebuf[80];
   char  buf[32];
   UInt16 memval;
   VidByte * memaddr;

   strncpy(linebuf, spaces, 24);
   strcpy(linebuf, "VRAM");
   strncat(linebuf, spaces, 60-strlen(linebuf));
   gotoxy(3, 2);
   cprintf("%-60s", linebuf);

   gotoxy(3, 3);
   cprintf("%-60s", spaces);

   for (i = 0; i < 16; i++) {
      sprintf(linebuf, " %.4X: ", (addr+i*0x08));
      for (j = 0; j < 8; j++) {
         if (j == 4) strcat(linebuf, " ");
         memaddr = pce_vidram + addr + (i*8) + j;
         memval  = memaddr->byte_high * 256 + memaddr->byte_low;
         sprintf(buf, "%.4X ", memval);
         strcat(linebuf, buf);
      }
      /* fill with spaces to cover over previous stuff on screen: */
      strncat(linebuf, spaces, 60-strlen(linebuf));

      /* display the line: */
      gotoxy(3, i+4);
      cprintf("%-60s", linebuf);
   }
   /* clear the bottom of the screen */
   for (i = 20; i < 22; i++) {
      gotoxy(3, i);
      cprintf("%-60s", spaces);
   }
}

void hexdump_zp(void)
{
   int   i, j;
   char  linebuf[80];
   char  buf[32];

   strncpy(linebuf, spaces, 24);
   strcpy(linebuf, "ZERO PAGE");
   strncat(linebuf, spaces, 60-strlen(linebuf));
   gotoxy(3, 2);
   cprintf("%-60s", linebuf);

   gotoxy(3, 3);
   cprintf("%-60s", spaces);

   for (i = 0; i < 16; i++) {
      sprintf(linebuf, "  %.2X: ", (i*0x10));
      for (j = 0; j < 16; j++) {
         if (j == 8) strcat(linebuf, " ");
         sprintf(buf, "%.2X ", zp_base[(i*0x10)+j]);
         strcat(linebuf, buf);
      }
      /* fill with spaces to cover over previous stuff on screen: */
      strncat(linebuf, spaces, 60-strlen(linebuf));

      /* display the line: */
      gotoxy(3, i+4);
      cprintf("%-60s", linebuf);
   }
   /* clear the bottom of the screen */
   for (i = 20; i < 22; i++) {
      gotoxy(3, i);
      cprintf("%-60s", spaces);
   }
}

void hexdump_sp(void)
{
   int   i, j;
   char  linebuf[80];
   char  buf[32];

   strncpy(linebuf, spaces, 24);
   strcat(linebuf, "STACK PAGE");
   strncat(linebuf, spaces, 60-strlen(linebuf));
   gotoxy(3, 2);
   cprintf("%-60s", linebuf);

   gotoxy(3, 3);
   cprintf("%-60s", spaces);


   for (i = 0; i < 16; i++) {
      sprintf(linebuf, "  %.2X: ", (i*0x10));
      for (j = 0; j < 16; j++) {
         if (j == 8) strcat(linebuf, " ");
         sprintf(buf, "%.2X ", sp_base[(i*0x10)+j]);
         strcat(linebuf, buf);
      }
      /* fill with spaces to cover over previous stuff on screen: */
      strncat(linebuf, spaces, 60-strlen(linebuf));

      /* display the line: */
      gotoxy(3, i+4);
      cprintf("%-60s", linebuf);
   }
   /* clear the bottom of the screen */
   for (i = 20; i < 22; i++) {
      gotoxy(3, i);
      cprintf("%-60s", spaces);
   }
}

/*
long inputnum(char * string)
{
   long   value = 0;
   char * c = (string + 1);

   if (*string != '$') {
      return(atol(string));
   }

   while (*c != '\0') {

     value *= 16;

     if ((*c >= '0') && (*c <= '9')) {
       value += (*c - '0');

     } else if ((*c >= 'A') && (*c <= 'F')) {
       value += (*c - 'A' + 10);

     } else if ((*c >= 'a') && (*c <= 'f')) {
       value += (*c - 'a' + 10);

     } else {

       return(-1);
     }
     
     c++;
   }

   return(value);
}
*/
