/****************************************************************************
 pallette.h
 Pallette hardware function prototypes
 ****************************************************************************/

#ifndef PALLETTE_H_
#define PALLETTE_H_

#include "defs.h"

typedef struct {
    UChar byte_low;
    UChar byte_high;
} ColEntry;

typedef struct {
    UChar red;
    UChar green;
    UChar blue;
} RGBEntry;

typedef struct {
    Int16  color;
    Int16  ref_count;
} VGAEntry;

extern UInt16   pal_flag;            // flag to update VGA palette (has palette changed ?  1=yes, 0=no)
extern UInt16   pal_idx;             // current palette 'index' in PCE hardware (ie. value at $0402/$0403)
extern ColEntry pce_palet[];         // PCE's palette (what's stored in Hu6260 chip)
extern UInt16   pce_vga_pal_map[];   // mapping from PCE's 512 colors to VGA's 256
extern UInt16   vga_pal_idx;         // used when allocating new PC palette colors (top entry in array)
extern VGAEntry vga_palet[];         // array of PC palette entries

extern void  Pallette_Init(void);

extern void  hw_put_0400(UChar);
extern void  hw_put_0402(UChar);
extern void  hw_put_0403(UChar);
extern void  hw_put_0404(UChar);
extern void  hw_put_0405(UChar);

extern UChar hw_get_0400(void);
extern UChar hw_get_0402(void);
extern UChar hw_get_0403(void);
extern UChar hw_get_0404(void);
extern UChar hw_get_0405(void);

#endif
