/* Sorry, some of comments is Japanese. */

#include <stdio.h>
#include <stdlib.h>
//#include <mem.h>

#define JAPANESE		0

unsigned char font[4096];

unsigned char linebuf[256];

char infile[256];
char outfile[256];

/* convert job */
int convert(void)
{
	int a,c,i,j,mask;
	int base=0;
	int endf=0;
	int val;
	FILE *fp;

	fp=fopen(infile,"rt");
	if (fp==NULL)
	{
#if JAPANESE		
		fprintf(stderr,"%sI[vł܂B\n",infile);
#else		
		fprintf(stderr,"Can't Open File '%s'.\n",infile);
#endif		
		return 1;
	}

	/* obt@̃NA */
	memset(font,0,sizeof(font));
	
	/* ϊ[v */
	while(1)
	{
		if (fgets(linebuf,sizeof(linebuf),fp)==NULL) break;				/* eof */

		/* JnR[h`FbN */
		if (linebuf[0]=='#')
		{
			sscanf(linebuf+1,"%x",&base);
			printf("code=0x%03x\n",base);

			for (j=0;j<8;j++)
			{
				if (fgets(linebuf,sizeof(linebuf),fp)==NULL)			/* eof */
				{
					endf=1;
					break;
				}
				if (!linebuf[0])
				{
					endf=1;
					break;												/* empty line */
				}
				
				/* rbgϊ */
				mask=128;
				val=0;
				for (i=0;i<8;i++)
				{
					if (linebuf[i]!='.') val|=mask;
					mask>>=1;
				}
				font[base*8+j]=val;
			}
			
			if (endf) break;
		}
		
	}
	
	fclose(fp);
	
	/* Z[u */
	fp=fopen(outfile,"wb");
	if (fp==NULL)
	{
#if JAPANESE		
		fprintf(stderr,"%s쐬ł܂B\n",outfile);
#else		
		fprintf(stderr,"Can't create file '%s'.\n",outfile);
#endif		
		return 1;
	}

	fwrite(font,sizeof(font),1,fp);
	fclose(fp);
#if JAPANESE		
	printf("%s쐬܂B\n",outfile);
#else		
	printf("'%s' was created.\n",outfile);
#endif		

	return 0;
}

/* Main */
int main(int argc,char *argv[])
{
	int a,c,i,j,mask;
	FILE *fp;

	if (argc<2)
	{
		fprintf(stderr,"usage:mkfnt filename (without ext.)\n");
		return 1;
	}
	/* set input file name */
	sprintf(infile,"%s.txt",argv[1]);
	
	/* set output file name */
	sprintf(outfile,"%s.dat",argv[1]);

	fprintf(stderr,"in =%s\nout=%s\n",infile,outfile);
	
	return convert();
}
