/****************************************************************************
   timer.c

   Timer-controller function implementation

 ****************************************************************************/

#include "defs.h"
#include "globals.h"
#include "timer.h"

// GLOBAL data:

UChar timer_relodreg = 0x7F;    // max value
Char  timer_downcntr = 0x7F;    // max value
UChar timer_onoff    = 0x00;    // initialize to zeroes

// Hardware functions:

void hw_put_0C00(UChar byte) {
   timer_relodreg = byte & 0x7F;
   return;
}

void hw_put_0C01(UChar byte) {
   timer_onoff = byte & 0x01;
   return;
}

UChar hw_get_0C00(void) {
   return(timer_downcntr);
}

UChar hw_get_0C01(void) {
   return(timer_onoff);
}
