/****************************************************************************
 * grph.c  - graphics routines for TG simulator
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <go32.h>
#include <bios.h>
#include <dos.h>
#include <mem.h>
#include <sys/farptr.h>

#include "defs.h"
#include "grph.h"
#include "impl.h"
#include "pallette.h"
#include "video.h"

#define DAC_READIDX_PORT    0x03C7
#define DAC_WRITEIDX_PORT   0x03C8
#define DAC_DATA_PORT	    0x03C9

//#define SPR_LEFT_MARG_BYTE 8
#define SPR_LEFT_MARG_PIX  32
#define SPR_TOP_MARG_PIX   64

/* GLOBALS */

//UChar  pixbuf[256][512];  // y-line, x-pix

// UChar *pixbufpt;
UInt16 indent;

UChar  sprbuf[4][64][16];     // plane, y-line, x-planepix
//UChar  sprite_buf[64][64];  // y-line, x-pix

UInt32 gr_bit_table[65536];

UInt16 vga_seg;

static VidByte *CG_line_addr[128];
static UInt16 x_blk_indent, x_pix_indent;


static void set_vga256(void) {
   union REGS inregs, outregs;
   UInt16 i;

   inregs.x.ax = 0x13;
   int86(0x10, &inregs, &outregs);
}

void set_text(void) {
   union REGS inregs, outregs;

   /* return to text */
   inregs.x.ax = 3;
   int86(0x10, &inregs, &outregs);
   gr_mode = 0;
   return;
}

void set_modex(void) {
   union REGS inregs, outregs;
   long  i;

   inregs.x.ax = 0x13;

   int86(0x10, &inregs, &outregs);

   outportw(0x03c4,0x0604);
   outportw(0x03c4,0x0100);
   outportb(0x03c2,0xe3);
   outportw(0x03c4,0x0300);
   outportb(0x03d4,0x11);
   outportb(0x03d5, (inportb(0x03d5) & 0x7f));
   outportw(0x03d4, 0x0d06);
   outportw(0x03d4, 0x3e07);
   outportw(0x03d4, 0x4109);
   outportw(0x03d4, 0xea10);
   outportw(0x03d4, 0xac11);
   outportw(0x03d4, 0xdf12);
   outportw(0x03d4, 0x0014);
   outportw(0x03d4, 0xe715);
   outportw(0x03d4, 0x0616);
   outportw(0x03d4, 0xe317);

   outportw(0x03c4, 0x0f02);
   for (i = 0; i < 0x8000; i++) {
      _farpokeb(vga_seg, i, 0);
   }
   gr_mode = 1;
}

//
// Initialize a bit-table for the bit-rearranging of the graphic data:
//
void init_graphics(void) {
   UInt32 index;
   UInt16 i, j, k;

   for (i=0; i < 256; i++) {
      for (j=0; j < 256; j++) {
         UInt32 output = 0;
         for (k=0; k < 8; k++) {
            output |= (j & (1<<k)) ? ((UInt32)0x08<<(4*k)):0;
            output |= (i & (1<<k)) ? ((UInt32)0x04<<(4*k)):0;
         }
         index = j*256+i;    // little-endian
         gr_bit_table[index] = output;
      }
   }
   vga_seg = __dpmi_segment_to_descriptor(0xA000);

   init_platform_gfx();
}

//
// Sets palette via direct-to-DAC
//
void set_palette_dac(void) {
   UInt16 i;
   RGBEntry vga_rgb_palet;

   /* set starting DAC index: */
   outportb(DAC_WRITEIDX_PORT, 0x0);   // start at index #0

   /* convert vga_palet to vga_rgb_palet: */
   for (i = 0; i < 256; i++) {
      if (vga_palet[i].color == -1) {
	 outportb(DAC_DATA_PORT, 0);	// red
	 outportb(DAC_DATA_PORT, 0);	// green
	 outportb(DAC_DATA_PORT, 0);	// blue
      } else {
	 vga_rgb_palet.green  = (UChar)((vga_palet[i].color & 0x1C0) >> 3);
	 vga_rgb_palet.red    = (UChar)((vga_palet[i].color & 0x038));
	 vga_rgb_palet.blue   = (UChar)((vga_palet[i].color & 0x007) << 3);

	 outportb(DAC_DATA_PORT, vga_rgb_palet.red );				// red
	 outportb(DAC_DATA_PORT, vga_rgb_palet.green ); 			// green
	 outportb(DAC_DATA_PORT, vga_rgb_palet.blue );				// blue
      }
   }
   pal_flag = 0;  // reset flag to reduce unnecessary palette updates
   VGA_Palet_RelHeld();
}


void blitit(void) {
   int    i, j, y_line_offset;
   int    start, end;
   long   l;

// Establish indentation margin around narrow screen
   if (vid_bat_x_vis == 32) {
      indent = 4;
   } else {
      indent = 0;
   }

   _farsetsel(vga_seg);

   for (j = 0; j < 4; j++) {
      outportw(0x03c4, (UInt16)((0x100 << j) + 2));

      y_line_offset = 0;

      for (i = 0; i < 240; i++) {
//	 register UChar * pixbufptr = &(pixbuf[i][8+j]);
	 register UChar * pixbufptr = pixbuf + (i * 512) + (8+j);
         register Word pixwrd;

         start = y_line_offset+(indent*2);
         end   = start+(vid_bat_x_vis*2);

	 if (indent != 0) {
	    for (l = y_line_offset; l < start; l+=2) {
	       _farnspokew(l, 0);
	    }
	    for (l = start; l < end; l+=2) {
	       pixwrd.b.bl = *pixbufptr;
	       pixbufptr+=4;
	       pixwrd.b.bh = *pixbufptr;
	       pixbufptr+=4;
	       _farnspokew(l, pixwrd.w);
	    }
	    for (l = end; l < 80; l+=2) {
	       _farnspokew(l, 0);
	    }

	 } else {

	    for (l = start; l < end; l+=2) {
	       pixwrd.b.bl = *pixbufptr;
	       pixbufptr+=4;
	       pixwrd.b.bh = *pixbufptr;
	       pixbufptr+=4;
	       _farnspokew(l, pixwrd.w);
	    }
	 }
	 y_line_offset += 80;
      }
   }
}

void blitit_b(void) {
   int    i, j, y_line_offset;
   int    start, end;
   short  l;

   indent = 0;

   _farsetsel(vga_seg);

   for (j = 0; j < 4; j++) {
      outportw(0x03c4, (UInt16)((0x100 << j) + 2));

      y_line_offset = 0;

      for (i = 0; i < 240; i++) {
//	 register UChar * pixbufptr = &(pixbuf[i][8+j]);
//       register Word pixwrd;

         start = y_line_offset;
         end   = start+80;

	 for (l = start; l < end; l+=4) {
	    _farnspokel(l, 0);
	 }

	 y_line_offset += 80;
      }
   }
}

void put_sprites(void) {

   Int16      x,y;
   UInt16     i,j,k;
   UInt16     plane;
   VidByte *  element;
   VidByte *  element_base;
   VidByte *  char_base;
   UChar      ind_pal;
   UInt16     vid_addr;
//
   UChar      byte;
   UInt16     x_blk_indent, y_blk_indent;
   UInt16     x_pix_indent, y_pix_indent;
   UInt16     y_base_offset, x_line_offset, y_line_offset;
   UInt16     oddadd;
   UInt16     bat_x, bat_y;
   UInt16     byte_off;
   UInt16     y_addr;
   Int16      x_pos, y_pos;

/* sprite stuff: */
   Int16      s;
   UInt16     attr, patt;
   VidByte  * spr_base;
   VidByte  * spr_addr;
   UInt16     a,b,c,d,cellno;
   UInt16     x_reverse, y_reverse;
   UInt16     spr_behind;		// flag - sprite in front, or behind ?
   Int16      pln_ind, y_ind, x_ind;	// indices for sprite buffer
   UInt32     dblword_out;

   Int16      x_temp;
   Int16      l;
   Word       tmpidx1, tmpidx2;
   register   UChar * pixbufptr;
   register   UChar   pix;


/* Now, work on sprites: */

   if ((satb_val & 0x8000) == 0) {

      for (s = 63; s >= 0; s--) {
	 spr_base = pce_vidram + satb_val + s*4;

	 y = (spr_base->w & 0x3FF);
	 if (y == 0) continue;	 // off screen
	 y -= SPR_TOP_MARG_PIX;
	 if (y > 240) continue;  // off screen
	 y_base_offset = y * 80;

	 x = ( (spr_base+1)->w  & 0x3FF);
//	 if ((x == 0) || (x > (vid_bat_x_vis*8+SPR_LEFT_MARG_PIX-1)) ) // off screen
//	    continue;

	 if (x == 0) continue;   // off screen
	 x -= SPR_LEFT_MARG_PIX;
	 if (x > vid_bat_x_vis*8) continue;  // off screen

//	 x_line_offset = x>>2;
//	 x_pix_indent  = x&3;

	 attr = (spr_base+3)->w;
	 spr_behind =( (attr & 0x80) ? 0:1 );

	 patt = ( (spr_base+2)->w & 0x07FE) << 5;
	 patt &= 0x7FFF;

	 ind_pal = (attr & 0x0F) << 4;

	 x_reverse = attr & 0x0800;
	 y_reverse = attr & 0x8000;

	 c=1;				   // horiz cells in sprite
	 if (attr & 0x0100) c=2;

	 switch (attr & 0x3000) {	   // vert cells in sprite
	    case 0x1000:
	       d=2;
	       break;
	    case 0x3000:
	       d=4;
	       break;
	    default:
	       d=1;
	       break;
	 }

	 for (b = 0; b < d; b++) {     // vertical scan
	    for (a = 0; a < c; a++) {  // horizontal scan

	       cellno = b*c+a;
	       spr_addr = (pce_vidram + patt + cellno*64);

	       for (i = 0; i < 16; i++) {
		  if (y_reverse) {
		     y_ind = ((d-1)-b)*16+(15-i);
		  } else {
		     y_ind = b*16+i;
		  }
		  if (y+y_ind <   0) continue;
		  if (y+y_ind > 240) continue;

// Do a slice-and-dice of the bits
// which make up a sprite:

                  tmpidx1.b.bl = (spr_addr   )->b.bh;
                  tmpidx1.b.bh = (spr_addr+16)->b.bh;
                  tmpidx2.b.bl = (spr_addr+32)->b.bh;
                  tmpidx2.b.bh = (spr_addr+48)->b.bh;

		  dblword_out = ( gr_bit_table[tmpidx1.w] >> 2)
				| gr_bit_table[tmpidx2.w];

		  if (x_reverse) {
		     x_temp = x+(((c-a)*16)-1)+8;
//                     pixbufptr = &(pixbuf[y+y_ind][x_temp]);
                     pixbufptr = pixbuf + ((y+y_ind) * 512) + x_temp;

		     for (l = 7; l >= 0; l--) {
			pix = ((dblword_out >> (l*4)) & 0x0F);
			if ( (pix) && (x_temp+l >= 8) ) {
			   *pixbufptr = pce_vga_pal_map[(UInt16)(0x0100|ind_pal|pix)];
			}
			pixbufptr--;
		     }

		  } else {
		     x_temp = x+(a*16)+8;
//                     pixbufptr = &(pixbuf[y+y_ind][x_temp]);
                     pixbufptr = pixbuf + ((y+y_ind) * 512) + x_temp;

		     for (l = 0; l < 8; l++) {
			pix = ((dblword_out >> ((7-l)*4)) & 0x0F);
			if ( (pix) && (x_temp+l >= 8) ) {
			   *pixbufptr = pce_vga_pal_map[(UInt16)(0x0100|ind_pal|pix)];
			}
			pixbufptr++;
		     }
		  }


// Do a slice-and-dice of the bits
// that make up a sprite:

                  tmpidx1.b.bl = (spr_addr   )->b.bl;
                  tmpidx1.b.bh = (spr_addr+16)->b.bl;
                  tmpidx2.b.bl = (spr_addr+32)->b.bl;
                  tmpidx2.b.bh = (spr_addr+48)->b.bl;

		  dblword_out = ( gr_bit_table[tmpidx1.w] >> 2)
				| gr_bit_table[tmpidx2.w];


		  if (x_reverse) {
		     x_temp = x+(((c-a)*16-8)-1)+8;
//                     pixbufptr = &(pixbuf[y+y_ind][x_temp]);
                     pixbufptr = pixbuf + ((y+y_ind) * 512) + x_temp;

		     for (l = 7; l >= 0; l--) {
			pix = ((dblword_out >> (l*4)) & 0x0F);
			if ( (pix) && (x_temp+l >= 8) ) {
			   *pixbufptr = pce_vga_pal_map[(UInt16)(0x0100|ind_pal|pix)];
			}
			pixbufptr--;
		     }

		  } else {
		     x_temp = x+(a*16+8)+8;
//                     pixbufptr = &(pixbuf[y+y_ind][x_temp]);
                     pixbufptr = pixbuf + ((y+y_ind) * 512) + x_temp;

		     for (l = 0; l < 8; l++) {
			pix = ((dblword_out >> ((7-l)*4)) & 0x0F);
			if ( (pix) && (x_temp+l >= 8) ) {
			   *pixbufptr = pce_vga_pal_map[(UInt16)(0x0100|ind_pal|pix)];
			}
			pixbufptr++;
		     }
		  }

		  spr_addr++;
	       }
	    }
	 }
//	 for (i = 0; i < 4; i++) {
//	    plane  = ((i+x_pix_indent) & 3);
//	    oddadd = (i+x_pix_indent) / 4;
//	    outportw(0x3c4, (UInt16)((0x100 << plane) + 2));
//	    for (j = 0; j < d*16; j++) {
//	       y_pos = y+j;
//	       if ( (y_pos < 0) || (y_pos > 240) )
//		  continue;
//	       y_addr = y_base_offset + (j*80);
//	       for (k = 0; k < c*4; k++) {
//		  byte_off = x_line_offset + k + oddadd - SPR_LEFT_MARG_BYTE;
//		  x_pos = x+k*4+i - SPR_LEFT_MARG_PIX;
//		  if ((x_pos < 0) || (x_pos > (vid_bat_x_vis*8-1)))
//		     continue;
//		  byte = sprbuf[i][j][k];
//		  if ((byte & 0x0F) != 0) {
////
//// 'sprite_behind' logic is an approximation;
//// it will not work in the current environment
////
////		       if (spr_behind == 0) {
//
////			_farpokeb(vga_seg, (long)(y_addr+byte_off+indent*2),
////				       pce_vga_pal_map[(UInt16)(byte)+256]);
//			_farnspokeb((long)(y_addr+byte_off+indent*2),
//				    pce_vga_pal_map[(UInt16)(byte)+256]);
//
////		       } else {
////			  if (peekb(vga_seg, y_addr+byte_off+indent*2) == 0) {
////			   pokeb(vga_seg, y_addr+byte_off+indent*2,
////					  pce_vga_pal_map[(UInt16)(byte)+256]);
////			  }
////		       }
//		  }
//	       }
//	    }
//	 }
      }
   }
   return;
}

//
// setup 
void set_CGline_globals(void)
{
   register int i;

   for (i = 0; i < 128; i++) {
      CG_line_addr[i] = pce_vidram + (unsigned)(i * vid_bat_x_virt);
   }
   x_blk_indent = (vidreg[7].w >> 3) % vid_bat_x_virt;
   x_pix_indent =  vidreg[7].w & 7;
}


//
//
//
void put_CG(int y) {

   int     x;
   UInt16  y_blk_indent, y_pix_indent;
   UInt16  bat_x;

   VidByte *  element;
   VidByte *  element_base;
   VidByte *  char_base;
   UInt16     vid_addr;

   register UChar * pixbufptr;


   y_pix_indent = (y + vidreg[8].w) & 7;
   y_blk_indent = (y + vidreg[8].w) >> 3;

   if (vid_bat_y_virt == 32) {
         y_blk_indent &= 31;

   } else if (vid_bat_y_virt == 64) {
         y_blk_indent &= 63;

   } else {
         y_blk_indent %= vid_bat_y_virt;
   }

//
// first 8 pixels is a red-line area (not BLiTted to screen)
//
//   pixbufptr = &(pixbuf[y][8-x_pix_indent]);
   pixbufptr = pixbuf + (y * 512) + (8-x_pix_indent);

   element_base = CG_line_addr[y_blk_indent];
   bat_x        = x_blk_indent;

   for (x=0; x < vid_bat_x_vis+1; x++) {

      register UInt32 dblword_out;
      register UChar  ind_pal;

      element   = element_base + bat_x;

//
//  In PCE terms, element is a 16-bit memory address.
//
//  It contains: PPPPxAAAAAAAAAAA
//
//  Where 'PPPP'             = 1 of 16 CG palettes
//        'x'                = not used
//        '0AAAAAAAAAAA0000' = address of CG block to display here
//

      ind_pal   = (UChar)(element->b.bh & 0xf0);

      char_base = (pce_vidram + y_pix_indent) + ( (element->w & 0x07ff) << 4);


      dblword_out = ( gr_bit_table[char_base->w] >> 2)
	            | gr_bit_table[(char_base+8)->w];

      *(pixbufptr++) = pce_vga_pal_map[((dblword_out>>28) & 0x0F) | ind_pal];
      *(pixbufptr++) = pce_vga_pal_map[((dblword_out>>24) & 0x0F) | ind_pal];
      *(pixbufptr++) = pce_vga_pal_map[((dblword_out>>20) & 0x0F) | ind_pal];
      *(pixbufptr++) = pce_vga_pal_map[((dblword_out>>16) & 0x0F) | ind_pal];
      *(pixbufptr++) = pce_vga_pal_map[((dblword_out>>12) & 0x0F) | ind_pal];
      *(pixbufptr++) = pce_vga_pal_map[((dblword_out>> 8) & 0x0F) | ind_pal];
      *(pixbufptr++) = pce_vga_pal_map[((dblword_out>> 4) & 0x0F) | ind_pal];
      *(pixbufptr++) = pce_vga_pal_map[((dblword_out    ) & 0x0F) | ind_pal];

      if (++bat_x == vid_bat_x_virt) bat_x = 0;
   }
}

void put_graphics(void) {
//   int y;
//
//   for (y = 0; y < 240; y++) {
//      put_CG(y);
//   }
//   put_sprites();
   blit_to_screen();
}
