/****************************************************************************
   impl.c

   Implementation-specific functions

 ****************************************************************************/

#include <allegro.h>

#include "globals.h"   // PCE/emulation globals
#include "joy.h"       // PCE joypad globals...


BITMAP * bmp;
char   * pixbuf;

PALETTE rgb_palet;

Int16 gr_mode = 0;

/* system-wide stuff */

void impl_init(void)
{
   allegro_init();
   return;
}


/* keyboard globals */

void kbd_init(void)
{
   install_keyboard();
   return;
}

void kbd_exit(void)
{
   remove_keyboard();
   return;
}

void pollkbd(void)
{
}


//
// This translates the keyboard-pressed array (or joystick) into a
// PCE joystick word, so it can be read by the joystick routines.
//
void xlate_to_PCEjoy(void) {
   UChar joypad;
   int   i;

   joypad = 0xff;

   if (key[KEY_UP])               joypad &= ~0x10;  /* UP    */
   if (key[KEY_DOWN])             joypad &= ~0x40;  /* DOWN  */
   if (key[KEY_LEFT])             joypad &= ~0x80;  /* LEFT  */
   if (key[KEY_RIGHT])            joypad &= ~0x20;  /* RIGHT */

   if ((joypad & 0x50) == 0)      joypad |= 0x50;   /* can't have both */
   if ((joypad & 0xA0) == 0)      joypad |= 0xA0;   /* can't have both */

   if (key[KEY_ENTER])            joypad &= ~0x08;  /* RUN       */
   if (key[KEY_SPACE])            joypad &= ~0x04;  /* SELECT    */

   if (key_shifts & KB_CTRL_FLAG) joypad &= ~0x02;  /* Button II */
   if (key_shifts & KB_ALT_FLAG)  joypad &= ~0x01;  /* Button I  */


   if (key[KEY_ESC])  halt_flag = 1;


   joy_values[0] = joypad;        // controller #1

   for (i = 1; i < 5; i++) {      // duplicate values; no joypad tap installed
      joy_values[i] = joypad;
   }

   return;
}


//
// Graphics stuff:
//
void init_platform_gfx(void)
{
   set_color_depth(8);

   bmp = create_bitmap_ex(8, 512, 256);   // create it wider than necessary
   clear(bmp);
   set_clip(bmp, 0, 0, 0, 0);

   pixbuf = bmp->line[0];   // actual buffer
}

void blit_to_screen(void)
{
   blit(bmp, screen, 8, 0, 0, 0, 320, 240);
}

void switch_gfx_mode(void)
{
   int i;

   gr_mode = 1;

   set_color_depth(8);

   i = set_gfx_mode(GFX_VESA2L, 384, 288, 0, 0);
   if (i >= 0) return;

   i = set_gfx_mode(GFX_VESA2L, 400, 300, 0, 0);
   if (i >= 0) return;

   i = set_gfx_mode(GFX_VESA2L, 512, 384, 0, 0);
   if (i >= 0) return;

   i = set_gfx_mode(GFX_VESA2L, 560, 420, 0, 0);
   if (i >= 0) return;

   i = set_gfx_mode(GFX_VESA2L, 640, 480, 0, 0);
   if (i >= 0) return;

   i = set_gfx_mode(GFX_VESA1, 640, 480, 0, 0);
   if (i < 0) {
      printf("Can't set graphics screen\n");
      gr_mode = 0;
      exit(1);
   }
}

void switch_text_mode(void)
{
//   set_text_mode();
}

void pce_to_rgb(int i, Int16 color)
{
   rgb_palet[i].r = (color & 0x038);
   rgb_palet[i].g = (color & 0x1C0) >> 3;
   rgb_palet[i].b = (color & 0x007) << 3;
}

void set_gr_palette(void)
{
   set_palette(rgb_palet);
}
