/****************************************************************************
   impl.c

   Implementation-specific functions

   This is a tricky section - be careful
 ****************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <bios.h>
#include <dos.h>

#include "defs.h"
#include "globals.h"
#include "impl.h"
#include "joy.h"
#include "psg.h"
#include "timer.h"


/* keyboard globals */
UChar key_array[256];
UChar e0flag;
void interrupt(* orig_pckey_handl)( ... );
void interrupt new_pckey_handl( ... );

/* timer interrupt globals */
static int new_timer = 0;
void interrupt(* orig_pctimer_handl)( ... );
void interrupt new_pctimer_handl( ... );

UInt16 vsync_flag = 0;
UInt16 tiq_flag = 0;

//
// This translates the keyboard-pressed array into a TG
// joystick word, so it can be read by the joystick routines.
//
void read_pckeyjoys(void) {
   UChar joypad;
   int   i;

   joypad = 0xff;

   if (key_array[72] != 0)    joypad &= ~0x10;  /* UP    */
   if (key_array[80] != 0)    joypad &= ~0x40;  /* DOWN  */
   if (key_array[75] != 0)    joypad &= ~0x80;  /* LEFT  */
   if (key_array[77] != 0)    joypad &= ~0x20;  /* RIGHT */

   if ((joypad & 0x50) == 0)  joypad |= 0x50;   /* can't have both */
   if ((joypad & 0xA0) == 0)  joypad |= 0xA0;   /* can't have both */

   if (key_array[19] != 0)    joypad &= ~0x08;  /* RUN       */
   if (key_array[31] != 0)    joypad &= ~0x04;  /* SELECT    */
   if (key_array[83] != 0)    joypad &= ~0x02;  /* Button II */
   if (key_array[28] != 0)    joypad &= ~0x01;  /* Button I  */

   joy_values[0] = joypad;
   for (i = 1; i < 5; i++) {
      joy_values[i] = 0xff;
   }

   return;
}

//
// Initialize PC keyboard handler...
//
void init_pckeyint(void)
{
   Int16 i;

   e0flag = 0;
   for (i = 0; i < 256; i++) {
      key_array[i] = 0;
   }
   orig_pckey_handl = getvect(0x09);
   setvect(0x09, &new_pckey_handl);
}

//
// Terminate PC keyboard interrupt handler
//
void exit_pckeyint(void)
{
   setvect(0x09, orig_pckey_handl);
}

//
// PC keyboard interrupt handler
//
void interrupt new_pckey_handl( ... )
{
  asm {
    cli
    in      al, 0x60           /* get scan code from keyboard port */
    cmp     al, 0xE0           /* al = $E0 key  */
    jne     SetScanCode
    mov     [e0flag], 0x80
    mov     al, 0x20           /* Send 'generic' EOI to PIC */
    out     0x20, al
    jmp     exit
  SetScanCode:
    mov     bl, al             /* Save scancode in BL */
    and     bl, 0x7F
    add     bl, [e0flag]
    xor     bh, bh
    and     al, 0x80           /* keep break bit, if set */
    xor     al, 0x80           /* flip bit, 1 means pressed, 0 no */
    rol     al, 1              /* move breakbit to bit 0 */
    mov     [offset key_array + bx], al
    mov     [e0flag], 0
    mov     al, 0x20           /* send EOI to PIC */
    out     0x20, al
  exit:
    sti
  }
}

//
// Initialize PC timer interrupt handler...
//
void init_pctimerint(void)
{
   asm {cli};
   orig_pctimer_handl = getvect(0x08); /* redirect vector */

   setvect(0x08, &new_pctimer_handl);
   new_timer = 1;

   outp(0x43, 0x36);                 /* set timer count = 170 (7020/sec) */
   outp(0x40, 0xAA);
   outp(0x40, 0x00);

   atexit(exit_pctimerint);
   asm {sti};
}

//
// Terminate PC timer interrupt handler...
//
void exit_pctimerint(void)
{
   if (!new_timer) return;

   asm {cli};
   setvect(0x08, orig_pctimer_handl);  /* reinstate old timer int handler  */

   outp(0x43, 0x36);                 /* set timer count = 65536 (18.2/sec) */
   outp(0x40, 0x00);
   outp(0x40, 0x00);

   asm {sti};

   new_timer = 0;
}

//
// PC timer interrupt handler...
//
void interrupt new_pctimer_handl( ... )
{
  static video_slice = 0;
  static orig_pctimer_slice = 0;

//  asm { cli }   // may wish to suppress interrupts temporarily...

//
// Sound generator - mix:
//
  UInt16 sound_byte = 0;   // use left channel

  int temp_count;
  PCE_Voice * voiceptr = &(psg_voice[0]);

  for (int i = 0; i < 6; i++) {

    if (voiceptr->dda_ctrl & 0x80) {

      if (voiceptr->dda_ctrl & 0x40) {
        sound_byte += voiceptr->wave_dda_l;
      } else {

        voiceptr->wave_data_play_idx += voiceptr->cnt_int;
        voiceptr->wave_data_play_idx_frac += voiceptr->cnt_frac;
        if (voiceptr->wave_data_play_idx_frac > voiceptr->freq) {
           voiceptr->wave_data_play_idx_frac -= voiceptr->freq;
           voiceptr->wave_data_play_idx++;
        }
        voiceptr->wave_data_play_idx &= 31;

        // range = 0 - 0x1A5E:
        sound_byte += voiceptr->wave_data_l[voiceptr->wave_data_play_idx];
      }
    }
    voiceptr++;
  }

  // range = 0 - 0x1A5E (per voice); 0 - 0x9E34 (all 6)
  // (shift >>4, then mult by main volume -> range = 0-0x944D)
  asm {
     mov ax, word ptr sound_byte
     shr ax,4                    // get ready for main volume
     mul word ptr psg_mainvol_l  // multiply by main volume
     shr ax,8                    // final value back down to (0-0x94) range
     adc ax,0                    // 'rounding' bit
     mov word ptr sound_byte,ax
  }

//  while ((inportb(BLASTER+0x0C) & 0x80) != 0);  // actually, should do this...
  outportb(BLASTER+0x0C, 0x10);
  while ((inportb(BLASTER+0x0C) & 0x80) != 0);
  outportb(BLASTER+0x0C, (char)sound_byte);

//
// PCE TIMER stuff:
//
  if (timer_onoff) {
    if (--timer_downcntr < 0) {
      timer_downcntr = timer_relodreg;
      tiq_flag = 1;
    }
  }

//
// set VSYNC flag every 1/60th second:
//
  video_slice++;
  if (video_slice == 117) {       // (roughly 1/60 sec) // 117
    video_slice = 0;
    vsync_flag = 1;
  }

//  asm { sti }    // matches '{ cli }' above (either uncomment both or neither)

//
// Original PC Timer interrupt (chained)
//
  orig_pctimer_slice++;
  if (orig_pctimer_slice == 385) {  // 18.2 per second
    orig_pctimer_slice = 0;
    orig_pctimer_handl();
  } else {
    outp(0x20,0x20);      /* generic interrupt reset */
  }
}
