#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "MZ-1R12.h"




unsigned char MZ1R12RAM[1024 * 32];
unsigned short MZ1R12AddressPtr;
unsigned char MZ1R12 = FALSE;

extern unsigned char MZExtROM[0x10000 - 0xE000];

extern void ReInitVGA(void);




UINT16 MZ1R12_Read(UINT16 Address)
{
 UINT16 Result;


 Result = 0xFF;

 switch(Address)
 {
  case MZ1R12RESETREG:
        MZ1R12AddressPtr = 0;
        break;
  case MZ1R12READREG:
        Result = MZ1R12RAM[MZ1R12AddressPtr++];
        break;
 }

 return(Result);
}




void MZ1R12_Write(UINT16 Address, UINT8 Data)
{
 switch(Address)
 {
  case MZ1R12HIGHADRREG:
        MZ1R12AddressPtr = (MZ1R12AddressPtr & 0x00FF) | (Data << 8);
        break;
  case MZ1R12LOWADRREG:
        MZ1R12AddressPtr = (MZ1R12AddressPtr & 0xFF00) | Data;
        break;
  case MZ1R12WRITEREG:
        MZ1R12RAM[MZ1R12AddressPtr++] = Data;
        break;
 }
}




void SaveMZ1R12RAM(void)
{
 FILE *pMZ1R12;


 pMZ1R12 = fopen("MZ-1R12.DAT", "wb");
 fwrite(MZ1R12RAM, sizeof(char), 1024 * 32, pMZ1R12);
 fclose(pMZ1R12);
}




void LoadMZ1R12RAM(void)
{
 FILE *pMZ1R12;


 if((pMZ1R12 = fopen("MZ-1R12.DAT", "rb")) != NULL)
 {
  fread(MZ1R12RAM, sizeof(char), 1024 * 32, pMZ1R12);
  fclose(pMZ1R12);
 }
 else memset(MZ1R12RAM, 0xFF, sizeof(MZ1R12RAM));
}




void LoadMZ1R12ROM(void)
{
 FILE *pROM;

 
 if((pROM = fopen("MZ-1R12.ROM", "rb")) != NULL)
 {
  fread(MZExtROM + 0x0800, sizeof(char), 0x10000 - 0xE800, pROM);
  fclose(pROM);
 }
 else
 {
  ReInitVGA();
  printf("Can not open MZ-1R12.ROM !\n");
  exit(1);
 }
}
