#include <stdio.h>
#include <stdlib.h>
#include <ctype.h>
#include <string.h>

#define VERSION "1.0"



struct CMTHeader
{
 unsigned char Attribute;
 char Name[17];
 unsigned short Size;
 unsigned short LoadAddress;
 unsigned short ExecAddress;
 char Comment[104];
};



int main(int argc, char *argv[])
{
 char Help[256];
 FILE *InfoFile;
 unsigned char HeaderBuffer[128];
 struct CMTHeader *InfoHeader;
 unsigned char Line;
 unsigned char Offset;


 printf("\nMZFInfo V %s    (c) 2001 by BKK\n\n", VERSION);

 if(argc == 1)
 {
  puts("usage: mzfinfo filename");
  puts("");
  puts("example: mzfinfo test.mzf");
  puts("");
  exit(1);
 }

 strcpy(Help, argv[1]);

 if(strchr(Help, '.') == NULL) strcat(Help, ".MZF");

 if((InfoFile = fopen(Help, "rb")) == NULL)
 {
  printf("File %s open error!\n", Help);
  exit(1);
 }

 fread(HeaderBuffer, sizeof(unsigned char), 128, InfoFile);
 fclose(InfoFile);

 InfoHeader = (struct CMTHeader *) HeaderBuffer;

 printf("Filename: %s\n\n", Help);

 memcpy(Help, InfoHeader->Name, 17);
 Help[strchr(Help, '\r') - Help] = '\0';

 printf("\"%s\"  ", Help);
 switch(InfoHeader->Attribute)
 {
  case 0x01 : printf("(ML programm)\n"); break;
  case 0x02 : printf("(MZ-80 BASIC programm)\n"); break;
  case 0x03 : printf("(MZ-80 data file)\n"); break;
  case 0x04 : printf("(MZ-700 data file)\n"); break;
  case 0x05 : if(InfoHeader->LoadAddress != 0)
               printf("(MZ-700 BASIC programm)\n");
              else
               printf("(MZ-800 BASIC programm)\n");
              break;
 }
 printf("Size: %5u    ", InfoHeader->Size);
 printf("Load: 0x%04X    ", InfoHeader->LoadAddress);
 printf("End: 0x%04X    ", InfoHeader->LoadAddress + InfoHeader->Size - 1);
 printf("Exec: 0x%04X\n\n", InfoHeader->ExecAddress);

 for(Line = 0; Line < 16; Line++)
 {
  printf("                     ");
  for(Offset = 0; Offset < 8; Offset++)
   printf("%02X ", HeaderBuffer[Line * 8 + Offset]);
  printf("  ");
  for(Offset = 0; Offset < 8; Offset++)
   printf("%c", isprint(HeaderBuffer[Line * 8 + Offset]) ? HeaderBuffer[Line * 8 + Offset] : '.');
  printf("\n");
 }
 return(0);
}
