#include <stdio.h>
#include <string.h>

#define VERSION "1.0"



struct CMTHeader
{
 unsigned char Attribute;
 char Name[17];
 unsigned short Size;
 unsigned short LoadAddress;
 unsigned short ExecAddress;
 char Comment[104];
};



unsigned char MZTBitMask = 0x00;
unsigned char MZTByte = 0;
unsigned int CheckSumm;

FILE *InfoFile;




unsigned char ReadBit(void)
{
 unsigned char Bit;


 if(MZTBitMask == 0)
 {
  MZTByte = fgetc(InfoFile);
  MZTBitMask = 0x80;
 }

 if(MZTByte & MZTBitMask) Bit = 1;
 else Bit = 0;

 MZTBitMask = MZTBitMask >> 1;

 return(Bit);
}




unsigned char ReadByte(void)
{
 unsigned char Byte;
 unsigned char BitMask;


 (void) ReadBit();
 Byte = 0;
 BitMask = 0x80;
 while(BitMask)
 {
  if(ReadBit()) Byte = Byte | BitMask;
  BitMask = BitMask >> 1;
 }

 return(Byte);
}



int main(int argc, char *argv[])
{
 char Help[256];
 unsigned char HeaderBuffer[128];
 struct CMTHeader *InfoHeader;
 unsigned char Line;
 unsigned char Offset;
 unsigned int Counter;


 printf("\nMZTInfo V %s    (c) 2000 by BKK\n\n", VERSION);

 if(argc == 1)
 {
  puts("usage: mztinfo filename");
  puts("");
  puts("example: mztinfo test.mzt");
  puts("");
  exit(1);
 }

 strcpy(Help, argv[1]);

 if(strchr(Help, '.') == NULL) strcat(Help, ".MZT");

 if((InfoFile = fopen(Help, "rb")) == NULL)
 {
  printf("File %s open error!\n", Help);
  exit(1);
 }

 for(Counter = 0; Counter < 22000; Counter++) (void) ReadBit();
 for(Counter = 0; Counter < 40; Counter++) (void) ReadBit();
 for(Counter = 0; Counter < 40; Counter++) (void) ReadBit();
 (void) ReadBit();

 for(Counter = 0; Counter < 128; Counter++)
  HeaderBuffer[Counter] = ReadByte();

 fclose(InfoFile);

 InfoHeader = (struct CMTHeader *) HeaderBuffer;

 printf("Filename: %s\n\n", Help);

 memcpy(Help, InfoHeader->Name, 17);
 Help[strchr(Help, '\r') - Help] = '\0';

 printf("\"%s\"  ", Help);
 switch(InfoHeader->Attribute)
 {
  case 0x01 : printf("(ML programm)\n"); break;
  case 0x02 : printf("(MZ-80 BASIC programm)\n"); break;
  case 0x03 : printf("(MZ-80 data file)\n"); break;
  case 0x04 : printf("(MZ-700 data file)\n"); break;
  case 0x05 : if(InfoHeader->LoadAddress != 0)
               printf("(MZ-700 BASIC programm)\n");
              else
               printf("(MZ-800 BASIC programm)\n");
              break;
 }
 printf("Size: %5u    ", InfoHeader->Size);
 printf("Load: 0x%04X    ", InfoHeader->LoadAddress);
 printf("End: 0x%04X    ", InfoHeader->LoadAddress + InfoHeader->Size - 1);
 printf("Exec: 0x%04X\n\n", InfoHeader->ExecAddress);

 for(Line = 0; Line < 16; Line++)
 {
  printf("                     ");
  for(Offset = 0; Offset < 8; Offset++)
   printf("%02X ", HeaderBuffer[Line * 8 + Offset]);
  printf("  ");
  for(Offset = 0; Offset < 8; Offset++)
   printf("%c", isprint(HeaderBuffer[Line * 8 + Offset]) ? HeaderBuffer[Line * 8 + Offset] : '.');
  printf("\n");
 }
 return(0);
}
