#define VERSION "0.30"

#define FMS 0xEFFF

#include <stdio.h>
#include <string.h>


#define FALSE 0
#define TRUE 1

#define QDSIZE 61455
#define MAXQDFILETYPES 12



struct CMTHeaderStr
{
 unsigned char Attribute;
 char Name[17];
 unsigned short Size;
 unsigned short LoadAddress;
 unsigned short ExecAddress;
 char Comment[104];
};


struct QDHeaderStr
{
 unsigned char Attribute;
 char Name[17];
 unsigned short Unknown;
 unsigned short Size;
 unsigned short LoadAddress;
 unsigned short ExecAddress;
 char Comment[38];
};


char QDFileTypes[MAXQDFILETYPES][4] = {
                         "???",
                         "OBJ",
                         "BTX",
                         "BSD",
                         "BRD",
                         "RB ",
                         "???",
                         "LIB",
                         "???",
                         "???",
                         "SYS",
                         "GR "
                        };


unsigned char QDArray[QDSIZE];
unsigned short QDPtr;




void QDFormat(void)
{
 FILE *QDFile;
 unsigned char QDFormatByte;
 unsigned short Counter;


 puts("Format");


 QDPtr = 0;

 QDArray[QDPtr++] = 0x00;           // BREAK
 QDArray[QDPtr++] = 0x16;           // SYNC CHAR1
 QDArray[QDPtr++] = 0x16;           // SYNC CHAR2
 QDArray[QDPtr++] = 0xA5;           // SHARP SYNC
 QDArray[QDPtr++] = 0x00;           // 0 data blocks on disk
 QDArray[QDPtr++] = 'C';            // CRC
 QDArray[QDPtr++] = 'R';            // CRC
 QDArray[QDPtr++] = 'C';            //
 QDArray[QDPtr++] = 0x00;           // BREAK
 QDArray[QDPtr++] = 0x16;           // SYNC CHAR1
 QDArray[QDPtr++] = 0x16;           // SYNC CHAR2
 QDArray[QDPtr++] = 0xA5;
 
 QDFormatByte = 0xAA;
 Counter = FMS;
 do
 {
  QDFormatByte = ~QDFormatByte;
  QDArray[QDPtr++] = QDFormatByte;
  Counter--;
 } while(Counter != 0);
 
 QDArray[QDPtr++] = 'C';            // CRC
 QDArray[QDPtr++] = 'R';            // CRC
 QDArray[QDPtr++] = 'C';            // CRC

 if((QDFile = fopen("MZ700.qd", "wb")) != NULL)
 {
  fwrite(QDArray, QDSIZE, 1, QDFile);
  fclose(QDFile);
 }
}




unsigned short SeekSync(unsigned short Ptr)
{
 unsigned char SyncFound;


 SyncFound = FALSE;
 do
 {
  if(QDArray[Ptr++] == 0x16)
  {
   if(QDArray[Ptr++] == 0x16) SyncFound = TRUE;
   else Ptr--;
  }
 } while(!SyncFound && (Ptr <= QDSIZE));

 return(Ptr);
}



void QDDir(void)
{
 FILE *QDFile;
 unsigned char QDBlocks;
 unsigned char Counter;
 unsigned char QDFileType;
 unsigned short QDBlockSize;
 unsigned short PtrSave;


 if((QDFile = fopen("MZ700.qd", "rb")) != NULL)
 {
  fread(QDArray, QDSIZE, 1, QDFile);
  fclose(QDFile);

  QDPtr = 0;
  QDPtr = SeekSync(QDPtr);

  QDPtr++;
  QDBlocks = QDArray[QDPtr];

  puts("DIRECTORY OF QD:");

  for(Counter = 0; Counter < QDBlocks; Counter++)
  {
   QDPtr = SeekSync(QDPtr);
   PtrSave = QDPtr;

   QDBlockSize = QDArray[QDPtr + 2];
   QDBlockSize = QDBlockSize + QDArray[QDPtr + 3] * 256;
//   printf("BLSize: %u -> %04X\n", QDBlockSize, QDBlockSize);
   
   QDPtr++;
   if(QDArray[QDPtr] == 0x00)
   {
    QDPtr += 3;

    QDFileType = QDArray[QDPtr++];
    if(QDFileType >= MAXQDFILETYPES) QDFileType = 0;
    printf(" %s  \"", QDFileTypes[QDFileType]);
    do
    {
     printf("%c", QDArray[QDPtr++]);
    } while(QDArray[QDPtr] != 0x0d);
    puts("\"");    
   }
   QDPtr = PtrSave + QDBlockSize;
  }
  puts("Ready");
 }
}




void AddFileToQD(char *MZFileName)
{
 FILE *QDFile;
 FILE *MZFFile;
 unsigned short FilePos;
 unsigned short MZFFileSize;
 unsigned short QDPtr;
 unsigned char QDBlocks;
 unsigned short QDBlockSize;
 unsigned short Counter;
 unsigned short *usPtr;

 unsigned char CMTHeader[sizeof(struct CMTHeaderStr)];
 struct CMTHeaderStr *CMTHeaderPtr;
 struct QDHeaderStr *QDHeaderPtr;


 printf("try to add %s\n", MZFileName);

 if((QDFile = fopen("MZ700.QD", "rb")) == NULL)
 {
  puts("file MZ700.QD not found");
  exit(3);
 }
 
 fread(QDArray, QDSIZE, 1, QDFile);
 fclose(QDFile);

 QDPtr = 0;
 QDPtr = SeekSync(QDPtr);

 QDPtr++;
 QDBlocks = QDArray[QDPtr++];

 QDPtr = QDPtr + 3;     // jump over CRC

 for(Counter = 0; Counter < QDBlocks; Counter++)
 {
  QDPtr = SeekSync(QDPtr);

  QDPtr = QDPtr + 2;    // jump over 0xA5 and the next byte

  QDBlockSize = QDArray[QDPtr++];
  QDBlockSize = QDBlockSize + QDArray[QDPtr++] * 256;
//   printf("BLSize: %u -> %04X\n", QDBlockSize, QDBlockSize);

  QDPtr = QDPtr + QDBlockSize;

  QDPtr = QDPtr + 3;    // jump over CRC
 }


 if((MZFFile = fopen(MZFileName, "rb")) == NULL)
 {
  printf("file %s not found\n", MZFileName);
  exit(5);
 }

 fseek(MZFFile, 0, SEEK_END);
 MZFFileSize = ftell(MZFFile);
 fseek(MZFFile, 0, SEEK_SET);

 if(MZFFileSize > (QDSIZE - QDPtr + 14))
 {
  printf("file %s is to big, only %u bytes free\n", MZFileName, QDSIZE - QDPtr);
 }
 else
 {
  QDArray[QDPtr++] = 0x00;      // BREAK
  QDArray[QDPtr++] = 0x16;      // SYNCCHAR1
  QDArray[QDPtr++] = 0x16;      // SYNCCHAR2

  QDArray[QDPtr++] = 0xA5;
  QDArray[QDPtr++] = 0x00;

  QDArray[QDPtr++] = 64;      // headerlength fixed
  QDArray[QDPtr++] = 0x00;

/*
  fread(&QDArray[QDPtr], 1, 64, MZFFile);
  if(QDArray[QDPtr] == 0x05) QDArray[QDPtr] = 2;        // BTX file
  QDPtr = QDPtr + 64;
  fseek(MZFFile, 128, SEEK_SET);        // go to end of MZF header
*/

  fread(CMTHeader, 1, sizeof(struct CMTHeaderStr), MZFFile);
  CMTHeaderPtr = (struct CMTHeaderStr *) &CMTHeader[0];

  QDHeaderPtr = (struct QDHeaderStr *) &QDArray[QDPtr];

  QDHeaderPtr->Attribute = CMTHeaderPtr->Attribute;
  if(CMTHeaderPtr->Size != 0)
  {
   if(QDHeaderPtr->Attribute == 0x05) QDHeaderPtr->Attribute = 0x02;
  }
  memcpy(QDHeaderPtr->Name, CMTHeaderPtr->Name, 17);

  if(CMTHeaderPtr->Size == 0)
  {
   memcpy(&QDHeaderPtr->Unknown, &CMTHeaderPtr->Size, 64 - 18);
  }
  else
  {
   QDHeaderPtr->Unknown = 0;
   QDHeaderPtr->Size = CMTHeaderPtr->Size;
   QDHeaderPtr->LoadAddress = CMTHeaderPtr->LoadAddress;
   QDHeaderPtr->ExecAddress = CMTHeaderPtr->ExecAddress;
   memcpy(QDHeaderPtr->Comment, CMTHeaderPtr->Comment, 38);
  }

  QDPtr = QDPtr + sizeof(struct QDHeaderStr);

  QDArray[QDPtr++] = 'C';
  QDArray[QDPtr++] = 'R';
  QDArray[QDPtr++] = 'C';

  QDArray[QDPtr++] = 0x00;      // BREAK
  QDArray[QDPtr++] = 0x16;      // SYNCCHAR1
  QDArray[QDPtr++] = 0x16;      // SYNCCHAR2

  QDArray[QDPtr++] = 0xA5;
  QDArray[QDPtr++] = 0x05;

  usPtr = (unsigned short *) &QDArray[QDPtr];
  *usPtr = MZFFileSize - 128;
  QDPtr = QDPtr + 2;

  fread(&QDArray[QDPtr], 1, MZFFileSize - 128, MZFFile);
  QDPtr = QDPtr + MZFFileSize - 128;

  QDArray[QDPtr++] = 'C';
  QDArray[QDPtr++] = 'R';
  QDArray[QDPtr++] = 'C';

  QDArray[4] = QDArray[4] + 2;          // increase blockcounts
 }

 fclose(MZFFile);
 
 QDFile = fopen("MZ700.QD", "wb");
 fwrite(QDArray, QDSIZE, 1, QDFile);
 fclose(QDFile);
}




int main(int argc, char *argv[])
{
 printf("\nMZQDTool V %s   (c) 2002 by BKK\n\n", VERSION);

 if(argc == 1)
 {
  puts("usage: mzqdtool [format] [dir] [add filename]");
  puts("");
  exit(1);
 }

 if(strcmp("format", argv[1]) == 0) QDFormat();
 if(strcmp("dir", argv[1]) == 0) QDDir();
 if(strcmp("add", argv[1]) == 0)
 {
  if(argc < 3)
  {
   puts("error: no file to add");
   exit(2);
  }
  AddFileToQD(argv[2]);
 }

 return(0);
}
