 #
 # Keyboard interrupt hooking example.
 # The author is not responsible for any
 # damage this code could do to you or your property.
 #
 #            Martynas Kunigelis, 1996/13/05
 #            e-mail:  Martynas.Kunigelis@vm.ktu.lt
 #
 # extended by
 #
 #            Bernd Krueger-Knauber, 1999/17/04
 #                                   1999/14/05
 #                                   1999/25/06         Windows Flag
 #                                   2000/22/01         LED's and Win95
 #
		.file	"keyboard.s"
 #
 # externals (optional):
 #
		.extern ___djgpp_base_address
		.extern ___djgpp_ds_alias
 		.extern	___djgpp_dos_sel
 #
 # public functions and variables:
 #
		.global _keyboard_map
		.global _keyboard_init
		.global _keyboard_close
		.global _keyboard_chain

                .global _keyboard_reset
                .global _keyboard_led

		.text
		
		.align 	4

locking_region_start:

_keyboard_map:  .space  0xEF, 0

old_vector:
old_vector_ofs:	.long	0
old_vector_sel:	.word	0
chain_flag:     .byte   1
E0_Flag:        .byte   0
E1_Flag:        .byte   0


		.align	4

handler_procedure:

 #
 # .. will be called every time a key is pressed/released
 #                    
		pushl	%eax
		pushl	%edx
		pushw	%ds
 #
 # Load DS with our data selector
 #
 		movw	%cs:___djgpp_ds_alias, %ds
 #
 # Read the scancode from keyboard port and update keyboard_map
 #
		inb	$0x60, %al

#pushw   %ax
#movb    $0x0E, %ah
#int     $0x10
#popw    %ax


E0_Test:
                cmpb    $0xE0, %al
                jne     E1_Test
                movb    $1, E0_Flag
                jmp     ProcessEnd
E1_Test:
                cmpb    $0xE1, %al
                jne     ProcessData
                movb    $1, E1_Flag
                jmp     ProcessEnd

ProcessData:
		movb	%al, %dl
		andl	$0x7f, %edx

E0_Check:
                cmpb    $1, E0_Flag
                jne     E1_Check
                movb    $0, E0_Flag
                add     $0x60, %edx
                cmpb    $0xC6, %al
                je      ProcessEnd
                jmp     NormalData
E1_Check:
                cmpb    $1, E1_Flag
                jne     NormalData
                cmpb    $0xC5, %al
                jne     ProcessEnd
                movb    $0, E1_Flag
                movb    $0xE1, %dl
                clc
                setnc   _keyboard_map(%edx)
                jmp     ProcessEnd

NormalData:
		testb	$0x80, %al
		setz	_keyboard_map(%edx)

                cmpb    $0xA6, %dl
                je      ClearPause
ClearBreak:
                movb    $0xA6, %dl
                clc
                setc    _keyboard_map(%edx)

ClearPause:
                movb    $0xE1, %dl
                clc
                setc    _keyboard_map(%edx)


ProcessEnd:
		
 #
 # Chain if flag is set, otherwise do what's necessary and return
 #
		cmpb	$0, chain_flag
		jne	handler_chain
 #
 # Acknowledge keyboard and interrupt contollers
 #
		inb	$0x61, %al
		orb	$0x80, %al
		outb	%al, $0x61
		andb	$0x7f, %al
		outb	%al, $0x61
		movb	$0x20, %al
		outb	%al, $0x20

		popw	%ds
		popl	%edx
		popl	%eax
		sti
		iret

		.align	4

handler_chain:  popw	%ds
		popl	%edx
		popl	%eax
		ljmp	%cs:(old_vector)

locking_region_end:


		.align	4
_keyboard_init:

 #
 # int keyboard_init(void);
 #
 # Initializes the keyboard handler and hooks the keyboard interrupt.
 # Returns -1 on failure, zero on success
 #
		pushl	%esi
		pushl	%edi
		pushl	%ebx
 #
 # First, we need to lock the handler and memory it touches, so
 # it doesn't get swapped out to disk.
 #
		leal	locking_region_start, %ecx
		leal	locking_region_end, %edi
		subl	%ecx, %edi
		addl	___djgpp_base_address, %ecx
		shldl	$16, %ecx, %ebx		# ecx -> bx:cx
		shldl	$16, %edi, %esi         # edi -> si:di
		movw    $0x0600, %ax		# lock linear region
		int	$0x31
		jc	init_error




 #
 # Now we need to save the old interrupt vector, so we can restore
 # it later and also to know where to jump if chaining.
 #
		movw	$0x0204, %ax    	# get pm int vector
		movb	$0x09, %bl
		int	$0x31
		movw	%cx, old_vector_sel
		movl	%edx, old_vector_ofs
 #
 # Make sure we chain after initialization.
 #
		movl	$1, chain_flag
 #
 # Set the interrupt vector to point to our handler.
 #
		movw	%cs, %cx    		
		leal	handler_procedure, %edx
		movb	$0x09, %bl
		movw	$0x0205, %ax    	# set pm int vector
		int	$0x31
 #*
 #* Actually we would have to unlock the locked region on failure
 #* here. But since most programs would exit with an error message
 #* in such case, there's no need to worry.
 #*

init_error:

 #
 # This sets EAX to -1 if CF is set and to 0 atherwise
 #
		movl	$0, %eax
		sbbl	$0, %eax
		
		popl	%ebx
		popl	%edi
		popl	%esi
		ret


		.align 4
_keyboard_close:

 #
 # void keyboard_close(void);
 #
 # Shuts the keyboard handler down.
 #
		pushl	%esi
		pushl	%edi
		pushl	%ebx
 #
 # Unlock the region we locked at initialization
 # 
		leal	locking_region_start, %ecx
		leal	locking_region_end, %edi
		subl	%ecx, %edi
		addl	___djgpp_base_address, %ecx
		shldl	$16, %ecx, %ebx
		shldl	$16, %edi, %esi
		movw	$0x0601, %ax  		# unlock linear region
		int	$0x31                   
 #
 # Restore the interrupt vector to its previous value
 #
		movw	old_vector_sel, %cx
		movl	old_vector_ofs, %edx
		movb	$0x09, %bl
		movw	$0x0205, %ax            # set pm int vector
		int	$0x31

		popl	%ebx
		popl	%edi
		popl	%esi
		ret
 #
 # void keyboard_chain(int toggle);
 #
		.align	4
_keyboard_chain:
		cmpl	$0, 4(%esp)
		je	chain_off
chain_on:

 #
 # Set the chain_flag and clear BIOS shift/ctrl/alt status bits:
 #
		movb	$1, chain_flag

		push	%es
		movw	___djgpp_dos_sel, %es
		andb	$0xf0, %es:0x417
		pop	%es
		jmp	chain_done
chain_off:
		movb    $0, chain_flag
chain_done:     ret


#
# OutKbdData
#

OutKbdData:
cli
                outb    %al,$0x60
OutKbdDataLoop:
                inb     $0x64,%al
                testb   $0x02,%al
                jnz     OutKbdDataLoop
sti
                ret


#
# InKbdData
#

InKbdData:
cli
                inb     $0x64,%al
                testb   $0x01,%al
                jz      InKbdData
                inb     $0x60,%al
sti
                ret


 #
 # void keyboard_reset(void)
 #
                .align 4
_keyboard_reset:
                movw    $0x1600, %ax    # Windows installation check
                int     $0x2F           # multiplex int
                cmpb    $0, %al         # 0 = no Winows
                jne     Reset_End
                movb    $0xFF,%al
                call    OutKbdData
                call    InKbdData
Reset_End:
                ret

 #
 # void keyboard_led(unsigned char LED);
 #
		.align	4
_keyboard_led:
                movw    $0x1600, %ax    # Windows installation check
                int     $0x2F           # multiplex int
                cmpb    $0, %al         # 0 = no Winows
                jne     Win_LED
                movb    $0xED, %al      # LED command in al
                call    OutKbdData
                call    InKbdData
                movb    4(%esp), %al    # LED data in al
                call    OutKbdData
                call    InKbdData
                jmp     LED_End

Win_LED:
                push    %ax
                movb    6(%esp), %al    # LED data in al
                shl     %al
                shl     %al
                shl     %al
                shl     %al
                push    %es
                movw    ___djgpp_dos_sel, %es
                andb    $0x8F, %es:0x417
                orb     %al, %es:0x417

movw $0x0100, %ax
int $0x16

                pop     %es
                pop     %ax

LED_End:
                ret


 #
 #  "Hey pig, nothing's turning out the way I planned."
 #  - Nine Inch Nails
 #
