//#define DEBUG
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <dpmi.h>
#include <go32.h>
#include <sys/movedata.h>
#include <sys/farptr.h>

#include "KuP_80Z.h"


#define VIDEOPAGE 2
#define VIDEOADDRESSOFFSET 8192
#define POS(x,y) (VIDEOADDRESSOFFSET + (y * 160) + (x << 1))



extern unsigned short B800;

extern void ReInitVGA(void);


#ifdef DEBUG
 extern FILE *DebugFile;
#endif


unsigned char KuP_80Z = FALSE;
unsigned char KuP_80Z_Active = FALSE;

unsigned char DisplayStartChanged = FALSE;

unsigned char KuP_80Z_Font[1280];

unsigned char KuP_80Z_VRAM[2048];


unsigned char BKK[2];

struct CRT6845 KuP_6845;



UINT16 KuP_80Z_Read(UINT16 Address)
{
 UINT16 Result;
 unsigned short UpdatePtr;
 unsigned short VRAMAddress;


 Result = 0; 

 switch(Address)
 {
  case 0x70:
             UpdatePtr = (KuP_6845.R[18] << 8) + KuP_6845.R[19];
             VRAMAddress = UpdatePtr % 2048;

             Result = KuP_80Z_VRAM[VRAMAddress];

#ifdef DEBUG
fprintf(DebugFile, "Peek UPD: %u RAM: %u Data: '%c'\n", UpdatePtr, VRAMAddress, Result);
fflush(DebugFile);
#endif

/*
             UpdatePtr++;
             UpdatePtr = UpdatePtr & 0x3FFF;
             KuP_6845.R[18] = UpdatePtr >> 8;
             KuP_6845.R[19] = (unsigned char) UpdatePtr;
*/             
             break;
  case 0x71:
             break;
  case 0x72:
             Result = KuP_6845.Status;
             KuP_6845.Status = KuP_6845.Status | 0x80;
             break;
  case 0x73:
             if((KuP_6845.AR > 13) && (KuP_6845.AR < 20)) Result = KuP_6845.R[KuP_6845.AR];
#ifdef DEBUG             
fprintf(DebugFile, "Read Reg[%u]: %02X\n", KuP_6845.AR, KuP_6845.R[KuP_6845.AR]);
fflush(DebugFile);
#endif
             break;
 }

 return Result;
}




void KuP_80Z_Write(UINT16 Address, UINT8 Data)
{
 unsigned short UpdatePtr;
 unsigned short DisplayStart;
 unsigned short CursorPtr;
 unsigned short CursorAddress;
 unsigned short VRAMAddress;
 __dpmi_regs DPMIRegister;

 unsigned short i;

#ifdef DEBUG
fprintf(DebugFile, "A:%02X D:%02X\n", Address, Data);
fflush(DebugFile);
#endif

 switch(Address)
 {
  case 0x70:
             break;
  case 0x71:
             DisplayStart = (KuP_6845.R[12] << 8) + KuP_6845.R[13];
             DisplayStart = DisplayStart % 2048;

             UpdatePtr = (KuP_6845.R[18] << 8) + KuP_6845.R[19];
             VRAMAddress = (UpdatePtr % 2048);

             KuP_80Z_VRAM[VRAMAddress] = Data;

             if(DisplayStartChanged)
             {                 
              for(i = DisplayStart; i < (DisplayStart + 2000); i++)
              {
               _farpokeb(B800, VIDEOADDRESSOFFSET + ((i - DisplayStart) << 1), KuP_80Z_VRAM[i % 2048]);
              }
              DisplayStartChanged = FALSE;
             }
             else
             {
              if(DisplayStart > VRAMAddress)
               _farpokeb(B800, VIDEOADDRESSOFFSET + ((2048 - DisplayStart + VRAMAddress) << 1), KuP_80Z_VRAM[VRAMAddress]);
              else
              _farpokeb(B800, VIDEOADDRESSOFFSET + ((VRAMAddress - DisplayStart) << 1), KuP_80Z_VRAM[VRAMAddress]);
             }



#ifdef DEBUG
fprintf(DebugFile, "Poke UPD: %u RAM: %u Pos: %u,%u D='%c'\n", UpdatePtr, VRAMAddress, ((UpdatePtr - DisplayStart) % 80), ((UpdatePtr - DisplayStart) / 80), Data);
fflush(DebugFile);
#endif
             UpdatePtr++;
             UpdatePtr = UpdatePtr & 0x3FFF;
             KuP_6845.R[18] = UpdatePtr >> 8;
             KuP_6845.R[19] = (unsigned char) UpdatePtr;
             break;
  case 0x72:
             KuP_6845.AR = Data;

             if(KuP_6845.AR == 31)
             {
              KuP_6845.Status = KuP_6845.Status & 0x7F;
              KuP_6845.R[18] = BKK[1];
              KuP_6845.R[19] = BKK[0];
#ifdef DEBUG
fprintf(DebugFile, "Updateaddress: %u\n", (KuP_6845.R[18] << 8) + KuP_6845.R[19]);
fflush(DebugFile);
#endif
             }

             break;
  case 0x73:
#ifdef DEBUG
fprintf(DebugFile, "R[%u]=%02Xh (%ud)\n", KuP_6845.AR, Data, Data);
fflush(DebugFile);
#endif
             if(KuP_6845.AR < 20)
             {

              // update location registers
              if((KuP_6845.AR == 18) || (KuP_6845.AR == 19))
              {
               // they are only valid after R31 access
               BKK[19 - KuP_6845.AR] = Data;
               break;
              }

              KuP_6845.R[KuP_6845.AR] = Data;


              // display start registers
              if((KuP_6845.AR == 12) || (KuP_6845.AR == 13))
              {
               // if this register has changed, we need a full screen update
               // (scrolling)
               // but is not done here, because it happens twice (R12 and R13)
               // it is only neccessary when a new character is written
               // this must happen even when scrolled by 1 line, because 2048
               // are 48 bytes more than needed.
               DisplayStartChanged = TRUE;

#ifdef DEBUG
DisplayStart = (KuP_6845.R[12] << 8) + KuP_6845.R[13];
DisplayStart = DisplayStart % 2048;
fprintf(DebugFile, "Displaystart: %04X (%u)\n", DisplayStart, DisplayStart);
fflush(DebugFile);
#endif
              }


              if(KuP_80Z_Active)
              {
               // cursor start and end register
               if((KuP_6845.AR == 10) || (KuP_6845.AR == 11))
               {
                DPMIRegister.h.ah = 0x01;
                if((KuP_6845.R[10] & 0x60) == 0x20)
                 DPMIRegister.h.ch = KuP_6845.R[10]; // no cursor
                else 
                 DPMIRegister.h.ch = KuP_6845.R[10] & 0x1F; // no attributes yet
                DPMIRegister.h.cl = KuP_6845.R[11];
                __dpmi_int(0x10, &DPMIRegister);
               }
              
               // cursor position registers
               if((KuP_6845.AR == 14) || (KuP_6845.AR == 15))
               {
                CursorPtr = (KuP_6845.R[14] << 8) + KuP_6845.R[15];
                DisplayStart = (KuP_6845.R[12] << 8) + KuP_6845.R[13];
                
                DisplayStart = DisplayStart % 2048;
                CursorPtr = CursorPtr % 2048;

                if(DisplayStart > CursorPtr)
                 CursorAddress = 2048 - DisplayStart + CursorPtr;
                else
                 CursorAddress = CursorPtr - DisplayStart;

#ifdef DEBUG
fprintf(DebugFile, "CPtr: %u CAddr: %u\n", CursorPtr, CursorAddress);
fflush(DebugFile);
#endif
                DPMIRegister.h.ah = 0x02;
                DPMIRegister.h.bh = VIDEOPAGE;
                DPMIRegister.h.dh = CursorAddress / 80;   // row
                DPMIRegister.h.dl = CursorAddress % 80;   // col
                __dpmi_int(0x10, &DPMIRegister);
               }
              }

             }
             break;
 }
}




void KuP_80Z_Activate(void)
{
 union REGS Register;
 __dpmi_regs DPMIRegister;
 unsigned short CursorPtr;
 unsigned short DisplayStart;
 unsigned short CursorAddress;


 // set 350 scan lines -> 8x8 font will be activated
 Register.w.ax = 0x1201;
 Register.w.bx = 0x0030;
 int86(0x10, &Register, &Register);

 // mode 3, 80 x 25 colour mode
 // with MSB set, the screen is not cleared
 Register.w.ax = 0x0082;
 int86(0x10, &Register, &Register);
 
 // acivate page 2, p0 = B800:0, p1 = B800:4096, p2 = B800:8192
 Register.h.ah = 0x05;
 Register.h.al = VIDEOPAGE;
 int86(0x10, &Register, &Register);


 // Copy the K&P-CharacterFont into the VGA-Card
 // and program the CRT to the corresponding values

 dosmemput(&KuP_80Z_Font[0], 0x800, __tb);

 DPMIRegister.h.ah = 0x11;
 DPMIRegister.h.al = 0x10;
 DPMIRegister.h.bh = 10;    // 10 scan lines
 DPMIRegister.h.bl = 0;     // in table 0
 DPMIRegister.x.cx = 128;   // 128 characters
 DPMIRegister.x.dx = 0;     // first character is ASCII 0
 DPMIRegister.x.es = __tb >> 4;
 DPMIRegister.x.bp = __tb & 0x0F;
 __dpmi_int(0x10, &DPMIRegister);


 // set cursorposition
 CursorPtr = (KuP_6845.R[14] << 8) + KuP_6845.R[15];
 DisplayStart = (KuP_6845.R[12] << 8) + KuP_6845.R[13];

 DisplayStart = DisplayStart % 2048;
 CursorPtr = CursorPtr % 2048;

 if(DisplayStart > CursorPtr)
  CursorAddress = 2048 - DisplayStart + CursorPtr;
 else
  CursorAddress = CursorPtr - DisplayStart;

 DPMIRegister.h.ah = 0x02;
 DPMIRegister.h.bh = VIDEOPAGE;
 DPMIRegister.h.dh = CursorAddress / 80;   // row
 DPMIRegister.h.dl = CursorAddress % 80;   // col
 __dpmi_int(0x10, &DPMIRegister);


 // set cursor look
 DPMIRegister.h.ah = 0x01;
 DPMIRegister.h.ch = KuP_6845.R[10] & 0x1F; // no attributes yet
 DPMIRegister.h.cl = KuP_6845.R[11];
 __dpmi_int(0x10, &DPMIRegister);


 KuP_80Z_Active = TRUE;
}




void KuP_80Z_LoadROM(void)
{
 FILE *pROM;
 unsigned char c;
 
 
 if((pROM = fopen("KuP_80Z.ROM", "rb")) != NULL)
 {
  for(c = 0; c < 128; c++)
  {
   fread(&KuP_80Z_Font[c * 10], 1, 10, pROM);
   fseek(pROM, 6, SEEK_CUR);
  }
  fclose(pROM);
  KuP_80Z_Activate();
  KuP_80Z_Active = FALSE;
 }
 else
 {
  ReInitVGA();
  printf("Can not open KuP_80Z.ROM !\n");
  exit(1);
 }
}
